/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.deduction.matching.template.local.service.internal;

import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.business.common.sdk.vo.UuidVo;
import com.biz.crm.tpm.business.deduction.matching.template.local.entity.TpmDeductionMatchingTemplate;
import com.biz.crm.tpm.business.deduction.matching.template.local.entity.TpmDeductionMatchingTemplateAllowance;
import com.biz.crm.tpm.business.deduction.matching.template.local.repository.TpmDeductionMatchingTemplateAllowanceRepository;
import com.biz.crm.tpm.business.deduction.matching.template.local.repository.TpmDeductionMatchingTemplateRepository;
import com.biz.crm.tpm.business.deduction.matching.template.sdk.dto.TpmDeductionMatchingTemplateAllowanceDto;
import com.biz.crm.tpm.business.deduction.matching.template.sdk.dto.TpmDeductionMatchingTemplateDto;
import com.biz.crm.tpm.business.deduction.matching.template.sdk.dto.log.TpmDeductionMatchingTemplateLogEventDto;
import com.biz.crm.tpm.business.deduction.matching.template.sdk.enums.DeductionMatchingTemplateConditionEnum;
import com.biz.crm.tpm.business.deduction.matching.template.sdk.enums.TpmDeductionMatchingTemplateEnums;
import com.biz.crm.tpm.business.deduction.matching.template.sdk.event.log.TpmDeductionMatchingTemplateLogEventListener;
import com.biz.crm.tpm.business.deduction.matching.template.sdk.service.TpmDeductionMatchingTemplateService;
import com.biz.crm.tpm.business.deduction.matching.template.sdk.vo.TpmDeductionMatchingTemplateAllowanceVo;
import com.biz.crm.tpm.business.deduction.matching.template.sdk.vo.TpmDeductionMatchingTemplateVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service(value="tpmDeductionMatchingTemplateService")
public class TpmDeductionMatchingTemplateServiceImpl
implements TpmDeductionMatchingTemplateService {
    @Autowired(required=false)
    private TpmDeductionMatchingTemplateRepository tpmDeductionMatchingTemplateRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private NebulaNetEventClient nebulaNetEventClient;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired(required=false)
    private TpmDeductionMatchingTemplateAllowanceRepository tpmDeductionMatchingTemplateAllowanceRepository;

    public Page<TpmDeductionMatchingTemplateVo> findByConditions(Pageable pageable, TpmDeductionMatchingTemplateDto dto) {
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)1, (int)50));
        if (Objects.isNull(dto)) {
            dto = new TpmDeductionMatchingTemplateDto();
        }
        String tenantCode = TenantUtils.getTenantCode();
        dto.setTenantCode(tenantCode);
        return this.tpmDeductionMatchingTemplateRepository.findByConditions(pageable, dto);
    }

    public List<TpmDeductionMatchingTemplateVo> findAllListByConditions(TpmDeductionMatchingTemplateDto dto) {
        if (Objects.isNull(dto)) {
            return Lists.newArrayList();
        }
        String tenantCode = TenantUtils.getTenantCode();
        dto.setTenantCode(tenantCode);
        List<TpmDeductionMatchingTemplateVo> voList = this.tpmDeductionMatchingTemplateRepository.findAllListByConditions(dto);
        if (CollectionUtils.isEmpty(voList)) {
            return voList;
        }
        List<TpmDeductionMatchingTemplateAllowanceVo> allowances = this.tpmDeductionMatchingTemplateAllowanceRepository.findByCodeList(voList.stream().map(TpmDeductionMatchingTemplateVo::getCode).collect(Collectors.toList()));
        Map<String, List<TpmDeductionMatchingTemplateAllowanceVo>> codeToAllowance = allowances.stream().collect(Collectors.groupingBy(TpmDeductionMatchingTemplateAllowanceVo::getCode));
        voList.forEach(vo -> vo.setAllowances((List)codeToAllowance.getOrDefault(vo.getCode(), Lists.newArrayList())));
        return this.tpmDeductionMatchingTemplateRepository.findAllListByConditions(dto);
    }

    public TpmDeductionMatchingTemplateVo findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        TpmDeductionMatchingTemplate entity = (TpmDeductionMatchingTemplate)((Object)this.tpmDeductionMatchingTemplateRepository.getById((Serializable)((Object)id)));
        Assert.notNull((Object)((Object)entity), (String)"\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\uff01");
        Validate.isTrue((boolean)DelFlagStatusEnum.NORMAL.getCode().equals(entity.getDelFlag()), (String)"\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\uff01", (Object[])new Object[0]);
        String tenantCode = TenantUtils.getTenantCode();
        Validate.isTrue((boolean)tenantCode.equals(entity.getTenantCode()), (String)"\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\uff01", (Object[])new Object[0]);
        TpmDeductionMatchingTemplateVo vo = (TpmDeductionMatchingTemplateVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, TpmDeductionMatchingTemplateVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        List<TpmDeductionMatchingTemplateAllowanceVo> allowances = this.tpmDeductionMatchingTemplateAllowanceRepository.findByCode(entity.getCode());
        vo.setAllowances(allowances);
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public TpmDeductionMatchingTemplateVo create(TpmDeductionMatchingTemplateDto dto) {
        this.createValidate(dto);
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.tpmDeductionMatchingTemplateRepository.lambdaQuery().eq(TpmDeductionMatchingTemplate::getBusinessFormatCode, (Object)dto.getBusinessFormatCode())).eq(TpmDeductionMatchingTemplate::getBusinessUnitCode, (Object)dto.getBusinessUnitCode())).eq(TpmDeductionMatchingTemplate::getSalesOrgCode, (Object)dto.getSalesOrgCode())).eq(TpmDeductionMatchingTemplate::getDeductionMatchingTemplateType, (Object)dto.getDeductionMatchingTemplateType())).list();
        if (!CollectionUtils.isEmpty((Collection)list)) {
            dto.getAllowances().forEach(allowance -> {
                List codes = list.stream().map(o -> o.getCode()).collect(Collectors.toList());
                List templateAllowanceList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.tpmDeductionMatchingTemplateAllowanceRepository.lambdaQuery().in(TpmDeductionMatchingTemplateAllowance::getCode, codes)).eq(StringUtils.isNotBlank((CharSequence)allowance.getResaleCommercialCode()), TpmDeductionMatchingTemplateAllowance::getResaleCommercialCode, (Object)allowance.getResaleCommercialCode())).eq(StringUtils.isNotBlank((CharSequence)allowance.getApplyBusinessCustomerCode()), TpmDeductionMatchingTemplateAllowance::getApplyBusinessCustomerCode, (Object)allowance.getApplyBusinessCustomerCode())).eq(TpmDeductionMatchingTemplateAllowance::getApplyMappingCode, (Object)allowance.getApplyMappingCode())).list();
                Validate.isTrue((boolean)CollectionUtils.isEmpty((Collection)templateAllowanceList), (String)"\u8be5\u6a21\u677f\u5185\u5bb9\u91cd\u590d", (Object[])new Object[0]);
            });
        }
        String tenantCode = TenantUtils.getTenantCode();
        dto.setTenantCode(tenantCode);
        String ruleCode = StringUtils.join((Object[])new String[]{"MB", DateFormatUtils.format((Date)new Date(), (String)"yyyyMMdd")});
        String code = (String)this.generateCodeService.generateCode(ruleCode, 1, Integer.valueOf(10), 2L, TimeUnit.DAYS).get(0);
        dto.setCode(code);
        Collection allowances = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)dto.getAllowances(), TpmDeductionMatchingTemplateAllowanceDto.class, TpmDeductionMatchingTemplateAllowance.class, HashSet.class, ArrayList.class, new String[0]);
        allowances.forEach(e -> {
            e.setTenantCode(tenantCode);
            e.setCode(code);
        });
        TpmDeductionMatchingTemplate entity = (TpmDeductionMatchingTemplate)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, TpmDeductionMatchingTemplate.class, LinkedHashSet.class, ArrayList.class, new String[0]));
        this.tpmDeductionMatchingTemplateRepository.saveOrUpdate((Object)entity);
        this.tpmDeductionMatchingTemplateAllowanceRepository.saveBatch(allowances);
        TpmDeductionMatchingTemplateLogEventDto logEventDto = new TpmDeductionMatchingTemplateLogEventDto();
        logEventDto.setOriginal(null);
        logEventDto.setNewest(dto);
        SerializableBiConsumer & Serializable onCreate = TpmDeductionMatchingTemplateLogEventListener::onCreate;
        this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, TpmDeductionMatchingTemplateLogEventListener.class, (SerializableBiConsumer)onCreate);
        return (TpmDeductionMatchingTemplateVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, TpmDeductionMatchingTemplateVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
    }

    @Transactional(rollbackFor={Exception.class})
    public TpmDeductionMatchingTemplateVo update(TpmDeductionMatchingTemplateDto dto) {
        this.updateValidate(dto);
        TpmDeductionMatchingTemplate oldEntity = (TpmDeductionMatchingTemplate)((Object)this.tpmDeductionMatchingTemplateRepository.getById((Serializable)((Object)dto.getId())));
        Validate.notNull((Object)((Object)oldEntity), (String)"\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\uff01", (Object[])new Object[0]);
        Validate.isTrue((boolean)DelFlagStatusEnum.NORMAL.getCode().equals(oldEntity.getDelFlag()), (String)"\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\uff01", (Object[])new Object[0]);
        String tenantCode = TenantUtils.getTenantCode();
        Validate.isTrue((boolean)tenantCode.equals(oldEntity.getTenantCode()), (String)"\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\uff01", (Object[])new Object[0]);
        TpmDeductionMatchingTemplateDto oldDto = (TpmDeductionMatchingTemplateDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)oldEntity, TpmDeductionMatchingTemplateDto.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        List<TpmDeductionMatchingTemplateAllowanceVo> oldAllowances = this.tpmDeductionMatchingTemplateAllowanceRepository.findByCode(oldEntity.getCode());
        oldDto.setAllowances((List)Lists.newArrayList((Iterable)this.nebulaToolkitService.copyCollectionByWhiteList(oldAllowances, TpmDeductionMatchingTemplateAllowanceVo.class, TpmDeductionMatchingTemplateAllowanceDto.class, HashSet.class, ArrayList.class, new String[0])));
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.tpmDeductionMatchingTemplateRepository.lambdaQuery().eq(TpmDeductionMatchingTemplate::getBusinessFormatCode, (Object)dto.getBusinessFormatCode())).eq(TpmDeductionMatchingTemplate::getBusinessUnitCode, (Object)dto.getBusinessUnitCode())).eq(TpmDeductionMatchingTemplate::getSalesOrgCode, (Object)dto.getSalesOrgCode())).eq(TpmDeductionMatchingTemplate::getDeductionMatchingTemplateType, (Object)dto.getDeductionMatchingTemplateType())).ne(UuidEntity::getId, (Object)dto.getId())).list();
        if (!CollectionUtils.isEmpty((Collection)list)) {
            dto.getAllowances().forEach(allowance -> {
                List codes = list.stream().map(o -> o.getCode()).collect(Collectors.toList());
                List templateAllowanceList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.tpmDeductionMatchingTemplateAllowanceRepository.lambdaQuery().in(TpmDeductionMatchingTemplateAllowance::getCode, codes)).eq(StringUtils.isNotBlank((CharSequence)allowance.getResaleCommercialCode()), TpmDeductionMatchingTemplateAllowance::getResaleCommercialCode, (Object)allowance.getResaleCommercialCode())).eq(StringUtils.isNotBlank((CharSequence)allowance.getApplyBusinessCustomerCode()), TpmDeductionMatchingTemplateAllowance::getApplyBusinessCustomerCode, (Object)allowance.getApplyBusinessCustomerCode())).eq(TpmDeductionMatchingTemplateAllowance::getApplyMappingCode, (Object)allowance.getApplyMappingCode())).list();
                Validate.isTrue((boolean)CollectionUtils.isEmpty((Collection)templateAllowanceList), (String)"\u8be5\u6a21\u677f\u5185\u5bb9\u91cd\u590d", (Object[])new Object[0]);
            });
        }
        TpmDeductionMatchingTemplate newEntity = (TpmDeductionMatchingTemplate)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, TpmDeductionMatchingTemplate.class, HashSet.class, ArrayList.class, new String[0]));
        String code = newEntity.getCode();
        Collection newAllowances = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)dto.getAllowances(), TpmDeductionMatchingTemplateAllowanceDto.class, TpmDeductionMatchingTemplateAllowance.class, HashSet.class, ArrayList.class, new String[0]);
        newAllowances.forEach(e -> {
            e.setTenantCode(tenantCode);
            e.setCode(code);
        });
        this.tpmDeductionMatchingTemplateAllowanceRepository.removeByIds(oldAllowances.stream().map(UuidVo::getId).collect(Collectors.toList()));
        this.tpmDeductionMatchingTemplateRepository.saveOrUpdate((Object)newEntity);
        this.tpmDeductionMatchingTemplateAllowanceRepository.saveBatch(newAllowances);
        TpmDeductionMatchingTemplateLogEventDto logEventDto = new TpmDeductionMatchingTemplateLogEventDto();
        logEventDto.setOriginal(oldDto);
        logEventDto.setNewest(dto);
        SerializableBiConsumer & Serializable onUpdate = TpmDeductionMatchingTemplateLogEventListener::onUpdate;
        this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, TpmDeductionMatchingTemplateLogEventListener.class, (SerializableBiConsumer)onUpdate);
        return (TpmDeductionMatchingTemplateVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, TpmDeductionMatchingTemplateVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
    }

    @Transactional(rollbackFor={Exception.class})
    public void delete(List<String> idList) {
        Validate.isTrue((!CollectionUtils.isEmpty(idList) ? 1 : 0) != 0, (String)"\u5220\u9664\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        String tenantCode = TenantUtils.getTenantCode();
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.tpmDeductionMatchingTemplateRepository.lambdaQuery().select(new SFunction[]{TpmDeductionMatchingTemplate::getCode}).in(UuidEntity::getId, idList)).eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).list();
        Validate.noNullElements((Iterable)list, (String)"\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\uff01", (Object[])new Object[0]);
        List codeList = list.stream().map(TpmDeductionMatchingTemplate::getCode).collect(Collectors.toList());
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.tpmDeductionMatchingTemplateRepository.lambdaUpdate().in(UuidEntity::getId, idList)).set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode())).update();
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.tpmDeductionMatchingTemplateAllowanceRepository.lambdaUpdate().in(TpmDeductionMatchingTemplateAllowance::getCode, codeList)).set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode())).update();
    }

    public void disableOrEnable(List<String> idList, String code) {
        Validate.isTrue((!CollectionUtils.isEmpty(idList) ? 1 : 0) != 0, (String)"\u5220\u9664\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List list = ((LambdaQueryChainWrapper)this.tpmDeductionMatchingTemplateRepository.lambdaQuery().in(UuidEntity::getId, idList)).list();
        Validate.noNullElements((Iterable)list, (String)"\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\uff01", (Object[])new Object[0]);
        String tenantCode = TenantUtils.getTenantCode();
        List codeList = list.stream().map(TpmDeductionMatchingTemplate::getCode).collect(Collectors.toList());
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.tpmDeductionMatchingTemplateRepository.lambdaUpdate().in(UuidEntity::getId, idList)).eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).set(UuidFlagOpEntity::getEnableStatus, (Object)code)).update();
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.tpmDeductionMatchingTemplateAllowanceRepository.lambdaUpdate().in(TpmDeductionMatchingTemplateAllowance::getCode, codeList)).eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).set(UuidFlagOpEntity::getEnableStatus, (Object)code)).update();
        ArrayList oldDtos = Lists.newArrayList((Iterable)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)list, TpmDeductionMatchingTemplate.class, TpmDeductionMatchingTemplateDto.class, HashSet.class, ArrayList.class, new String[0]));
        oldDtos.forEach(oldDto -> {
            TpmDeductionMatchingTemplateLogEventDto logEventDto = new TpmDeductionMatchingTemplateLogEventDto();
            logEventDto.setOriginal(oldDto);
            TpmDeductionMatchingTemplateDto newDto = (TpmDeductionMatchingTemplateDto)this.nebulaToolkitService.copyObjectByWhiteList(oldDto, TpmDeductionMatchingTemplateDto.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            newDto.setEnableStatus(code);
            logEventDto.setNewest(newDto);
            SerializableBiConsumer & Serializable onUpdateEnable = TpmDeductionMatchingTemplateLogEventListener::onUpdateEnable;
            this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, TpmDeductionMatchingTemplateLogEventListener.class, (SerializableBiConsumer)onUpdateEnable);
        });
    }

    public TpmDeductionMatchingTemplateVo findByCode(String matchTemplateCode) {
        TpmDeductionMatchingTemplate template = this.tpmDeductionMatchingTemplateRepository.findByCode(matchTemplateCode);
        TpmDeductionMatchingTemplateVo templateVo = (TpmDeductionMatchingTemplateVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)template, TpmDeductionMatchingTemplateVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        templateVo.setAllowances(this.tpmDeductionMatchingTemplateAllowanceRepository.findByCode(templateVo.getCode()));
        return templateVo;
    }

    private void createValidate(TpmDeductionMatchingTemplateDto dto) {
        Validate.notNull((Object)dto, (String)"\u65b0\u589e\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        dto.setId(null);
        Validate.notBlank((CharSequence)dto.getBusinessFormatCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u4e1a\u6001\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getBusinessUnitCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u4e1a\u52a1\u5355\u5143\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getSalesOrgCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u9500\u552e\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getDeductionMatchingTemplateType(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u6263\u8d39\u5339\u914d\u6a21\u677f\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getMatchingCondition(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u5339\u914d\u6761\u4ef6\u8bbe\u7f6e\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.noNullElements((Iterable)dto.getAllowances(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u5bb9\u5dee\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        ArrayList matchList = Lists.newArrayList((Object[])dto.getMatchingCondition().split(","));
        if (matchList.contains(DeductionMatchingTemplateConditionEnum.YEAR_MONTH.getCode()) && matchList.contains(DeductionMatchingTemplateConditionEnum.YEAR_MONTH_DAY.getCode())) {
            throw new IllegalArgumentException("\u5e74\u6708\u65e5\u548c\u5e74\u6708\u4e0d\u53ef\u540c\u65f6\u9009\u62e9");
        }
        if (!matchList.contains(DeductionMatchingTemplateConditionEnum.YEAR_MONTH.getCode())) {
            dto.setIsAddUpMapping(BooleanEnum.FALSE.getCapital());
        }
        if (matchList.contains(DeductionMatchingTemplateConditionEnum.SETTLEMENT_CODE.getCode()) || dto.getMatchingCondition().contains(DeductionMatchingTemplateConditionEnum.FEE_CODE.getCode())) {
            Validate.isTrue((matchList.size() == 1 ? 1 : 0) != 0, (String)"\u9009\u62e9\u8d39\u7528\u5355\u7f16\u7801\u6216\u7ed3\u7b97\u5355\u7f16\u7801\u65f6\uff0c\u4e0d\u53ef\u9009\u62e9\u5176\u4ed6\u5339\u914d\u6761\u4ef6", (Object[])new Object[0]);
        }
        HashSet allowanceKey = Sets.newHashSet();
        dto.getAllowances().forEach(allowance -> {
            String key;
            allowance.setId(null);
            Validate.isTrue((StringUtils.isNotBlank((CharSequence)allowance.getResaleCommercialCode()) || StringUtils.isNotBlank((CharSequence)allowance.getApplyBusinessCustomerCode()) ? 1 : 0) != 0, (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u96f6\u552e\u5546\u4e0e\u5ba2\u6237\u5fc5\u586b\u5176\u4e00\uff01", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)allowance.getApplyMappingCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u9002\u7528\u6620\u5c04\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            if (matchList.contains(DeductionMatchingTemplateConditionEnum.YEAR_MONTH_DAY.getCode())) {
                allowance.setTimeAllowanceType(TpmDeductionMatchingTemplateEnums.AllowanceType.INTEGER.getValue());
                allowance.setTimeAllowanceUnit(TpmDeductionMatchingTemplateEnums.AllowanceUnit.DAY.getValue());
                allowance.setTimeAllowanceValue(Integer.valueOf(0));
            }
            if (matchList.contains(DeductionMatchingTemplateConditionEnum.YEAR_MONTH.getCode())) {
                allowance.setTimeAllowanceUnit(TpmDeductionMatchingTemplateEnums.AllowanceUnit.MONTH.getValue());
                Validate.notBlank((CharSequence)allowance.getTimeAllowanceType(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u65f6\u95f4\u5bb9\u5dee\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
                Validate.notNull((Object)allowance.getTimeAllowanceValue(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u65f6\u95f4\u5bb9\u5dee\u503c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
                Validate.isTrue((allowance.getTimeAllowanceValue() >= 0 ? 1 : 0) != 0, (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u65f6\u95f4\u5bb9\u5dee\u503c\u4e0d\u80fd\u5c0f\u4e8e0\uff01", (Object[])new Object[0]);
            }
            if (!matchList.contains(DeductionMatchingTemplateConditionEnum.YEAR_MONTH.getCode()) && !matchList.contains(DeductionMatchingTemplateConditionEnum.YEAR_MONTH_DAY.getCode())) {
                allowance.setTimeAllowanceType(null);
                allowance.setTimeAllowanceUnit(null);
                allowance.setTimeAllowanceValue(null);
            }
            Validate.isTrue((!allowanceKey.contains(key = allowance.getResaleCommercialCode() + allowance.getApplyBusinessAreaCode() + allowance.getApplyMappingCode() + allowance.getTimeAllowanceType() + allowance.getTimeAllowanceUnit()) ? 1 : 0) != 0, (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u5bb9\u5dee\u4e0d\u80fd\u91cd\u590d\uff01", (Object[])new Object[0]);
            allowanceKey.add(key);
        });
    }

    private void updateValidate(TpmDeductionMatchingTemplateDto dto) {
        Validate.notNull((Object)dto, (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getId(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0cID\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getBusinessFormatCode(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u4e1a\u6001\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getBusinessUnitCode(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u4e1a\u52a1\u5355\u5143\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getSalesOrgCode(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u9500\u552e\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getDeductionMatchingTemplateType(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u6263\u8d39\u5339\u914d\u6a21\u677f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getMatchingCondition(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u5339\u914d\u6761\u4ef6\u8bbe\u7f6e\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.noNullElements((Iterable)dto.getAllowances(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u5bb9\u5dee\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        ArrayList matchList = Lists.newArrayList((Object[])dto.getMatchingCondition().split(","));
        if (matchList.contains(DeductionMatchingTemplateConditionEnum.YEAR_MONTH.getCode()) && matchList.contains(DeductionMatchingTemplateConditionEnum.YEAR_MONTH_DAY.getCode())) {
            throw new IllegalArgumentException("\u5e74\u6708\u65e5\u548c\u5e74\u6708\u4e0d\u53ef\u540c\u65f6\u9009\u62e9");
        }
        if (!matchList.contains(DeductionMatchingTemplateConditionEnum.YEAR_MONTH.getCode())) {
            dto.setIsAddUpMapping(BooleanEnum.FALSE.getCapital());
        }
        if (matchList.contains(DeductionMatchingTemplateConditionEnum.SETTLEMENT_CODE.getCode()) || matchList.contains(DeductionMatchingTemplateConditionEnum.FEE_CODE.getCode())) {
            Validate.isTrue((matchList.size() == 1 ? 1 : 0) != 0, (String)"\u9009\u62e9\u8d39\u7528\u5355\u7f16\u7801\u6216\u7ed3\u7b97\u5355\u7f16\u7801\u65f6\uff0c\u4e0d\u53ef\u9009\u62e9\u5176\u4ed6\u5339\u914d\u6761\u4ef6", (Object[])new Object[0]);
        }
        HashSet allowanceKey = Sets.newHashSet();
        dto.getAllowances().forEach(allowance -> {
            String key;
            allowance.setId(null);
            Validate.isTrue((StringUtils.isNotBlank((CharSequence)allowance.getResaleCommercialCode()) || StringUtils.isNotBlank((CharSequence)allowance.getApplyBusinessCustomerCode()) ? 1 : 0) != 0, (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u96f6\u552e\u5546\u4e0e\u5ba2\u6237\u5fc5\u586b\u5176\u4e00\uff01", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)allowance.getApplyMappingCode(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u9002\u7528\u6620\u5c04\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            if (matchList.contains(DeductionMatchingTemplateConditionEnum.YEAR_MONTH_DAY.getCode())) {
                allowance.setTimeAllowanceType(TpmDeductionMatchingTemplateEnums.AllowanceType.INTEGER.getValue());
                allowance.setTimeAllowanceUnit(TpmDeductionMatchingTemplateEnums.AllowanceUnit.DAY.getValue());
                allowance.setTimeAllowanceValue(Integer.valueOf(0));
            }
            if (matchList.contains(DeductionMatchingTemplateConditionEnum.YEAR_MONTH.getCode())) {
                allowance.setTimeAllowanceUnit(TpmDeductionMatchingTemplateEnums.AllowanceUnit.MONTH.getValue());
                Validate.notBlank((CharSequence)allowance.getTimeAllowanceType(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u65f6\u95f4\u5bb9\u5dee\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
                Validate.notNull((Object)allowance.getTimeAllowanceValue(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u65f6\u95f4\u5bb9\u5dee\u503c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
                Validate.isTrue((allowance.getTimeAllowanceValue() >= 0 ? 1 : 0) != 0, (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u65f6\u95f4\u5bb9\u5dee\u503c\u4e0d\u80fd\u5c0f\u4e8e0\uff01", (Object[])new Object[0]);
            }
            if (!matchList.contains(DeductionMatchingTemplateConditionEnum.YEAR_MONTH.getCode()) && !matchList.contains(DeductionMatchingTemplateConditionEnum.YEAR_MONTH_DAY.getCode())) {
                allowance.setTimeAllowanceType(null);
                allowance.setTimeAllowanceUnit(null);
                allowance.setTimeAllowanceValue(null);
            }
            Validate.isTrue((!allowanceKey.contains(key = allowance.getResaleCommercialCode() + allowance.getApplyBusinessAreaCode() + allowance.getApplyMappingCode() + allowance.getTimeAllowanceType() + allowance.getTimeAllowanceUnit()) ? 1 : 0) != 0, (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u5bb9\u5dee\u4e0d\u80fd\u91cd\u590d\uff01", (Object[])new Object[0]);
            allowanceKey.add(key);
        });
    }
}

