package com.biz.crm.tpm.business.detailed.forecast.local.consumer;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mdm.business.dictionary.sdk.constant.DictConstant;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictToolkitService;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgVoService;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgAllParentVo;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.rocketmq.service.AbstractRocketMqConsumer;
import com.biz.crm.mn.common.rocketmq.service.RocketMqProducer;
import com.biz.crm.mn.common.rocketmq.util.RocketMqUtil;
import com.biz.crm.mn.common.rocketmq.vo.MqMessageVo;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.constant.ActivityDetailPlanConstant;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.constant.ActivityDetailPlanPassMqTagConstant;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanItemDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.enums.ActivityDetailPlanPassMqTagEnum;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.service.ActivityDetailPlanSdkService;
import com.biz.crm.tpm.business.detailed.forecast.local.util.ActivityDetailPlanPassDetailedForecastBuilder;
import com.biz.crm.tpm.business.detailed.forecast.local.util.ActivityDetailPlanPassDetailedForecastUtil;
import com.biz.crm.tpm.business.detailed.forecast.sdk.dto.DetailedForecastDto;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.vo.AuditExecuteIndicatorVo;
import com.bizunited.nebula.security.sdk.login.UserIdentity;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.spring.annotation.ConsumeMode;
import org.apache.rocketmq.spring.annotation.MessageModel;
import org.apache.rocketmq.spring.annotation.RocketMQMessageListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author wanghaojia
 * @date 2023/1/16 19:59
 */
@Slf4j
@Component
@RocketMQMessageListener(topic = ActivityDetailPlanConstant.TPM_ACTIVITY_DETAIL_PLAN_PROCESS_PASS_TOPIC + "${rocketmq.environment}",
        /**
         * tag
         * 可用 || 监听多个tag： "tag1 || tag2 || tag3"
         * 请把tag  定义在 *** 内 需要统一维护
        */
        selectorExpression = ActivityDetailPlanPassMqTagConstant.PASS_DETAILED_FORECAST,
        /**
         * 相同分组下 consumer 可自动负载均衡
         * 请把consumerGroup  定义在 *** 内 需要统一维护
        */
        consumerGroup = ActivityDetailPlanPassMqTagConstant.PASS_DETAILED_FORECAST + "${rocketmq.environment}",
        /**
         * 默认集群消费MqConstant
         * 可以设置 ConsumeMode.ORDERLY 使用广播消费
         * 也可使用集群模式模拟广播模式：
         * 启动多个不同 consumerGroup 的consumer实例
        */
        consumeMode = ConsumeMode.CONCURRENTLY,
        /**
         * 集群消费or广播消费;默认是集群消费
        */
        messageModel = MessageModel.CLUSTERING)
public class ActivityDetailPlanPassDetailedForecastConsumer extends AbstractRocketMqConsumer {

    @Autowired(required = false)
    private ActivityDetailPlanSdkService activityDetailPlanSdkService;

    @Autowired(required = false)
    private ActivityDetailPlanPassDetailedForecastUtil activityDetailPlanPassDetailedForecastUtil;

    @Autowired(required = false)
    private LoginUserService loginUserService;

    @Autowired(required = false)
    private CustomerVoService customerVoService;

    @Autowired(required = false)
    private ProductVoService productVoService;

    @Autowired(required = false)
    private SalesOrgVoService salesOrgVoService;

    @Autowired(required = false)
    private DictToolkitService dictToolkitService;

    @Autowired(required = false)
    private RocketMqProducer rocketMqProducer;

    @Override
    protected Object handleMessage(MqMessageVo message) {
        log.info("活动细案审批通过推送细案预测表 order mq message received  : {}", message);
        if (Objects.isNull(message)
                || StringUtils.isEmpty(message.getMsgBody())) {
            return "消息为空!";
        }
        try {
            List<String> detailPlanCodeList = JSON.parseArray(message.getMsgBody(), String.class);
            List<ActivityDetailPlanDto> dtoList = activityDetailPlanSdkService.buildActivityDetailPlanParams(detailPlanCodeList);
            UserIdentity loginUser = loginUserService.getLoginUser();
            if (!CollectionUtils.isEmpty(dtoList)) {
                Map<String, String> regionMap = dictToolkitService.findMapByDictTypeCode(DictConstant.MDM_CUSTOMIZE_ORG);
                dtoList.forEach(activityDetailPlanDto -> {
                    if (Objects.isNull(activityDetailPlanDto) || CollectionUtil.isEmpty(activityDetailPlanDto.getItemList())) {
                        return;
                    }
                    List<String> cusCodes = activityDetailPlanDto.getItemList().stream()
                            .filter(e -> StringUtils.isNotEmpty(e.getCustomerCode())).map(ActivityDetailPlanItemDto::getCustomerCode).distinct().collect(Collectors.toList());
                    Map<String, CustomerVo> customerVoMap = new HashMap<>();
                    if (!CollectionUtils.isEmpty(cusCodes)) {
                        //指标有的表里面没有客户拼接后编码，强校验了erp编码
                        List<CustomerVo> customerVos = customerVoService.findBaseByCustomerCodes(cusCodes);
                        if (CollectionUtil.isNotEmpty(customerVos)) {
                            customerVoMap.putAll(
                                    customerVos.stream()
                                            .filter(e -> StringUtils.isNotEmpty(e.getErpCode()))
                                            .collect(Collectors.toMap(CustomerVo::getCustomerCode, v -> v)));
                        }
                    }

                    List<String> productCodeList = activityDetailPlanDto.getItemList().stream().filter(e -> StringUtils.isNotEmpty(e.getProductCode())).map(ActivityDetailPlanItemDto::getProductCode).distinct().collect(Collectors.toList());
                    Map<String, ProductVo> productVoMap = Maps.newHashMap();
                    if (CollectionUtil.isNotEmpty(productCodeList)) {
                        List<ProductVo> list = productVoService.findByCodes(productCodeList);
                        productVoMap.putAll(
                                list.stream().collect(Collectors.toMap(ProductVo::getProductCode, v -> v, (v1, v2) -> v2)));
                    }

                    List<String> salesOrgCodes = activityDetailPlanDto.getItemList().stream().filter(e -> StringUtils.isNotEmpty(e.getActivityOrgCode())).map(ActivityDetailPlanItemDto::getActivityOrgCode).distinct().collect(Collectors.toList());
                    Map<String, SalesOrgAllParentVo> salesOrgVoMap = Maps.newHashMap();
                    if (CollectionUtil.isNotEmpty(salesOrgCodes)) {
                        List<SalesOrgAllParentVo> list = salesOrgVoService.findSalesOrgIncludeAllParentByCodes(salesOrgCodes);
                        salesOrgVoMap.putAll(
                                list.stream().collect(Collectors.toMap(SalesOrgAllParentVo::getCurrSalesOrgCode, v -> v, (v1, v2) -> v2)));
                    }

                    //垂直核减堆头数
                    Map<String, AuditExecuteIndicatorVo> auditExecuteIndicatorMap = new HashMap<>();
                    if (StringUtils.equals(BusinessUnitEnum.VERTICAL.getCode(), activityDetailPlanDto.getBusinessUnitCode())){
                        List<String> detailPlanItemCodes = activityDetailPlanDto.getItemList().stream().map(ActivityDetailPlanItemDto::getDetailPlanItemCode).collect(Collectors.toList());
                        List<AuditExecuteIndicatorVo> auditExecuteIndicatorVoList = activityDetailPlanPassDetailedForecastUtil.getMinusCompostQuantity(detailPlanItemCodes);
                        auditExecuteIndicatorMap = auditExecuteIndicatorVoList.stream().collect(Collectors.toMap(AuditExecuteIndicatorVo::getActiveNumber, Function.identity(), (o, n) -> o));
                    }
                    Map<String, AuditExecuteIndicatorVo> finalAuditExecuteIndicatorMap = auditExecuteIndicatorMap;
                    activityDetailPlanDto.getItemList().forEach(item -> {
                        SalesOrgAllParentVo salesOrgAllParentVo = null;
                        if (StringUtils.isNotEmpty(item.getActivityOrgCode())) {
                            salesOrgAllParentVo = salesOrgVoMap.get(item.getActivityOrgCode());
                        }
                        CustomerVo customerVo = null;
                        if (StringUtils.isNotEmpty(item.getCustomerCode())) {
                            customerVo = customerVoMap.get(item.getCustomerCode());
                        }
                        ProductVo productVo = null;
                        if (StringUtils.isNotEmpty(item.getProductCode())) {
                            productVo = productVoMap.get(item.getProductCode());
                        }
                        String businessUnitCode = activityDetailPlanDto.getBusinessUnitCode();
                        DetailedForecastDto detailedForecastDto = ActivityDetailPlanPassDetailedForecastBuilder.buildUnit1Dto(activityDetailPlanDto, item, regionMap, customerVo, salesOrgAllParentVo,productVo, finalAuditExecuteIndicatorMap);
                        if (BusinessUnitEnum.isDefaultBusinessUnit(businessUnitCode)) {
                            //主体
                            try {
                                activityDetailPlanPassDetailedForecastUtil.buildUnit1Param(activityDetailPlanDto, detailedForecastDto, item, loginUser);
                            } catch (Exception e) {
                                log.error("细案编码[{}]明细编码[{}]细案预测生成失败：{}", detailedForecastDto.getDetailedCaseCode(), detailedForecastDto.getActivityDetailItemCode(), e.getMessage());
                                log.error("", e);
                            }
                        } else if (StringUtils.equals(BusinessUnitEnum.VERTICAL.getCode(), businessUnitCode)) {
                            //垂直
                            try {
                                activityDetailPlanPassDetailedForecastUtil.buildUnit3Param(detailedForecastDto, item, loginUser);
                            } catch (Exception e) {
                                log.error("细案编码[{}]明细编码[{}]细案预测生成失败：{}", detailedForecastDto.getDetailedCaseCode(), detailedForecastDto.getActivityDetailItemCode(), e.getMessage());
                                log.error("", e);
                            }
                        }
                    });
                });
            }

        } catch (Exception e) {
            log.error(ActivityDetailPlanPassMqTagEnum.PASS_DETAILED_FORECAST.getName() + "处理失败" + e.getMessage(), e);
            return "消费失败." + e.getMessage();
        } finally {
            //执行玩后推MQ到活动细案审批通过推送扣费预测管理
            MqMessageVo mqMessageVo = new MqMessageVo();
            mqMessageVo.setMsgBody(message.getMsgBody());
            mqMessageVo.setTopic(ActivityDetailPlanConstant.TPM_ACTIVITY_DETAIL_PLAN_PROCESS_PASS_TOPIC + RocketMqUtil.mqEnvironment());
            mqMessageVo.setTag(ActivityDetailPlanPassMqTagEnum.PASS_AUDIT_FEE_PREDICTION.getCode());
            log.info("细案预测表执行玩后推MQ到活动细案审批通过推送扣费预测管理:{}", JSONObject.toJSONString(mqMessageVo));
            rocketMqProducer.sendMqMsg(mqMessageVo, 10);
        }
        return "消费成功.";
    }
}
