package com.biz.crm.tpm.business.detailed.forecast.local.consumer;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.business.common.sdk.service.RedisService;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.biz.crm.mn.common.rocketmq.service.AbstractRocketMqConsumer;
import com.biz.crm.mn.common.rocketmq.vo.MqMessageVo;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.constant.ActivityDetailPlanConstant;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.constant.ActivityDetailPlanPassMqTagConstant;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.service.ActivityDetailPlanItemSdkService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanItemVo;
import com.biz.crm.tpm.business.detailed.forecast.local.entity.DetailedForecastEntity;
import com.biz.crm.tpm.business.detailed.forecast.local.repository.DetailedForecastRepository;
import com.biz.crm.tpm.business.detailed.forecast.local.util.ActivityDetailPlanPassDetailedForecastUtil;
import com.biz.crm.tpm.business.detailed.forecast.sdk.constant.DeatailedForecastConstants;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.vo.AuditExecuteIndicatorVo;
import com.bizunited.nebula.security.sdk.login.UserIdentity;
import com.google.common.collect.Maps;
import jodd.util.StringUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.spring.annotation.ConsumeMode;
import org.apache.rocketmq.spring.annotation.MessageModel;
import org.apache.rocketmq.spring.annotation.RocketMQMessageListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author wanghaojia
 * @date 2023/1/16 19:59
 */
@Slf4j
@Component
@RocketMQMessageListener(topic = ActivityDetailPlanConstant.TPM_ACTIVITY_DETAIL_PLAN_PROCESS_PASS_TOPIC + "${rocketmq.environment}",
        /**
         * tag
         * 可用 || 监听多个tag： "tag1 || tag2 || tag3"
         * 请把tag  定义在 *** 内 需要统一维护
        */
        selectorExpression = ActivityDetailPlanPassMqTagConstant.DETAILED_FORECAST_REFRESH,
        /**
         * 相同分组下 consumer 可自动负载均衡
         * 请把consumerGroup  定义在 *** 内 需要统一维护
        */
        consumerGroup = ActivityDetailPlanPassMqTagConstant.DETAILED_FORECAST_REFRESH + "${rocketmq.environment}",
        /**
         * 默认集群消费MqConstant
         * 可以设置 ConsumeMode.ORDERLY 使用广播消费
         * 也可使用集群模式模拟广播模式：
         * 启动多个不同 consumerGroup 的consumer实例
        */
        consumeMode = ConsumeMode.CONCURRENTLY,
        /**
         * 集群消费or广播消费;默认是集群消费
        */
        messageModel = MessageModel.CLUSTERING)
public class ActivityDetailPlanPassDetailedForecastRefreshConsumer extends AbstractRocketMqConsumer {

    @Autowired(required = false)
    private ActivityDetailPlanPassDetailedForecastUtil activityDetailPlanPassDetailedForecastUtil;

    @Autowired(required = false)
    private LoginUserService loginUserService;

    @Autowired(required = false)
    private RedisService redisService;

    @Autowired(required = false)
    private DetailedForecastRepository detailedForecastRepository;

    @Autowired(required = false)
    private ActivityDetailPlanItemSdkService activityDetailPlanItemSdkService;

    @Autowired(required = false)
    private ProductVoService productVoService;

    @Override
    protected Object handleMessage(MqMessageVo message) {
        log.info("细案预测表更新 order mq message received  : {}", message);
        if (Objects.isNull(message)
                || StringUtils.isEmpty(message.getMsgBody())) {
            return "消息为空!";
        }
        try {
            Object object = redisService.hGet(DeatailedForecastConstants.REFRESH_IDS_KEY, message.getMsgBody());
            if (Objects.isNull(object) || StringUtils.isEmpty(object.toString())) {
                return "缓存ids已过期!";
            }

            List<String> ids = JSON.parseArray(object.toString(), String.class);
            List<DetailedForecastEntity> entityList = detailedForecastRepository.findByIds(ids);
            if (CollectionUtils.isEmpty(entityList)) {
                return "消费警告. 消费对象数据查询为空！";
            }
            List<String> activityDetailItemCodeList = entityList.stream()
                    .filter(k -> StringUtil.isNotEmpty(k.getActivityDetailItemCode()))
                    .map(DetailedForecastEntity::getActivityDetailItemCode)
                    .distinct().collect(Collectors.toList());
            Map<String, ActivityDetailPlanItemVo> itemVoMap = Maps.newHashMap();
            Map<String, ProductVo> productVoMap = Maps.newHashMap();
            if (CollectionUtil.isNotEmpty(activityDetailItemCodeList)) {
                List<ActivityDetailPlanItemVo> itemList = activityDetailPlanItemSdkService.listByItemCodeList(activityDetailItemCodeList);
                if (CollectionUtil.isNotEmpty(itemList)) {
                    itemVoMap.putAll(itemList.stream().collect(Collectors.toMap(ActivityDetailPlanItemVo::getDetailPlanItemCode, v -> v, (n, oldValue) -> n)));
                    List<String> productCodeList = itemList.stream().filter(e -> StringUtils.isNotEmpty(e.getProductCode()))
                            .map(ActivityDetailPlanItemVo::getProductCode).distinct().collect(Collectors.toList());
                    if (CollectionUtil.isNotEmpty(productCodeList)) {
                        List<ProductVo> list = productVoService.findByCodes(productCodeList);
                        productVoMap.putAll(list.stream().collect(Collectors.toMap(ProductVo::getProductCode, v -> v, (v1, v2) -> v2)));
                    }
                }
            }
            UserIdentity loginUser = loginUserService.getLoginUser();

            //垂直核减堆头数
            Map<String, AuditExecuteIndicatorVo> auditExecuteIndicatorMap = new HashMap<>();
            List<String> activityDetailItemCodes = entityList.stream().filter(item -> BusinessUnitEnum.VERTICAL.getCode().equals(item.getBusinessUnitCode())).map(DetailedForecastEntity::getActivityDetailItemCode).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(activityDetailItemCodes)){
                List<AuditExecuteIndicatorVo> auditExecuteIndicatorVoList = activityDetailPlanPassDetailedForecastUtil.getMinusCompostQuantity(activityDetailItemCodes);
                auditExecuteIndicatorMap = auditExecuteIndicatorVoList.stream().collect(Collectors.toMap(AuditExecuteIndicatorVo::getActiveNumber, Function.identity(), (old, ne) -> old));
            }
            Map<String, AuditExecuteIndicatorVo> finalAuditExecuteIndicatorMap = auditExecuteIndicatorMap;
            entityList.forEach(entity -> {
                try {
                    activityDetailPlanPassDetailedForecastUtil.refreshUpdate(entity, itemVoMap.get(entity.getActivityDetailItemCode()), productVoMap, loginUser, finalAuditExecuteIndicatorMap);
                } catch (Exception e) {
                    log.error("细案编码[{}]明细编码[{}]细案预测刷新计算失败：{}", entity.getDetailedCaseCode(), entity.getActivityDetailItemCode(), e.getMessage());
                    log.error("", e);
                }
            });
        } catch (Exception e) {
            log.error("细案预测表更新处理失败" + e.getMessage(), e);
            return "消费失败." + e.getMessage();
        }
        return "消费成功.";
    }

    public void handleMessageTest(MqMessageVo vo) {
        String uuid = UUID.randomUUID().toString().replace("-", "");
        redisService.hSet(DeatailedForecastConstants.REFRESH_IDS_KEY, uuid, vo.getMsgBody(), 60 * 60 * 48);//定时任务每天跑，缓存2天够了
        vo.setMsgBody(uuid);
        this.handleMessage(vo);
    }
}
