package com.biz.crm.tpm.business.detailed.forecast.local.consumer;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.service.RedisService;
import com.biz.crm.mn.common.rocketmq.service.AbstractRocketMqConsumer;
import com.biz.crm.mn.common.rocketmq.service.RocketMqProducer;
import com.biz.crm.mn.common.rocketmq.util.RocketMqUtil;
import com.biz.crm.mn.common.rocketmq.vo.MqMessageVo;
import com.biz.crm.mn.third.system.ecrm.sdk.vo.DetailedForecastRequestVo;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.constant.ActivityDetailPlanConstant;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.constant.ActivityDetailPlanPassMqTagConstant;
import com.biz.crm.tpm.business.detailed.forecast.sdk.constant.DeatailedForecastConstants;
import com.biz.crm.tpm.business.detailed.forecast.sdk.dto.DetailedForecastAutoRefreshDto;
import com.biz.crm.tpm.business.detailed.forecast.sdk.service.DetailedForecastService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.spring.annotation.ConsumeMode;
import org.apache.rocketmq.spring.annotation.MessageModel;
import org.apache.rocketmq.spring.annotation.RocketMQMessageListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Objects;
import java.util.UUID;

/**
 * @author wanghaojia
 * @date 2023/1/16 19:59
 */
@Slf4j
@Component
@RocketMQMessageListener(topic = ActivityDetailPlanConstant.TPM_ACTIVITY_DETAIL_PLAN_PROCESS_PASS_TOPIC + "${rocketmq.environment}",
        /**
         * tag
         * 可用 || 监听多个tag： "tag1 || tag2 || tag3"
         * 请把tag  定义在 *** 内 需要统一维护
        */
        selectorExpression = ActivityDetailPlanPassMqTagConstant.JOB_DETAILED_FORECAST_REFRESH,
        /**
         * 相同分组下 consumer 可自动负载均衡
         * 请把consumerGroup  定义在 *** 内 需要统一维护
        */
        consumerGroup = ActivityDetailPlanPassMqTagConstant.JOB_DETAILED_FORECAST_REFRESH + "${rocketmq.environment}",
        /**
         * 默认集群消费MqConstant
         * 可以设置 ConsumeMode.ORDERLY 使用广播消费
         * 也可使用集群模式模拟广播模式：
         * 启动多个不同 consumerGroup 的consumer实例
        */
        consumeMode = ConsumeMode.CONCURRENTLY,
        /**
         * 集群消费or广播消费;默认是集群消费
        */
        messageModel = MessageModel.CLUSTERING)
public class DetailedForecastRefreshConsumer extends AbstractRocketMqConsumer {

    @Autowired(required = false)
    private DetailedForecastService detailedForecastService;

    @Autowired(required = false)
    private RedisService redisService;

    @Autowired(required = false)
    private RocketMqProducer rocketMqProducer;

    @Override
    protected Object handleMessage(MqMessageVo message) {
        log.info("细案预测表更新 order mq message received  : {}", message);
        if (Objects.isNull(message)
                || StringUtils.isEmpty(message.getMsgBody())) {
            return "消息为空!";
        }
        try {
            Pageable page = PageRequest.of(1, 2000);
            int index = 1;
            DetailedForecastAutoRefreshDto dto = JSONObject.parseObject(message.getMsgBody(), DetailedForecastAutoRefreshDto.class);
            String businessUnitCode = dto.getBusinessUnitCode();
            String yearMonthLy = dto.getYearMonthLy();
            Long total = dto.getTotal();
            while (true) {
                List<String> list = detailedForecastService.findAutoRefreshDataList(page, dto);
                log.info("业务单元[" + businessUnitCode + "]年月[" + yearMonthLy + "]细案预测定时刷新：总数[{}]第[{}]页查询到[{}]条数据！", total, index, list.size());
                if (CollectionUtils.isEmpty(list)) {
                    break;
                }
                try {
                    String uuid = UUID.randomUUID().toString().replace("-", "");
                    redisService.hSet(DeatailedForecastConstants.REFRESH_IDS_KEY, uuid, JSON.toJSONString(list), 60 * 60 * 48);
                    //定时任务每天跑，缓存2天够了
                    MqMessageVo mqMessageVo = new MqMessageVo();
                    mqMessageVo.setMsgBody(uuid);
                    mqMessageVo.setTopic(ActivityDetailPlanConstant.TPM_ACTIVITY_DETAIL_PLAN_PROCESS_PASS_TOPIC + RocketMqUtil.mqEnvironment());
                    mqMessageVo.setTag(ActivityDetailPlanPassMqTagConstant.DETAILED_FORECAST_REFRESH);
                    rocketMqProducer.sendMqMsg(mqMessageVo);
                    Page<DetailedForecastRequestVo> result = new Page<>();
                    result.setTotal(list.size());
                    result.setCurrent(page.getPageNumber());
                    result.setSize(page.getPageSize());
                    Thread.sleep(200);
                    //这里可能会分1000多批推送mq处理数据，防止mq出问题，加延迟
                } catch (Exception e) {
                    log.error("businessUnitCode+细案预测定时刷新发送MQ失败！总数[{}]第[{}]页,{}", total, index, e.getMessage());
                    log.error("", e);
                }
                index++;
                page = PageRequest.of(index, 2000);
            }
        } catch (Exception e) {
            log.error("细案预测表更新处理失败" + e.getMessage(), e);
            return "消费失败." + e.getMessage();
        }
        return "消费成功.";
    }

}
