package com.biz.crm.tpm.business.detailed.forecast.local.consumer;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgVoService;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgAllParentVo;
import com.biz.crm.mn.common.rocketmq.service.AbstractRocketMqConsumer;
import com.biz.crm.mn.common.rocketmq.vo.MqMessageVo;
import com.biz.crm.tpm.business.detailed.forecast.local.util.ActivityDetailPlanPassDetailedForecastBuilder;
import com.biz.crm.tpm.business.detailed.forecast.local.util.ActivityDetailPlanPassDetailedForecastUtil;
import com.biz.crm.tpm.business.detailed.forecast.sdk.dto.DetailedForecastDto;
import com.biz.crm.tpm.business.promotion.plan.sdk.constant.PromotionPlanConstant;
import com.biz.crm.tpm.business.promotion.plan.sdk.constant.PromotionPlanMqTagConstant;
import com.biz.crm.tpm.business.promotion.plan.sdk.service.PromotionPlanService;
import com.biz.crm.tpm.business.promotion.plan.sdk.vo.GeneralExpensesVo;
import com.biz.crm.tpm.business.promotion.plan.sdk.vo.PromotionPlanVo;
import com.bizunited.nebula.security.sdk.login.UserIdentity;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.spring.annotation.ConsumeMode;
import org.apache.rocketmq.spring.annotation.MessageModel;
import org.apache.rocketmq.spring.annotation.RocketMQMessageListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author wanghaojia
 * @date 2023/1/16 19:59
 */
@Slf4j
@Component
@RocketMQMessageListener(topic = PromotionPlanConstant.TPM_PROMOTION_PLAN_PASS_PUSH_DATAILED_FORECAST_TOPIC + "${rocketmq.environment}",
        /**
         * tag
         * 可用 || 监听多个tag： "tag1 || tag2 || tag3"
         * 请把tag  定义在 *** 内 需要统一维护
        */
        selectorExpression = PromotionPlanMqTagConstant.PROMOTION_PLAN_PASS_DETAILED_FORECAST,
        /**
         * 相同分组下 consumer 可自动负载均衡
         * 请把consumerGroup  定义在 *** 内 需要统一维护
        */
        consumerGroup = PromotionPlanMqTagConstant.PROMOTION_PLAN_PASS_DETAILED_FORECAST + "${rocketmq.environment}",
        /**
         * 默认集群消费MqConstant
         * 可以设置 ConsumeMode.ORDERLY 使用广播消费
         * 也可使用集群模式模拟广播模式：
         * 启动多个不同 consumerGroup 的consumer实例
        */
        consumeMode = ConsumeMode.CONCURRENTLY,
        /**
         * 集群消费or广播消费;默认是集群消费
        */
        messageModel = MessageModel.CLUSTERING)
public class PromotionPlanActivityDetailPlanPassDetailedForecastConsumer extends AbstractRocketMqConsumer {


    @Autowired(required = false)
    private PromotionPlanService promotionPlanService;

    @Autowired(required = false)
    private ActivityDetailPlanPassDetailedForecastUtil activityDetailPlanPassDetailedForecastUtil;

    @Autowired(required = false)
    private CustomerVoService customerVoService;

    @Autowired(required = false)
    private SalesOrgVoService salesOrgVoService;

    @Autowired(required = false)
    private ProductVoService productVoService;

    @Autowired(required = false)
    private LoginUserService loginUserService;

    @Override
    protected Object handleMessage(MqMessageVo message) {
        log.info("电商促销规划审批通过推送细案预测表 order mq message received  : {}", message);
        if (Objects.isNull(message)
                || StringUtils.isEmpty(message.getMsgBody())) {
            return "消息为空!";
        }
        try {
            String businessNo = message.getMsgBody();
            List<String> businessNoList = new ArrayList<>();
            if (businessNo.contains("[")) {
                businessNoList = JSON.parseArray(message.getMsgBody(), String.class);
            } else {
                businessNoList.add(businessNo);
            }
            UserIdentity loginUser = loginUserService.getLoginUser();
            List<PromotionPlanVo> planVos = promotionPlanService.findByCodes(businessNoList);
            if (CollectionUtils.isEmpty(planVos)) {
                log.error("电商促销规划审批通过推送细案预测表=====》数据不存在");
                return "电商促销规划审批通过推送细案预测表=====》数据不存在";
            }
            List<String> salesOrgCodes = planVos.stream().filter(e -> StringUtils.isNotEmpty(e.getSalesOrgCode())).map(PromotionPlanVo::getSalesOrgCode).distinct().collect(Collectors.toList());
            Map<String, SalesOrgAllParentVo> salesOrgVoMap = new HashMap<>();
            if (!CollectionUtils.isEmpty(salesOrgCodes)) {
                List<SalesOrgAllParentVo> salesOrgVos = salesOrgVoService.findSalesOrgIncludeAllParentByCodes(salesOrgCodes);
                salesOrgVoMap.putAll(
                        salesOrgVos.stream().collect(Collectors.toMap(SalesOrgAllParentVo::getCurrSalesOrgCode, v -> v, (v1, v2) -> v2)));
            }


            for (PromotionPlanVo plan : planVos) {
                if (Objects.nonNull(plan) && CollectionUtils.isNotEmpty(plan.getGeneralExpensesVos())) {
                    List<CustomerVo> customerVoList = customerVoService.findByCustomerCodes(plan.getGeneralExpensesVos().stream().map(GeneralExpensesVo::getCustomerCode).collect(Collectors.toList()));
                    Map<String, CustomerVo> customerVoMap = customerVoList.stream().collect(Collectors.toMap(CustomerVo::getCustomerCode, Function.identity()));

                    List<String> productCodeList = plan.getGeneralExpensesVos().stream().filter(e -> StringUtils.isNotEmpty(e.getProductCode())).map(GeneralExpensesVo::getProductCode)
                            .distinct().collect(Collectors.toList());
                    Map<String, ProductVo> productVoMap = Maps.newHashMap();
                    if (CollectionUtil.isNotEmpty(productCodeList)) {
                        List<ProductVo> list = productVoService.findByCodes(productCodeList);
                        productVoMap.putAll(
                                list.stream().collect(Collectors.toMap(ProductVo::getProductCode, v -> v, (v1, v2) -> v2)));
                    }

                    plan.getGeneralExpensesVos().forEach(item -> {
                        SalesOrgAllParentVo salesOrgAllParentVo = null;
                        if (StringUtils.isNotEmpty(plan.getSalesOrgCode())) {
                            salesOrgAllParentVo = salesOrgVoMap.get(plan.getSalesOrgCode());
                        }
                        CustomerVo customerVo = null;
                        if (StringUtils.isNotEmpty(item.getCustomerCode())) {
                            customerVo = customerVoMap.get(item.getCustomerCode());
                        }
                        ProductVo productVo = null;
                        if (StringUtils.isNotEmpty(item.getProductCode())) {
                            productVo = productVoMap.get(item.getProductCode());
                        }
                        DetailedForecastDto detailedForecastDto = ActivityDetailPlanPassDetailedForecastBuilder.buildUnit4Dto(plan, item, customerVo, salesOrgAllParentVo, productVo);
                        try {
                            activityDetailPlanPassDetailedForecastUtil.buildUnit4Param(detailedForecastDto, item, loginUser);
                        } catch (Exception e) {
                            log.error("促销规划编号[{}]明细编码[{}]细案预测生成计算失败：{}", detailedForecastDto.getDetailedCaseCode(), detailedForecastDto.getActivityDetailItemCode(), e.getMessage());
                            e.printStackTrace();
                        }
                    });
                }
            }
        } catch (Exception e) {
            log.error("促销规划审批通过推送活动细案MQ消息处理失败" + e.getMessage(), e);
            return "消费失败." + e.getMessage();
        }
        return "消费成功.";
    }

}
