package com.biz.crm.tpm.business.detailed.forecast.local.consumer;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgVoService;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgAllParentVo;
import com.biz.crm.mn.common.rocketmq.service.AbstractRocketMqConsumer;
import com.biz.crm.mn.common.rocketmq.vo.MqMessageVo;
import com.biz.crm.tpm.business.detailed.forecast.local.util.ActivityDetailPlanPassDetailedForecastBuilder;
import com.biz.crm.tpm.business.detailed.forecast.local.util.ActivityDetailPlanPassDetailedForecastUtil;
import com.biz.crm.tpm.business.detailed.forecast.sdk.dto.DetailedForecastDto;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.constant.SubComActivityDetailPlanConstant;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.constant.SubComActivityDetailPlanPassMqTagConstant;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.service.SubComActivityDetailPlanVoService;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.vo.SubComActivityDetailPlanItemVo;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.vo.SubComActivityDetailPlanVo;
import com.bizunited.nebula.security.sdk.login.UserIdentity;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.spring.annotation.ConsumeMode;
import org.apache.rocketmq.spring.annotation.MessageModel;
import org.apache.rocketmq.spring.annotation.RocketMQMessageListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.*;
import java.util.stream.Collectors;

/**
 * @author wanghaojia
 * @date 2023/1/16 19:59
 */
@Slf4j
@Component
@RocketMQMessageListener(topic = SubComActivityDetailPlanConstant.TPM_ACTIVITY_DETAIL_PLAN_PROCESS_PASS_TOPIC + "${rocketmq.environment}",
        /**
         * tag
         * 可用 || 监听多个tag： "tag1 || tag2 || tag3"
         * 请把tag  定义在 *** 内 需要统一维护
        */
        selectorExpression = SubComActivityDetailPlanPassMqTagConstant.PASS_ACTIVITY_DETAIL_DETAILED_FORECAST,
        /**
         * 相同分组下 consumer 可自动负载均衡
         * 请把consumerGroup  定义在 *** 内 需要统一维护
        */
        consumerGroup = SubComActivityDetailPlanPassMqTagConstant.PASS_ACTIVITY_DETAIL_DETAILED_FORECAST + "${rocketmq.environment}",
        /**
         * 默认集群消费MqConstant
         * 可以设置 ConsumeMode.ORDERLY 使用广播消费
         * 也可使用集群模式模拟广播模式：
         * 启动多个不同 consumerGroup 的consumer实例
        */
        consumeMode = ConsumeMode.CONCURRENTLY,
        /**
         * 集群消费or广播消费;默认是集群消费
        */
        messageModel = MessageModel.CLUSTERING)
public class SubComActivityDetailPlanPassDetailedForecastConsumer extends AbstractRocketMqConsumer {

    @Autowired(required = false)
    private SubComActivityDetailPlanVoService subComActivityDetailPlanVoService;

    @Autowired(required = false)
    private ActivityDetailPlanPassDetailedForecastUtil activityDetailPlanPassDetailedForecastUtil;

    @Autowired(required = false)
    private CustomerVoService customerVoService;

    @Autowired(required = false)
    private ProductVoService productVoService;

    @Autowired(required = false)
    private SalesOrgVoService salesOrgVoService;

    @Autowired(required = false)
    private LoginUserService loginUserService;

    @Override
    protected Object handleMessage(MqMessageVo message) {
        log.info("分子活动细案审批通过推送细案预测表 order mq message received  : {}", message);
        if (Objects.isNull(message)
                || StringUtils.isEmpty(message.getMsgBody())) {
            return "消息为空!";
        }
        try {
            UserIdentity loginUser = loginUserService.getLoginUser();
            String businessNo = message.getMsgBody();
            List<String> businessNoList = new ArrayList<>();
            if (businessNo.contains("[")) {
                businessNoList = JSON.parseArray(message.getMsgBody(), String.class);
            } else {
                businessNoList.add(businessNo);
            }
            List<SubComActivityDetailPlanVo> detailPlanVos = subComActivityDetailPlanVoService.findDetailByPlanCodes(businessNoList);
            if (CollectionUtils.isEmpty(detailPlanVos)) {
                log.error("分子活动细案审批通过推送细案预测表=====》数据不存在");
                return "分子活动细案审批通过推送细案预测表=====》数据不存在";
            }
            for (SubComActivityDetailPlanVo detailPlanVo : detailPlanVos) {
                if (Objects.nonNull(detailPlanVo) && CollectionUtils.isNotEmpty(detailPlanVo.getItemList())) {
                    List<String> cusCodes = detailPlanVo.getItemList().stream()
                            .filter(e -> StringUtils.isNotEmpty(e.getCustomerCode())).map(SubComActivityDetailPlanItemVo::getCustomerCode).distinct().collect(Collectors.toList());
                    Map<String, CustomerVo> customerVoMap = Maps.newHashMap();
                    if (CollectionUtil.isNotEmpty(cusCodes)) {
                        //指标有的表里面没有客户拼接后编码，强校验了erp编码
                        List<CustomerVo> customerVos = customerVoService.findBaseByCustomerCodes(cusCodes);
                        if (CollectionUtil.isNotEmpty(customerVos)) {
                            customerVoMap.putAll(
                                    customerVos.stream()
                                            .filter(e -> StringUtils.isNotEmpty(e.getErpCode()))
                                            .collect(Collectors.toMap(CustomerVo::getCustomerCode, vo -> vo, (v1, v2) -> v2)));
                        }
                    }


                    List<String> productCodeList = detailPlanVo.getItemList().stream().filter(e -> StringUtils.isNotEmpty(e.getProductCode())).map(SubComActivityDetailPlanItemVo::getProductCode)
                            .distinct().collect(Collectors.toList());
                    Map<String, ProductVo> productVoMap = Maps.newHashMap();
                    if (CollectionUtil.isNotEmpty(productCodeList)) {
                        List<ProductVo> list = productVoService.findByCodes(productCodeList);
                        productVoMap.putAll(
                                list.stream().collect(Collectors.toMap(ProductVo::getProductCode, v -> v, (v1, v2) -> v2)));
                    }

                    List<String> salesOrgCodes = detailPlanVo.getItemList().stream().filter(e ->
                            StringUtils.isNotEmpty(e.getSalesGroupCode())
                                    || StringUtils.isNotEmpty(e.getSalesOrgCode())
                                    || StringUtils.isNotEmpty(e.getSalesInstitutionCode())
                    ).map(e -> {
                        if (StringUtils.isNotEmpty(e.getSalesGroupCode())) {
                            return e.getSalesGroupCode();
                        } else if (StringUtils.isNotEmpty(e.getSalesOrgCode())) {
                            return e.getSalesOrgCode();
                        } else if (StringUtils.isNotEmpty(e.getSalesInstitutionCode())) {
                            return e.getSalesInstitutionCode();
                        }
                        return "";
                    }).distinct().collect(Collectors.toList());
                    Map<String, SalesOrgAllParentVo> salesOrgVoMap = new HashMap<>();
                    if (CollectionUtils.isNotEmpty(salesOrgCodes)) {
                        List<SalesOrgAllParentVo> list = salesOrgVoService.findSalesOrgIncludeAllParentByCodes(salesOrgCodes);
                        salesOrgVoMap.putAll(
                                list.stream().collect(Collectors.toMap(SalesOrgAllParentVo::getCurrSalesOrgCode, v -> v, (v1, v2) -> v2)));
                    }

                    detailPlanVo.getItemList().forEach(item -> {
                        CustomerVo customerVo = null;
                        if (StringUtils.isNotEmpty(item.getCustomerCode())) {
                            customerVo = customerVoMap.get(item.getCustomerCode());
                        }
                        ProductVo productVo = null;
                        if (StringUtils.isNotEmpty(item.getProductCode())) {
                            productVo = productVoMap.get(item.getProductCode());
                        }
                        DetailedForecastDto detailedForecastDto = ActivityDetailPlanPassDetailedForecastBuilder.buildUnit2Dto(detailPlanVo, item, customerVo, salesOrgVoMap, productVo);
                        try {
                            activityDetailPlanPassDetailedForecastUtil.buildUnit2Param(detailedForecastDto, item, loginUser);
                        } catch (Exception e) {
                            log.error("分子细案编码[{}]明细编码[{}]细案预测生成计算失败：{}", detailedForecastDto.getDetailedCaseCode(), detailedForecastDto.getActivityDetailItemCode(), e.getMessage());
                            log.error("", e);
                        }
                    });
                }
            }
        } catch (Exception e) {
            log.error("分子活动细案审批通过推送细案预测表处理失败" + e.getMessage(), e);
            return "消费失败." + e.getMessage();
        }
        return "消费成功.";
    }

    public Object handleMessageTest(MqMessageVo message) {
        return this.handleMessage(message);
    }

}
