package com.biz.crm.tpm.business.detailed.forecast.local.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.rocketmq.service.RocketMqProducer;
import com.biz.crm.mn.common.rocketmq.util.RocketMqUtil;
import com.biz.crm.mn.common.rocketmq.vo.MqMessageVo;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.constant.ActivityDetailPlanConstant;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.constant.ActivityDetailPlanPassMqTagConstant;
import com.biz.crm.tpm.business.detailed.forecast.local.consumer.ActivityDetailPlanPassDetailedForecastRefreshConsumer;
import com.biz.crm.tpm.business.detailed.forecast.local.mapper.DetailedForecastMapper;
import com.biz.crm.tpm.business.detailed.forecast.local.service.internal.DetailedForecastAutoCreateXxlJob;
import com.biz.crm.tpm.business.detailed.forecast.local.service.internal.DetailedForecastAutoRefreshXxlJob;
import com.biz.crm.tpm.business.detailed.forecast.local.task.impl.DeatailedForecastSchedulingImp;
import com.biz.crm.tpm.business.detailed.forecast.local.util.DetailedForecastVerticalBudgetDataUtil;
import com.biz.crm.tpm.business.detailed.forecast.sdk.dto.*;
import com.biz.crm.tpm.business.detailed.forecast.sdk.service.DetailedForecastService;
import com.biz.crm.tpm.business.detailed.forecast.sdk.vo.DetailedForecastSummaryVo;
import com.biz.crm.tpm.business.detailed.forecast.sdk.vo.DetailedForecastVo;
import com.biz.crm.tpm.business.detailed.forecast.sdk.vo.UpExpectAuditAmountMonitorVo;
import com.biz.crm.tpm.business.promotion.plan.sdk.constant.PromotionPlanConstant;
import com.biz.crm.tpm.business.promotion.plan.sdk.constant.PromotionPlanMqTagConstant;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.constant.SubComActivityDetailPlanConstant;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.constant.SubComActivityDetailPlanPassMqTagConstant;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author youjun
 * @date 2022年11月08日 19:53
 */
@RestController
@RequestMapping("/v1/detailed/forecast")
@Slf4j
@Api(tags = "细案预测")
public class DetailedForecastController {

    /**
     * 服务对象
     */
    @Autowired
    private DetailedForecastService detailedForecastService;

    @Autowired(required = false)
    private DetailedForecastMapper detailedForecastMapper;

    @Autowired(required = false)
    private RocketMqProducer rocketMqProducer;

    @Autowired(required = false)
    private DeatailedForecastSchedulingImp deatailedForecastSchedulingImp;

    @Autowired(required = false)
    private ActivityDetailPlanPassDetailedForecastRefreshConsumer activityDetailPlanPassDetailedForecastRefreshConsumer;

    @Autowired(required = false)
    private DetailedForecastAutoRefreshXxlJob detailedForecastAutoRefreshXxlJob;

    @Autowired(required = false)
    private DetailedForecastAutoCreateXxlJob detailedForecastAutoCreateXxlJob;

    @Autowired(required = false)
    private DetailedForecastVerticalBudgetDataUtil detailedForecastVerticalBudgetDataUtil;

    /**
     * 后端 预算预测管理 列表
     *
     * @param pageable 分页对象
     * @param dto      查询实体
     * @return 所有数据
     */
    @ApiOperation(value = "后端预算预测管理列表")
    @GetMapping("findByForecastsForWebList")
    public Result<Page<DetailedForecastVo>> findByForecastsForWebList(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
                                                                      @ApiParam(name = "detailedForecast", value = "细案预测表") DetailedForecastDto dto) {
        try {
            Page<DetailedForecastVo> page = this.detailedForecastService.findByForecastsForWebList(pageable, dto);
            return Result.ok(page);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 分页查询所有数据
     *
     * @param pageable         分页对象
     * @param detailedForecast 查询实体
     * @return 所有数据
     */
    @ApiOperation(value = "分页查询所有数据")
    @GetMapping("findByForecasts")
    public Result<Page<DetailedForecastVo>> findByForecasts(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
                                                            @ApiParam(name = "detailedForecast", value = "细案预测表") DetailedForecastDto detailedForecast) {
        try {
            Page<DetailedForecastVo> page = this.detailedForecastService.findByForecasts(pageable, detailedForecast);
            return Result.ok(page);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 新增细案预测数据
     *
     * @param detailedForecast 实体对象
     * @return 新增结果
     */
    @ApiOperation(value = "新增数据")
    @PostMapping("create")
    public Result<?> create(@ApiParam(name = "detailedForecast", value = "细案预测表") @RequestBody DetailedForecastDto detailedForecast) {
        try {

            return Result.ok(this.detailedForecastService.create(detailedForecast));
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 修改数据
     *
     * @param detailedForecast 实体对象
     * @return 修改结果
     */
    @ApiOperation(value = "修改数据")
    @PatchMapping
    public Result<?> update(@ApiParam(name = "detailedForecast", value = "细案预测表") @RequestBody DetailedForecastDto detailedForecast) {
        try {
            return Result.ok(this.detailedForecastService.update(detailedForecast));
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }


    /**
     * 批量更新(重新计算预估可核销金额)
     *
     * @param idList 主键列表
     * @return 修改结果
     */
    @ApiOperation(value = "批量更新(重新计算预估可核销金额)")
    @PatchMapping("updateAuditAmount")
    public Result<?> updateAuditAmount(@ApiParam(name = "idList", value = "主键集合") @RequestBody List<String> idList) {
        try {
            this.detailedForecastService.updateAuditAmount(idList);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 批量确认
     *
     * @param idList 主键列表
     * @return 修改结果
     */
    @ApiOperation(value = "确认")
    @PatchMapping("confirm")
    public Result<?> confirm(@ApiParam(name = "idList", value = "主键集合") @RequestBody List<String> idList) {
        try {
            this.detailedForecastService.confirm(idList);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 删除数据
     *
     * @param ids 主键结合
     * @return 删除结果
     */
    @ApiOperation(value = "删除数据", notes = "")
    @DeleteMapping("delete")
    public Result<?> deleteById(@RequestParam("ids") List<String> ids) {
        try {
            this.detailedForecastService.delete(ids);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 通过主键查询单条数据
     *
     * @param id 主键
     * @return 单条数据
     */
    @ApiOperation(value = "通过主键查询单条数据")
    @GetMapping("{id}")
    public Result<DetailedForecastVo> findById(@PathVariable @ApiParam(name = "id", value = "主键id", required = true) String id) {
        try {
            DetailedForecastVo detailedForecastVo = this.detailedForecastService.findById(id);
            return Result.ok(detailedForecastVo);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 更新数据不覆盖
     *
     * @param detailedForecast 主键
     * @return 更新数据不覆盖
     */
    @ApiOperation(value = "更新不覆盖数据")
    @PostMapping("updateDetailedForecast")
    public Result<?> updateDetailedForecast(@ApiParam(name = "detailedForecast", value = "细案预测表") @RequestBody DetailedForecastDto detailedForecast) {
        try {
            this.detailedForecastService.updateDetailedForecast(detailedForecast);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }


    @ApiOperation("callEcrm")
    @GetMapping("callEcrm")
    public Result callEcrm() {
        try {
            deatailedForecastSchedulingImp.executePullTask();
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    @ApiOperation("初始化-活动细案审批通过推送细案预测表")
    @PostMapping("mainQuarterInit")
    public Result mainQuarterInit(@RequestBody DetailedForecastInitDto dto) {
        Validate.notBlank(dto.getBusinessUnitCode(), "业务单元为空！");
        try {
            int pageNumber = 1;
            int pageSize = 50;
            while (true) {
                Page<String> page = new Page<>(pageNumber, pageSize);
                Page<String> pageList = null;
                if (BusinessUnitEnum.isDefaultBusinessUnit(dto.getBusinessUnitCode()) || BusinessUnitEnum.VERTICAL.getCode().equals(dto.getBusinessUnitCode())) {
                    pageList = detailedForecastMapper.findInitCodeList(page, dto);
                } else if (BusinessUnitEnum.SON_COMPANY.getCode().equals(dto.getBusinessUnitCode())) {
                    pageList = detailedForecastMapper.findSubComInitCodeList(page, dto);
                } else if (BusinessUnitEnum.ONLINE.getCode().equals(dto.getBusinessUnitCode())) {
                    pageList = detailedForecastMapper.findOnlineInitCodeList(page, dto);
                } else {
                    throw new RuntimeException("初始化-活动细案审批通过推送细案预测表=====>未定义该业务单元[" + dto.getBusinessUnitCode() + "]处理逻辑");
                }
                if (CollectionUtils.isEmpty(pageList.getRecords())) {
                    break;
                }
                log.info("初始化-活动细案审批通过推送细案预测表=====>{}, {}, {}", pageNumber, pageList.getRecords().size(), pageList.getTotal());
                MqMessageVo vo = new MqMessageVo();
                if (BusinessUnitEnum.isDefaultBusinessUnit(dto.getBusinessUnitCode()) || BusinessUnitEnum.VERTICAL.getCode().equals(dto.getBusinessUnitCode())) {
                    vo.setTopic(ActivityDetailPlanConstant.TPM_ACTIVITY_DETAIL_PLAN_PROCESS_PASS_TOPIC + RocketMqUtil.mqEnvironment());
                    vo.setTag(ActivityDetailPlanPassMqTagConstant.PASS_DETAILED_FORECAST);
                    log.info("初始化-活动细案审批通过推送细案预测表=====>{}", dto.getBusinessUnitCode());
                } else if (BusinessUnitEnum.SON_COMPANY.getCode().equals(dto.getBusinessUnitCode())) {
                    vo.setTopic(SubComActivityDetailPlanConstant.TPM_ACTIVITY_DETAIL_PLAN_PROCESS_PASS_TOPIC + RocketMqUtil.mqEnvironment());
                    vo.setTag(SubComActivityDetailPlanPassMqTagConstant.PASS_ACTIVITY_DETAIL_DETAILED_FORECAST);
                    log.info("初始化-活动细案审批通过推送细案预测表=====>{}", dto.getBusinessUnitCode());
                } else if (BusinessUnitEnum.ONLINE.getCode().equals(dto.getBusinessUnitCode())) {
                    vo.setTopic(PromotionPlanConstant.TPM_PROMOTION_PLAN_PASS_PUSH_DATAILED_FORECAST_TOPIC + RocketMqUtil.mqEnvironment());
                    vo.setTag(PromotionPlanMqTagConstant.PROMOTION_PLAN_PASS_DETAILED_FORECAST);
                    log.info("初始化-活动细案审批通过推送细案预测表=====>{}", dto.getBusinessUnitCode());
                }
                vo.setMsgBody(JSONObject.toJSONString(pageList.getRecords()));
                log.info("初始化-活动细案审批通过推送细案预测表=====>{}", JSONObject.toJSON(vo));
                rocketMqProducer.sendMqMsg(vo);
                Thread.sleep(200);
                pageNumber++;
            }
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    @ApiOperation("测试细案预测表更新")
    @PostMapping("testRefresh")
    public Result testRefresh(@RequestBody List<String> list) {
        try {
            MqMessageVo vo = new MqMessageVo();
            vo.setMsgBody(JSONObject.toJSONString(list));
            activityDetailPlanPassDetailedForecastRefreshConsumer.handleMessageTest(vo);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 推送数据到ECRM
     *
     * @param idList 细案预测id列表
     * @return com.biz.crm.business.common.sdk.model.Result<?>
     * @author jiangyin
     * @date 2023/2/20 20:54
     */
    @ApiOperation("推送数据到ECRM")
    @PostMapping("pushEcrm")
    public Result<?> pushEcrm(@RequestBody List<String> idList) {
        try {
            this.detailedForecastService.pushEcrm(idList);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }


    @ApiOperation("测试细案预测自动刷新定时任务")
    @PostMapping("testAutoRefresh")
    public Result<?> testAutoRefresh(@RequestBody DetailedForecastAutoRefreshDto dto) {
        try {
            this.detailedForecastAutoRefreshXxlJob.testAutoRefresh(dto);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    @ApiOperation("测试细案预测定时补创建任务")
    @PostMapping("testAutoCreate")
    public Result<?> testAutoCreate(@RequestBody DetailedForecastAutoRefreshDto dto) {
        try {
            this.detailedForecastAutoCreateXxlJob.autoCreate();
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    @ApiOperation("核销结案审批通过更新核销金额")
    @PostMapping("updateWriteOffAmount")
    public Result<?> updateWriteOffAmount(@RequestBody List<String> auditCodes) {
        try {
            this.detailedForecastService.updateWriteOffAmount(auditCodes);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    @ApiOperation("刷预算-初始化")
    @PostMapping("initBudget")
    public Result<?> initBudget(@RequestBody List<String> budgetCodeList) {
        try {
            this.detailedForecastVerticalBudgetDataUtil.initBudget(budgetCodeList);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    @ApiOperation("刷预算-重新占用")
    @PostMapping("washData")
    public Result<?> washData(@RequestBody List<String> activityDetailItemCodeList) {
        try {
            this.detailedForecastVerticalBudgetDataUtil.washData(activityDetailItemCodeList);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 向上预计可核销金额监控表 （只取常温、主体数据）
     * 数据视图编码（tpm_up_expect_audit_amount_monitor_data_view）
     *
     * @param pageable 分页对象
     * @param dto      查询实体
     * @return 所有数据
     */
    @ApiOperation(value = "向上预计可核销金额监控表")
    @GetMapping("/pageUpExpectAuditAmountMonitor")
    public Result<Page<UpExpectAuditAmountMonitorVo>> pageUpExpectAuditAmountMonitor(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
                                                                                     @ApiParam(name = "detailedForecast", value = "细案预测表") UpExpectAuditAmountMonitorDto dto) {
        try {
            Page<UpExpectAuditAmountMonitorVo> page = this.detailedForecastService.pageUpExpectAuditAmountMonitor(pageable, dto);
            return Result.ok(page);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    @ApiOperation(value = "细案预测汇总分页查询")
    @GetMapping("summaryPage")
    public Result<Page<DetailedForecastSummaryVo>> summaryPage(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
                                                               @ApiParam(name = "dto", value = "细案预测汇总dto") DetailedForecastSummaryDto dto) {
        try {
            Page<DetailedForecastSummaryVo> page = this.detailedForecastService.summaryPage(pageable, dto);
            return Result.ok(page);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    @ApiOperation(value = "细案预测汇总手动执行Job")
    @GetMapping("detailedForecastSummaryUpdateQuery")
    public Result<?> detailedForecastSummaryUpdateQuery(@ApiParam(name = "dto", value = "细案预测汇总dto") DetailedForecastSummaryDto dto) {
        try {
            this.detailedForecastService.detailedForecastSummaryUpdateQuery(dto);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }
}
