package com.biz.crm.tpm.business.detailed.forecast.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.detailed.forecast.sdk.dto.DetailedForecastFeeLedgerDto;
import com.biz.crm.tpm.business.detailed.forecast.sdk.service.DetailedForecastFeeLedgerService;
import com.biz.crm.tpm.business.detailed.forecast.sdk.vo.DetailedForecastFeeLedgerVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author: yaoyongming
 * @date: 2023/4/13 10:01
 */
@RestController
@RequestMapping("/v1/detailed/forecast/feeLedger")
@Slf4j
@Api(tags = "细案核销台账表")
public class DetailedForecastFeeLedgerController {
    
    @Autowired(required = false)
    private DetailedForecastFeeLedgerService detailedForecastFeeLedgerService;

    /**
     * 分页查询所有数据
     *
     * @param pageable         分页对象
     * @param detailedForecast 查询实体
     * @return 所有数据
     */
    @ApiOperation(value = "分页查询所有数据")
    @GetMapping("findByForecasts")
    public Result<Page<DetailedForecastFeeLedgerVo>> findByForecasts(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
                                          @ApiParam(name = "detailedForecast", value = "细案核销台账表") DetailedForecastFeeLedgerDto detailedForecast) {
        try {
            Page<DetailedForecastFeeLedgerVo> page = this.detailedForecastFeeLedgerService.findByForecasts(pageable, detailedForecast);
            return Result.ok(page);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }
}
