package com.biz.crm.tpm.business.detailed.forecast.local.entity;


import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @author youjun
 * @date 2022年11月08日 17:27
 */
@ApiModel(value = "DetailedForecastEntity", description = "TPM-细案预测")
@TableName("tpm_detailed_forecast")
@Getter
@Setter
@Entity(name = "tpm_detailed_forecast")
@org.hibernate.annotations.Table(appliesTo = "tpm_detailed_forecast", comment = "TPM-细案预测")
@Table(
        name = "tpm_detailed_forecast",
        indexes = {
                @Index(name = "tpm_detailed_forecast_index1", columnList = "activity_detail_item_code"),
                @Index(name = "tpm_detailed_forecast_index2", columnList = "only_key", unique = true),
                @Index(name = "tpm_detailed_forecast_index3", columnList = "tenant_code,del_flag,business_format_code,business_unit_code,show_flag"),
                @Index(name = "tpm_detailed_forecast_index4", columnList = "year_month_str"),
                @Index(name = "tpm_detailed_forecast_index5", columnList = "create_time,id"),
        }
)
public class DetailedForecastEntity extends TenantFlagOpEntity {

    /**
     * 唯一key
     */
    @ApiModelProperty(name = "onlyKey", notes = "唯一key")
    @Column(name = "only_key", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT '唯一key '")
    private String onlyKey;

    /**
     * 状态
     */
    @ApiModelProperty(name = "detailedPredictionType", notes = "状态")
    @Column(name = "detailed_prediction_type", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT '状态 '")
    private String detailedPredictionType;

    /**
     * 业态[数据字典:mdm_business_format]
     */
    @ApiModelProperty(name = "businessFormatCode", notes = "业态[数据字典:mdm_business_format]")
    @Column(name = "business_format_code", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT '业态[数据字典:mdm_business_format] '")
    private String businessFormatCode;

    /**
     * 业务单元[数据字典:mdm_business_unit]
     */
    @ApiModelProperty(name = "businessUnitCode", notes = "业务单元[数据字典:mdm_business_unit]")
    @Column(name = "business_unit_code", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT '业务单元[数据字典:mdm_business_unit] '")
    private String businessUnitCode;

    /**
     * 方案编码
     */
    @ApiModelProperty(name = "schemeCode", notes = "方案编码")
    @Column(name = "scheme_code", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT '方案编码 '")
    private String schemeCode;

    /**
     * 方案名称
     */
    @ApiModelProperty(name = "schemeName", notes = "方案名称")
    @Column(name = "scheme_name", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT '方案名称 '")
    private String schemeName;

    /**
     * 细案编码
     */
    @ApiModelProperty(name = "detailedCaseCode", notes = "细案编码")
    @Column(name = "detailed_case_code", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT '细案编码 '")
    private String detailedCaseCode;

    /**
     * 细案名称
     */
    @ApiModelProperty(name = "detailedCaseName", notes = "细案名称")
    @Column(name = "detailed_case_name", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT '细案名称 '")
    private String detailedCaseName;

    /**
     * 活动类型
     */
    @ApiModelProperty(name = "activityTypeCode", notes = "活动类型")
    @Column(name = "activity_type_code", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT '活动类型 '")
    private String activityTypeCode;

    @ApiModelProperty(name = "活动类型名称", notes = "活动类型名称")
    @Column(name = "activity_type_name", length = 256, columnDefinition = "VARCHAR(256) COMMENT '活动类型名称'")
    private String activityTypeName;

    /**
     * 活动形式
     */
    @ApiModelProperty(name = "activityFormCode", notes = "活动形式")
    @Column(name = "activity_form_code", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT '活动形式 '")
    private String activityFormCode;

    @ApiModelProperty(name = "活动形式名称", notes = "活动形式名称")
    @Column(name = "activity_form_name", length = 256, columnDefinition = "VARCHAR(256) COMMENT '活动形式名称'")
    private String activityFormName;

    /**
     * 活动开始时间
     */
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(name = "activityStartTime", notes = "活动开始时间")
    @Column(name = "activity_start_time", columnDefinition = "datetime COMMENT '活动开始时间 '")
    private Date activityStartTime;

    /**
     * 活动结束时间
     */
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(name = "activityEndTime", notes = "活动结束时间")
    @Column(name = "activity_end_time", columnDefinition = "datetime COMMENT '活动结束时间 '")
    private Date activityEndTime;

    /**
     * 一级管理渠道
     */
    @ApiModelProperty(name = "primaryManagementChannel", notes = "一级管理渠道")
    @Column(name = "primary_management_channel", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT '一级管理渠道 '")
    private String primaryManagementChannel;

    /**
     * 客户
     */
    @ApiModelProperty(name = "customer", notes = "客户")
    @Column(name = "customer", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT '客户 '")
    private String customer;

    /**
     * 客户编码
     */
    @ApiModelProperty(name = "customerCode", notes = "客户编码")
    @Column(name = "customer_code", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT '客户编码 '")
    private String customerCode;

    /**
     * 客户erpCode
     */
    @Column(name = "customer_erp_code", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT '客户erpCode '")
    private String customerErpCode;


    @ApiModelProperty("电商客户等级编码")
    @Column(name = "estore_customer_level", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT '电商客户等级编码 '")
    private String estoreCustomerLevel;

    /**
     * 客户rtm模式
     */
    @ApiModelProperty(name = "rtmMode", notes = "客户rtm模式")
    @Column(name = "rtm_mode", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT '客户rtm模式 '")
    private String rtmMode;

    /**
     * 核销类型
     */
    @ApiModelProperty(name = "auditType", notes = "核销类型")
    @Column(name = "audit_type", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT '核销类型 '")
    private String auditType;

    /**
     * 核销公式编码
     */
    @ApiModelProperty(name = "auditFormulaCode", notes = "核销公式编码")
    @Column(name = "audit_formula_code", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT '核销公式编码 '")
    private String auditFormulaCode;

    /**
     * 核销条件
     */
    @ApiModelProperty(name = "writeOffConditions", notes = "核销条件")
    @Column(name = "write_off_conditions", nullable = true, columnDefinition = "text COMMENT '核销条件 '")
    private String writeOffConditions;

    /**
     * 核销公式
     */
    @ApiModelProperty(name = "writeOffFormula", notes = "核销公式")
    @Column(name = "write_off_formula", nullable = true, columnDefinition = "text COMMENT '核销公式 '")
    private String writeOffFormula;

    /**
     * 核销条件取值
     */
    @ApiModelProperty(name = "writeOffConditionValue", notes = "核销条件取值")
    @Column(name = "write_off_condition_value", nullable = true,  columnDefinition = "text COMMENT '核销条件取值 '")
    private String writeOffConditionValue;

    /**
     * 核销公式取值
     */
    @ApiModelProperty(name = "writeOffFormulaValue", notes = "核销公式取值")
    @Column(name = "write_off_formula_value", nullable = true, columnDefinition = "text COMMENT '核销公式取值 '")
    private String writeOffFormulaValue;

    /**
     * 预估核销金额
     */
    @ApiModelProperty(name = "estimatedWriteOffAmount",notes = "预估核销金额")
    @Column(name = "estimated_write_off_amount", columnDefinition = "decimal(24,6) COMMENT '预估核销金额'")
    private BigDecimal estimatedWriteOffAmount;

    /**
     * 实际核销金额
     */
    @ApiModelProperty(name = "actualWriteOffAmount",notes = "实际核销金额")
    @Column(name = "actual_write_off_amount", columnDefinition = "decimal(24,6) COMMENT '实际核销金额'")
    private BigDecimal actualWriteOffAmount;


    /**
     * 核销金额
     */
    @ApiModelProperty(name = "writeOffAmount",notes = "核销金额")
    @Column(name = "write_off_amount", columnDefinition = "decimal(24,6) COMMENT '核销金额'")
    private BigDecimal writeOffAmount;

    /**
     * 任务量缺口
     */
    @ApiModelProperty(name = "taskVolumeGap",notes = "任务量缺口")
    @Column(name = "task_volume_gap", columnDefinition = "decimal(24,6) COMMENT '任务量缺口'")
    private BigDecimal taskVolumeGap;

    /**
     * 细案明细编码
     */
    @ApiModelProperty(name = "activityDetailItemCode",notes = "细案明细编码")
        @Column(name = "activity_detail_item_code",nullable = true, length = 32, columnDefinition = "VARCHAR(64) COMMENT '细案明细编码'")
    private String activityDetailItemCode;

    /**
     * 核销公式取值
     */
    @ApiModelProperty(name = "writeOffPremise", notes = "可核销前提")
    @Column(name = "write_off_premise", nullable = true, columnDefinition = "text COMMENT '可核销前提 '")
    private String writeOffPremise;

    /**
     * 预算编码
     */
    @ApiModelProperty("预算编码")
    @Column(name = "budget_code", length = 32, columnDefinition = " varchar(32) COMMENT '预算编码'")
    private String budgetCode;

    /**
     * 产品编码
     */
    @ApiModelProperty("产品编码")
    @Column(name = "product_code", length = 128, columnDefinition = " varchar(128) COMMENT '产品编码'")
    private String productCode;

    /**
     * 产品名称
     */
    @ApiModelProperty("产品名称")
    @Column(name = "product_name", length = 128, columnDefinition = " varchar(128) COMMENT '产品名称'")
    private String productName;

    /**
     * 销售组织编码
     */
    @ApiModelProperty("销售组织编码")
    @Column(name = "sale_org_code", length = 128, columnDefinition = " varchar(128) COMMENT '销售组织编码'")
    private String saleOrgCode;

    /**
     * 销售组织ERP编码
     */
    @ApiModelProperty("销售组织ERP编码")
    @Column(name = "sale_org_erp_code", length = 128, columnDefinition = " varchar(128) COMMENT '销售组织ERP编码'")
    private String saleOrgErpCode;

    /**
     * 销售组织名称
     */
    @ApiModelProperty("销售组织名称")
    @Column(name = "sale_org_name", length = 128, columnDefinition = " varchar(128) COMMENT '销售组织名称'")
    private String saleOrgName;

    /**
     * 所属销售机构ERP编码
     */
    @ApiModelProperty("所属销售机构ERP编码")
    @Column(name = "sales_institution_erp_code", length = 32, columnDefinition = " varchar(32) COMMENT '所属销售机构ERP编码'")
    private String salesInstitutionErpCode;

    /**
     * 销售机构编码
     */
    @ApiModelProperty(name = "salesInstitutionCode", value = "销售机构编码", notes = "销售机构编码")
    @Column(name = "sales_institution_code", length = 64, columnDefinition = " varchar(64) COMMENT '销售机构编码'")
    private String salesInstitutionCode;

    /**
     * 销售机构名称
     */
    @ApiModelProperty(name = "salesInstitutionName", value = "销售机构名称", notes = "销售机构名称")
    @Column(name = "sales_institution_name", length = 128, columnDefinition = " varchar(128) COMMENT '销售机构名称'")
    private String salesInstitutionName;

    @ApiModelProperty("所属销售大区ERP编码")
    @Column(name = "sales_region_erp_code", length = 32, columnDefinition = " varchar(32) COMMENT '所属销售大区ERP编码'")
    private String salesRegionErpCode;

    @ApiModelProperty("所属销售大区编码")
    @Column(name = "sales_region_code", length = 64, columnDefinition = " varchar(64) COMMENT '所属销售大区编码'")
    private String salesRegionCode;

    @ApiModelProperty("所属销售大区名称")
    @Column(name = "sales_region_name", length = 128, columnDefinition = " varchar(128) COMMENT '所属销售大区名称'")
    private String salesRegionName;

    @ApiModelProperty("所属销售组织(组)ERP编码")
    @Column(name = "sales_group_erp_code", length = 32, columnDefinition = " varchar(32) COMMENT '所属销售组织(组)ERP编码'")
    private String salesGroupErpCode;

    @ApiModelProperty("所属销售组织(组)编码")
    @Column(name = "sales_group_code", length = 64, columnDefinition = " varchar(64) COMMENT '所属销售组织(组)编码'")
    private String salesGroupCode;

    @ApiModelProperty("所属销售组织(组)名称")
    @Column(name = "sales_group_name", length = 128, columnDefinition = " varchar(128) COMMENT '所属销售组织(组)编码'")
    private String salesGroupName;

    @ApiModelProperty("所属销售组织ERP编码")
    @Column(name = "sales_org_erp_code", length = 32, columnDefinition = " varchar(32) COMMENT '所属销售组织ERP编码'")
    private String salesOrgErpCode;

    @ApiModelProperty("所属销售组织编码")
    @Column(name = "sales_org_code", length = 64, columnDefinition = " varchar(64) COMMENT '所属销售组织编码'")
    private String salesOrgCode;

    @ApiModelProperty("所属销售组织名称")
    @Column(name = "sales_org_name", length = 128, columnDefinition = " varchar(128) COMMENT '所属销售组织名称'")
    private String salesOrgName;

    /**
     * 公式计算参数
     */
    @Column(name = "cal_param", columnDefinition = "text COMMENT '公式计算参数'")
    private String calParam;

    /**
     * 公式计算异常
     */
    @Column(name = "cal_ex", columnDefinition = "VARCHAR(500) COMMENT '公式计算异常'")
    private String calEx;

    /**
     * 年月
     */
    @Column(name = "year_month_str", columnDefinition = "VARCHAR(64) COMMENT '年月'")
    private String yearMonthStr;

    @ApiModelProperty("年月（datetime）")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM")
    @DateTimeFormat(pattern = "yyyy-MM")
    @Column(name = "year_month_ly", length = 20, columnDefinition = "datetime COMMENT '年月（datetime） '")
    private Date yearMonthLy;

    /**
     * 门店编码
     */
    @Column(name = "terminal_code", columnDefinition = "VARCHAR(64) COMMENT '门店编码'")
    private String terminalCode;

    /**
     * 门店名称
     */
    @Column(name = "terminal_name", columnDefinition = "VARCHAR(255) COMMENT '门店名称'")
    private String terminalName;

    /**
     * 品牌编码
     */
    @Column(name = "product_brand_code", columnDefinition = "VARCHAR(255) COMMENT '品牌编码'")
    private String productBrandCode;

    /**
     * 品牌名称
     */
    @Column(name = "product_brand_name", columnDefinition = "VARCHAR(255) COMMENT '品牌名称'")
    private String productBrandName;

    /**
     * 品类编码
     */
    @Column(name = "product_category_code", columnDefinition = "VARCHAR(255) COMMENT '品类编码'")
    private String productCategoryCode;

    /**
     * 品类名称
     */
    @Column(name = "product_category_name", columnDefinition = "VARCHAR(255) COMMENT '品类名称'")
    private String productCategoryName;

    /**
     * 品项编码
     */
    @Column(name = "product_item_code", columnDefinition = "VARCHAR(255) COMMENT '品项编码'")
    private String productItemCode;

    /**
     * 品项名称
     */
    @Column(name = "product_item_name", columnDefinition = "VARCHAR(255) COMMENT '品项名称'")
    private String productItemName;

    /**
     * 上级方案明细编码
     */
    @Column(name = "relate_plan_item_code", columnDefinition = "VARCHAR(128) COMMENT '上级方案明细编码'")
    private String relatePlanItemCode;

    /**
     * 区域
     */
    @Column(name = "region", columnDefinition = "VARCHAR(255) COMMENT '区域'")
    private String region;

    /**
     * 区域
     */
    @Column(name = "region_name", columnDefinition = "VARCHAR(128) COMMENT '区域'")
    private String regionName;

    /**
     * 零售商编码
     */
    @Column(name = "system_code", columnDefinition = "VARCHAR(128) COMMENT '零售商编码'")
    private String systemCode;

    /**
     * 零售商名称
     */
    @Column(name = "system_name", columnDefinition = "VARCHAR(128) COMMENT '零售商名称'")
    private String systemName;

    /**
     * 渠道编码
     */
    @Column(name = "channel_code", columnDefinition = "VARCHAR(128) COMMENT '渠道编码'")
    private String channelCode;

    /**
     * 渠道名称
     */
    @Column(name = "channel_name", columnDefinition = "VARCHAR(128) COMMENT '渠道名称'")
    private String channelName;

    @ApiModelProperty(name = "人员编码", notes = "人员编码")
    @Column(name = "person_code", columnDefinition = "VARCHAR(128) COMMENT '人员编码'")
    private String personCode;

    @ApiModelProperty(name = "人员身份证号码", notes = "人员身份证号码")
    @Column(name = "identity_card", columnDefinition = "VARCHAR(128) COMMENT '人员身份证号码'")
    private String identityCard;

    @ApiModelProperty(name = "二级渠道编码", notes = "二级渠道编码")
    @Column(name = "second_channel_code", columnDefinition = "VARCHAR(128) COMMENT '二级渠道编码'")
    private String secondChannelCode;

    @ApiModelProperty(name = "二级渠道名称", notes = "二级渠道名称")
    @Column(name = "second_channel_name", columnDefinition = "VARCHAR(128) COMMENT '二级渠道名称'")
    private String secondChannelName;

    @ApiModelProperty("总部预算项目编码")
    @Column(name = "head_budget_item_code", length = 32, columnDefinition = "varchar(32) COMMENT '总部预算项目编码'")
    private String headBudgetItemCode;

    /**
     * 大区预算编码
     */
    @ApiModelProperty("预算编码/大区预算编码")
    @Column(name = "month_budget_code", length = 32, columnDefinition = "varchar(32) COMMENT '大区预算编码'")
    private String monthBudgetCode;

    /**
     * 形式说明
     */
    @ApiModelProperty("形式说明")
    @Column(name = "form_description", nullable = true, length = 255, columnDefinition = "VARCHAR(255) COMMENT '形式说明'")
    private String formDescription;

    @ApiModelProperty("是否临时活动")
    @Column(name = "is_temporary", nullable = true, length = 12, columnDefinition = "VARCHAR(12) COMMENT '是否临时活动'")
    private String isTemporary;

    /**
     * 一级管理渠道编码
     */
    @ApiModelProperty("一级管理渠道编码")
    @Column(name = "first_channel_code", length = 32, columnDefinition = "varchar(32) COMMENT '一级管理渠道编码'")
    private String firstChannelCode;
    /**
     * 一级管理渠道名称
     */
    @ApiModelProperty("一级管理渠道名称")
    @Column(name = "first_channel_name", length = 256, columnDefinition = "varchar(256) COMMENT '一级管理渠道名称'")
    private String firstChannelName;

    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(name = "cusCreateTime", notes = "经销商创建时间")
    @Column(name = "cus_create_time", columnDefinition = "datetime COMMENT '经销商创建时间 '")
    private Date cusCreateTime;

    @ApiModelProperty(name = "applyAmount",notes = "申请金额")
    @Column(name = "apply_amount", columnDefinition = "decimal(24,6) COMMENT '申请金额'")
    private BigDecimal applyAmount;

    @ApiModelProperty("预估超额扣减预算失败时，记录上一次预估核销金额")
    @Column(name = "over_budget_fail_amount", columnDefinition = "decimal(24,6) COMMENT '预估超额扣减预算失败时，记录上一次预估核销金额'")
    private BigDecimal overBudgetFailAmount;

    @ApiModelProperty("预估超额扣减预算成功标志(Y/N)")
    @Column(name = "over_budget_success", length = 10, columnDefinition = "varchar(10) COMMENT '预估超额扣减预算成功标志(Y/N)'")
    private String overBudgetSuccess;

    @ApiModelProperty("陈列批次")
    @Column(name = "display_number", nullable = true, length = 10, columnDefinition = "varchar(10) COMMENT '陈列批次'")
    private String displayNumber;

    @ApiModelProperty("是否客户上账")
    @Column(name = "customer_account", nullable = true, length = 10, columnDefinition = "varchar(10) COMMENT '是否客户上账'")
    private String customerAccount;

    @ApiModelProperty("分销渠道编码")
    @Column(name = "distribution_channel_code", nullable = true, length = 64, columnDefinition = "varchar(64) COMMENT '分销渠道编码'")
    private String distributionChannelCode;

    @ApiModelProperty("分销渠道")
    @Column(name = "distribution_channel_name", nullable = true, length = 128, columnDefinition = "varchar(128) COMMENT '分销渠道'")
    private String distributionChannelName;

    @ApiModelProperty("大区承担金额")
    @Column(name = "department_fee_amount", precision = 24, scale = 6, columnDefinition = "decimal(24,6) COMMENT '大区承担金额'")
    private BigDecimal departmentFeeAmount;

    @ApiModelProperty("总部承担金额")
    @Column(name = "head_fee_amount", precision = 24, scale = 6, columnDefinition = "decimal(24,6) COMMENT '总部承担金额'")
    private BigDecimal headFeeAmount;

    @ApiModelProperty("超额补占预算备注")
    @Column(name = "over_budget_remark", nullable = true, length = 256, columnDefinition = "varchar(256) COMMENT '超额补占预算备注'")
    private String overBudgetRemark;

    @ApiModelProperty("是否展示")
    @Column(name = "show_flag", nullable = true, length = 10, columnDefinition = "varchar(10) COMMENT '是否展示'")
    private String showFlag;

    @ApiModelProperty("推送ECRM状态")
    @Column(name = "push_ecrm_status", nullable = true, length = 10, columnDefinition = "varchar(10) COMMENT '推送ECRM状态'")
    private String pushEcrmStatus;

    @ApiModelProperty("核销方式")
    @Column(name = "write_off_method", nullable = true, length = 10, columnDefinition = "varchar(10) COMMENT '核销方式'")
    private String writeOffMethod;

    @ApiModelProperty("预估超额金额")
    @Column(name = "over_budget_amount", precision = 24, scale = 6, columnDefinition = "decimal(24,6) COMMENT '预估超额金额'")
    private BigDecimal overBudgetAmount;

    @ApiModelProperty(name = "组织编码", notes = "")
    @Column(name = "org_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '组织编码 '")
    private String orgCode;

    @ApiModelProperty(name = "组织名称", notes = "")
    @Column(name = "org_name", nullable = true, length = 256, columnDefinition = "VARCHAR(256) COMMENT '组织名称 '")
    private String orgName;

    @ApiModelProperty(name = "是否完全结案", notes = "是否完全结案")
    @Column(name = "whole_audit", length = 10,columnDefinition = "VARCHAR(10) COMMENT '是否完全结案'")
    private String wholeAudit;

    /**
     * 购买方式
     */
    @ApiModelProperty("购买方式")
    @Column(name = "buy_way", length = 32, columnDefinition = "varchar(32) COMMENT '购买方式'")
    private String buyWay;

    @ApiModelProperty("核减堆头数")
    @Column(name = "minus_compost_quantity",  columnDefinition = "decimal(24,6) COMMENT '核减堆头数'")
    private BigDecimal minusCompostQuantity;

}
