package com.biz.crm.tpm.business.detailed.forecast.local.entity;


import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantEntity;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @author youjun
 * @date 2022年11月08日 17:27
 */
@ApiModel(value = "DetailedForecastFormulaEntity", description = "TPM-细案预测-公式扩展表")
@TableName("tpm_detailed_forecast_formula")
@Getter
@Setter
@Entity(name = "tpm_detailed_forecast_formula")
@org.hibernate.annotations.Table(appliesTo = "tpm_detailed_forecast_formula", comment = "TPM-细案预测-公式扩展表")
@Table(
        name = "tpm_detailed_forecast_formula",
        indexes = {
                @Index(name = "tpm_detailed_forecast_formula_index1", columnList = "tenant_code,activity_detail_item_code"),
                @Index(name = "tpm_detailed_forecast_formula_index2", columnList = "year_month_str"),
        }
)
public class DetailedForecastFormulaEntity extends TenantEntity {

    /**
     * 细案编码
     */
    @ApiModelProperty(name = "detailedCaseCode", notes = "细案编码")
    @Column(name = "detailed_case_code", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT '细案编码 '")
    private String detailedCaseCode;

    /**
     * 细案明细编码
     */
    @ApiModelProperty(name = "activityDetailItemCode",notes = "细案明细编码")
    @Column(name = "activity_detail_item_code",nullable = true, length = 32, columnDefinition = "VARCHAR(64) COMMENT '细案明细编码'")
    private String activityDetailItemCode;

    /**
     * 年月
     */
    @Column(name = "year_month_str", columnDefinition = "VARCHAR(64) COMMENT '年月'")
    private String yearMonthStr;

    @ApiModelProperty("年月（datetime）")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM")
    @DateTimeFormat(pattern = "yyyy-MM")
    @Column(name = "year_month_ly", length = 20, columnDefinition = "datetime COMMENT '年月（datetime） '")
    private Date yearMonthLy;

    /**
     * 核销条件
     */
    @ApiModelProperty(name = "writeOffConditions", notes = "核销条件")
    @Column(name = "write_off_conditions", nullable = true, columnDefinition = "text COMMENT '核销条件 '")
    private String writeOffConditions;

    /**
     * 核销公式
     */
    @ApiModelProperty(name = "writeOffFormula", notes = "核销公式")
    @Column(name = "write_off_formula", nullable = true, columnDefinition = "text COMMENT '核销公式 '")
    private String writeOffFormula;

    /**
     * 核销条件取值
     */
    @ApiModelProperty(name = "writeOffConditionValue", notes = "核销条件取值")
    @Column(name = "write_off_condition_value", nullable = true,  columnDefinition = "text COMMENT '核销条件取值 '")
    private String writeOffConditionValue;

    /**
     * 核销公式取值
     */
    @ApiModelProperty(name = "writeOffFormulaValue", notes = "核销公式取值")
    @Column(name = "write_off_formula_value", nullable = true, columnDefinition = "text COMMENT '核销公式取值 '")
    private String writeOffFormulaValue;

    /**
     * 核销公式取值
     */
    @ApiModelProperty(name = "writeOffPremise", notes = "可核销前提")
    @Column(name = "write_off_premise", nullable = true, columnDefinition = "text COMMENT '可核销前提 '")
    private String writeOffPremise;

    /**
     * 公式计算参数
     */
    @Column(name = "cal_param", columnDefinition = "text COMMENT '公式计算参数'")
    private String calParam;

    /**
     * 公式计算异常
     */
    @Column(name = "cal_ex", columnDefinition = "VARCHAR(500) COMMENT '公式计算异常'")
    private String calEx;

    @ApiModelProperty("超额补占预算备注")
    @Column(name = "over_budget_remark", nullable = true, length = 256, columnDefinition = "varchar(256) COMMENT '超额补占预算备注'")
    private String overBudgetRemark;
}
