package com.biz.crm.tpm.business.detailed.forecast.local.entity;


import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.util.Date;

/**
 * @author youjun
 * @date 2022年11月08日 17:27
 */
@ApiModel(value = "DetailedForecastProductEntity", description = "TPM-细案预测-产品扩展表")
@TableName("tpm_detailed_forecast_product")
@Getter
@Setter
@Entity(name = "tpm_detailed_forecast_product")
@org.hibernate.annotations.Table(appliesTo = "tpm_detailed_forecast_product", comment = "TPM-细案预测-产品扩展表")
@Table(
        name = "tpm_detailed_forecast_product",
        indexes = {
                @Index(name = "tpm_detailed_forecast_product_index1", columnList = "activity_detail_item_code"),
                @Index(name = "tpm_detailed_forecast_product_index2", columnList = "detailed_forecast_id"),
                @Index(name = "tpm_detailed_forecast_product_index3", columnList = "year_month_str"),
        }
)
public class DetailedForecastProductEntity extends TenantEntity {

    /**
     * 细案预测ID
     */
    @ApiModelProperty("细案预测ID")
    @Column(name = "detailed_forecast_id", length = 36, columnDefinition = " varchar(36) COMMENT '细案预测ID'")
    private String detailedForecastId;

    /**
     * 细案编码
     */
    @ApiModelProperty(name = "detailedCaseCode", notes = "细案编码")
    @Column(name = "detailed_case_code", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT '细案编码 '")
    private String detailedCaseCode;

    /**
     * 细案明细编码
     */
    @ApiModelProperty(name = "activityDetailItemCode",notes = "细案明细编码")
    @Column(name = "activity_detail_item_code",nullable = true, length = 32, columnDefinition = "VARCHAR(64) COMMENT '细案明细编码'")
    private String activityDetailItemCode;

    /**
     * 年月
     */
    @Column(name = "year_month_str", columnDefinition = "VARCHAR(64) COMMENT '年月'")
    private String yearMonthStr;

    @ApiModelProperty("年月（datetime）")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM")
    @DateTimeFormat(pattern = "yyyy-MM")
    @Column(name = "year_month_ly", length = 20, columnDefinition = "datetime COMMENT '年月（datetime） '")
    private Date yearMonthLy;

    /**
     * 产品编码
     */
    @ApiModelProperty("产品编码")
    @Column(name = "product_code", length = 128, columnDefinition = " varchar(128) COMMENT '产品编码'")
    private String productCode;

    /**
     * 产品名称
     */
    @ApiModelProperty("产品名称")
    @Column(name = "product_name", length = 128, columnDefinition = " varchar(128) COMMENT '产品名称'")
    private String productName;
}
