package com.biz.crm.tpm.business.detailed.forecast.local.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.util.Date;

/**
 * 细案预测数据刷新临时表
 * 这张表在数据库加定时任务清理前一天的数据，不加代码来处理了！！！！！
 *
 * @author wanghaojia
 * @date 2023/10/16 10:29
 */
@ApiModel(value = "DetailedForecastRefreshEntity", description = "TPM-细案预测刷新")
@TableName("tpm_detailed_forecast_refresh")
@Getter
@Setter
@Entity(name = "tpm_detailed_forecast_refresh")
@org.hibernate.annotations.Table(appliesTo = "tpm_detailed_forecast_refresh", comment = "TPM-细案预测刷新")
@Table(
        name = "tpm_detailed_forecast_refresh",
        indexes = {
                @Index(name = "tpm_detailed_forecast_refresh_index1", columnList = "business_unit_code", unique = false),
                @Index(name = "tpm_detailed_forecast_refresh_index2", columnList = "year_month_str", unique = false),
                @Index(name = "tpm_detailed_forecast_refresh_index3", columnList = "operation_key", unique = false),
                @Index(name = "tpm_detailed_forecast_refresh_index4", columnList = "refresh_day", unique = false),
                @Index(name = "tpm_detailed_forecast_refresh_index5", columnList = "expire_time", unique = false),
        })
public class DetailedForecastRefreshEntity extends UuidEntity {

    /**
     * 业务单元
     */
    @Column(name = "business_unit_code", columnDefinition = "VARCHAR(32) COMMENT '业务单元'")
    private String businessUnitCode;

    /**
     * 年月
     */
    @Column(name = "year_month_str", columnDefinition = "VARCHAR(19) COMMENT '年月'")
    private String yearMonthStr;

    /**
     * 细案预测表id
     */
    @Column(name = "detailed_forecast_id", columnDefinition = "VARCHAR(32) COMMENT '细案预测表id'")
    private String detailedForecastId;

    /**
     * 本次处理数据标识
     */
    @Column(name = "operation_key", columnDefinition = "VARCHAR(32) COMMENT '本次处理数据标识'")
    private String operationKey;

    /**
     * 刷新日期
     */
    @Column(name = "refresh_day", columnDefinition = "VARCHAR(19) COMMENT '刷新日期'")
    private String refreshDay;

    @ApiModelProperty("过期时间")
    @TableField(fill = FieldFill.INSERT, updateStrategy = FieldStrategy.NOT_EMPTY)
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Column(name = "expire_time", length = 20, columnDefinition = "datetime default NOW() COMMENT '过期时间 '")
    private Date expireTime;

}
