package com.biz.crm.tpm.business.detailed.forecast.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @CLASS_DESCRIBE: 细案预测汇总表
 * @AUTHOR: create by zkey on 2023-10-06
 */
@ApiModel(value = "DetailedForecastSummaryEntity", description = "TPM-细案预测汇总表")
@TableName("tpm_detailed_forecast_summary")
@Getter
@Setter
@Entity(name = "tpm_detailed_forecast_summary")
@org.hibernate.annotations.Table(appliesTo = "tpm_detailed_forecast_summary", comment = "TPM-细案预测汇总表")
@Table(
        name = "tpm_detailed_forecast_summary"//索引还未加！！！
)
public class DetailedForecastSummaryEntity extends TenantFlagOpEntity {
    @ApiModelProperty(name = "businessFormatCode", notes = "业态")
    @Column(name = "business_format_code", length = 36, columnDefinition = " varchar(36) COMMENT '业态'")
    private String businessFormatCode;

    @ApiModelProperty(name = "businessUnitCode", notes = "业务单元")
    @Column(name = "business_unit_code", length = 36, columnDefinition = " varchar(36) COMMENT '业务单元'")
    private String businessUnitCode;

    @ApiModelProperty(name = "schemeCode", notes = "方案编码")
    @Column(name = "scheme_code", length = 64, columnDefinition = " varchar(64) COMMENT '方案编码'")
    private String schemeCode;

    @ApiModelProperty(name = "schemeName", notes = "方案名称")
    @Column(name = "scheme_name", length = 255, columnDefinition = " varchar(255) COMMENT '方案名称'")
    private String schemeName;

    @ApiModelProperty("零售商编码")
    @Column(name = "system_code", length = 64, columnDefinition = " varchar(64) COMMENT '零售商编码'")
    private String systemCode;

    @ApiModelProperty("零售商名称")
    @Column(name = "system_name", length = 255, columnDefinition = " varchar(255) COMMENT '零售商名称'")
    private String systemName;

    @ApiModelProperty("区域")
    @Column(name = "region", length = 255, columnDefinition = " varchar(255) COMMENT '区域'")
    private String region;

    @ApiModelProperty("区域")
    @Column(name = "region_name", length = 255, columnDefinition = " varchar(255) COMMENT '区域'")
    private String regionName;

    @ApiModelProperty(name = "activityTypeCode", notes = "活动类型")
    @Column(name = "activity_type_code", length = 64, columnDefinition = " varchar(64) COMMENT '活动类型'")
    private String activityTypeCode;

    @ApiModelProperty(name = "活动类型名称", notes = "活动类型名称")
    @Column(name = "activity_type_name", length = 255, columnDefinition = " varchar(255) COMMENT '活动类型名称'")
    private String activityTypeName;

    @ApiModelProperty(name = "activityFormCode", notes = "活动形式")
    @Column(name = "activity_form_code", length = 64, columnDefinition = " varchar(64) COMMENT '活动形式'")
    private String activityFormCode;

    @ApiModelProperty(name = "活动形式名称", notes = "活动形式名称")
    @Column(name = "activity_form_name", length = 255, columnDefinition = " varchar(255) COMMENT '活动形式名称'")
    private String activityFormName;

    @ApiModelProperty("品牌编码")
    @Column(name = "product_brand_code", length = 36, columnDefinition = " varchar(36) COMMENT '品牌编码'")
    private String productBrandCode;

    @ApiModelProperty("品牌名称")
    @Column(name = "product_brand_name", length = 255, columnDefinition = " varchar(255) COMMENT '品牌名称'")
    private String productBrandName;

    @ApiModelProperty(name = "activityStartTime", notes = "活动开始时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Column(name = "activity_start_time", columnDefinition = " datetime COMMENT '细案预测ID'")
    private Date activityStartTime;

    @ApiModelProperty(name = "activityEndTime", notes = "活动结束时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Column(name = "activity_end_time", columnDefinition = " datetime COMMENT '细案预测ID'")
    private Date activityEndTime;

    @ApiModelProperty(name = "periodPromotionQuantity", notes = "期间促销量")
    @Column(name = "period_promotion_quantity", columnDefinition = " decimal(20,4) COMMENT '期间促销量'")
    private BigDecimal periodPromotionQuantity;

    @ApiModelProperty(name = "applyAmount", notes = "申请金额")
    @Column(name = "apply_amount", columnDefinition = " decimal(20,4) COMMENT '申请金额'")
    private BigDecimal applyAmount;

    @ApiModelProperty(name = "actualSalesAmount", notes = "实际销售额")
    @Column(name = "actual_sales_amount", columnDefinition = " decimal(20,4) COMMENT '实际销售额'")
    private BigDecimal actualSalesAmount;

    @ApiModelProperty(name = "estimatedWriteOffAmount", notes = "预核销金额")
    @Column(name = "estimated_write_off_amount", columnDefinition = " decimal(20,4) COMMENT '预核销金额'")
    private BigDecimal estimatedWriteOffAmount;

    @ApiModelProperty(name = "remnantAuditAmount", notes = "剩余核销金额")
    @Column(name = "remnant_audit_amount", columnDefinition = " decimal(20,4) COMMENT '剩余核销金额'")
    private BigDecimal remnantAuditAmount;

    @ApiModelProperty(name = "alreadyAuditAmount", notes = "已结案金额")
    @Column(name = "already_audit_amount", columnDefinition = " decimal(20,4) COMMENT '已结案金额'")
    private BigDecimal alreadyAuditAmount;
}
