package com.biz.crm.tpm.business.detailed.forecast.local.exports;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.common.ie.sdk.excel.process.ExportProcess;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.mn.common.base.constant.CommonConstant;
import com.biz.crm.tpm.business.detailed.forecast.sdk.constant.DeatailedForecastConstants;
import com.biz.crm.tpm.business.detailed.forecast.sdk.dto.DetailedForecastFeeLedgerDto;
import com.biz.crm.tpm.business.detailed.forecast.sdk.dto.DetailedForecastSummaryDto;
import com.biz.crm.tpm.business.detailed.forecast.sdk.service.DetailedForecastFeeLedgerService;
import com.biz.crm.tpm.business.detailed.forecast.sdk.service.DetailedForecastService;
import com.biz.crm.tpm.business.detailed.forecast.sdk.vo.DetailedForecastFeeLedgerExportVo;
import com.biz.crm.tpm.business.detailed.forecast.sdk.vo.DetailedForecastFeeLedgerVo;
import com.biz.crm.tpm.business.detailed.forecast.sdk.vo.DetailedForecastSummaryExportVo;
import com.biz.crm.tpm.business.detailed.forecast.sdk.vo.DetailedForecastSummaryVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.*;

/**
 * @author: yaoyongming
 * @date: 2023/4/19 16:31
 */
@Component
@Slf4j
public class DetailedForeacastSummaryExportProcess implements ExportProcess<DetailedForecastSummaryExportVo> {

    @Autowired(required = false)
    private DictDataVoService dictDataVoService;

    @Autowired(required = false)
    private DetailedForecastService detailedForecastService;

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    @Override
    public Integer getTotal(Map<String, Object> params) {
        params = this.convertEuropaParam(params);
        Pageable pageable = PageRequest.of(1, 1);
        DetailedForecastSummaryDto dto = convertParams(params);
        Page<DetailedForecastSummaryVo> pageResult = detailedForecastService.summaryPage(pageable, dto);
        Validate.isTrue(pageResult.getTotal() < CommonConstant.IE_EXPORT_MAX_TOTAL, "导出时，" +
                "单次最大导出[" + CommonConstant.IE_EXPORT_MAX_TOTAL + "]条,请输入更多查询条件!!");
        return Long.valueOf(pageResult.getTotal()).intValue();
    }

    @Override
    public JSONArray getData(ExportTaskProcessVo vo, Map<String, Object> params) {
        params = this.convertEuropaParam(params);
        log.info("=====>      细案预测汇总表导出[{}]    <=====", JSON.toJSONString(vo));
        Pageable pageable = PageRequest.of(vo.getPageNo() + 1, getPageSize());
        DetailedForecastSummaryDto dto = convertParams(params);
        Page<DetailedForecastSummaryVo> pageResult = detailedForecastService.summaryPage(pageable, dto);
        if (CollectionUtils.isEmpty(pageResult.getRecords())) {
            return new JSONArray();
        }
        List<DetailedForecastSummaryVo> records = pageResult.getRecords();
        return JSON.parseArray(JSON.toJSONString(this.adjustData(records), SerializerFeature.WriteDateUseDateFormat));
    }

    @Override
    public String getBusinessCode() {
        return "DETAILED_FORECAST_SUMMARY_EXPORT";
    }

    @Override
    public Integer getPageSize() {
        return CommonConstant.IE_EXPORT_PAGE_SIZE;
    }

    /**
     * 获取参数
     *
     * @param params
     * @return
     */
    private DetailedForecastSummaryDto convertParams(Map<String, Object> params) {
        // map 参数转换为对应的dto参数对象，可以手工进行修改设置
        return JSON.parseObject(JSON.toJSONString(params), DetailedForecastSummaryDto.class);
    }

    /**
     * 调整数据
     *
     * @param data
     */
    private List<DetailedForecastSummaryExportVo> adjustData(Collection<DetailedForecastSummaryVo> data) {
        List<DetailedForecastSummaryExportVo> list = (List<DetailedForecastSummaryExportVo>) nebulaToolkitService.copyCollectionByWhiteList(data, DetailedForecastSummaryVo.class, DetailedForecastSummaryExportVo.class, HashSet.class, ArrayList.class);
        //  转换数据字典值
        Map<String, List<DictDataVo>> mapDict = this.dictDataVoService.findByDictTypeCodeList(Lists.newArrayList(DeatailedForecastConstants.MDM_BUSINESS_FORMAT,
                DeatailedForecastConstants.MDM_BUSINESS_UNIT));

        for (DetailedForecastSummaryExportVo vo : list) {
            vo.setBusinessFormatCode(findDictValue(mapDict, DeatailedForecastConstants.MDM_BUSINESS_FORMAT, String.valueOf(vo.getBusinessFormatCode())));
            vo.setBusinessUnitCode(findDictValue(mapDict, DeatailedForecastConstants.MDM_BUSINESS_UNIT, String.valueOf(vo.getBusinessUnitCode())));
        }
        return list;
    }

    /**
     * 获取字典值
     *
     * @param mapDict
     * @param dictTypeCode
     * @param code
     * @return
     */
    private String findDictValue(Map<String, List<DictDataVo>> mapDict, String dictTypeCode, String code) {
        if (Objects.isNull(mapDict) || StringUtils.isBlank(dictTypeCode) || StringUtils.isBlank(code)) {
            return StringUtils.EMPTY;
        }
        final List<DictDataVo> vos = mapDict.get(dictTypeCode);
        if (CollectionUtils.isEmpty(vos)) {
            return StringUtils.EMPTY;
        }
        final Optional<String> first =
                vos.stream()
                        .filter(a -> a.getDictCode().equals(code))
                        .map(DictDataVo::getDictValue)
                        .findFirst();
        return first.orElse(StringUtils.EMPTY);
    }

    @Override
    public String getBusinessName() {
        return "细案汇总导出";
    }
}
