package com.biz.crm.tpm.business.detailed.forecast.local.imports.model;


import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelImport;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;


@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "TPM-细案预测导入vo")
@CrmExcelImport(startRow = 1)
public class DetailedForecastImportsVo extends CrmExcelVo {

    /**
     * 主键
     */
    @ApiModelProperty("主键")
    @CrmExcelColumn("主键")
    private String id;

    /**
     * 创建人账号
     */
    @ApiModelProperty("创建人账号")
    @CrmExcelColumn("创建人账号")
    private String createAccount;

    /**
     * 创建人名称
     */
    @ApiModelProperty("创建人名称")
    @CrmExcelColumn("创建人名称")
    private String createName;

    /**
     * 创建时间
     */
    @ApiModelProperty("创建时间 ")
    @CrmExcelColumn("创建时间 ")
    private Date createTime;

    /**
     * 修改人账号
     */
    @ApiModelProperty("修改人账号")
    @CrmExcelColumn("修改人账号")
    private String modifyAccount;

    /**
     * 修改人名称
     */
    @ApiModelProperty("修改人名称")
    @CrmExcelColumn("修改人名称")
    private String modifyName;

    /**
     * 修改时间
     */
    @ApiModelProperty("修改时间")
    @CrmExcelColumn("修改时间")
    private Date modifyTime;

    /**
     * 数据状态（删除状态）
     */
    @ApiModelProperty("数据状态（删除状态）")
    @CrmExcelColumn("数据状态（删除状态）")
    private String delFlag;

    /**
     * 数据业务状态（启用状态）
     */
    @ApiModelProperty("数据业务状态（启用状态）")
    @CrmExcelColumn("数据业务状态（启用状态）")
    private String enableStatus;

    /**
     * 备注
     */
    @ApiModelProperty("备注")
    @CrmExcelColumn("备注")
    private String remark;

    /**
     * 租户编号
     */
    @ApiModelProperty("租户编号")
    @CrmExcelColumn("租户编号")
    private String tenantCode;

    /**
     * 细案明细编码
     */
    @ApiModelProperty("细案明细编码")
    @CrmExcelColumn("细案明细编码")
    private String activityDetailItemCode;

    /**
     * 活动结束时间
     */
    @ApiModelProperty("活动结束时间 ")
    @CrmExcelColumn("活动结束时间 ")
    private Date activityEndTime;

    /**
     * 活动开始时间
     */
    @ApiModelProperty("活动开始时间 ")
    @CrmExcelColumn("活动开始时间 ")
    private Date activityStartTime;

    /**
     * 活动类型
     */
    @ApiModelProperty("活动类型 ")
    @CrmExcelColumn("活动类型 ")
    private String activityType;

    /**
     * 实际核销金额
     */
    @ApiModelProperty("实际核销金额")
    @CrmExcelColumn("实际核销金额")
    private Double actualWriteOffAmount;

    /**
     * 业态[数据字典:mdm_business_format]
     */
    @ApiModelProperty("业态[数据字典:mdm_business_format] ")
    @CrmExcelColumn("业态[数据字典:mdm_business_format] ")
    private String businessFormatCode;

    /**
     * 业务单元[数据字典:mdm_business_unit]
     */
    @ApiModelProperty("业务单元[数据字典:mdm_business_unit] ")
    @CrmExcelColumn("业务单元[数据字典:mdm_business_unit] ")
    private String businessUnitCode;

    /**
     * 客户
     */
    @ApiModelProperty("客户 ")
    @CrmExcelColumn("客户 ")
    private String customer;

    /**
     * 细案编码
     */
    @ApiModelProperty("细案编码 ")
    @CrmExcelColumn("细案编码 ")
    private String detailedCaseCode;

    /**
     * 细案名称
     */
    @ApiModelProperty("细案名称 ")
    @CrmExcelColumn("细案名称 ")
    private String detailedCaseName;

    /**
     * 状态
     */
    @ApiModelProperty("状态 ")
    @CrmExcelColumn("状态 ")
    private String detailedPredictionType;

    /**
     * 预估核销金额
     */
    @ApiModelProperty("预估核销金额")
    @CrmExcelColumn("预估核销金额")
    private Double estimatedWriteOffAmount;

    /**
     * 活动形式
     */
    @ApiModelProperty("活动形式 ")
    @CrmExcelColumn("活动形式 ")
    private String formOfActivity;

    /**
     * 一级管理渠道
     */
    @ApiModelProperty("一级管理渠道 ")
    @CrmExcelColumn("一级管理渠道 ")
    private String primaryManagementChannel;

    /**
     * 方案编码
     */
    @ApiModelProperty("方案编码 ")
    @CrmExcelColumn("方案编码 ")
    private String schemeCode;

    /**
     * 方案名称
     */
    @ApiModelProperty("方案名称 ")
    @CrmExcelColumn("方案名称 ")
    private String schemeName;

    /**
     * 任务量缺口
     */
    @ApiModelProperty("任务量缺口")
    @CrmExcelColumn("任务量缺口")
    private Double taskVolumeGap;

    /**
     * 核销条件取值
     */
    @ApiModelProperty("核销条件取值 ")
    @CrmExcelColumn("核销条件取值 ")
    private String writeOffConditionValue;

    /**
     * 核销条件
     */
    @ApiModelProperty("核销条件 ")
    @CrmExcelColumn("核销条件 ")
    private String writeOffConditions;

    /**
     * 核销公式
     */
    @ApiModelProperty("核销公式 ")
    @CrmExcelColumn("核销公式 ")
    private String writeOffFormula;

    /**
     * 核销公式取值
     */
    @ApiModelProperty("核销公式取值 ")
    @CrmExcelColumn("核销公式取值 ")
    private String writeOffFormulaValue;

    /**
     * 细案明细编码
     */
    @ApiModelProperty("细案明细编码")
    @CrmExcelColumn("细案明细编码")
    private String isPushAudit;

    /**
     * 已结案金额
     */
    @ApiModelProperty("已结案金额")
    @CrmExcelColumn("已结案金额")
    private Double alreadyAuditAmount;

    /**
     * 是否完全结案
     */
    @ApiModelProperty("是否完全结案")
    @CrmExcelColumn("是否完全结案")
    private String wholeAudit;

    /**
     * 活动形式
     */
    @ApiModelProperty("活动形式 ")
    @CrmExcelColumn("活动形式 ")
    private String activityFormCode;

    /**
     * 活动形式名称
     */
    @ApiModelProperty("活动形式名称")
    @CrmExcelColumn("活动形式名称")
    private String activityFormName;

    /**
     * 活动类型
     */
    @ApiModelProperty("活动类型 ")
    @CrmExcelColumn("活动类型 ")
    private String activityTypeCode;

    /**
     * 活动类型名称
     */
    @ApiModelProperty("活动类型名称")
    @CrmExcelColumn("活动类型名称")
    private String activityTypeName;

}
