package com.biz.crm.tpm.business.detailed.forecast.local.imports.service;


import com.biz.crm.common.ie.sdk.excel.process.ImportProcess;
import com.biz.crm.common.ie.sdk.vo.TaskGlobalParamsVo;
import com.biz.crm.tpm.business.detailed.forecast.local.imports.model.DetailedForecastImportsVo;
import com.biz.crm.tpm.business.detailed.forecast.sdk.dto.DetailedForecastDto;
import com.biz.crm.tpm.business.detailed.forecast.sdk.service.DetailedForecastService;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.JsonUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

import java.util.*;

@Component
@Slf4j
public class DetailedForecastImportsService implements ImportProcess<DetailedForecastImportsVo> {

    @Autowired
    private DetailedForecastService detailedForecastVoService;


    @Autowired
    @Qualifier("nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;

    @Override
    public Map<Integer, String> execute(LinkedHashMap<Integer, DetailedForecastImportsVo> data, TaskGlobalParamsVo paramsVo, Map<String, Object> params) {
        final Optional<DetailedForecastImportsVo> first = data.values().stream().findFirst();
        if (!first.isPresent()) {
            return null;
        }
        DetailedForecastImportsVo vo = first.get();
        log.info("导入中--------------------------" + JsonUtils.obj2JsonString(vo));
        Validate.notNull(vo, "TPM-细案预测时，传入的信息不能为空");
        this.validate(vo);
        DetailedForecastDto detailedForecastDto = nebulaToolkitService.copyObjectByWhiteList(vo, DetailedForecastDto.class, HashSet.class, ArrayList.class);
        detailedForecastVoService.create(detailedForecastDto);
        return null;
    }

    @Override
    public Class<DetailedForecastImportsVo> findCrmExcelVoClass() {
        return DetailedForecastImportsVo.class;
    }

    @Override
    public String getTemplateCode() {
        return "TPM_DETAILED_FORECAST_IMPORTS_CODE";
    }

    @Override
    public String getTemplateName() {
        return "TPM-细案预测导入模板";
    }

    /**
     * 验证导入参数
     *
     * @param importsVo
     */
    private void validate(DetailedForecastImportsVo importsVo) {

    }
}
