package com.biz.crm.tpm.business.detailed.forecast.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mn.third.system.ecrm.sdk.vo.DetailedForecastRequestVo;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanBudgetVo;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanItemVo;
import com.biz.crm.tpm.business.detailed.forecast.local.entity.DetailedForecastEntity;
import com.biz.crm.tpm.business.detailed.forecast.local.vo.TpmUpExpectAuditAmountMonitorWarningQueryDto;
import com.biz.crm.tpm.business.detailed.forecast.sdk.dto.*;
import com.biz.crm.tpm.business.detailed.forecast.sdk.vo.*;
import com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetDetailVo;
import com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetVo;
import org.apache.ibatis.annotations.Param;
import org.springframework.data.domain.Pageable;

import java.util.List;
import java.util.Map;
import java.util.Set;


/**
 * 细案预测表(DetailedForecastEntity)表mybatis访问层
 *
 * @author youjun
 * @date 2022年11月09日 12：57
 */
public interface DetailedForecastMapper extends BaseMapper<DetailedForecastEntity> {
    /**
     * 后端预算预测管理列表
     *
     * @param page
     * @param dto
     * @return
     */
    Page<DetailedForecastVo> findByForecastsForWebList(Page<DetailedForecastVo> page, @Param("dto") DetailedForecastDto dto);

    /**
     * 分页查询所有数据
     *
     * @param page             分页对象
     * @param detailedForecast 查询实体
     * @return 所有数据
     */
    Page<DetailedForecastVo> findByForecasts(@Param("page") Page<DetailedForecastVo> page, @Param("dto") DetailedForecastDto detailedForecast);

    Page<DetailedForecastFeeLedgerVo> findByForecastsFeeLedger(@Param("page") Page<DetailedForecastFeeLedgerVo> page, @Param("dto") DetailedForecastFeeLedgerDto detailedForecast);

    List<DetailedForecastFeeLedgerVo> getActivityDetailPlanItem(@Param("codeList") List<String> codeList);

    List<DetailedForecastFeeLedgerVo> getDetailedForecastFormula(@Param("codeList") List<String> codeList);

    Page<DetailedForecastVo> findForAudit(@Param("page") Page<DetailedForecastVo> page, @Param("dto") DetailedForecastDto detailedForecast);

    List<DetailedForecastRequestVo> selectUnSynchronizedAll();

    void updateSynchronousRegime(List<DetailedForecastRequestVo> vos);

    Page<DetailedForecastRequestVo> selectUnSynchronizedPage(Pageable pageable);

    /**
     * 初始化到需要刷新的细案预测数据到临时表
     */
    Long initAutoRefreshHead(@Param("dto") DetailedForecastAutoRefreshDto dto);
    Long initAutoRefreshSubCom(@Param("dto") DetailedForecastAutoRefreshDto dto);
    Long initAutoRefreshOnLine(@Param("dto") DetailedForecastAutoRefreshDto dto);

    List<String> findAutoRefreshDataList(@Param("dto") DetailedForecastAutoRefreshDto dto);

    List<MonthBudgetDetailVo> findBudgetDetailByBusinessCode(@Param("businessCode") String businessCode,
                                                             @Param("tenantCode") String tenantCode);

    List<ActivityDetailPlanBudgetVo> findActivityDetailBudgetCodes(@Param("detailPlanItemCode") String detailPlanItemCode,
                                                                   @Param("tenantCode") String tenantCode);

    Page<String> findInitCodeList(@Param("page") Page<String> page, @Param("dto") DetailedForecastInitDto dto);

    Page<String> findSubComInitCodeList(@Param("page") Page<String> page, @Param("dto") DetailedForecastInitDto dto);

    Page<String> findOnlineInitCodeList(@Param("page") Page<String> page, @Param("dto") DetailedForecastInitDto dto);

    List<MonthBudgetVo> findBudgetProductProList(@Param("dto") DetailedForecastDto dto,
                                                 @Param("tenantCode") String tenantCode,
                                                 @Param("feeBelongCode") String feeBelongCode,
                                                 @Param("budgetItemCode") String budgetItemCode);

    List<DetailedForecastFeeLedgerResultVo> getPaidAmount(@Param("codeList") Set<String> codeList);

    List<DetailedForecastFeeLedgerResultVo> getReimburseTaxAmount(@Param("codeList") Set<String> codeList);

    List<DetailedForecastFeeLedgerResultVo> getFeePoolAmount(@Param("codeList") Set<String> codeList);

    List<String> findMainAutoCreateDataList(@Param("dto") DetailedForecastAutoCreateDto dto);

    List<String> findSubComAutoCreateDataList(@Param("dto") DetailedForecastAutoCreateDto dto);

    List<String> findOnlineAutoCreateDataList(@Param("dto") DetailedForecastAutoCreateDto dto);

    List<String> findMainAutoUpdateShowFlagDataList(@Param("dto") DetailedForecastAutoCreateDto dto);

    List<String> findSubComAutoUpdateShowFlagDataList(@Param("dto") DetailedForecastAutoCreateDto dto);

    Long autoUpdateShowFLag(@Param("list") List<String> activityDetailItemCodes);

    List<DetailedForecastVo> findByPlanItemCode(@Param("codeSet") Set<String> codeSet, @Param("tenantCode") String tenantCode);

    List<String> findActivityDetailCodeByAuditList(@Param("auditCodeList") List<String> auditCodeList, String tenantCode);

    List<DetailedForecastVo> findAuditAmount(@Param("activityDetailCodeList") List<String> activityDetailCodeList,
                                             @Param("businessUnitCodes") List<String> businessUnitCodes,
                                             @Param("tenantCode") String tenantCode);

    /**
     * 向上预计可核销金额监控表 （只取常温、主体数据）
     *
     * @param page 分页对象
     * @param dto  查询实体
     * @return 所有数据
     */
    Page<UpExpectAuditAmountMonitorVo> pageUpExpectAuditAmountMonitor(Page<UpExpectAuditAmountMonitorVo> page, @Param("dto") UpExpectAuditAmountMonitorDto dto);

    /**
     * 细案预测汇总
     *
     * @param page
     * @param dto
     * @return
     */
    Page<DetailedForecastSummaryVo> summaryPage(@Param("page") Page<DetailedForecastSummaryVo> page, @Param("dto") DetailedForecastSummaryDto dto);

    /**
     * 细案预测汇总-查垂直销售业绩
     *
     * @param tenantCode
     * @param keyList
     * @param keyBrandList
     * @return
     */
    List<DetailedForecastSummaryVo> summarySalesPerformanceList(@Param("tenantCode") String tenantCode,
                                                                @Param("keyList") List<String> keyList,
                                                                @Param("keyBrandList") List<String> keyBrandList);

    List<Map<String, Object>> findTpmUpExpectAuditAmountMonitorWarning(@Param("dto") TpmUpExpectAuditAmountMonitorWarningQueryDto dto);

    List<DetailedForecastVo> findListForSaleAndFeeMonitoring(@Param("list") List<DetailedForecastDto> detailedForecastDtos);

    /**
     * 查询本次增量的数据
     * @param dto
     * @return
     */
    List<ActivityDetailPlanItemVo> findDetailedForecastSummaryUpdate(@Param("dto") DetailedForecastSummaryDto dto);

    /**
     * 根据planCode 得到增量的细案明细编码 然后查询细案预测数据
     * @param detailPlanItemCodes
     * @return
     */
    List<DetailedForecastVo> findDetailedForecastSummaryUpdateList(@Param("detailPlanItemCodes") List<String> detailPlanItemCodes,@Param("tenantCode") String tenantCode);

    Page<ActivityDetailPlanItemVo> findActivityDetailPlanItemList(Page<ActivityDetailPlanItemVo> page,@Param("dto") DetailedForecastSummaryDto dto);

    Page<DetailedForecastSummaryVo> summaryPageNew(@Param("page") Page<DetailedForecastSummaryVo> page, @Param("dto") DetailedForecastSummaryDto dto);
    List<DetailedForecastVo> findEstimatedWriteOffAmountByCodes(@Param("codes") List<String> codes,@Param("tenantCode") String tenantCode);

    /**
     * 细案预测汇总核销金额
     * @param records
     * @return
     */
    List<DetailedForecastVo> findByProfitMonitor(@Param("records") List<DetailedForecastDto> records);

    List<DetailedForecastVo> findByProfitMonitor1(@Param("records") List<DetailedForecastDto> detailedForecastDtos);

    List<AuditDetailedForecastVo> findByActivityDetailItemCodes2(@Param("list") List<String> activityDetailItemCodes);
}
