package com.biz.crm.tpm.business.detailed.forecast.local.model;

import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelImport;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @author youjun
 * @date 2022年11月10日 9:48
 */
@Data
@CrmExcelImport(startRow = 1)
public class DetailedForecastImportsVo extends CrmExcelVo {
    /**
     * 状态
     */
    @ApiModelProperty(name = "detailedPredictionType", notes = "状态")
    private String detailedPredictionType;

    /**
     * 业态
     */
    @ApiModelProperty(name = "businessFormatCode", notes = "业态")
    private String businessFormatCode;

    /**
     * 业务单元
     */
    @ApiModelProperty(name = "businessUnitCode", notes = "业务单元")
    private String businessUnitCode;

    /**
     * 方案编码
     */
    @ApiModelProperty(name = "schemeCode", notes = "方案编码")
    private String schemeCode;

    /**
     * 方案名称
     */
    @ApiModelProperty(name = "schemeName", notes = "方案名称")
    private String schemeName;

    /**
     * 细案编码
     */
    @ApiModelProperty(name = "detailedCaseCode", notes = "细案编码")
    private String detailedCaseCode;

    /**
     * 细案名称
     */
    @ApiModelProperty(name = "detailedCaseName", notes = "细案名称")
    private String detailedCaseName;

    /**
     * 活动类型
     */
    @ApiModelProperty(name = "activityType", notes = "活动类型")
    private String activityType;

    /**
     * 活动形式
     */
    @ApiModelProperty(name = "formOfActivity", notes = "活动形式")
    private String formOfActivity;

    /**
     * 活动开始时间
     */
    @ApiModelProperty(name = "activityStartTime", notes = "活动开始时间")
    private Date activityStartTime;

    /**
     * 活动结束时间
     */
    @ApiModelProperty(name = "activityEndTime", notes = "活动结束时间")
    private Date activityEndTime;

    /**
     * 一级管理渠道
     */
    @ApiModelProperty(name = "primaryManagementChannel", notes = "一级管理渠道")
    private String primaryManagementChannel;

    /**
     * 客户
     */
    @ApiModelProperty(name = "customer", notes = "客户")
    private String customer;

    /**
     * 核销条件
     */
    @ApiModelProperty(name = "writeOffConditions", notes = "核销条件")
    private String writeOffConditions;

    /**
     * 核销公式
     */
    @ApiModelProperty(name = "writeOffFormula", notes = "核销公式")
    private String writeOffFormula;

    /**
     * 核销条件取值
     */
    @ApiModelProperty(name = "writeOffConditionValue", notes = "核销条件取值")
    private String writeOffConditionValue;

    /**
     * 核销公式取值
     */
    @ApiModelProperty(name = "writeOffFormulaValue", notes = "核销公式取值")
    private String writeOffFormulaValue;

    /**
     * 预估核销金额
     */
    @ApiModelProperty(name = "estimatedWriteOffAmount", notes = "预估核销金额")
    private BigDecimal estimatedWriteOffAmount;

    /**
     * 实际核销金额
     */
    @ApiModelProperty(name = "actualWriteOffAmount",notes = "实际核销金额")
    private BigDecimal actualWriteOffAmount;

    /**
     * 任务量缺口
     */
    @ApiModelProperty(name = "taskVolumeGap", notes = "任务量缺口")
    private BigDecimal taskVolumeGap;
    /**
     * 细案明细编码
     */
    @ApiModelProperty(name = "activityDetailItemCode", notes = "细案明细编码")
    private String activityDetailItemCode;
}
