package com.biz.crm.tpm.business.detailed.forecast.local.notifier.log;

import com.biz.crm.common.log.sdk.dto.CrmBusinessLogDto;
import com.biz.crm.common.log.sdk.enums.OperationTypeEunm;
import com.biz.crm.common.log.sdk.service.CrmBusinessLogVoService;
import com.biz.crm.tpm.business.detailed.forecast.sdk.dto.log.DetailedForecastLogEventDto;
import com.biz.crm.tpm.business.detailed.forecast.sdk.event.DetailedForecastLogEventListener;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DetailedForecastLogEventListenerImpl implements DetailedForecastLogEventListener {

    @Autowired(required = false)
    private CrmBusinessLogVoService crmBusinessLogVoService;

    /**
     * 新增时日志记录
     * @param dto 细案预测单新旧vo对象
     */
    @Override
    public void onCreate(DetailedForecastLogEventDto dto) {
        CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
        crmBusinessLogDto.setOperationType(OperationTypeEunm.CREATE.getDictCode());
        this.buildCrmBusinessLog(crmBusinessLogDto, dto);
    }

    /**
     * 删除时日志记录
     * @param dto 细案预测单新旧vo对象
     */
    @Override
    public void onDelete(DetailedForecastLogEventDto dto) {
        CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
        crmBusinessLogDto.setOperationType(OperationTypeEunm.DELETE.getDictCode());
        this.buildCrmBusinessLog(crmBusinessLogDto, dto);
    }

    /**
     * 修改时日志记录
     * @param dto 细案预测单新旧vo对象
     */
    @Override
    public void onUpdate(DetailedForecastLogEventDto dto) {
        CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
        crmBusinessLogDto.setOperationType(OperationTypeEunm.UPDATE.getDictCode());
        this.buildCrmBusinessLog(crmBusinessLogDto, dto);
    }


    /**
     * 构建日志dto对象
     * @param crmBusinessLogDto 日志dto
     * @param eventDto 新旧vo对象
     */
    private void buildCrmBusinessLog(CrmBusinessLogDto crmBusinessLogDto, DetailedForecastLogEventDto eventDto) {
        crmBusinessLogDto.setOnlyKey(eventDto.getNewest().getId());
        crmBusinessLogDto.setAppCode(TenantUtils.getTenantCode());
        crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
        crmBusinessLogDto.setOldObject(eventDto.getOriginal());
        crmBusinessLogDto.setNewObject(eventDto.getNewest());
        crmBusinessLogVoService.handleSave(crmBusinessLogDto);
    }
}
