package com.biz.crm.tpm.business.detailed.forecast.local.repository;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.mn.third.system.ecrm.sdk.vo.DetailedForecastRequestVo;
import com.biz.crm.tpm.business.detailed.forecast.local.entity.DetailedForecastEntity;
import com.biz.crm.tpm.business.detailed.forecast.local.entity.DetailedForecastFormulaEntity;
import com.biz.crm.tpm.business.detailed.forecast.local.mapper.DetailedForecastFormulaMapper;
import com.biz.crm.tpm.business.detailed.forecast.local.mapper.DetailedForecastMapper;
import com.biz.crm.tpm.business.detailed.forecast.sdk.dto.DetailedForecastAutoRefreshDto;
import com.biz.crm.tpm.business.detailed.forecast.sdk.dto.DetailedForecastDto;
import com.biz.crm.tpm.business.detailed.forecast.sdk.vo.DetailedForecastVo;
import liquibase.util.StringUtil;
import org.apache.commons.compress.utils.Lists;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;


/**
 * 细案预测表公式扩展表(DetailedForecastFormulaEntity)表数据库访问层
 *
 * @author youjun
 * @date 2022年11月09日 13:03
 */
@Component
public class DetailedForecastFormulaRepository extends ServiceImpl<DetailedForecastFormulaMapper, DetailedForecastFormulaEntity> {

    @Autowired(required = false)
    private DetailedForecastFormulaMapper detailedForecastFormulaMapper;

    private static final String property_detailedCaseCode = "detailedCaseCode";
    private static final String property_activityDetailItemCode = "activityDetailItemCode";
    private static final String property_yearMonthStr = "yearMonthStr";
    private static final String property_yearMonthLy = "yearMonthLy";

    public static final List<String> excludeFieldList = Lists.newArrayList();

    static {
        PropertyDescriptor[] propertyDescriptors = BeanUtils.getPropertyDescriptors(TenantEntity.class);
        excludeFieldList.addAll(Arrays.stream(propertyDescriptors).map(PropertyDescriptor::getName).collect(Collectors.toList()));
        excludeFieldList.add(property_detailedCaseCode);
        excludeFieldList.add(property_activityDetailItemCode);
        excludeFieldList.add(property_yearMonthStr);
        excludeFieldList.add(property_yearMonthLy);
    }

    //判断下是否所有属性都为空
    public boolean hasNotEmptyProperty(DetailedForecastFormulaEntity entity){
        PropertyDescriptor[] propertyDescriptors = BeanUtils.getPropertyDescriptors(DetailedForecastFormulaEntity.class);
        boolean hasNotEmptyProperty = false;
        for (PropertyDescriptor propertyDescriptor : propertyDescriptors) {
            if (excludeFieldList.contains(propertyDescriptor.getName())){
                continue;
            }
            try {
                Object invoke = propertyDescriptor.getReadMethod().invoke(entity);
                if (null != invoke && StringUtil.isNotEmpty(invoke.toString())){
                    hasNotEmptyProperty = true;
                    break;
                }
            } catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        return hasNotEmptyProperty;
    }
}
