package com.biz.crm.tpm.business.detailed.forecast.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantEntity;
import com.biz.crm.tpm.business.detailed.forecast.local.entity.DetailedForecastEntity;
import com.biz.crm.tpm.business.detailed.forecast.local.entity.DetailedForecastFormulaEntity;
import com.biz.crm.tpm.business.detailed.forecast.local.entity.DetailedForecastProductEntity;
import com.biz.crm.tpm.business.detailed.forecast.local.mapper.DetailedForecastFormulaMapper;
import com.biz.crm.tpm.business.detailed.forecast.local.mapper.DetailedForecastProductMapper;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import liquibase.util.StringUtil;
import org.apache.commons.compress.utils.Lists;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;


/**
 * 细案预测表产品扩展表(DetailedForecastProductEntity)表数据库访问层
 *
 * @author youjun
 * @date 2022年11月09日 13:03
 */
@Component
public class DetailedForecastProductRepository extends ServiceImpl<DetailedForecastProductMapper, DetailedForecastProductEntity> {

    @Autowired(required = false)
    private DetailedForecastProductMapper detailedForecastProductMapper;

    private static final String property_detailedCaseCode = "detailedCaseCode";
    private static final String property_activityDetailItemCode = "activityDetailItemCode";
    private static final String property_yearMonthStr = "yearMonthStr";

    public static final List<String> excludeFieldList = Lists.newArrayList();

    static {
        PropertyDescriptor[] propertyDescriptors = BeanUtils.getPropertyDescriptors(TenantEntity.class);
        excludeFieldList.addAll(Arrays.stream(propertyDescriptors).map(PropertyDescriptor::getName).collect(Collectors.toList()));
        excludeFieldList.add(property_detailedCaseCode);
        excludeFieldList.add(property_activityDetailItemCode);
        excludeFieldList.add(property_yearMonthStr);
    }

    //判断下是否所有属性都为空
    public boolean hasNotEmptyProperty(DetailedForecastProductEntity entity) {
        PropertyDescriptor[] propertyDescriptors = BeanUtils.getPropertyDescriptors(DetailedForecastProductEntity.class);
        boolean hasNotEmptyProperty = false;
        for (PropertyDescriptor propertyDescriptor : propertyDescriptors) {
            if (excludeFieldList.contains(propertyDescriptor.getName())) {
                continue;
            }
            try {
                Object invoke = propertyDescriptor.getReadMethod().invoke(entity);
                if (null != invoke && StringUtil.isNotEmpty(invoke.toString())) {
                    hasNotEmptyProperty = true;
                    break;
                }
            } catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        return hasNotEmptyProperty;
    }

    public List<DetailedForecastProductEntity> buildEntityList(DetailedForecastEntity entity) {
        List<DetailedForecastProductEntity> productEntityList = new ArrayList<>();
        if (!StringUtils.isEmpty(entity.getProductCode())) {
            String[] productCodes = entity.getProductCode().split(",");
            List<String> productNames = Lists.newArrayList();
            if (!StringUtils.isEmpty(entity.getProductName())) {
                productNames = Arrays.asList(entity.getProductName().split(","));
            }
            for (int i = 0; i < productCodes.length; i++) {
                DetailedForecastProductEntity productEntity = new DetailedForecastProductEntity();
                productEntity.setProductCode(productCodes[i]);
                if (i < productNames.size()) {
                    productEntity.setProductName(productNames.get(i));
                }
                productEntity.setTenantCode(TenantUtils.getTenantCode());
                productEntity.setDetailedCaseCode(entity.getDetailedCaseCode());
                productEntity.setActivityDetailItemCode(entity.getActivityDetailItemCode());
                productEntity.setYearMonthStr(entity.getYearMonthStr());
                productEntity.setYearMonthLy(entity.getYearMonthLy());
                productEntityList.add(productEntity);
            }
        }
        return productEntityList;
    }

    public boolean removeByForecastIds(List<String> forecastIds) {
        return this.lambdaUpdate()
                .eq(DetailedForecastProductEntity::getTenantCode, TenantUtils.getTenantCode())
                .in(DetailedForecastProductEntity::getDetailedForecastId, forecastIds).remove();
    }

    public List<DetailedForecastProductEntity> findByForecastIds(List<String> forecastIds) {
        return this.lambdaQuery()
                .eq(DetailedForecastProductEntity::getTenantCode, TenantUtils.getTenantCode())
                .in(DetailedForecastProductEntity::getDetailedForecastId, forecastIds).list();
    }
}
