package com.biz.crm.tpm.business.detailed.forecast.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.tpm.business.detailed.forecast.local.entity.DetailedForecastRefreshEntity;
import com.biz.crm.tpm.business.detailed.forecast.local.mapper.DetailedForecastRefreshMapper;
import org.springframework.stereotype.Component;

import java.util.Date;


/**
 * 细案预测自动刷新
 *
 * @author: huxmld
 * @version: v1.0.0
 * @date: 2023-12-20 17:27
 */
@Component
public class DetailedForecastRefreshRepository extends ServiceImpl<DetailedForecastRefreshMapper, DetailedForecastRefreshEntity> {


    /**
     * 清楚过期数据
     *
     * @return
     */
    public void removeExpireTime() {
        this.lambdaUpdate()
                .le(DetailedForecastRefreshEntity::getExpireTime, new Date())
                .remove();
    }
}
