package com.biz.crm.tpm.business.detailed.forecast.local.repository;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.mn.common.base.eunm.BusinessFormatEnum;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.third.system.ecrm.sdk.enumeration.PushECRMStatusEnum;
import com.biz.crm.mn.third.system.ecrm.sdk.vo.DetailedForecastRequestVo;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanItemVo;
import com.biz.crm.tpm.business.detailed.forecast.local.entity.DetailedForecastEntity;
import com.biz.crm.tpm.business.detailed.forecast.local.entity.DetailedForecastFormulaEntity;
import com.biz.crm.tpm.business.detailed.forecast.local.entity.DetailedForecastProductEntity;
import com.biz.crm.tpm.business.detailed.forecast.local.mapper.DetailedForecastMapper;
import com.biz.crm.tpm.business.detailed.forecast.local.vo.TpmUpExpectAuditAmountMonitorWarningQueryDto;
import com.biz.crm.tpm.business.detailed.forecast.sdk.dto.*;
import com.biz.crm.tpm.business.detailed.forecast.sdk.vo.*;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import jodd.util.StringUtil;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.io.Serializable;
import java.util.*;
import java.util.stream.Collectors;


/**
 * 细案预测表(DetailedForecastEntity)表数据库访问层
 *
 * @author youjun
 * @date 2022年11月09日 13:03
 */
@Component
public class DetailedForecastRepository extends ServiceImpl<DetailedForecastMapper, DetailedForecastEntity> {

    @Autowired(required = false)
    private DetailedForecastMapper detailedForecastMapper;

    @Autowired(required = false)
    private DetailedForecastFormulaRepository detailedForecastFormulaRepository;

    @Autowired(required = false)
    private DetailedForecastProductRepository detailedForecastProductRepository;

    /**
     * 后端预算预测管理列表
     *
     * @param pageable
     * @param detailedForecast
     * @return
     */
    public Page<DetailedForecastVo> findByForecastsForWebList(Pageable pageable, DetailedForecastDto detailedForecast) {
        Page<DetailedForecastVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        return this.detailedForecastMapper.findByForecastsForWebList(page, detailedForecast);
    }

    /**
     * 分页查询数据
     *
     * @param pageable 分页对象
     * @param dto      实体对象
     * @return
     */
    public Page<DetailedForecastVo> findByForecasts(Pageable pageable, DetailedForecastDto dto) {
        pageable = ObjectUtils.defaultIfNull(pageable, PageRequest.of(1, 50));
        dto = ObjectUtils.defaultIfNull(dto, new DetailedForecastDto());
        if (StringUtil.isEmpty(dto.getTenantCode())) {
            dto.setTenantCode(TenantUtils.getTenantCode());
        }
        Page<DetailedForecastVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        return this.detailedForecastMapper.findByForecasts(page, dto);
    }

    public Page<DetailedForecastFeeLedgerVo> findByForecasts(Pageable pageable, DetailedForecastFeeLedgerDto dto) {
        pageable = ObjectUtils.defaultIfNull(pageable, PageRequest.of(1, 50));
        dto = ObjectUtils.defaultIfNull(dto, new DetailedForecastFeeLedgerDto());
        if (StringUtil.isEmpty(dto.getTenantCode())) {
            dto.setTenantCode(TenantUtils.getTenantCode());
        }
        Page<DetailedForecastFeeLedgerVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        return this.detailedForecastMapper.findByForecastsFeeLedger(page, dto);
    }

    public List<DetailedForecastFeeLedgerVo> getActivityDetailPlanItem(List<String> activityDetailItemCodeList) {
        if (CollectionUtils.isEmpty(activityDetailItemCodeList)) {
            return Collections.emptyList();
        }
        return this.detailedForecastMapper.getActivityDetailPlanItem(activityDetailItemCodeList);
    }

    public List<DetailedForecastFeeLedgerVo> getDetailedForecastFormula(List<String> activityDetailItemCodeList) {
        if (CollectionUtils.isEmpty(activityDetailItemCodeList)) {
            return Collections.emptyList();
        }
        return this.detailedForecastMapper.getDetailedForecastFormula(activityDetailItemCodeList);
    }


    public List<DetailedForecastEntity> findByIds(List<String> ids) {
        List<DetailedForecastEntity> list = this.lambdaQuery().eq(DetailedForecastEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .in(UuidEntity::getId, ids).list();
        return this.loadExtend(list);
    }

    public List<DetailedForecastEntity> findByDetailCodes(List<String> detailCodes) {
        return this.lambdaQuery().eq(DetailedForecastEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .in(DetailedForecastEntity::getDetailedCaseCode, detailCodes).list();
    }

    public Page<DetailedForecastVo> findForAudit(Pageable pageable, DetailedForecastDto detailedForecast) {
        Page<DetailedForecastVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        Page<DetailedForecastVo> pageList = this.detailedForecastMapper.findForAudit(page, detailedForecast);
        return pageList;
    }

    public List<DetailedForecastRequestVo> selectUnSynchronizedAll() {
        return detailedForecastMapper.selectUnSynchronizedAll();
    }

    public void updateSynchronousRegime(List<DetailedForecastRequestVo> vos) {
        detailedForecastMapper.updateSynchronousRegime(vos);
    }

    public List<DetailedForecastEntity> getDetailedForecastByParams(DetailedForecastDto detailedForecast) {

        List<DetailedForecastEntity> list = this.baseMapper.selectList(Wrappers.lambdaQuery(DetailedForecastEntity.class)
                .eq(DetailedForecastEntity::getActivityDetailItemCode, detailedForecast.getActivityDetailItemCode())
                .orderByDesc(DetailedForecastEntity::getCreateTime).last("limit 1"));

        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        return this.loadExtend(list);
    }

    public Page<DetailedForecastRequestVo> selectUnSynchronizedPage(Pageable pageable) {
        return detailedForecastMapper.selectUnSynchronizedPage(pageable);
    }

    public Long findAutoRefreshDataCount(DetailedForecastAutoRefreshDto dto) {
        //修改逻辑，这里把数据写入到临时表，加快效率
        if (BusinessUnitEnum.isDefaultBusinessUnit(dto.getBusinessUnitCode())) {
            return this.detailedForecastMapper.initAutoRefreshHead(dto);
        } else if (BusinessUnitEnum.SON_COMPANY.getCode().equals(dto.getBusinessUnitCode())) {
            return this.detailedForecastMapper.initAutoRefreshSubCom(dto);
        } else if (BusinessUnitEnum.ONLINE.getCode().equals(dto.getBusinessUnitCode())) {
            return this.detailedForecastMapper.initAutoRefreshOnLine(dto);
        }
        return 0L;
    }

    public List<String> findAutoRefreshDataList(Pageable pageable, DetailedForecastAutoRefreshDto dto) {
        dto.setOffset(pageable.getPageSize() * (pageable.getPageNumber() - 1));
        dto.setLimit(pageable.getPageSize());
        return this.detailedForecastMapper.findAutoRefreshDataList(dto);
    }

    public List<String> findAutoCreateDataList(DetailedForecastAutoCreateDto dto) {
        if (BusinessUnitEnum.SON_COMPANY.getCode().equals(dto.getBusinessUnitCode())) {
            return this.detailedForecastMapper.findSubComAutoCreateDataList(dto);
        } else if (BusinessUnitEnum.ONLINE.getCode().equals(dto.getBusinessUnitCode())) {
            return this.detailedForecastMapper.findOnlineAutoCreateDataList(dto);
        } else {
            return this.detailedForecastMapper.findMainAutoCreateDataList(dto);
        }
    }

    public List<String> findAutoUpdateShowFlagDataList(DetailedForecastAutoCreateDto dto) {
        if (BusinessUnitEnum.SON_COMPANY.getCode().equals(dto.getBusinessUnitCode())) {
            return this.detailedForecastMapper.findSubComAutoUpdateShowFlagDataList(dto);
        } else if (BusinessUnitEnum.ONLINE.getCode().equals(dto.getBusinessUnitCode())) {
            return null;
        } else {
            return this.detailedForecastMapper.findMainAutoUpdateShowFlagDataList(dto);
        }
    }

    public Long autoUpdateShowFLag(List<String> activityDetailItemCodes) {
        return detailedForecastMapper.autoUpdateShowFLag(activityDetailItemCodes);
    }

    //扩展表
    //组装公式表字段
    public List<DetailedForecastEntity> loadExtend(List<DetailedForecastEntity> list) {
        if (CollectionUtils.isEmpty(list)) {
            return Lists.newArrayList();
        }
        List<String> idList = list.stream().map(DetailedForecastEntity::getId).collect(Collectors.toList());

        //公式扩展
        List<DetailedForecastFormulaEntity> formulaList = detailedForecastFormulaRepository.listByIds(idList);
        Map<String, DetailedForecastFormulaEntity> formulaMap = formulaList.stream().collect(Collectors.toMap(DetailedForecastFormulaEntity::getId, v -> v));

        //产品扩展
        List<DetailedForecastProductEntity> productList = detailedForecastProductRepository.findByForecastIds(idList);
        Map<String, List<DetailedForecastProductEntity>> productListMap = productList.stream().collect(Collectors.groupingBy(DetailedForecastProductEntity::getDetailedForecastId));

        String[] formulaIgnoreFieldArr = DetailedForecastFormulaRepository.excludeFieldList.toArray(new String[]{});
        for (DetailedForecastEntity entity : list) {
            if (formulaMap.containsKey(entity.getId())) {
                BeanUtils.copyProperties(formulaMap.get(entity.getId()), entity, formulaIgnoreFieldArr);
            }
            if (productListMap.containsKey(entity.getId())) {
                List<DetailedForecastProductEntity> productEntityList = productListMap.get(entity.getId());
                productEntityList.sort(Comparator.comparing(DetailedForecastProductEntity::getProductCode));
                List<String> productCodeList = productEntityList.stream().map(DetailedForecastProductEntity::getProductCode).collect(Collectors.toList());
                List<String> productNameList = productEntityList.stream().map(DetailedForecastProductEntity::getProductName).collect(Collectors.toList());
                entity.setProductCode(String.join(",", productCodeList));
                entity.setProductName(String.join(",", productNameList));
            }
        }
        return list;
    }

    public List<DetailedForecastEntity> clearExtend(List<DetailedForecastEntity> list) {
        if (CollectionUtils.isEmpty(list)) {
            return Lists.newArrayList();
        }
        for (DetailedForecastEntity forecastEntity : list) {
            forecastEntity.setWriteOffConditions(null);
            forecastEntity.setWriteOffFormula(null);
            forecastEntity.setWriteOffConditionValue(null);
            forecastEntity.setWriteOffFormulaValue(null);
            forecastEntity.setWriteOffPremise(null);
            forecastEntity.setCalParam(null);
            forecastEntity.setCalEx(null);
            forecastEntity.setOverBudgetRemark(null);

            forecastEntity.setProductCode(null);
            forecastEntity.setProductName(null);
        }
        return list;
    }

    public List<DetailedForecastEntity> list(QueryWrapper<DetailedForecastEntity> queryWrapper) {
        List<DetailedForecastEntity> list = super.list(queryWrapper);
        return this.loadExtend(list);
    }

    @Override
    public DetailedForecastEntity getById(Serializable id) {
        DetailedForecastEntity entity = super.getById(id);
        if (Objects.isNull(entity)) {
            return null;
        }
        return this.loadExtend(Lists.newArrayList(entity)).get(0);
    }

    @Override
    public boolean save(DetailedForecastEntity entity) {
        DetailedForecastFormulaEntity formulaEntity = BeanUtil.copyProperties(entity, DetailedForecastFormulaEntity.class);
        List<DetailedForecastProductEntity> productEntityList = detailedForecastProductRepository.buildEntityList(entity);

        entity = this.clearExtend(Lists.newArrayList(entity)).get(0);
        boolean save = super.save(entity);
        //保存下公式扩展表
        formulaEntity.setId(entity.getId());
        detailedForecastFormulaRepository.save(formulaEntity);
        //保存下产品扩展表
        for (DetailedForecastProductEntity productEntity : productEntityList) {
            productEntity.setDetailedForecastId(entity.getId());
        }
        detailedForecastProductRepository.saveBatch(productEntityList);
        return save;
    }

    @Override
    public boolean updateById(DetailedForecastEntity entity) {
        DetailedForecastFormulaEntity formulaEntity = BeanUtil.copyProperties(entity, DetailedForecastFormulaEntity.class);
        List<DetailedForecastProductEntity> productEntityList = detailedForecastProductRepository.buildEntityList(entity);

        entity = this.clearExtend(Lists.newArrayList(entity)).get(0);
        boolean result = super.updateById(entity);

        //保存下公式扩展表
        detailedForecastFormulaRepository.saveOrUpdate(formulaEntity);
        //保存下产品扩展表
        for (DetailedForecastProductEntity productEntity : productEntityList) {
            productEntity.setDetailedForecastId(entity.getId());
        }
        detailedForecastProductRepository.removeByForecastIds(Lists.newArrayList(entity.getId()));
        detailedForecastProductRepository.saveBatch(productEntityList);
        return result;
    }

    @Override
    public boolean saveOrUpdate(DetailedForecastEntity entity, Wrapper<DetailedForecastEntity> updateWrapper) {
        DetailedForecastFormulaEntity formulaEntity = BeanUtil.copyProperties(entity, DetailedForecastFormulaEntity.class);
        List<DetailedForecastProductEntity> productEntityList = detailedForecastProductRepository.buildEntityList(entity);

        entity = this.clearExtend(Lists.newArrayList(entity)).get(0);
        boolean result = super.saveOrUpdate(entity, updateWrapper);

        //保存下公式扩展表
        detailedForecastFormulaRepository.saveOrUpdate(formulaEntity);
        //保存下产品扩展表
        for (DetailedForecastProductEntity productEntity : productEntityList) {
            productEntity.setDetailedForecastId(entity.getId());
        }
        detailedForecastProductRepository.removeByForecastIds(Lists.newArrayList(entity.getId()));
        detailedForecastProductRepository.saveBatch(productEntityList);
        return result;
    }

    @Override
    public boolean saveBatch(Collection<DetailedForecastEntity> entityList, int batchSize) {
        List<DetailedForecastFormulaEntity> formulaEntityList = Lists.newArrayList();
        List<DetailedForecastProductEntity> productEntityList = new ArrayList<>();
        for (DetailedForecastEntity entity : entityList) {
            entity.setId(UUID.randomUUID().toString().replace("-", ""));

            DetailedForecastFormulaEntity formulaEntity = BeanUtil.copyProperties(entity, DetailedForecastFormulaEntity.class);
            formulaEntityList.add(formulaEntity);

            List<DetailedForecastProductEntity> productList = detailedForecastProductRepository.buildEntityList(entity);
            for (DetailedForecastProductEntity productEntity : productList) {
                productEntity.setDetailedForecastId(entity.getId());
            }
            productEntityList.addAll(productList);
        }
        entityList = this.clearExtend(Lists.newArrayList(entityList));
        boolean result = super.saveBatch(entityList, batchSize);
        if (!CollectionUtils.isEmpty(formulaEntityList)) {
            //保存下公式扩展表
            detailedForecastFormulaRepository.saveBatch(formulaEntityList, batchSize);
        }
        if (!CollectionUtils.isEmpty(productEntityList)) {
            //保存下产品扩展表
            detailedForecastProductRepository.removeByForecastIds(entityList.stream().map(DetailedForecastEntity::getId).collect(Collectors.toList()));
            detailedForecastProductRepository.saveBatch(productEntityList);
        }

        return result;
    }

    @Override
    public boolean saveOrUpdateBatch(Collection<DetailedForecastEntity> entityList, int batchSize) {
        List<DetailedForecastFormulaEntity> formulaEntityList = Lists.newArrayList();
        List<DetailedForecastProductEntity> productEntityList = new ArrayList<>();
        for (DetailedForecastEntity entity : entityList) {
            entity.setId(UUID.randomUUID().toString().replace("-", ""));

            DetailedForecastFormulaEntity formulaEntity = BeanUtil.copyProperties(entity, DetailedForecastFormulaEntity.class);
            formulaEntityList.add(formulaEntity);

            List<DetailedForecastProductEntity> productList = detailedForecastProductRepository.buildEntityList(entity);
            for (DetailedForecastProductEntity productEntity : productList) {
                productEntity.setDetailedForecastId(entity.getId());
            }
            productEntityList.addAll(productList);
        }

        entityList = this.clearExtend(Lists.newArrayList(entityList));
        boolean result = super.saveOrUpdateBatch(entityList, batchSize);
        //保存下公式扩展表
        detailedForecastFormulaRepository.saveOrUpdateBatch(formulaEntityList, batchSize);
        //保存下产品扩展表
        detailedForecastProductRepository.removeByForecastIds(entityList.stream().map(DetailedForecastEntity::getId).collect(Collectors.toList()));
        detailedForecastProductRepository.saveBatch(productEntityList);
        return result;
    }

    @Override
    public boolean updateBatchById(Collection<DetailedForecastEntity> entityList, int batchSize) {

        List<DetailedForecastFormulaEntity> formulaEntityList = Lists.newArrayList();
        List<DetailedForecastProductEntity> productEntityList = new ArrayList<>();

        for (DetailedForecastEntity entity : entityList) {
            DetailedForecastFormulaEntity formulaEntity = BeanUtil.copyProperties(entity, DetailedForecastFormulaEntity.class);
            formulaEntityList.add(formulaEntity);

            List<DetailedForecastProductEntity> productList = detailedForecastProductRepository.buildEntityList(entity);
            for (DetailedForecastProductEntity productEntity : productList) {
                productEntity.setDetailedForecastId(entity.getId());
            }
            productEntityList.addAll(productList);
        }

        entityList = this.clearExtend(Lists.newArrayList(entityList));
        boolean result = super.updateBatchById(entityList, batchSize);

        //保存下公式扩展表
        detailedForecastFormulaRepository.updateBatchById(formulaEntityList, batchSize);
        //保存下产品扩展表
        detailedForecastProductRepository.removeByForecastIds(entityList.stream().map(DetailedForecastEntity::getId).collect(Collectors.toList()));
        detailedForecastProductRepository.saveBatch(productEntityList);
        return result;
    }

    @Override
    public boolean removeByIds(Collection<? extends Serializable> idList) {
        if (CollectionUtils.isEmpty(idList)) {
            return true;
        }
        List<String> ids = idList.stream().map(Object::toString).collect(Collectors.toList());
        boolean result = super.removeByIds(idList);
        boolean formulaResult = this.detailedForecastFormulaRepository.removeByIds(idList);
        boolean productResult = this.detailedForecastProductRepository.removeByForecastIds(ids);
        return result && formulaResult && productResult;
    }

    public void updatePushECRMStatusByCodeSet(Set<String> activityDetailPlanItemCodeSet) {
        this.lambdaUpdate()
                .in(DetailedForecastEntity::getActivityDetailItemCode, activityDetailPlanItemCodeSet)
                .eq(DetailedForecastEntity::getBusinessUnitCode, BusinessUnitEnum.HEADQUARTERS.getCode())
                .eq(DetailedForecastEntity::getTenantCode, TenantUtils.getTenantCode())
                .set(DetailedForecastEntity::getPushEcrmStatus, PushECRMStatusEnum.ADD.getCode())
                .update();
    }

    public List<DetailedForecastEntity> findByActivityDetailItemCodes(Set<String> activityDetailItemCodes) {
        if (CollectionUtil.isEmpty(activityDetailItemCodes)) {
            return Collections.emptyList();
        }
        return this.lambdaQuery()
                .eq(DetailedForecastEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(DetailedForecastEntity::getTenantCode, TenantUtils.getTenantCode())
                .in(DetailedForecastEntity::getActivityDetailItemCode, activityDetailItemCodes)
                .list();
    }

    /**
     * 获取已付款金额
     *
     * @param codeList
     * @return
     */
    public List<DetailedForecastFeeLedgerResultVo> getPaidAmount(Set<String> codeList) {
        if (CollectionUtil.isEmpty(codeList)) {
            return Collections.emptyList();
        }
        List<DetailedForecastFeeLedgerResultVo> list = detailedForecastMapper.getPaidAmount(codeList);
        return !CollectionUtils.isEmpty(list) ? list : new ArrayList<>();
    }

    /**
     * 获取报销金额
     *
     * @param codeList
     * @return
     */
    public List<DetailedForecastFeeLedgerResultVo> getReimburseTaxAmount(Set<String> codeList) {
        if (CollectionUtil.isEmpty(codeList)) {
            return Collections.emptyList();
        }
        List<DetailedForecastFeeLedgerResultVo> list = detailedForecastMapper.getReimburseTaxAmount(codeList);
        return !CollectionUtils.isEmpty(list) ? list : new ArrayList<>();
    }

    /**
     * 入费用池金额
     *
     * @param codeList
     * @return
     */
    public List<DetailedForecastFeeLedgerResultVo> getFeePoolAmount(Set<String> codeList) {
        if (CollectionUtil.isEmpty(codeList)) {
            return Collections.emptyList();
        }
        List<DetailedForecastFeeLedgerResultVo> list = detailedForecastMapper.getFeePoolAmount(codeList);
        return !CollectionUtils.isEmpty(list) ? list : new ArrayList<>();
    }

    /**
     * 根据方案明细编码查细案预测
     *
     * @param codeSet
     * @return
     */
    public List<DetailedForecastVo> findByPlanItemCode(Set<String> codeSet) {
        return detailedForecastMapper.findByPlanItemCode(codeSet, TenantUtils.getTenantCode());
    }

    public List<DetailedForecastVo> findAuditAmount(List<String> auditCodeList) {
        if(CollectionUtil.isEmpty(auditCodeList)){
            return Collections.emptyList();
        }
        String tenantCode = TenantUtils.getTenantCode();
        List<String> businessUnitCodes = new ArrayList<>();
        businessUnitCodes.add(BusinessUnitEnum.HEADQUARTERS.getCode());
        businessUnitCodes.add(BusinessUnitEnum.SON_COMPANY.getCode());
        List<String> activityDetailCodeList = detailedForecastMapper.findActivityDetailCodeByAuditList(auditCodeList, tenantCode);
        if(CollectionUtil.isEmpty(activityDetailCodeList)){
            return Collections.emptyList();
        }
        return detailedForecastMapper.findAuditAmount(activityDetailCodeList, businessUnitCodes, tenantCode);
    }

    /**
     * 向上预计可核销金额监控表 （只取常温、主体数据）
     *
     * @param pageable 分页对象
     * @param dto      查询实体
     * @return 所有数据
     */
    public Page<UpExpectAuditAmountMonitorVo> pageUpExpectAuditAmountMonitor(Pageable pageable, UpExpectAuditAmountMonitorDto dto) {
        //1.获取主表信息.
        Page<UpExpectAuditAmountMonitorVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        Page<UpExpectAuditAmountMonitorVo> pageList = this.detailedForecastMapper.pageUpExpectAuditAmountMonitor(page, dto);
        return pageList;
    }

    public Page<DetailedForecastSummaryVo> summaryPage(Pageable pageable, DetailedForecastSummaryDto dto) {
        Page<DetailedForecastSummaryVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        dto.setTenantCode(TenantUtils.getTenantCode());
        Validate.notBlank(dto.getTenantCode(), "租户号为空");
        return this.detailedForecastMapper.summaryPage(page, dto);
    }

    public List<DetailedForecastSummaryVo> summarySalesPerformanceList(List<String> keyList, List<String> keyBrandList) {
        return this.detailedForecastMapper.summarySalesPerformanceList(TenantUtils.getTenantCode(), keyList, keyBrandList);
    }

    public List<Map<String, Object>> findTpmUpExpectAuditAmountMonitorWarning(TpmUpExpectAuditAmountMonitorWarningQueryDto dto) {
        dto.setBusinessFormatCode(BusinessFormatEnum.NORMAL.getCode());
        dto.setBusinessUnitCode(BusinessUnitEnum.HEADQUARTERS.getCode());
        dto.setTenantCode(TenantUtils.getTenantCode());
        dto.setShowFlag(BooleanEnum.TRUE.getCapital());
        return detailedForecastMapper.findTpmUpExpectAuditAmountMonitorWarning(dto);
    }

    public List<DetailedForecastEntity> findEstimatedWriteOffAmount(DetailedForecastDto detailedForecastDto) {
        if (Objects.isNull(detailedForecastDto)) {
            return Lists.newArrayList();
        }
        List<DetailedForecastEntity> list = this.lambdaQuery().eq(DetailedForecastEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(DetailedForecastEntity::getTenantCode, TenantUtils.getTenantCode())
                .eq(DetailedForecastEntity::getSalesGroupCode, detailedForecastDto.getSalesGroupCode())
                .eq(DetailedForecastEntity::getBusinessUnitCode, detailedForecastDto.getBusinessUnitCode())
                .eq(DetailedForecastEntity::getYearMonthStr, detailedForecastDto.getYearMonthStr())
                .list();
        return list;
    }

    public List<DetailedForecastVo> findListForSaleAndFeeMonitoring(List<DetailedForecastDto> detailedForecastDtos) {
        if (CollectionUtils.isEmpty(detailedForecastDtos)) {
            return Lists.newArrayList();
        }
        return this.detailedForecastMapper.findListForSaleAndFeeMonitoring(detailedForecastDtos);
    }

    public List<DetailedForecastEntity> findByPlanItemCodes(Set<String> constituentDetailPlanItemCodes) {
        if (CollectionUtils.isEmpty(constituentDetailPlanItemCodes)) {
            return Lists.newArrayList();
        }
        return this.lambdaQuery().in(DetailedForecastEntity::getActivityDetailItemCode, constituentDetailPlanItemCodes)
                .eq(DetailedForecastEntity::getTenantCode, TenantUtils.getTenantCode())
                .list();
    }

    /**
     * 查询本次增量的数据
     *
     * @param dto
     * @return
     */
    public List<ActivityDetailPlanItemVo> findDetailedForecastSummaryUpdate(DetailedForecastSummaryDto dto) {
        return this.detailedForecastMapper.findDetailedForecastSummaryUpdate(dto);
    }

    /**
     * 根据planCode 得到增量的细案明细编码 然后查询细案预测数据
     *
     * @param detailPlanItemCodes
     * @return
     */
    public List<DetailedForecastVo> findDetailedForecastSummaryUpdateList(List<String> detailPlanItemCodes) {
        return this.detailedForecastMapper.findDetailedForecastSummaryUpdateList(detailPlanItemCodes, TenantUtils.getTenantCode());
    }

    public Page<ActivityDetailPlanItemVo> findActivityDetailPlanItemList(Page<ActivityDetailPlanItemVo> page, DetailedForecastSummaryDto dto) {
        return this.detailedForecastMapper.findActivityDetailPlanItemList(page, dto);
    }

    public Page<DetailedForecastSummaryVo> summaryPageNew(Pageable pageable, DetailedForecastSummaryDto dto) {
        Page<DetailedForecastSummaryVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        dto.setTenantCode(TenantUtils.getTenantCode());
        Validate.notBlank(dto.getTenantCode(), "租户号为空");
        return this.detailedForecastMapper.summaryPageNew(page, dto);
    }

    public List<DetailedForecastVo> findEstimatedWriteOffAmountByCodes(List<String> codes) {
        return this.baseMapper.findEstimatedWriteOffAmountByCodes(codes, TenantUtils.getTenantCode());
    }

    /**
     * 细案预测汇总核销金额
     *
     * @param records
     * @return
     */
    public List<DetailedForecastVo> findByProfitMonitor(List<DetailedForecastDto> records) {
        return this.detailedForecastMapper.findByProfitMonitor(records);
    }

    public List<DetailedForecastVo> findByProfitMonitor1(List<DetailedForecastDto> detailedForecastDtos) {
        return this.detailedForecastMapper.findByProfitMonitor1(detailedForecastDtos);
    }

    public List<AuditDetailedForecastVo> findByActivityDetailItemCodes2(List<String> activityDetailItemCodes) {
        if (CollectionUtils.isEmpty(activityDetailItemCodes)) {
            return Lists.newArrayList();
        }
        return this.getBaseMapper().findByActivityDetailItemCodes2(activityDetailItemCodes);
    }
}
