package com.biz.crm.tpm.business.detailed.forecast.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.tpm.business.detailed.forecast.local.entity.DetailedForecastSummaryEntity;
import com.biz.crm.tpm.business.detailed.forecast.local.mapper.DetailedForecastSummaryMapper;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.springframework.stereotype.Component;

import java.util.List;


@Component
public class DetailedForecastSummaryRepository extends ServiceImpl<DetailedForecastSummaryMapper, DetailedForecastSummaryEntity> {

    public void deleteSummaryByPlanCode(List<String> planCodes) {
        this.lambdaUpdate()
                .eq(DetailedForecastSummaryEntity::getTenantCode, TenantUtils.getTenantCode())
                .in(DetailedForecastSummaryEntity::getSchemeCode,planCodes)
                .remove();
    }
}
