package com.biz.crm.tpm.business.detailed.forecast.local.service.internal;

import com.biz.crm.tpm.business.detailed.forecast.local.repository.DetailedForecastRepository;
import com.biz.crm.tpm.business.detailed.forecast.local.vo.TpmUpExpectAuditAmountMonitorWarningQueryDto;
import com.biz.crm.tpm.business.warning.config.sdk.dto.TpmWarningConditionDto;
import com.biz.crm.tpm.business.warning.config.sdk.dto.TpmWarningMonitoringVariable;
import com.biz.crm.tpm.business.warning.config.sdk.service.AbstractTpmWarningMonitoringVariableRegister;
import org.apache.commons.compress.utils.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

/**
 * 向上预计可核销金额监控表-预警监控配置
 * @author wanghaojia
 * @date 2023/6/14 15:32
 */
@Service
public class AbstractTpmWarningUpExpectAuditAmountMonitorVariableRegister extends AbstractTpmWarningMonitoringVariableRegister {

    public static final String monitoringTable = "tpm_up_expect_audit_amount_monitor";

    @Autowired
    private DetailedForecastRepository detailedForecastRepository;

    @Override
    public String monitoringTable() {
        return monitoringTable;
    }

    @Override
    public List<TpmWarningMonitoringVariable> variableList() {
        List<TpmWarningMonitoringVariable> variableList = Lists.newArrayList();
        TpmWarningMonitoringVariable tpmWarningMonitoringVariable = new TpmWarningMonitoringVariable();
        tpmWarningMonitoringVariable.setVariableField("write_off_amount_gap");
        tpmWarningMonitoringVariable.setVariableFieldName("可核销金额缺口（元）");
        tpmWarningMonitoringVariable.setVariableQueryField("(IFNULL(t.apply_amount,0) - IFNULL(t.estimated_write_off_amount,0))");
        variableList.add(tpmWarningMonitoringVariable);
        return variableList;
    }

    @Override
    public List<Map<String,Object>> dataList(List<TpmWarningConditionDto> conditionList) {
        TpmUpExpectAuditAmountMonitorWarningQueryDto dto = new TpmUpExpectAuditAmountMonitorWarningQueryDto();
        String appendWhereSql = super.appendWhereSql(conditionList);
        dto.setAppendWhereSql(appendWhereSql);
        return detailedForecastRepository.findTpmUpExpectAuditAmountMonitorWarning(dto);
    }

    @Override
    public String businessCodeField() {
        return "id";
    }

}
