package com.biz.crm.tpm.business.detailed.forecast.local.service.internal;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.business.common.sdk.service.RedisService;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.mn.common.rocketmq.service.RocketMqProducer;
import com.biz.crm.mn.common.rocketmq.util.RocketMqUtil;
import com.biz.crm.mn.common.rocketmq.vo.MqMessageVo;
import com.biz.crm.mn.third.system.ecrm.sdk.vo.DetailedForecastRequestVo;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.constant.ActivityDetailPlanConstant;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.constant.ActivityDetailPlanPassMqTagConstant;
import com.biz.crm.tpm.business.detailed.forecast.sdk.constant.DeatailedForecastConstants;
import com.biz.crm.tpm.business.detailed.forecast.sdk.dto.DetailedForecastAutoCreateDto;
import com.biz.crm.tpm.business.detailed.forecast.sdk.dto.DetailedForecastAutoRefreshDto;
import com.biz.crm.tpm.business.detailed.forecast.sdk.service.DetailedForecastService;
import com.biz.crm.tpm.business.promotion.plan.sdk.constant.PromotionPlanConstant;
import com.biz.crm.tpm.business.promotion.plan.sdk.constant.PromotionPlanMqTagConstant;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.constant.SubComActivityDetailPlanConstant;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.constant.SubComActivityDetailPlanPassMqTagConstant;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.task.annotations.DynamicTaskService;
import com.google.common.collect.Lists;
import lombok.SneakyThrows;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.UUID;

/**
 * <p>
 * 细案预测定时创建
 * 因发版等其他原因导致未正常生成细案预测的数据重新生成
 * 默认检查更新时间3天内的活动
 * </p>
 *
 * @author chenshuang
 * @since 2023-02-16
 */
@Slf4j
@Service
public class DetailedForecastAutoCreateXxlJob {

    @Autowired(required = false)
    private DetailedForecastService detailedForecastService;

    @Autowired(required = false)
    private RocketMqProducer rocketMqProducer;

    @Autowired(required = false)
    private LoginUserService loginUserService;

    @Autowired(required = false)
    private RedisService redisService;

    /**
     * 细案预测定时补创建任务，7点开始1个小时执行一次，默认检查更新时间3天内的活动
     */
    @DynamicTaskService(cornExpression = "0 0 7/1 * * ?", taskDesc = "细案预测定时补创建任务")
    public void autoCreate() {
        log.info("=====>    细案预测定时补创建[{}] start    <=====", DateUtil.dateStrNowAll());
        try {
            if (redisService.hasKey(DeatailedForecastConstants.CREATE_KEY)) {
                Object o = redisService.get(DeatailedForecastConstants.CREATE_KEY);
                String msg = "细案预测定时补创建进行中！开始时间：" + o.toString();
                log.error(msg);
                throw new RuntimeException(msg);
            }
            loginUserService.refreshAuthentication(null);
            String nowDateTime = DateUtil.getDate(DateUtil.DEFAULT_DATE_ALL_PATTERN);
            //锁5分钟自然解锁
            redisService.set(DeatailedForecastConstants.CREATE_KEY, nowDateTime, 60 * 5);
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern(DateUtil.DEFAULT_DATE_ALL_PATTERN);

            DetailedForecastAutoCreateDto dto = new DetailedForecastAutoCreateDto();
            dto.setModifyBeginDateTime(LocalDateTime.now().plusDays(-300).format(formatter));
            try {
                dto.setBusinessUnitCode(BusinessUnitEnum.SON_COMPANY.getCode());
                List<String> subComList = detailedForecastService.findAutoCreateDataList(dto);
                log.info("细案预测定时补创建===》分子===》{}", subComList.size());
                this.sendMq(dto.getBusinessUnitCode(), subComList);
            } catch (Exception e) {
                log.error("细案预测定时补创建===》分子===》异常：" + e.getMessage(), e);
            }

            try {
                dto.setBusinessUnitCode(BusinessUnitEnum.ONLINE.getCode());
                List<String> onlineList = detailedForecastService.findAutoCreateDataList(dto);
                log.info("细案预测定时补创建===》电商===》{}", onlineList.size());
                this.sendMq(dto.getBusinessUnitCode(), onlineList);
            } catch (Exception e) {
                log.error("细案预测定时补创建===》电商===》异常：" + e.getMessage(), e);
            }

            try {
                dto.setBusinessUnitCode(BusinessUnitEnum.HEADQUARTERS.getCode());
                List<String> mainList = detailedForecastService.findAutoCreateDataList(dto);
                log.info("细案预测定时补创建===》主体、垂直===》{}", mainList.size());
                this.sendMq(dto.getBusinessUnitCode(), mainList);
            } catch (Exception e) {
                log.error("细案预测定时补创建===》主体、垂直===》异常：" + e.getMessage(), e);
            }
        } catch (RuntimeException e) {
            e.printStackTrace();
            log.error("细案预测定时补创建异常：" + e.getMessage(), e);
        }
        log.info("=====>    细案预测定时补创建[{}] end    <=====", DateUtil.dateStrNowAll());
    }

    public void sendMq(String businessUnitCode, List<String> list) {
        Lists.partition(list, 50).forEach(codes -> {
            try {
                MqMessageVo mqMessageVo = new MqMessageVo();
                mqMessageVo.setMsgBody(JSONObject.toJSONString(codes));
                if (BusinessUnitEnum.isDefaultBusinessUnit(businessUnitCode) || BusinessUnitEnum.VERTICAL.getCode().equals(businessUnitCode)) {
                    mqMessageVo.setTopic(ActivityDetailPlanConstant.TPM_ACTIVITY_DETAIL_PLAN_PROCESS_PASS_TOPIC + RocketMqUtil.mqEnvironment());
                    mqMessageVo.setTag(ActivityDetailPlanPassMqTagConstant.PASS_DETAILED_FORECAST);
                } else if (BusinessUnitEnum.SON_COMPANY.getCode().equals(businessUnitCode)) {
                    mqMessageVo.setTopic(SubComActivityDetailPlanConstant.TPM_ACTIVITY_DETAIL_PLAN_PROCESS_PASS_TOPIC + RocketMqUtil.mqEnvironment());
                    mqMessageVo.setTag(SubComActivityDetailPlanPassMqTagConstant.PASS_ACTIVITY_DETAIL_DETAILED_FORECAST);
                } else if (BusinessUnitEnum.ONLINE.getCode().equals(businessUnitCode)) {
                    mqMessageVo.setTopic(PromotionPlanConstant.TPM_PROMOTION_PLAN_PASS_PUSH_DATAILED_FORECAST_TOPIC + RocketMqUtil.mqEnvironment());
                    mqMessageVo.setTag(PromotionPlanMqTagConstant.PROMOTION_PLAN_PASS_DETAILED_FORECAST);
                }
                log.info("细案预测定时补创建===>单元[{}]发送MQ===>{}条", businessUnitCode, codes.size());
                rocketMqProducer.sendMqMsg(mqMessageVo);
                Thread.sleep(200);
            } catch (Exception e) {
                log.error("细案预测定时补创建===>单元[" + businessUnitCode + "]发送MQ异常：" + e.getMessage() + " ===> " + JSONObject.toJSONString(codes), e);
            }
        });
    }
}
