package com.biz.crm.tpm.business.detailed.forecast.local.service.internal;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.business.common.sdk.service.RedisService;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.mn.common.rocketmq.service.RocketMqProducer;
import com.biz.crm.mn.common.rocketmq.util.RocketMqUtil;
import com.biz.crm.mn.common.rocketmq.vo.MqMessageVo;
import com.biz.crm.mn.third.system.ecrm.sdk.vo.DetailedForecastRequestVo;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.constant.ActivityDetailPlanConstant;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.constant.ActivityDetailPlanPassMqTagConstant;
import com.biz.crm.tpm.business.detailed.forecast.local.repository.DetailedForecastRefreshRepository;
import com.biz.crm.tpm.business.detailed.forecast.sdk.constant.DeatailedForecastConstants;
import com.biz.crm.tpm.business.detailed.forecast.sdk.dto.DetailedForecastAutoRefreshDto;
import com.biz.crm.tpm.business.detailed.forecast.sdk.service.DetailedForecastService;
import com.bizunited.nebula.task.annotations.DynamicTaskService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.List;
import java.util.UUID;

/**
 * <p>
 * 细案预测定时刷新
 * </p>
 *
 * @author chenshuang
 * @since 2023-02-16
 */
@Slf4j
@Service
public class DetailedForecastAutoRefreshXxlJob {

    @Autowired(required = false)
    private DetailedForecastService detailedForecastService;

    @Autowired(required = false)
    private RocketMqProducer rocketMqProducer;

    @Autowired(required = false)
    private LoginUserService loginUserService;

    @Autowired(required = false)
    private RedisService redisService;

    @Autowired(required = false)
    private DetailedForecastRefreshRepository detailedForecastRefreshRepository;

    /**
     * 细案预测定时刷新，每天同步一次（这个定时任务很耗时）
     */
    @DynamicTaskService(cornExpression = "0 20 2 * * ?", taskDesc = "细案预测定时刷新任务-活动细案")
    public void autoRefreshHead() {
        loginUserService.refreshAuthentication(null);
        this.removeExpireTimeData();
        //跑两个月的数据
        Calendar instance = Calendar.getInstance();
        SimpleDateFormat yearMonthFormat = new SimpleDateFormat(DateUtil.DEFAULT_YEAR_MONTH);
        autoRefresh(BusinessUnitEnum.HEADQUARTERS.getCode(), yearMonthFormat.format(instance.getTime()) + "-01");

        instance.add(Calendar.MONTH, -1);
        autoRefresh(BusinessUnitEnum.HEADQUARTERS.getCode(), yearMonthFormat.format(instance.getTime()) + "-01");
    }

    @DynamicTaskService(cornExpression = "0 40 2 * * ?", taskDesc = "细案预测定时刷新任务-分子细案")
    public void autoRefreshSubCom() {
        loginUserService.refreshAuthentication(null);
        this.removeExpireTimeData();
        //跑两个月的数据
        Calendar instance = Calendar.getInstance();
        SimpleDateFormat yearMonthFormat = new SimpleDateFormat(DateUtil.DEFAULT_YEAR_MONTH);
        autoRefresh(BusinessUnitEnum.SON_COMPANY.getCode(), yearMonthFormat.format(instance.getTime()) + "-01");

        instance.add(Calendar.MONTH, -1);
        autoRefresh(BusinessUnitEnum.SON_COMPANY.getCode(), yearMonthFormat.format(instance.getTime()) + "-01");
    }

    @DynamicTaskService(cornExpression = "0 0 3 * * ?", taskDesc = "细案预测定时刷新任务-电商促销政策")
    public void autoRefreshOnline() {
        loginUserService.refreshAuthentication(null);
        this.removeExpireTimeData();
        //跑两个月的数据
        Calendar instance = Calendar.getInstance();
        SimpleDateFormat yearMonthFormat = new SimpleDateFormat(DateUtil.DEFAULT_YEAR_MONTH);
        autoRefresh(BusinessUnitEnum.ONLINE.getCode(), yearMonthFormat.format(instance.getTime()) + "-01");

        instance.add(Calendar.MONTH, -1);
        autoRefresh(BusinessUnitEnum.ONLINE.getCode(), yearMonthFormat.format(instance.getTime()) + "-01");
    }

    public void autoRefresh(String businessUnitCode, String yearMonthLy) {
        log.info("=====>    " + "业务单元[" + businessUnitCode + "]年月[" + yearMonthLy + "]细案预测定时刷新[{}] start    <=====", DateUtil.dateStrNowAll());
        loginUserService.refreshAuthentication(null);
        String yearMonthDay = DateUtil.getDate(DateUtil.DEFAULT_YEAR_MONTH_DAY);
        String key1 = DeatailedForecastConstants.REFRESH_PAGE_KEY + yearMonthDay;
        String operationKey = UUID.randomUUID().toString().replace("-", "");
        try {
            //这个定时任务现在查需要执行数据挺快的，就不加锁了，在实际处理业务数据的地方加好锁
            DetailedForecastAutoRefreshDto dto = new DetailedForecastAutoRefreshDto();
            dto.setBusinessUnitCode(businessUnitCode);
//            dto.setNowDateTime(nowDateTime);
            dto.setOperationKey(operationKey);
            dto.setYearMonthLy(yearMonthLy);
            dto.setYearMonthDay(yearMonthDay);
            Long total = detailedForecastService.findAutoRefreshCount(dto);
            dto.setTotal(total);

            MqMessageVo mqMessageVo = new MqMessageVo();
            mqMessageVo.setMsgBody(JSONObject.toJSONString(dto));
            mqMessageVo.setTopic(ActivityDetailPlanConstant.TPM_ACTIVITY_DETAIL_PLAN_PROCESS_PASS_TOPIC + RocketMqUtil.mqEnvironment());
            mqMessageVo.setTag(ActivityDetailPlanPassMqTagConstant.JOB_DETAILED_FORECAST_REFRESH);
            rocketMqProducer.sendMqMsg(mqMessageVo, 10);
        } catch (RuntimeException e) {
            log.error("businessUnitCode+细案预测定时刷新异常：" + e.getMessage(), e);
        }
        log.info("=====>    " + businessUnitCode + "细案预测定时刷新[{}] end    <=====", DateUtil.dateStrNowAll());
    }

    public void testAutoRefresh(DetailedForecastAutoRefreshDto dto) {
        log.info("=====>    细案预测定时刷新[{}] start    <=====", DateUtil.dateStrNowAll());
        String nowDateTime = DateUtil.getDate(DateUtil.DEFAULT_DATE_ALL_PATTERN);
        if (StringUtils.isEmpty(dto.getNowDateTime())
                && StringUtils.isEmpty(dto.getStartDateTimeStart()) && StringUtils.isEmpty(dto.getStartDateTimeStart())
                && StringUtils.isEmpty(dto.getEndDateTimeStart()) && StringUtils.isEmpty(dto.getEndDateTimeEnd())) {
            dto.setNowDateTime(nowDateTime);
        }
        loginUserService.refreshAuthentication(null);
        String yearMonthDay = DateUtil.getDate(DateUtil.DEFAULT_YEAR_MONTH_DAY);
        String key1 = DeatailedForecastConstants.REFRESH_PAGE_KEY + yearMonthDay;
        try {
            Pageable page = PageRequest.of(1, 2000);
            int index = 1;
            if (redisService.hasKey(DeatailedForecastConstants.REFRESH_LOCK_KEY)) {
                Object o = redisService.get(DeatailedForecastConstants.REFRESH_LOCK_KEY);
                String msg = "细案预测定时刷新进行中！开始时间：" + o.toString();
                log.error(msg);
                throw new RuntimeException(msg);
            }
            redisService.set(DeatailedForecastConstants.REFRESH_LOCK_KEY, nowDateTime, 60 * 60 * 24);
            dto.setNowDateTime(nowDateTime);
            Long total = detailedForecastService.findAutoRefreshCount(dto);
            while (true) {
                List<String> list = detailedForecastService.findAutoRefreshDataList(page, dto);
                log.info("细案预测定时刷新：总数[{}]第[{}]页查询到[{}]条数据！", total, index, list.size());
                if (CollectionUtils.isEmpty(list)) {
                    break;
                }
                try {
                    String uuid = UUID.randomUUID().toString().replace("-", "");
                    redisService.hSet(DeatailedForecastConstants.REFRESH_IDS_KEY, uuid, JSON.toJSONString(list), 60 * 60 * 48);//定时任务每天跑，缓存2天够了
                    MqMessageVo mqMessageVo = new MqMessageVo();
                    mqMessageVo.setMsgBody(uuid);
                    mqMessageVo.setTopic(ActivityDetailPlanConstant.TPM_ACTIVITY_DETAIL_PLAN_PROCESS_PASS_TOPIC + RocketMqUtil.mqEnvironment());
                    mqMessageVo.setTag(ActivityDetailPlanPassMqTagConstant.DETAILED_FORECAST_REFRESH);
                    rocketMqProducer.sendMqMsg(mqMessageVo);
                    Page<DetailedForecastRequestVo> result = new Page<>();
                    result.setTotal(list.size());
                    result.setCurrent(page.getPageNumber());
                    result.setSize(page.getPageSize());
                    redisService.set(key1, JSONObject.toJSONString(result), 60 * 60 * 72);
                    Thread.sleep(200);
                } catch (Exception e) {
                    e.printStackTrace();
                    log.error("细案预测定时刷新发送MQ失败！总数[{}]第[{}]页,{}", total, index, e.getMessage());
                }
                index++;
                page = PageRequest.of(index, 2000);
            }
        } catch (RuntimeException e) {
            e.printStackTrace();
            log.error("细案预测定时刷新异常：" + e.getMessage(), e);
        }
        log.info("=====>    细案预测定时刷新[{}] end    <=====", DateUtil.dateStrNowAll());
    }


    /**
     * 删除锁定超时的单据
     */
    @Transactional(propagation = Propagation.NOT_SUPPORTED, rollbackFor = Exception.class)
    public void removeExpireTimeData() {
        detailedForecastRefreshRepository.removeExpireTime();
    }

}
