package com.biz.crm.tpm.business.detailed.forecast.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.service.ActivityDetailPlanItemSdkService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanItemVo;
import com.biz.crm.tpm.business.detailed.forecast.local.entity.DetailedForecastFormulaEntity;
import com.biz.crm.tpm.business.detailed.forecast.local.repository.DetailedForecastFormulaRepository;
import com.biz.crm.tpm.business.detailed.forecast.local.repository.DetailedForecastRepository;
import com.biz.crm.tpm.business.detailed.forecast.sdk.dto.DetailedForecastFeeLedgerDto;
import com.biz.crm.tpm.business.detailed.forecast.sdk.service.DetailedForecastFeeLedgerService;
import com.biz.crm.tpm.business.detailed.forecast.sdk.vo.DetailedForecastFeeLedgerResultVo;
import com.biz.crm.tpm.business.detailed.forecast.sdk.vo.DetailedForecastFeeLedgerVo;
import com.biz.crm.tpm.business.detailed.forecast.sdk.vo.DetailedForecastFormulaVo;
import com.biz.crm.tpm.business.detailed.forecast.sdk.vo.DetailedForecastVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import jodd.util.StringUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StopWatch;

import java.math.BigDecimal;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author: yaoyongming
 * @date: 2023/4/13 10:12
 */
@Slf4j
@Service("detailedForecastFeeLedgerService")
public class DetailedForecastFeeLedgerServiceImpl implements DetailedForecastFeeLedgerService {

    @Autowired(required = false)
    private DetailedForecastRepository detailedForecastRepository;

    @Autowired(required = false)
    private ActivityDetailPlanItemSdkService activityDetailPlanItemSdkService;

    @Autowired(required = false)
    private DetailedForecastFormulaRepository detailedForecastFormulaRepository;

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    /**
     * 分页查询数据
     *
     * @param pageable            分页对象
     * @param dto 实体对象
     * @return
     */
    @Override
    public Page<DetailedForecastFeeLedgerVo> findByForecasts(Pageable pageable, DetailedForecastFeeLedgerDto dto) {
        pageable = ObjectUtils.defaultIfNull(pageable, PageRequest.of(1, 50));
        if (Objects.isNull(dto)) {
            dto = new DetailedForecastFeeLedgerDto();
        }
        dto.setTenantCode(TenantUtils.getTenantCode());
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        //分页数据
        Page<DetailedForecastFeeLedgerVo> voPage = detailedForecastRepository.findByForecasts(pageable, dto);
        stopWatch.stop();
        log.info("=====>    细案核销台账表列表耗时page[{}]    <=====", DateUtil.millisecondToStr(stopWatch.getLastTaskTimeMillis()));
        Page<DetailedForecastFeeLedgerVo> page = new Page<>();
        page.setTotal(voPage.getTotal());
        page.setCurrent(voPage.getCurrent());
        page.setSize(voPage.getSize());
        if (CollectionUtils.isEmpty(voPage.getRecords())) {
            return page;
        }


        Map<String, DetailedForecastFeeLedgerResultVo> paidAmountMap = new HashMap<>();
        Map<String, DetailedForecastFeeLedgerResultVo> reimburseTaxAmountMap = new HashMap<>();
        Map<String, DetailedForecastFeeLedgerResultVo> feePoolAmountMap = new HashMap<>();

        List<DetailedForecastFeeLedgerVo> feeLedgerVos = voPage.getRecords();

        Set<String> itemSet = feeLedgerVos.stream()
                .filter(k-> StringUtil.isNotEmpty(k.getActivityDetailItemCode()))
                .map(DetailedForecastVo::getActivityDetailItemCode).collect(Collectors.toSet());

        List<List<String>> partition = Lists.partition(new ArrayList<>(itemSet), 500);
        List<DetailedForecastFeeLedgerResultVo> paidAmountList = new ArrayList<>();
        List<DetailedForecastFeeLedgerResultVo> reimburseTaxAmountList = new ArrayList<>();
        List<DetailedForecastFeeLedgerResultVo> feePoolAmountList = new ArrayList<>();
        List<ActivityDetailPlanItemVo> activityDetailPlanItemVoList = new ArrayList<>();
        List<DetailedForecastFormulaVo> detailedForecastFormulaVoList = new ArrayList<>();
        List<DetailedForecastFeeLedgerVo> activityDetailPlanItemList = new ArrayList<>();
        List<DetailedForecastFeeLedgerVo> detailedForecastFormulaList = new ArrayList<>();
        for (List<String> part : partition) {
            stopWatch.start();
            paidAmountList.addAll(detailedForecastRepository.getPaidAmount(new HashSet<>(part)));
            stopWatch.stop();
            log.info("=====>    细案核销台账表列表耗时PaidAmount[{}]    <=====", DateUtil.millisecondToStr(stopWatch.getLastTaskTimeMillis()));
            stopWatch.start();
            reimburseTaxAmountList.addAll(detailedForecastRepository.getReimburseTaxAmount(new HashSet<>(part)));
            stopWatch.stop();
            log.info("=====>    细案核销台账表列表耗时ReimburseTaxAmount[{}]    <=====", DateUtil.millisecondToStr(stopWatch.getLastTaskTimeMillis()));
            stopWatch.start();
            feePoolAmountList.addAll(detailedForecastRepository.getFeePoolAmount(new HashSet<>(part)));
            stopWatch.stop();
            log.info("=====>    细案核销台账表列表耗时FeePoolAmount[{}]    <=====", DateUtil.millisecondToStr(stopWatch.getLastTaskTimeMillis()));
            stopWatch.start();
            activityDetailPlanItemVoList.addAll(activityDetailPlanItemSdkService.findByItemCodes(part));
            stopWatch.stop();
            log.info("=====>    细案核销台账表列表耗时activityDetailPlanItem[{}]    <=====", DateUtil.millisecondToStr(stopWatch.getLastTaskTimeMillis()));
            stopWatch.start();
            detailedForecastFormulaVoList.addAll(this.findByDetailPlanItemCodes(part));
            stopWatch.stop();
            log.info("=====>    细案核销台账表列表耗时DetailedForecastFormula[{}]    <=====", DateUtil.millisecondToStr(stopWatch.getLastTaskTimeMillis()));

            stopWatch.start();
            activityDetailPlanItemList.addAll(detailedForecastRepository.getActivityDetailPlanItem(part));
            stopWatch.stop();
            log.info("=====>    细案核销台账表列表耗时ActivityDetailPlanItem[{}]    <=====", DateUtil.millisecondToStr(stopWatch.getLastTaskTimeMillis()));

            stopWatch.start();
            detailedForecastFormulaList.addAll(detailedForecastRepository.getDetailedForecastFormula(part));
            stopWatch.stop();
            log.info("=====>    细案核销台账表列表耗时DetailedForecastFormula[{}]    <=====", DateUtil.millisecondToStr(stopWatch.getLastTaskTimeMillis()));
        }

        //已付款金额：根据细案明细编码查询付款单据管理中付款状态为付款成功（看着应该是3）的付款单中的本次付款金额加和
        if (!CollectionUtils.isEmpty(paidAmountList)) {
            paidAmountMap = paidAmountList.stream().
                    collect(Collectors.toMap(DetailedForecastFeeLedgerResultVo::getActivityDetailCode, v -> v, (newValue, oldValue) -> newValue));
        }
        //报销金额（含税）：根据细案明细编码查询结案核销管理中报销上账状态为上账成功的本次报销金额加和
        if (!CollectionUtils.isEmpty(reimburseTaxAmountList)) {
            reimburseTaxAmountMap = reimburseTaxAmountList.stream().
                    collect(Collectors.toMap(DetailedForecastFeeLedgerResultVo::getActivityDetailCode, v -> v, (newValue, oldValue) -> newValue));
        }
        //入费用池金额：根据细案明细编码查询结案核销管理中折扣上账状态为上账成功的本次报销金额加和
        if (!CollectionUtils.isEmpty(feePoolAmountList)) {
            feePoolAmountMap = feePoolAmountList.stream().
                    collect(Collectors.toMap(DetailedForecastFeeLedgerResultVo::getActivityDetailCode, v -> v, (newValue, oldValue) -> newValue));
        }

        //活动细案
        Map<String, ActivityDetailPlanItemVo> activityDetailPlanItemVoMap = new HashMap<>();
        if (!CollectionUtils.isEmpty(activityDetailPlanItemVoList)) {
            activityDetailPlanItemVoMap = activityDetailPlanItemVoList.stream().collect(Collectors.toMap(ActivityDetailPlanItemVo::getDetailPlanItemCode, Function.identity(), (n, o) -> n));
        }
        //活动细案公式
        Map<String, DetailedForecastFormulaVo> detailedForecastFormulaVoMap = new HashMap<>();
        if (!CollectionUtils.isEmpty(detailedForecastFormulaVoList)) {
            detailedForecastFormulaVoMap = detailedForecastFormulaVoList.stream().collect(Collectors.toMap(DetailedForecastFormulaVo::getActivityDetailItemCode, Function.identity(), (n, o) -> n));
        }

        Map<String, DetailedForecastFeeLedgerVo> activityDetailPlanItemMap = new HashMap<>();
        if (!CollectionUtils.isEmpty(activityDetailPlanItemList)) {
            activityDetailPlanItemMap = activityDetailPlanItemList.stream().collect(Collectors.toMap(DetailedForecastFeeLedgerVo::getActivityDetailItemCode, Function.identity(), (n, o) -> n));
        }
        Map<String, DetailedForecastFeeLedgerVo> detailedForecastFormulaMap = new HashMap<>();
        if (!CollectionUtils.isEmpty(detailedForecastFormulaList)) {
            detailedForecastFormulaMap = detailedForecastFormulaList.stream().collect(Collectors.toMap(DetailedForecastFeeLedgerVo::getActivityDetailItemCode, Function.identity(), (n, o) -> n));
        }

        for (DetailedForecastFeeLedgerVo vo : feeLedgerVos) {
            BigDecimal paidAmount = BigDecimal.ZERO;
            BigDecimal reimburseTaxAmount = BigDecimal.ZERO;
            BigDecimal feePoolAmount = BigDecimal.ZERO;

            DetailedForecastFeeLedgerVo ledgerVo1 = activityDetailPlanItemMap.get(vo.getActivityDetailItemCode());
            if (ledgerVo1 != null) {
                vo.setWholeAudit(ledgerVo1.getWholeAudit());
                vo.setAlreadyAuditAmountEx(ledgerVo1.getAlreadyAuditAmountEx());
            }


            DetailedForecastFeeLedgerVo ledgerVo2 = detailedForecastFormulaMap.get(vo.getActivityDetailItemCode());
            if (ledgerVo2 != null) {
                vo.setWriteOffConditionsEx(ledgerVo2.getWriteOffConditionsEx());
                vo.setWriteOffFormulaEx(ledgerVo2.getWriteOffFormulaEx());
                vo.setWriteOffConditionValueEx(ledgerVo2.getWriteOffConditionValueEx());
                vo.setWriteOffFormulaValueEx(ledgerVo2.getWriteOffFormulaValueEx());
                vo.setWriteOffPremiseEx(ledgerVo2.getWriteOffPremiseEx());
                vo.setCalExEx(ledgerVo2.getCalExEx());
                vo.setOverBudgetRemarkEx(ledgerVo2.getOverBudgetRemarkEx());
            }

            ActivityDetailPlanItemVo activityDetailPlanItemVo = activityDetailPlanItemVoMap.get(vo.getActivityDetailItemCode());
            if(activityDetailPlanItemVo!=null){
                vo.setAlreadyAuditAmountEx(activityDetailPlanItemVo.getAlreadyAuditAmount());
            }
            DetailedForecastFormulaVo detailedForecastFormulaVo = detailedForecastFormulaVoMap.get(vo.getActivityDetailItemCode());
            if (detailedForecastFormulaVo != null) {
                vo.setWriteOffConditionsEx(detailedForecastFormulaVo.getWriteOffConditions());
                vo.setWriteOffFormulaEx(detailedForecastFormulaVo.getWriteOffFormula());
                vo.setWriteOffConditionValueEx(detailedForecastFormulaVo.getWriteOffConditionValue());
                vo.setWriteOffFormulaValueEx(detailedForecastFormulaVo.getWriteOffFormulaValue());
                vo.setWriteOffPremiseEx(detailedForecastFormulaVo.getWriteOffPremise());
                vo.setCalExEx(detailedForecastFormulaVo.getCalEx());
                vo.setOverBudgetRemarkEx(detailedForecastFormulaVo.getOverBudgetRemark());
            }

            if (!CollectionUtils.isEmpty(paidAmountMap) && paidAmountMap.containsKey(vo.getActivityDetailItemCode())) {
                DetailedForecastFeeLedgerResultVo resVo1 = paidAmountMap.get(vo.getActivityDetailItemCode());
                paidAmount = resVo1.getAmount();
            }
            if (!CollectionUtils.isEmpty(reimburseTaxAmountMap) && reimburseTaxAmountMap.containsKey(vo.getActivityDetailItemCode())) {
                DetailedForecastFeeLedgerResultVo resVo2 = reimburseTaxAmountMap.get(vo.getActivityDetailItemCode());
                reimburseTaxAmount = resVo2.getAmount();
            }
            if (!CollectionUtils.isEmpty(feePoolAmountMap) && feePoolAmountMap.containsKey(vo.getActivityDetailItemCode())) {
                DetailedForecastFeeLedgerResultVo resVo3 = feePoolAmountMap.get(vo.getActivityDetailItemCode());
                feePoolAmount = resVo3.getAmount();
            }

            vo.setReimburseTaxAmount(reimburseTaxAmount);
            vo.setFeePoolAmount(feePoolAmount);
            //未付款金额：报销金额（含税）-已付款金额
            vo.setPendingAmount(vo.getReimburseTaxAmount().subtract(paidAmount));
        }

        page.setRecords(feeLedgerVos);
        return page;
    }

    @Override
    public List<DetailedForecastFormulaVo> findByDetailPlanItemCodes(List<String> detailPlanItemCodes) {
        if(CollectionUtils.isEmpty(detailPlanItemCodes)){
            return Lists.newArrayList();
        }

        List<DetailedForecastFormulaEntity> list = detailedForecastFormulaRepository.lambdaQuery()
                .eq(DetailedForecastFormulaEntity::getTenantCode, TenantUtils.getTenantCode())
                .in(DetailedForecastFormulaEntity::getActivityDetailItemCode, detailPlanItemCodes)
                .list();
        if(CollectionUtils.isEmpty(list)){
            return Lists.newArrayList();
        }
        return (List<DetailedForecastFormulaVo>) this.nebulaToolkitService.copyCollectionByWhiteList(list,DetailedForecastFormulaEntity.class,DetailedForecastFormulaVo.class,LinkedHashSet.class,ArrayList.class);
    }
}
