package com.biz.crm.tpm.business.detailed.forecast.local.service.internal;

import com.biz.crm.common.ie.sdk.excel.process.ImportProcess;
import com.biz.crm.common.ie.sdk.vo.TaskGlobalParamsVo;
import com.biz.crm.tpm.business.detailed.forecast.local.model.DetailedForecastImportsVo;
import com.biz.crm.tpm.business.detailed.forecast.sdk.dto.DetailedForecastDto;
import com.biz.crm.tpm.business.detailed.forecast.sdk.service.DetailedForecastService;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.*;

/**
 * @author youjun
 * @date 2022年11月10日 9:54
 */
@Slf4j
@Component
public class DetailedForecastImportsProcess implements ImportProcess<DetailedForecastImportsVo> {
    @Resource
    private DetailedForecastService detailedForecastService;

    @Resource
    private NebulaToolkitService nebulaToolkitService;

    @Override
    public Map<Integer, String> execute(LinkedHashMap<Integer, DetailedForecastImportsVo> data,
                                        TaskGlobalParamsVo paramsVo,
                                        Map<String, Object> params) {
        Validate.notEmpty(data, "导入数据不能为空！");

        List<DetailedForecastDto> importList = this.validate(data);

        detailedForecastService.importSave(importList);
        return null;
    }

    /**
     * 校验并转换数据
     *
     * @param data
     * @return java.util.List<com.biz.crm.tpm.business.detailed.forecast.sdk.dto.DetailedForecastDto>
     * @author youjun
     * @date 2022/11/10 9:58
     **/
    private List<DetailedForecastDto> validate(LinkedHashMap<Integer, DetailedForecastImportsVo> data) {
        List<DetailedForecastImportsVo> detailedForecastImportsVos = new ArrayList<>(data.values());

        // TODO:根据配置表校验
        detailedForecastImportsVos.forEach(importsVo -> {

        });
        Collection<DetailedForecastDto> detailedForecastDtoList = nebulaToolkitService.copyCollectionByWhiteList(detailedForecastImportsVos, DetailedForecastImportsVo.class, DetailedForecastDto.class, LinkedHashSet.class, ArrayList.class);
        return new ArrayList<>(detailedForecastDtoList);
    }

    @Override
    public Class<DetailedForecastImportsVo> findCrmExcelVoClass() {
        return DetailedForecastImportsVo.class;
    }

    @Override
    public String getTemplateCode() {
        return "TPM_DETAILED_FORECAST";
    }

    @Override
    public String getTemplateName() {
        return "TPM细案预测导入";
    }
}
