package com.biz.crm.tpm.business.detailed.forecast.local.service.internal;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.RedisService;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mdm.business.org.sdk.service.OrgVoService;
import com.biz.crm.mdm.business.org.sdk.vo.OrgVo;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgSubComOrgService;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgVoService;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgSubComOrgVo;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgVo;
import com.biz.crm.mn.common.base.eunm.BusinessFormatEnum;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.mn.common.rocketmq.service.RocketMqProducer;
import com.biz.crm.mn.common.rocketmq.util.RocketMqUtil;
import com.biz.crm.mn.common.rocketmq.vo.MqMessageVo;
import com.biz.crm.mn.third.system.ecrm.sdk.enumeration.PushECRMStatusEnum;
import com.biz.crm.mn.third.system.ecrm.sdk.service.EcrmService;
import com.biz.crm.mn.third.system.ecrm.sdk.vo.DetailedForecastRequestVo;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.constant.ActivityDetailPlanConstant;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.constant.ActivityDetailPlanPassMqTagConstant;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.service.ActivityDetailPlanItemSdkService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.service.ActivityDetailPlanSdkService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanItemVo;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanVo;
import com.biz.crm.tpm.business.detailed.forecast.local.entity.DetailedForecastEntity;
import com.biz.crm.tpm.business.detailed.forecast.local.entity.DetailedForecastFormulaEntity;
import com.biz.crm.tpm.business.detailed.forecast.local.entity.DetailedForecastProductEntity;
import com.biz.crm.tpm.business.detailed.forecast.local.entity.DetailedForecastSummaryEntity;
import com.biz.crm.tpm.business.detailed.forecast.local.repository.DetailedForecastFormulaRepository;
import com.biz.crm.tpm.business.detailed.forecast.local.repository.DetailedForecastProductRepository;
import com.biz.crm.tpm.business.detailed.forecast.local.repository.DetailedForecastRepository;
import com.biz.crm.tpm.business.detailed.forecast.local.repository.DetailedForecastSummaryRepository;
import com.biz.crm.tpm.business.detailed.forecast.local.util.ActivityDetailPlanPassDetailedForecastUtil;
import com.biz.crm.tpm.business.detailed.forecast.sdk.constant.DeatailedForecastConstants;
import com.biz.crm.tpm.business.detailed.forecast.sdk.constant.DetailedPredictionTypeEnum;
import com.biz.crm.tpm.business.detailed.forecast.sdk.dto.*;
import com.biz.crm.tpm.business.detailed.forecast.sdk.dto.log.DetailedForecastLogEventDto;
import com.biz.crm.tpm.business.detailed.forecast.sdk.event.DetailedForecastLogEventListener;
import com.biz.crm.tpm.business.detailed.forecast.sdk.service.DetailedForecastService;
import com.biz.crm.tpm.business.detailed.forecast.sdk.vo.AuditDetailedForecastVo;
import com.biz.crm.tpm.business.detailed.forecast.sdk.vo.DetailedForecastSummaryVo;
import com.biz.crm.tpm.business.detailed.forecast.sdk.vo.DetailedForecastVo;
import com.biz.crm.tpm.business.detailed.forecast.sdk.vo.UpExpectAuditAmountMonitorVo;
import com.biz.crm.tpm.business.warning.config.sdk.service.TpmWarningMonitoringSdkService;
import com.biz.crm.tpm.business.warning.config.sdk.vo.TpmWarningMonitoringVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 细案预测表(DetailedForecastEntity)表服务实现类
 * @author youjun
 * @date 2022年11月09日 11:24
 */
@Slf4j
@Service("detailedForecastService")
public class DetailedForecastServiceImpl implements DetailedForecastService {

    @Autowired
    private DetailedForecastRepository detailedForecastRepository;

    @Autowired
    private NebulaToolkitService nebulaToolkitService;

    @Resource
    private NebulaNetEventClient nebulaNetEventClient;

    @Autowired(required = false)
    private RocketMqProducer rocketMqProducer;

    @Autowired(required = false)
    private ActivityDetailPlanPassDetailedForecastUtil activityDetailPlanPassDetailedForecastUtil;

    @Autowired(required = false)
    private RedisService redisService;

    @Autowired(required = false)
    private DetailedForecastFormulaRepository detailedForecastFormulaRepository;

    @Autowired(required = false)
    private DetailedForecastProductRepository detailedForecastProductRepository;

    @Autowired(required = false)
    private SalesOrgSubComOrgService salesOrgSubComOrgService;

    @Autowired(required = false)
    private OrgVoService orgVoService;

    @Autowired(required = false)
    private DetailedForecastSummaryRepository detailedForecastSummaryRepository;

    /**
     * 后端预算预测管理列表
     * @param pageable
     * @param dto
     * @return
     */
    @Override
    public Page<DetailedForecastVo> findByForecastsForWebList(Pageable pageable, DetailedForecastDto dto) {
        pageable = ObjectUtils.defaultIfNull(pageable, PageRequest.of(1, 50));
        dto = ObjectUtils.defaultIfNull(dto, new DetailedForecastDto());
        dto.setTenantCode(TenantUtils.getTenantCode());
        Assert.hasLength(dto.getYearMonthStr(), "年月[yearMonthStr]必填");
        return this.detailedForecastRepository.findByForecastsForWebList(pageable, dto);
    }

    /**
     * 分页查询数据
     * @param pageable         分页对象
     * @param detailedForecast 实体对象
     * @return
     */
    @Override
    public Page<DetailedForecastVo> findByForecasts(Pageable pageable, DetailedForecastDto detailedForecast) {
        return this.detailedForecastRepository.findByForecasts(pageable, detailedForecast);
    }

    /**
     * 通过细案明细编码查询数据
     * @param activityDetailItemCodes 细案明细编码集合
     * @return
     */
    @Override
    public List<DetailedForecastVo> findByActivityDetailItemCode(Set<String> activityDetailItemCodes) {
        if (CollectionUtil.isEmpty(activityDetailItemCodes)) {
            return Collections.emptyList();
        }
        List<DetailedForecastEntity> list = detailedForecastRepository.findByActivityDetailItemCodes(activityDetailItemCodes);
        if (CollectionUtils.isEmpty(list)) {
            return new ArrayList<>();
        }
        return (List<DetailedForecastVo>) nebulaToolkitService.copyCollectionByWhiteList(list, DetailedForecastEntity.class, DetailedForecastVo.class, HashSet.class, ArrayList.class);

    }

    /**
     * 新增数据
     * @param detailedForecastDto 实体对象
     * @return 新增结果
     */
    @Override
    public DetailedForecastVo create(DetailedForecastDto detailedForecastDto) {
        DetailedForecastEntity detailedForecastEntity = this.nebulaToolkitService.copyObjectByWhiteList(detailedForecastDto, DetailedForecastEntity.class, null, null);
        detailedForecastEntity.setTenantCode(TenantUtils.getTenantCode());
        detailedForecastEntity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        detailedForecastEntity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        // 日志新增
        DetailedForecastLogEventDto logEventDto = new DetailedForecastLogEventDto();
        logEventDto.setOriginal(null);
        logEventDto.setNewest(detailedForecastDto);
        SerializableBiConsumer<DetailedForecastLogEventListener, DetailedForecastLogEventDto> onCreate =
                DetailedForecastLogEventListener::onCreate;
        this.nebulaNetEventClient.publish(logEventDto, DetailedForecastLogEventListener.class, onCreate);
        this.detailedForecastRepository.saveOrUpdate(detailedForecastEntity);

        return nebulaToolkitService.copyObjectByWhiteList(detailedForecastEntity, DetailedForecastVo.class, HashSet.class, ArrayList.class);
    }

    /**
     * 修改数据
     * @param detailedForecastDto 实体对象
     * @return 修改结果
     */
    @Override
    public DetailedForecastVo update(DetailedForecastDto detailedForecastDto) {
        DetailedForecastVo detailedForecastVo = this.findById(detailedForecastDto.getId());
        if (ObjectUtils.isEmpty(detailedForecastVo)) {
            throw new RuntimeException("数据不存在，请刷新后重试！");
        }
        DetailedForecastEntity detailedForecastEntity = this.nebulaToolkitService.copyObjectByWhiteList(detailedForecastVo, DetailedForecastEntity.class, null, null);
        detailedForecastEntity.setEstimatedWriteOffAmount(detailedForecastDto.getEstimatedWriteOffAmount());
        detailedForecastEntity.setActualWriteOffAmount(detailedForecastDto.getActualWriteOffAmount());
        this.detailedForecastRepository.saveOrUpdate(detailedForecastEntity);
        // 日志新增
        DetailedForecastDto dto = this.nebulaToolkitService.copyObjectByWhiteList(detailedForecastVo, DetailedForecastDto.class, LinkedHashSet.class, ArrayList.class);
        DetailedForecastLogEventDto logEventDto = new DetailedForecastLogEventDto();
        logEventDto.setOriginal(dto);
        logEventDto.setNewest(detailedForecastDto);
        SerializableBiConsumer<DetailedForecastLogEventListener, DetailedForecastLogEventDto> onUpdate =
                DetailedForecastLogEventListener::onUpdate;
        this.nebulaNetEventClient.publish(logEventDto, DetailedForecastLogEventListener.class, onUpdate);
        return detailedForecastVo;
    }

    /**
     * 删除数据
     * @param idList 主键结合
     * @return 删除结果
     */
    @Transactional(rollbackFor = Exception.class)
    @Override
    public void delete(List<String> idList) {
        Validate.isTrue(!CollectionUtils.isEmpty(idList), "删除数据时，主键集合不能为空！");
        List<DetailedForecastEntity> list = this.detailedForecastRepository.findByIds(idList);
        List<String> businessCodeList = new ArrayList<>();
        list.forEach(v -> {
            Validate.isTrue(!StringUtils.equals(DetailedPredictionTypeEnum.CONFIRMED.getDictCode(), v.getDetailedPredictionType()),
                            "细案明细编码[%s]已确认！", v.getActivityDetailItemCode());
            v.setOnlyKey(this.activityDetailPlanPassDetailedForecastUtil.packageOnlyKey(v, DateUtil.getDate(DateUtil.DEFAULT_DATE_ALL_PATTERN)));
            if (StringUtils.equals(BusinessUnitEnum.VERTICAL.getCode(), v.getBusinessUnitCode())) {
                businessCodeList.add(v.getActivityDetailItemCode());
            }
        });
        activityDetailPlanPassDetailedForecastUtil.releaseVerticalBudget(businessCodeList);
        this.detailedForecastRepository.removeByIds(idList);
    }

    /**
     * 通过主键查询单条数据
     * @param id 主键
     * @return 单条数据
     */
    @Override
    public DetailedForecastVo findById(String id) {
        DetailedForecastEntity detailedForecastEntity = this.detailedForecastRepository.getById(id);
        if (detailedForecastEntity == null) {
            return null;
        }
        return nebulaToolkitService.copyObjectByWhiteList(detailedForecastEntity, DetailedForecastVo.class, null, null);
    }

    /**
     * 更新不覆盖数据
     * @param detailedForecast 实体对象
     * @return 更新数据
     */
    @Override
    public void updateDetailedForecast(DetailedForecastDto detailedForecast) {
        DetailedForecastEntity detailedForecastEntity = this.nebulaToolkitService.copyObjectByWhiteList(detailedForecast, DetailedForecastEntity.class, null, null);
        detailedForecastEntity.setTenantCode(TenantUtils.getTenantCode());
        this.detailedForecastRepository.save(detailedForecastEntity);
    }

    /**
     * 批量导入新增
     * @param importList
     * @return 批量导入新增
     */
    @Override
    public void importSave(List<DetailedForecastDto> importList) {
        if (CollectionUtils.isEmpty(importList)) {
            return;
        }
        importList.forEach(dto -> {
            dto.setTenantCode(TenantUtils.getTenantCode());
            dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            dto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            dto.setId(UUID.randomUUID().toString().replaceAll("-", ""));
        });
        // 保存细案预测
        Collection<DetailedForecastEntity> detailedForecastEntitys = this.nebulaToolkitService.copyCollectionByWhiteList(importList, DetailedForecastDto.class, DetailedForecastEntity.class, LinkedHashSet.class, ArrayList.class);
        this.detailedForecastRepository.saveBatch(new ArrayList<>(detailedForecastEntitys));
        // 业务日志创建
        importList.forEach(dto -> {
            DetailedForecastLogEventDto logEventDto = new DetailedForecastLogEventDto();
            logEventDto.setOriginal(null);
            logEventDto.setNewest(dto);
            SerializableBiConsumer<DetailedForecastLogEventListener, DetailedForecastLogEventDto> onCreate =
                    DetailedForecastLogEventListener::onCreate;
            this.nebulaNetEventClient.publish(logEventDto, DetailedForecastLogEventListener.class, onCreate);
        });
    }

//    @Autowired(required = false)
//    private ActivityDetailPlanPassDetailedForecastRefreshConsumer activityDetailPlanPassDetailedForecastRefreshConsumer;

    @Override
    public void updateAuditAmount(List<String> idList) {
        Validate.notEmpty(idList, "请求入参不能为空,请检查");
        List<DetailedForecastEntity> forecastEntities = this.detailedForecastRepository.findByIds(idList);
        Validate.notEmpty(forecastEntities, "不存在的实例,请检查数据是否存在");
        forecastEntities.forEach(forecastEntity -> {
            Validate.isTrue(!StringUtils.equals(DetailedPredictionTypeEnum.CONFIRMED.getDictCode(), forecastEntity.getDetailedPredictionType()),
                            "细案明细编码[%s]已确认！", forecastEntity.getActivityDetailItemCode());
        });
        MqMessageVo mqMessageVo = new MqMessageVo();
        String uuid = UUID.randomUUID().toString().replace("-", "");
        List<String> ids = forecastEntities.stream().map(DetailedForecastEntity::getId).distinct().collect(Collectors.toList());
        redisService.hSet(DeatailedForecastConstants.REFRESH_IDS_KEY, uuid, JSON.toJSONString(ids), 60 * 60 * 48);//定时任务每天跑，缓存2天够了
        mqMessageVo.setMsgBody(uuid);
        mqMessageVo.setTopic(ActivityDetailPlanConstant.TPM_ACTIVITY_DETAIL_PLAN_PROCESS_PASS_TOPIC + RocketMqUtil.mqEnvironment());
        mqMessageVo.setTag(ActivityDetailPlanPassMqTagConstant.DETAILED_FORECAST_REFRESH);
        rocketMqProducer.sendMqMsg(mqMessageVo);
//        activityDetailPlanPassDetailedForecastRefreshConsumer.handleMessageTest(mqMessageVo);
    }

    @Override
    public void confirm(List<String> idList) {
        Validate.notEmpty(idList, "请求入参不能为空,请检查");
        List<DetailedForecastEntity> forecastEntities = this.detailedForecastRepository.findByIds(idList);
        Validate.notEmpty(forecastEntities, "不存在的实例,请检查数据是否存在");

        forecastEntities.forEach(forecastEntity -> {
            Validate.isTrue(!StringUtils.equals(DetailedPredictionTypeEnum.CONFIRMED.getDictCode(), forecastEntity.getDetailedPredictionType()),
                            "细案明细编码[%s]已确认！", forecastEntity.getActivityDetailItemCode());
            forecastEntity.setDetailedPredictionType(DetailedPredictionTypeEnum.CONFIRMED.getDictCode());
        });
        this.detailedForecastRepository.updateBatchById(forecastEntities);
    }

    @Override
    public Page<DetailedForecastVo> findForAudit(Pageable pageable, DetailedForecastDto detailedForecast) {
        pageable = ObjectUtils.defaultIfNull(pageable, PageRequest.of(1, 50));
        if (Objects.isNull(detailedForecast)) {
            detailedForecast = new DetailedForecastDto();
        }
        return this.detailedForecastRepository.findForAudit(pageable, detailedForecast);
    }

    @Override
    public Map<String, BigDecimal> findPreAuditAmount(List<String> detailCodes) {
        if (CollectionUtils.isEmpty(detailCodes)) {
            return Maps.newHashMap();
        }
        List<DetailedForecastEntity> detailedForecastEntities = this.detailedForecastRepository.findByDetailCodes(detailCodes);
        if (CollectionUtils.isEmpty(detailedForecastEntities)) {
            return Maps.newHashMap();
        }
        return detailedForecastEntities.stream().collect(
                Collectors.toMap(DetailedForecastEntity::getDetailedCaseCode, DetailedForecastEntity::getEstimatedWriteOffAmount, (k1, k2) -> {
                    return k1;
                }));

    }

    /**
     * 查询未向E-CRM同步的数据
     * @return
     */
    @Override
    public List<DetailedForecastRequestVo> selectUnSynchronizedAll() {
        return detailedForecastRepository.selectUnSynchronizedAll();
    }

    /**
     * 更新同步数据
     * @param vos
     */
    @Override
    public void updateSynchronousRegime(List<DetailedForecastRequestVo> vos) {
        detailedForecastRepository.updateSynchronousRegime(vos);
    }

    /*
     * 临时推送按钮实现，过后看情况清除(开始)
     */

    @Autowired(required = false)
    private EcrmService ecrmService;

    @Autowired(required = false)
    private StringRedisTemplate stringRedisTemplate;

    @Autowired(required = false)
    private ActivityDetailPlanSdkService activityDetailPlanSdkService;

    @Autowired(required = false)
    private ActivityDetailPlanItemSdkService activityDetailPlanItemSdkService;

    @Autowired(required = false)
    private CustomerVoService customerVoService;

    @Autowired(required = false)
    private SalesOrgVoService salesOrgVoService;

    @Autowired(required = false)
    private TpmWarningMonitoringSdkService tpmWarningMonitoringSdkService;

    @Override
    public void pushEcrm(List<String> idList) {

        Assert.notEmpty(idList, "请选择数据!");
        List<DetailedForecastEntity> entityList = detailedForecastRepository.findByIds(idList);
        Assert.notEmpty(entityList, "选择的数据不存在或已推送,请刷新后重试!");

        List<DetailedForecastEntity> unSupportEntity = entityList.stream().filter(o -> !BusinessUnitEnum.isDefaultBusinessUnit(o.getBusinessUnitCode())).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(unSupportEntity)) {
            throw new UnsupportedOperationException("存在非主体细案预测数据，推送中止");
        }

        //根据业务单元判断数据是从哪个业务模块过来的
        Map<String, DetailedForecastEntity> requestEntityMap = entityList.stream().collect(Collectors.toMap(DetailedForecastEntity::getActivityDetailItemCode, Function.identity()));
        Map<String, Set<String>> businessUnitCodeActivityDetailPlanItemCodeMap = entityList.stream().collect(Collectors.groupingBy(DetailedForecastEntity::getBusinessUnitCode, Collectors.mapping(DetailedForecastEntity::getActivityDetailItemCode, Collectors.toSet())));
        List<DetailedForecastRequestVo> result = new ArrayList<>();

        BeanUtilsBean beanUtilsBean = BeanUtilsBean.getInstance();
        beanUtilsBean.getConvertUtils().register(false, true, 0);

        //先把明细的数据复制过去
        try {
            //只有主体需要推ECRM
            for (String key : businessUnitCodeActivityDetailPlanItemCodeMap.keySet()) {
                if (BusinessUnitEnum.isDefaultBusinessUnit(key)) {
                    List<ActivityDetailPlanItemVo> activityDetailPlanItemVoList = activityDetailPlanItemSdkService.listByItemCodeList(new ArrayList<>(businessUnitCodeActivityDetailPlanItemCodeMap.get(key)));
                    List<ActivityDetailPlanVo> activityDetailPlanVoList = activityDetailPlanSdkService.findByCodes(new ArrayList<>(activityDetailPlanItemVoList.stream().map(ActivityDetailPlanItemVo::getDetailPlanCode).collect(Collectors.toSet())));
                    Map<String, ActivityDetailPlanVo> detailPlanMap = activityDetailPlanVoList.stream().collect(Collectors.toMap(ActivityDetailPlanVo::getDetailPlanCode, Function.identity()));

                    //客户编码，销售组织编码转换
                    List<String> customerCodeList = activityDetailPlanItemVoList.stream().map(ActivityDetailPlanItemVo::getCustomerCode).distinct().filter(Objects::nonNull).collect(Collectors.toList());
                    List<CustomerVo> customerVoList = customerVoService.findCustomerAndContactByCustomerCodes(customerCodeList);
                    Map<String, CustomerVo> customerMap = customerVoList.stream().collect(Collectors.toMap(CustomerVo::getCustomerCode, Function.identity()));

                    List<String> salesOrgCodeList = new ArrayList<>();
                    salesOrgCodeList.addAll(customerVoList.stream().map(CustomerVo::getSalesInstitutionCode).distinct().filter(Objects::nonNull).collect(Collectors.toList()));
                    salesOrgCodeList.addAll(customerVoList.stream().map(CustomerVo::getSalesRegionCode).distinct().filter(Objects::nonNull).collect(Collectors.toList()));
                    salesOrgCodeList.addAll(customerVoList.stream().map(CustomerVo::getSalesOrgCode).distinct().filter(Objects::nonNull).collect(Collectors.toList()));

                    List<SalesOrgVo> salesOrgVoList = salesOrgVoService.findBySalesOrgCodes(salesOrgCodeList);
                    Map<String, SalesOrgVo> salesOrgMap = salesOrgVoList.stream().collect(Collectors.toMap(SalesOrgVo::getSalesOrgCode, Function.identity()));

                    for (ActivityDetailPlanItemVo itemVo : activityDetailPlanItemVoList) {
                        ActivityDetailPlanVo detailPlanVo = detailPlanMap.get(itemVo.getDetailPlanCode());
                        DetailedForecastRequestVo requestVo = nebulaToolkitService.copyObjectByWhiteList(itemVo, DetailedForecastRequestVo.class, LinkedHashSet.class, ArrayList.class);
                        DetailedForecastEntity entity = requestEntityMap.get(requestVo.getDetailPlanItemCode());
                        beanUtilsBean.copyProperties(requestVo, entity);
                        requestVo.setIntegrationId(entity.getId());
                        requestVo.setDetailPlanItemCode(entity.getActivityDetailItemCode());
                        requestVo.setDetailPlanCode(detailPlanVo.getDetailPlanCode());
                        requestVo.setDetailPlanName(detailPlanVo.getDetailPlanName());
                        if (StringUtils.isEmpty(entity.getPushEcrmStatus())) {
                            requestVo.setProcessStatus(PushECRMStatusEnum.ADD.getCode());
                        } else {
                            requestVo.setProcessStatus(PushECRMStatusEnum.UPDATE.getCode());
                        }
                        requestVo.setActivityTypeCode(itemVo.getActivityTypeCode());
                        requestVo.setActivityTypeName(itemVo.getActivityTypeName());
                        requestVo.setActivityFormCode(itemVo.getActivityFormCode());
                        requestVo.setActivityFormName(itemVo.getActivityFormName());
                        requestVo.setAuditConditionValue(entity.getWriteOffConditionValue());
                        requestVo.setAuditCondition(entity.getWriteOffConditions());
                        requestVo.setAuditFormula(entity.getWriteOffFormula());
                        requestVo.setAuditFormulaValue(entity.getWriteOffFormulaValue());
                        requestVo.setSaleGap(Objects.nonNull(entity.getTaskVolumeGap())
                                                     ? entity.getTaskVolumeGap().toString() : null);

                        requestVo.setMonthSaleTask(itemVo.getMonthSalesTarget());
                        requestVo.setNowSpreadMarketRatio(Objects.nonNull(itemVo.getCurrentMarketRate())
                                                                  ? itemVo.getCurrentMarketRate().toString() : null);
                        requestVo.setMonthSpreadMarketRatio(Objects.nonNull(itemVo.getMonthTargetMarketRate())
                                                                    ? itemVo.getMonthTargetMarketRate().toString() : null);
                        requestVo.setIsLaunchPatrolDemand(itemVo.getIsStartPatrol());
                        requestVo.setPromoteSales(itemVo.getPeriodPromoteQuantity());
                        requestVo.setPromotionAmount(itemVo.getPeriodPromoteAmount());
                        requestVo.setPromoteChannelSales(itemVo.getPeriodChPromoteQuantity());
                        requestVo.setPromotionChannelAmount(itemVo.getPeriodChPromoteAmount());
                        requestVo.setMonthReplyQuantity(itemVo.getMonthReturnQuantity());
                        requestVo.setMonthReplyAmount(itemVo.getMonthReturnAmount());
                        requestVo.setStoreType(itemVo.getTerminalType());
                        requestVo.setTerminalPredictMonthSaleAmount(itemVo.getTerminalMonthSalesAmount());
                        requestVo.setUserName(itemVo.getPersonName());
                        requestVo.setPersonnelType(itemVo.getPersonType());
                        requestVo.setIdCard(itemVo.getPersonIdCard());
                        requestVo.setPrice(itemVo.getMaterialPrice());

                        requestVo.setStandeesDisplayQuantity(Objects.nonNull(itemVo.getQuantity()) ?
                                                                     new BigDecimal(itemVo.getQuantity()) : null);
                        requestVo.setStandeesDisplayPrice(itemVo.getPrice());

                        requestVo.setPurchaseType(itemVo.getProcurementType());
                        requestVo.setDescription(itemVo.getFormDescription());
                        requestVo.setTotalCost(itemVo.getTotalFeeAmount());
                        requestVo.setDealerBearFee(itemVo.getCustomerFeeAmount());
                        requestVo.setApplyFee(itemVo.getHeadFeeAmount());
                        requestVo.setProductName(itemVo.getProductName());
                        if (Objects.nonNull(itemVo.getDepartmentFeeAmount())) {
                            if (Objects.isNull(requestVo.getApplyFee())) {
                                requestVo.setApplyFee(itemVo.getDepartmentFeeAmount());
                            } else {
                                requestVo.setApplyFee(requestVo.getApplyFee().add(itemVo.getDepartmentFeeAmount()));
                            }
                        }

                        requestVo.setEstimateAuditAmount(entity.getEstimatedWriteOffAmount());
                        if (StringUtils.isNotEmpty(itemVo.getCustomerCode())) {
                            CustomerVo customerVo = customerMap.get(itemVo.getCustomerCode());
                            if (customerVo != null) {
                                requestVo.setCustomerCode(customerVo.getErpCode());
                                requestVo.setCustomerName(customerVo.getCustomerName());
                                if (StringUtils.isNotEmpty(customerVo.getSalesInstitutionCode())) {
                                    SalesOrgVo area = salesOrgMap.get(customerVo.getSalesInstitutionCode());
                                    if (area != null) {
                                        requestVo.setSalesInstitutionCode(area.getErpCode());
                                        requestVo.setSalesInstitutionName(area.getSalesOrgName());
                                    }
                                }
                                if (StringUtils.isNotEmpty(customerVo.getSalesRegionCode())) {
                                    SalesOrgVo region = salesOrgMap.get(customerVo.getSalesRegionCode());
                                    if (region != null) {
                                        requestVo.setSalesOrgRegionCode(region.getErpCode());
                                        requestVo.setSalesOrgRegionName(region.getSalesOrgName());

                                    }
                                }
                                if (StringUtils.isNotEmpty(customerVo.getSalesRegionCode())) {
                                    SalesOrgVo salesOrg = salesOrgMap.get(customerVo.getSalesOrgCode());
                                    if (salesOrg != null) {
                                        requestVo.setSalesOrgProvinceCode(salesOrg.getErpCode());
                                        requestVo.setSalesOrgProvinceName(salesOrg.getSalesOrgName());
                                    }
                                }
                            }
                        }
                        requestVo.setActivityBeginTime(DateUtil.format(itemVo.getActivityBeginDate(), DateUtil.DEFAULT_YEAR_MONTH_DAY));
                        requestVo.setActivityEndTime(DateUtil.format(itemVo.getActivityEndDate(), DateUtil.DEFAULT_YEAR_MONTH_DAY));
                        result.add(requestVo);
                    }
                }
            }
        } catch (Exception e) {
            log.error(e.getMessage());
            throw new UnsupportedOperationException(e.getMessage());
        }
        //推送数据并根据推送结果更改状态
        boolean pushResult = ecrmService.initiateSynchronization(result);
        if (pushResult) {
            Set<String> activityDetailPlanItemCodeSet = businessUnitCodeActivityDetailPlanItemCodeMap.get(BusinessUnitEnum.HEADQUARTERS.getCode());
            detailedForecastRepository.updatePushECRMStatusByCodeSet(activityDetailPlanItemCodeSet);
        }
    }

    /*
     * 临时推送按钮实现，过后看情况清除(结束)
     */

    @Override
    public DetailedForecastVo getDetailedForecastByParams(DetailedForecastDto detailedForecast) {
        List<DetailedForecastEntity> list = detailedForecastRepository.getDetailedForecastByParams(detailedForecast);
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        List<DetailedForecastVo> detailedForecastVos = (List<DetailedForecastVo>) this.nebulaToolkitService.copyCollectionByWhiteList(list
                , DetailedForecastEntity.class
                , DetailedForecastVo.class
                , HashSet.class
                , ArrayList.class);
        return detailedForecastVos.get(0);
    }

    /**
     * 通过id批量查询
     * @param idList
     * @return
     */
    @Override
    public List<DetailedForecastVo> findByIds(List<String> idList) {
        if (CollectionUtils.isEmpty(idList)) {
            return Lists.newArrayList();
        }
        List<DetailedForecastEntity> entityList = this.detailedForecastRepository.findByIds(idList);
        return (List<DetailedForecastVo>) nebulaToolkitService.copyCollectionByWhiteList(entityList, DetailedForecastEntity.class, DetailedForecastVo.class, HashSet.class, ArrayList.class);
    }

    @Override
    public Page<DetailedForecastRequestVo> selectUnSynchronizedPage(Pageable pageable) {
        return detailedForecastRepository.selectUnSynchronizedPage(pageable);
    }

    @Override
    public Long findAutoRefreshCount(DetailedForecastAutoRefreshDto dto) {
        dto.setTenantCode(TenantUtils.getTenantCode());
        Validate.notBlank(dto.getTenantCode(), "未获取到租户号！");
        return detailedForecastRepository.findAutoRefreshDataCount(dto);
    }

    /**
     * 定时任务更新查询待更新数据id
     * @param pageable
     * @param dto
     * @return
     */
    @Override
    public List<String> findAutoRefreshDataList(Pageable pageable, DetailedForecastAutoRefreshDto dto) {
        pageable = ObjectUtils.defaultIfNull(pageable, PageRequest.of(1, 2000));
        dto.setTenantCode(TenantUtils.getTenantCode());
        Validate.notBlank(dto.getTenantCode(), "未获取到租户号！");
        return detailedForecastRepository.findAutoRefreshDataList(pageable, dto);
    }

    @Override
    public List<String> findAutoCreateDataList(DetailedForecastAutoCreateDto dto) {
        dto.setTenantCode(TenantUtils.getTenantCode());
        Validate.notBlank(dto.getTenantCode(), "未获取到租户号！");
        return detailedForecastRepository.findAutoCreateDataList(dto);
    }

    @Transactional
    @Override
    public Long autoUpdateShowFLag(DetailedForecastAutoCreateDto dto) {
        dto.setTenantCode(TenantUtils.getTenantCode());
        Validate.notBlank(dto.getTenantCode(), "未获取到租户号！");
        List<String> activityDetailItemCodes = detailedForecastRepository.findAutoUpdateShowFlagDataList(dto);
        if (CollectionUtils.isEmpty(activityDetailItemCodes)) {
            return 0L;
        }
        return detailedForecastRepository.autoUpdateShowFLag(activityDetailItemCodes);
    }

    /**
     * 根据方案明细编码查细案预测
     * @param codeSet
     * @return
     */
    @Override
    public List<DetailedForecastVo> findByPlanItemCode(Set<String> codeSet) {
        if (CollectionUtils.isEmpty(codeSet)) {
            return null;
        }
        return detailedForecastRepository.findByPlanItemCode(codeSet);
    }

    @Transactional
    @Override
    public void updateWriteOffAmount(List<String> codes) {
        if (CollectionUtils.isEmpty(codes)) {
            return;
        }
        List<DetailedForecastVo> auditAmountList = this.detailedForecastRepository.findAuditAmount(codes);
        if (CollectionUtils.isEmpty(auditAmountList)) {
            return;
        }
        Map<String, BigDecimal> map = auditAmountList.stream().collect(Collectors.toMap(DetailedForecastVo::getActivityDetailItemCode, DetailedForecastVo::getWriteOffAmount));
        List<DetailedForecastEntity> entityList = this.detailedForecastRepository.findByActivityDetailItemCodes(map.keySet());
        for (DetailedForecastEntity entity : entityList) {
            if (map.containsKey(entity.getActivityDetailItemCode())) {
                entity.setWriteOffAmount(map.get(entity.getActivityDetailItemCode()));
            }
        }
        this.detailedForecastRepository.updateBatchById(entityList);
    }

    /**
     * 向上预计可核销金额监控表 （只取常温、主体数据）
     * 数据视图编码（tpm_up_expect_audit_amount_monitor_data_view）
     * @param pageable 分页对象
     * @param dto      查询实体
     * @return 所有数据
     */
    @Override
    public Page<UpExpectAuditAmountMonitorVo> pageUpExpectAuditAmountMonitor(Pageable pageable, UpExpectAuditAmountMonitorDto dto) {
        //1.获取主表信息
        pageable = ObjectUtils.defaultIfNull(pageable, PageRequest.of(1, 50));
        if (Objects.isNull(dto)) {
            dto = new UpExpectAuditAmountMonitorDto();
        }
        dto.setBusinessFormatCode(BusinessFormatEnum.NORMAL.getCode());
        dto.setBusinessUnitCode(BusinessUnitEnum.HEADQUARTERS.getCode());
        dto.setTenantCode(TenantUtils.getTenantCode());
        dto.setShowFlag(BooleanEnum.TRUE.getCapital());
        Page<UpExpectAuditAmountMonitorVo> monitorPage = this.detailedForecastRepository.pageUpExpectAuditAmountMonitor(pageable, dto);

        //2.填充明细字段、统计字段
        if (CollectionUtils.isEmpty(monitorPage.getRecords())) {
            return monitorPage;
        }
        //2.1公式扩展表map
        Map<String, DetailedForecastFormulaEntity> formulaMap = new HashMap<>();
        Map<String, List<DetailedForecastProductEntity>> productMap = new HashMap<>();
        //分子公司与销售机构关系map
        Map<String, SalesOrgSubComOrgVo> subComOrgVoMap = new HashMap<>();
        //组织map
        Map<String, OrgVo> orgVoMap = new HashMap<>();
        List<UpExpectAuditAmountMonitorVo> monitorVoList = monitorPage.getRecords();
        List<String> ids = monitorVoList.stream().map(UpExpectAuditAmountMonitorVo::getId).distinct().collect(Collectors.toList());
        List<DetailedForecastFormulaEntity> formulaList = detailedForecastFormulaRepository.listByIds(ids);
        if (!CollectionUtils.isEmpty(formulaList)) {
            formulaMap = formulaList.stream().collect(Collectors.toMap(DetailedForecastFormulaEntity::getId, Function.identity()));
        }
        //产品扩展
        List<DetailedForecastProductEntity> productList = detailedForecastProductRepository.findByForecastIds(ids);
        if (!CollectionUtils.isEmpty(formulaList)) {
            productMap = productList.stream().collect(Collectors.groupingBy(DetailedForecastProductEntity::getDetailedForecastId));
        }
        List<String> customerErpCodes = monitorVoList.stream().map(UpExpectAuditAmountMonitorVo::getCustomerErpCode).distinct().collect(Collectors.toList());
        List<SalesOrgSubComOrgVo> subComOrgVos = salesOrgSubComOrgService.listBySubComOrgCodeList(customerErpCodes);
        if (!CollectionUtils.isEmpty(subComOrgVos)) {
            subComOrgVoMap = subComOrgVos.stream().collect(Collectors.toMap(SalesOrgSubComOrgVo::getSubComOrgCode, Function.identity()));
            List<String> orgCodes = subComOrgVos.stream().map(SalesOrgSubComOrgVo::getOrgCode).distinct().collect(Collectors.toList());
            List<OrgVo> orgVoList = orgVoService.findByOrgCodes(orgCodes);
            if (!CollectionUtils.isEmpty(orgVoList)) {
                orgVoMap = orgVoList.stream().collect(Collectors.toMap(OrgVo::getOrgCode, Function.identity()));
            }
        }

        //2.2填充数据
        for (UpExpectAuditAmountMonitorVo monitor : monitorVoList) {
            DetailedForecastFormulaEntity formula = formulaMap.get(monitor.getId());
            if (!Objects.isNull(formula)) {
                monitor.setWriteOffConditions(formula.getWriteOffConditions());
                monitor.setWriteOffFormula(formula.getWriteOffFormula());
                monitor.setWriteOffConditionValue(formula.getWriteOffConditionValue());
                monitor.setWriteOffFormulaValue(formula.getWriteOffFormulaValue());
                monitor.setAuditPrecondition(formula.getWriteOffConditions());
            }

            List<DetailedForecastProductEntity> productEntityList = productMap.get(monitor.getId());
            if (!CollectionUtils.isEmpty(productEntityList)) {
                productEntityList.sort(Comparator.comparing(DetailedForecastProductEntity::getProductCode));
                List<String> productCodeList = productEntityList.stream().map(DetailedForecastProductEntity::getProductCode).collect(Collectors.toList());
                List<String> productNameList = productEntityList.stream().map(DetailedForecastProductEntity::getProductName).collect(Collectors.toList());
                monitor.setProductCode(String.join(",", productCodeList));
                monitor.setProductName(String.join(",", productNameList));
            }

            SalesOrgSubComOrgVo subComOrgVo = subComOrgVoMap.get(monitor.getCustomerErpCode());
            if (!Objects.isNull(subComOrgVo)) {
                monitor.setOrgCode(subComOrgVo.getOrgCode());
                OrgVo orgVo = orgVoMap.get(subComOrgVo.getOrgCode());
                if (!Objects.isNull(orgVo)) {
                    monitor.setOrgName(orgVo.getOrgName());
                }

            }

        }

        warning:
        if (!CollectionUtils.isEmpty(monitorVoList)) {
            //填充预警字段
            List<String> idList = monitorVoList.stream().map(UpExpectAuditAmountMonitorVo::getId).collect(Collectors.toList());
            List<TpmWarningMonitoringVo> tpmWarningMonitoringList = tpmWarningMonitoringSdkService.findTpmWarningMonitoringList(AbstractTpmWarningUpExpectAuditAmountMonitorVariableRegister.monitoringTable, idList);
            if (CollectionUtils.isEmpty(tpmWarningMonitoringList)) {
                break warning;
            }
            Map<String, TpmWarningMonitoringVo> warningMonitoringVoMap = tpmWarningMonitoringList.stream().collect(Collectors.toMap(TpmWarningMonitoringVo::getBusinessCode, Function.identity()));
            for (UpExpectAuditAmountMonitorVo upExpectAuditAmountMonitorVo : monitorVoList) {
                if (!warningMonitoringVoMap.containsKey(upExpectAuditAmountMonitorVo.getId())) {
                    continue;
                }
                TpmWarningMonitoringVo tpmWarningMonitoringVo = warningMonitoringVoMap.get(upExpectAuditAmountMonitorVo.getId());
                upExpectAuditAmountMonitorVo.setWarningCount(tpmWarningMonitoringVo.getWarningCount());
                upExpectAuditAmountMonitorVo.setWarningStatus(tpmWarningMonitoringVo.getWarningStatus());
                upExpectAuditAmountMonitorVo.setWarningVariableCount(tpmWarningMonitoringVo.getWarningVariableCount());
                upExpectAuditAmountMonitorVo.setRecoverWarningCount(tpmWarningMonitoringVo.getRecoverWarningCount());
            }
        }

        return monitorPage;
    }

    @Override
    public Page<DetailedForecastSummaryVo> summaryPage(Pageable pageable, DetailedForecastSummaryDto dto) {
        pageable = ObjectUtils.defaultIfNull(pageable, PageRequest.of(1, 50));
        dto.setBusinessUnitCode(BusinessUnitEnum.VERTICAL.getCode());
        //Page<DetailedForecastSummaryVo> page = this.detailedForecastRepository.summaryPage(pageable, dto);
        Page<DetailedForecastSummaryVo> page = this.detailedForecastRepository.summaryPageNew(pageable, dto);
        if (CollectionUtils.isEmpty(page.getRecords())) {
            return page;
        }

        //构建查寻垂直销售业绩的参数：区域名称+零售商名称+品牌编码+年月，用md5转一下进行批量查询
        /*Set<String> keySet = new HashSet<>();
        Set<String> keyBrandSet = new HashSet<>();
        for (DetailedForecastSummaryVo record : page.getRecords()) {
            List<String> yearMonthList = DateUtil.getBetweenYearMonths(record.getActivityStartTime(), record.getActivityEndTime(), DateUtil.DEFAULT_YEAR_MONTH_NO_CH);
            String keyPrefix = record.getRegionName() + record.getSystemName() + this.nullToEmptyString(record.getProductBrandCode());
            String id = keyPrefix + DateUtil.getDateStrByFormat(record.getActivityStartTime(), DateUtil.DEFAULT_DATE_ALL_PATTERN) + DateUtil.getDateStrByFormat(record.getActivityEndTime(), DateUtil.DEFAULT_DATE_ALL_PATTERN);
            record.setId(DigestUtils.md5Hex(id));
            for (String yearMonth : yearMonthList) {
                String key = keyPrefix + yearMonth;
                if (StringUtils.isEmpty(record.getProductBrandCode())) {
                    keyBrandSet.add(key);
                    continue;
                }
                keySet.add(key);
            }
        }

        //查询垂直销售业绩
        List<DetailedForecastSummaryVo> salesPerformanceList = Lists.newArrayList();
        if (!CollectionUtils.isEmpty(keySet)) {
            List<DetailedForecastSummaryVo> list = this.detailedForecastRepository.summarySalesPerformanceList(Lists.newArrayList(keySet), null);
            salesPerformanceList.addAll(list);
        }
        if (!CollectionUtils.isEmpty(keyBrandSet)) {
            List<DetailedForecastSummaryVo> list = this.detailedForecastRepository.summarySalesPerformanceList(null, Lists.newArrayList(keyBrandSet));
            salesPerformanceList.addAll(list);
        }
        log.info("细案预测汇总：垂直销售业绩：{}", salesPerformanceList.size());
        Map<String, BigDecimal> actualSalesMap = salesPerformanceList.stream().collect(Collectors.toMap(DetailedForecastSummaryVo::getId, DetailedForecastSummaryVo::getActualSalesAmount));

        //实际销售额：汇总垂直销售业绩的“实际折后出库额”字段
        for (DetailedForecastSummaryVo record : page.getRecords()) {
            List<String> yearMonthList = DateUtil.getBetweenYearMonths(record.getActivityStartTime(), record.getActivityEndTime(), DateUtil.DEFAULT_YEAR_MONTH_NO_CH);
            String keyPrefix = record.getRegionName() + record.getSystemName() + this.nullToEmptyString(record.getProductBrandCode());
            BigDecimal actualSalesAmount = BigDecimal.ZERO;
            for (String yearMonth : yearMonthList) {
                String key = keyPrefix + yearMonth;
                actualSalesAmount = actualSalesAmount.add(actualSalesMap.getOrDefault(key, BigDecimal.ZERO));
            }
            record.setActualSalesAmount(actualSalesAmount);
        }

        //剩余可核销金额:预核销金额-实际销售额
        for (DetailedForecastSummaryVo record : page.getRecords()) {
            BigDecimal estimatedWriteOffAmount = Optional.ofNullable(record.getEstimatedWriteOffAmount()).orElse(BigDecimal.ZERO);
            BigDecimal alreadyAuditAmount = Optional.ofNullable(record.getAlreadyAuditAmount()).orElse(BigDecimal.ZERO);
            BigDecimal remnantAuditAmount = estimatedWriteOffAmount.subtract(alreadyAuditAmount);
            record.setRemnantAuditAmount(remnantAuditAmount);
        }*/

        //计算比例
        for (DetailedForecastSummaryVo record : page.getRecords()) {
            if (Objects.nonNull(record.getActualSalesAmount()) && BigDecimal.ZERO.compareTo(record.getActualSalesAmount()) != 0) {
                //预核销投产比
                record.setPreAuditProductionRatio((Objects.isNull(record.getEstimatedWriteOffAmount()) ? BigDecimal.ZERO : record.getEstimatedWriteOffAmount()).multiply(new BigDecimal(100)).divide(record.getActualSalesAmount(), 2, RoundingMode.HALF_UP));
                //实际投产比
                record.setActualProductionRatio(record.getAlreadyAuditAmount().multiply(new BigDecimal(100)).divide(record.getActualSalesAmount(), 2, RoundingMode.HALF_UP));
            }
            if (Objects.nonNull(record.getApplyAmount()) && BigDecimal.ZERO.compareTo(record.getApplyAmount()) != 0) {
                //预结案率
                record.setPreAuditRatio((Objects.isNull(record.getEstimatedWriteOffAmount()) ? BigDecimal.ZERO : record.getEstimatedWriteOffAmount()).multiply(new BigDecimal(100)).divide(record.getApplyAmount(), 2, RoundingMode.HALF_UP));
                //实际结案率
                record.setActualAuditRatio(record.getAlreadyAuditAmount().multiply(new BigDecimal(100)).divide(record.getApplyAmount(), 2, RoundingMode.HALF_UP));
            }
        }
        return page;
    }

    @Override
    public List<DetailedForecastVo> findEstimatedWriteOffAmount(DetailedForecastDto detailedForecastDto) {
        if (Objects.isNull(detailedForecastDto)) {
            return Lists.newArrayList();
        }
        List<DetailedForecastEntity> detailedForecastEntities = this.detailedForecastRepository.findEstimatedWriteOffAmount(detailedForecastDto);
        if (CollectionUtils.isEmpty(detailedForecastEntities)) {
            return Lists.newArrayList();
        }
        Collection<DetailedForecastVo> detailedForecastVos = this.nebulaToolkitService.copyCollectionByWhiteList(detailedForecastEntities, DetailedForecastEntity.class, DetailedForecastVo.class, LinkedHashSet.class, ArrayList.class);
        return (List<DetailedForecastVo>) detailedForecastVos;
    }

    @Override
    public List<DetailedForecastVo> findListForSaleAndFeeMonitoring(List<DetailedForecastDto> detailedForecastDtos) {
        if (CollectionUtils.isEmpty(detailedForecastDtos)) {
            return Lists.newArrayList();
        }
        return this.detailedForecastRepository.findListForSaleAndFeeMonitoring(detailedForecastDtos);
    }

    @Override
    public List<DetailedForecastVo> findByPlanItemCodes(Set<String> constituentDetailPlanItemCodes) {
        if (CollectionUtils.isEmpty(constituentDetailPlanItemCodes)) {
            return Lists.newArrayList();
        }
        List<DetailedForecastEntity> detailedForecastEntities = this.detailedForecastRepository.findByPlanItemCodes(constituentDetailPlanItemCodes);
        if (CollectionUtils.isEmpty(detailedForecastEntities)) {
            return Lists.newArrayList();
        }
        Collection<DetailedForecastVo> detailedForecastVos = this.nebulaToolkitService.copyCollectionByWhiteList(detailedForecastEntities, DetailedForecastEntity.class, DetailedForecastVo.class, LinkedHashSet.class, ArrayList.class);
        return (List<DetailedForecastVo>) detailedForecastVos;
    }

    private Object nullToEmptyString(Object o) {
        if (Objects.isNull(o)) {
            return "";
        }
        return o;
    }

    /**
     * 细案预测汇总表 定时任务增量更新
     * @param dto
     */
    @Override
    public void detailedForecastSummaryUpdateQuery(DetailedForecastSummaryDto dto) {
        if (StringUtils.isBlank(dto.getUpdateQueryBegin()) || StringUtils.isBlank(dto.getUpdateQueryEnd())) return;
        log.info("进入细案预测汇总表定时任务增量更新");
        try {
            dto.setTenantCode(TenantUtils.getTenantCode());
            //查询增量的数据 -- planCode
            List<ActivityDetailPlanItemVo> activityDetailPlanItemVos = this.detailedForecastRepository.findDetailedForecastSummaryUpdate(dto);
            if (CollectionUtils.isEmpty(activityDetailPlanItemVos)) return;
            //根据planCode 删除细案汇总信息
            this.detailedForecastSummaryRepository.deleteSummaryByPlanCode(activityDetailPlanItemVos.stream().map(ActivityDetailPlanItemVo::getRelatePlanCode).collect(Collectors.toList()));
            //分页:根据planCode 得到增量的细案明细编码 然后查询细案预测数据
            dto.setPlanCodes(activityDetailPlanItemVos.stream().map(ActivityDetailPlanItemVo::getRelatePlanCode).collect(Collectors.toList()));
            //dto.setPlanCodes(Lists.newArrayList("AP20231009000056"));
            int current = 1;
            int pageSize = 200;
            int count = 1;
            Page<ActivityDetailPlanItemVo> pageResult;
            SimpleDateFormat dateFormat = new SimpleDateFormat(DateUtil.DEFAULT_DATE_ALL_PATTERN);
            Set<String> mb = Sets.newHashSet("HDMBPZ3913","HDMBPZ3922");
            do {
                Page<ActivityDetailPlanItemVo> page = new Page<>(current, pageSize);
                pageResult = this.detailedForecastRepository.findActivityDetailPlanItemList(page, dto);
                if (Objects.isNull(pageResult) || CollectionUtils.isEmpty(pageResult.getRecords())) break;
                current++;

                //查询细案预测
                List<DetailedForecastVo> result = this.detailedForecastRepository.findDetailedForecastSummaryUpdateList(pageResult.getRecords().stream().map(ActivityDetailPlanItemVo::getDetailPlanItemCode).collect(Collectors.toList()));
                if (CollectionUtils.isEmpty(result)) continue;
                log.info("查询细案预测返回,{}", JSON.toJSONString(result));
                Map<String, ActivityDetailPlanItemVo> activityDetailPlanItemVoMap = pageResult.getRecords().stream().collect(Collectors.toMap(ActivityDetailPlanItemVo::getDetailPlanItemCode, Function.identity(), (v1, v2) -> v1));

                //开始转换并汇总
                Map<String, DetailedForecastSummaryEntity> data = Maps.newHashMap();
                result.forEach(record -> {
                    ActivityDetailPlanItemVo itemVo = activityDetailPlanItemVoMap.get(record.getActivityDetailItemCode());
                    log.info("细案预测汇总-细案明细,{}", (itemVo == null ? "null" : JSON.toJSONString(itemVo)));
                    String planCode = itemVo == null ? "" : itemVo.getPlanCode();
                    String planName = itemVo == null ? "" : itemVo.getPlanName();
                    String templateConfigCode = itemVo == null ? "" : itemVo.getTemplateConfigCode();
                    BigDecimal periodPromotionQuantity = itemVo == null ? BigDecimal.ZERO : (itemVo.getPeriodPromotionalNumber() == null ? BigDecimal.ZERO : new BigDecimal(itemVo.getPeriodPromotionalNumber()));
                    BigDecimal applyAmount = itemVo == null ? BigDecimal.ZERO : (itemVo.getFeeAmount() == null ? BigDecimal.ZERO : itemVo.getFeeAmount());
                    BigDecimal alreadyAuditAmount = itemVo == null ? BigDecimal.ZERO : (itemVo.getAlreadyAuditAmount() == null ? BigDecimal.ZERO : itemVo.getAlreadyAuditAmount());
                    String key = StringUtils.join(record.getBusinessUnitCode(),
                                                  record.getBusinessFormatCode(),
                                                  planCode, planName,
                                                  record.getSystemCode(),
                                                  record.getSystemName(),
                                                  record.getRegionName(),
                                                  record.getRegion(),
                                                  record.getActivityTypeCode(),
                                                  record.getActivityTypeName(),
                                                  record.getActivityFormCode(),
                                                  record.getActivityFormName(),
                                                  record.getProductBrandCode(),
                                                  record.getProductBrandName(),
                                                  dateFormat.format(record.getActivityStartTime()),
                                                  dateFormat.format(record.getActivityEndTime()));
                    log.info("细案预测汇总-去重key,{}", key);
                    String id = DigestUtils.md5Hex(key.getBytes(StandardCharsets.UTF_8));
                    log.info("细案预测汇总-模板编码,{},细案编码,{}",key,itemVo.getDetailPlanCode());
                    DetailedForecastSummaryEntity entity;
                    if (data.containsKey(id)) {
                        entity = data.get(id);
                        //本次内存内需要累计
                        if (mb.contains(templateConfigCode)) {
                            log.info("细案预测汇总-细案编码,{},期间促销量,{}",itemVo.getDetailPlanCode(),periodPromotionQuantity);
                            entity.setPeriodPromotionQuantity(entity.getPeriodPromotionQuantity().add(periodPromotionQuantity));
                        }
                        entity.setApplyAmount(entity.getApplyAmount().add(applyAmount));
                        entity.setAlreadyAuditAmount(entity.getAlreadyAuditAmount().add(alreadyAuditAmount));
                        entity.setEstimatedWriteOffAmount((Objects.isNull(entity.getEstimatedWriteOffAmount()) ? BigDecimal.ZERO : entity.getEstimatedWriteOffAmount())
                                                                  .add(Objects.isNull(record.getEstimatedWriteOffAmount()) ? BigDecimal.ZERO : record.getEstimatedWriteOffAmount()));
                        data.put(id, entity);
                    } else {
                        entity = new DetailedForecastSummaryEntity();
                        BeanUtils.copyProperties(record, entity);
                        entity.setSchemeCode(planCode);
                        entity.setSchemeName(planName);
                        entity.setPeriodPromotionQuantity(BigDecimal.ZERO);
                        if (mb.contains(templateConfigCode)) {
                            log.info("细案预测汇总-细案编码,{},期间促销量,{}",itemVo.getDetailPlanCode(),periodPromotionQuantity);
                            entity.setPeriodPromotionQuantity(periodPromotionQuantity);
                        }
                        entity.setApplyAmount(applyAmount);
                        entity.setAlreadyAuditAmount(alreadyAuditAmount);
                        entity.setId(id);
                        data.put(id, entity);
                    }
                });

                //构建查寻垂直销售业绩的参数：区域名称+零售商名称+品牌编码+年月，用md5转一下进行批量查询
                Set<String> keySet = new HashSet<>();
                Set<String> keyBrandSet = new HashSet<>();
                //以下是抄袭的
                for (DetailedForecastSummaryEntity record : data.values()) {
                    List<String> yearMonthList = DateUtil.getBetweenYearMonths(record.getActivityStartTime(), record.getActivityEndTime(), DateUtil.DEFAULT_YEAR_MONTH_NO_CH);
                    String keyPrefix = record.getRegionName() + record.getSystemName() + this.nullToEmptyString(record.getProductBrandCode());
                    //String id = keyPrefix + DateUtil.getDateStrByFormat(record.getActivityStartTime(), DateUtil.DEFAULT_DATE_ALL_PATTERN) + DateUtil.getDateStrByFormat(record.getActivityEndTime(), DateUtil.DEFAULT_DATE_ALL_PATTERN);
                    //record.setId(DigestUtils.md5Hex(id));
                    for (String yearMonth : yearMonthList) {
                        String key = keyPrefix + yearMonth;
                        if (StringUtils.isNotEmpty(record.getProductBrandCode())) {
                            keyBrandSet.add(key);
                            continue;
                        }
                        keySet.add(key);
                    }
                }

                //查询垂直销售业绩
                List<DetailedForecastSummaryVo> salesPerformanceList = Lists.newArrayList();
                if (!CollectionUtils.isEmpty(keySet)) {
                    List<DetailedForecastSummaryVo> list = this.detailedForecastRepository.summarySalesPerformanceList(Lists.newArrayList(keySet), null);
                    salesPerformanceList.addAll(list);
                }
                if (!CollectionUtils.isEmpty(keyBrandSet)) {
                    List<DetailedForecastSummaryVo> list = this.detailedForecastRepository.summarySalesPerformanceList(null, Lists.newArrayList(keyBrandSet));
                    salesPerformanceList.addAll(list);
                }

                log.info("细案预测汇总：垂直销售业绩：{}", salesPerformanceList.size());
                Map<String, BigDecimal> actualSalesMap = salesPerformanceList.stream().collect(Collectors.toMap(DetailedForecastSummaryVo::getId, DetailedForecastSummaryVo::getActualSalesAmount));

                //实际销售额：汇总垂直销售业绩的“实际折后出库额”字段
                for (DetailedForecastSummaryEntity record : data.values()) {
                    List<String> yearMonthList = DateUtil.getBetweenYearMonths(record.getActivityStartTime(), record.getActivityEndTime(), DateUtil.DEFAULT_YEAR_MONTH_NO_CH);
                    String keyPrefix = record.getRegionName() + record.getSystemName() + this.nullToEmptyString(record.getProductBrandCode());
                    BigDecimal actualSalesAmount = BigDecimal.ZERO;
                    for (String yearMonth : yearMonthList) {
                        String key = keyPrefix + yearMonth;
                        actualSalesAmount = actualSalesAmount.add(actualSalesMap.getOrDefault(key, BigDecimal.ZERO));
                    }
                    record.setActualSalesAmount(actualSalesAmount);
                }


                //从数据库判断是否是更新还是新增
                List<DetailedForecastSummaryEntity> entityList = this.detailedForecastSummaryRepository.lambdaQuery().in(DetailedForecastSummaryEntity::getId, data.keySet()).list();
                Map<String, DetailedForecastSummaryEntity> databaseMap = entityList.stream().collect(Collectors.toMap(DetailedForecastSummaryEntity::getId, Function.identity()));

                data.values().forEach(value -> {
                    if (databaseMap.containsKey(value.getId())) {
                        //需要跟数据库的数据汇总
                        value.setPeriodPromotionQuantity(ObjectUtils.defaultIfNull(value.getPeriodPromotionQuantity(),BigDecimal.ZERO).add(ObjectUtils.defaultIfNull(databaseMap.get(value.getId()).getPeriodPromotionQuantity(),BigDecimal.ZERO)));
                        value.setApplyAmount(ObjectUtils.defaultIfNull(value.getApplyAmount(),BigDecimal.ZERO).add(ObjectUtils.defaultIfNull(databaseMap.get(value.getId()).getApplyAmount(),BigDecimal.ZERO)));
                        value.setEstimatedWriteOffAmount(ObjectUtils.defaultIfNull(value.getEstimatedWriteOffAmount(),BigDecimal.ZERO).add(ObjectUtils.defaultIfNull(databaseMap.get(value.getId()).getEstimatedWriteOffAmount(),BigDecimal.ZERO)));
                        value.setAlreadyAuditAmount(ObjectUtils.defaultIfNull(value.getAlreadyAuditAmount(),BigDecimal.ZERO).add(ObjectUtils.defaultIfNull(databaseMap.get(value.getId()).getAlreadyAuditAmount(),BigDecimal.ZERO)));
                    }
                    //剩余可核销金额:预核销金额-实际销售额
                    BigDecimal estimatedWriteOffAmount = Optional.ofNullable(value.getEstimatedWriteOffAmount()).orElse(BigDecimal.ZERO);
                    BigDecimal alreadyAuditAmount = Optional.ofNullable(value.getAlreadyAuditAmount()).orElse(BigDecimal.ZERO);
                    BigDecimal remnantAuditAmount = estimatedWriteOffAmount.subtract(alreadyAuditAmount);
                    value.setRemnantAuditAmount(remnantAuditAmount);
                });
                log.info("细案预测汇总-数据MAP,{}", JSON.toJSONString(data));
                this.detailedForecastSummaryRepository.saveOrUpdateBatch(data.values(), 100);
                count++;
            } while (pageResult.hasNext() && count <= 1000);
            //往数据库写数据

        } catch (Exception e) {
            log.error("细案预测汇总报错啦:", e);
            e.printStackTrace();
        }
    }

    /**
     * 更据细案明细编码查询预估核销金额（单字段查询）
     * @param codes
     * @return
     */
    @Override
    public List<DetailedForecastVo> findEstimatedWriteOffAmountByCodes(List<String> codes) {
        if (CollectionUtils.isEmpty(codes)) {
            return Lists.newArrayList();
        }
        List<DetailedForecastVo> list = this.detailedForecastRepository.findEstimatedWriteOffAmountByCodes(codes);
        if (CollectionUtils.isEmpty(list)) {
            return Lists.newArrayList();
        }
        return list;
    }

    /**
     * 细案预测汇总核销金额
     * @param records
     * @return
     */
    @Override
    public List<DetailedForecastVo> findByProfitMonitor(List<DetailedForecastDto> records) {
        return this.detailedForecastRepository.findByProfitMonitor(records);
    }

    @Override
    public List<DetailedForecastVo> findByProfitMonitor1(List<DetailedForecastDto> detailedForecastDtos) {
        return this.detailedForecastRepository.findByProfitMonitor1(detailedForecastDtos);
    }

    @Override
    public List<AuditDetailedForecastVo> findByActivityDetailItemCodes(List<String> activityDetailItemCodes) {
        if(CollectionUtils.isEmpty(activityDetailItemCodes)){
            return Lists.newArrayList();
        }
        return this.detailedForecastRepository.findByActivityDetailItemCodes2(activityDetailItemCodes);
    }
}
