package com.biz.crm.tpm.business.detailed.forecast.local.service.internal;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.business.common.sdk.service.RedisService;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.mn.common.rocketmq.service.RocketMqProducer;
import com.biz.crm.mn.common.rocketmq.util.RocketMqUtil;
import com.biz.crm.mn.common.rocketmq.vo.MqMessageVo;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.constant.ActivityDetailPlanConstant;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.constant.ActivityDetailPlanPassMqTagConstant;
import com.biz.crm.tpm.business.detailed.forecast.sdk.constant.DeatailedForecastConstants;
import com.biz.crm.tpm.business.detailed.forecast.sdk.dto.DetailedForecastAutoCreateDto;
import com.biz.crm.tpm.business.detailed.forecast.sdk.service.DetailedForecastService;
import com.biz.crm.tpm.business.promotion.plan.sdk.constant.PromotionPlanConstant;
import com.biz.crm.tpm.business.promotion.plan.sdk.constant.PromotionPlanMqTagConstant;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.constant.SubComActivityDetailPlanConstant;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.constant.SubComActivityDetailPlanPassMqTagConstant;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.task.annotations.DynamicTaskService;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;

/**
 * <p>
 * 细案预测定时刷新展示状态
 * 更新showFlag字段，默认未Y，不展示更新为N
 * 1、主体要求不展示已关闭的明细，把明细对应的预测数据showFlag更新为N
 *
 * </p>
 *
 * @author chenshuang
 * @since 2023-02-16
 */
@Slf4j
@Service
public class DetailedForecastShowFlagRefreshXxlJob {

    @Autowired(required = false)
    private DetailedForecastService detailedForecastService;

    @Autowired(required = false)
    private RocketMqProducer rocketMqProducer;

    @Autowired(required = false)
    private LoginUserService loginUserService;

    @Autowired(required = false)
    private RedisService redisService;

    /**
     * 细案预测定时刷新展示状态任务，7点开始个小时执行一次，默认检查更新时间3天内的活动
     */
    @DynamicTaskService(cornExpression = "0 0 7/1 * * ?", taskDesc = "细案预测定时刷新展示状态任务")
    public void autoRefresh() {
        log.info("=====>    细案预测定时刷新展示状态[{}] start    <=====", DateUtil.dateStrNowAll());
        loginUserService.refreshAuthentication(null);
        try {
            if (redisService.hasKey(DeatailedForecastConstants.REFRESH_SHOW_FLAG_KEY)) {
                Object o = redisService.get(DeatailedForecastConstants.REFRESH_SHOW_FLAG_KEY);
                String msg = "细案预测定时刷新展示状态进行中！开始时间：" + o.toString();
                log.error(msg);
                throw new RuntimeException(msg);
            }
            String nowDateTime = DateUtil.getDate(DateUtil.DEFAULT_DATE_ALL_PATTERN);
            //锁5分钟自然解锁
            redisService.set(DeatailedForecastConstants.REFRESH_SHOW_FLAG_KEY, nowDateTime, 60 * 5);
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern(DateUtil.DEFAULT_DATE_ALL_PATTERN);

            DetailedForecastAutoCreateDto dto = new DetailedForecastAutoCreateDto();
            dto.setModifyBeginDateTime(LocalDateTime.now().plusDays(-3).format(formatter));
            dto.setTenantCode(TenantUtils.getTenantCode());
            try {
                dto.setBusinessUnitCode(BusinessUnitEnum.HEADQUARTERS.getCode());
                Long count = detailedForecastService.autoUpdateShowFLag(dto);
                log.info("细案预测定时刷新展示状态===》主体===》{}", count);
                dto.setBusinessUnitCode(BusinessUnitEnum.SON_COMPANY.getCode());
                count = detailedForecastService.autoUpdateShowFLag(dto);
                log.info("细案预测定时刷新展示状态===》分子===》{}", count);
            } catch (Exception e) {
                log.error("细案预测定时刷新展示状态===》主体===》异常：" + e.getMessage(), e);
            }
        } catch (RuntimeException e) {
            e.printStackTrace();
            log.error("细案预测定时补创建异常：" + e.getMessage(), e);
        }
        log.info("=====>    细案预测定时刷新展示状态[{}] end    <=====", DateUtil.dateStrNowAll());
    }
}
