package com.biz.crm.tpm.business.detailed.forecast.local.service.internal;

import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.business.common.sdk.service.RedisService;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.mn.common.rocketmq.service.RocketMqProducer;
import com.biz.crm.tpm.business.detailed.forecast.sdk.constant.DeatailedForecastConstants;
import com.biz.crm.tpm.business.detailed.forecast.sdk.dto.DetailedForecastAutoCreateDto;
import com.biz.crm.tpm.business.detailed.forecast.sdk.dto.DetailedForecastSummaryDto;
import com.biz.crm.tpm.business.detailed.forecast.sdk.service.DetailedForecastService;
import com.bizunited.nebula.task.annotations.DynamicTaskService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.List;

/**
 * 细案预测汇总 定时任务增量更新
 */
@Slf4j
@Service
public class DetailedForecastSummaryXxlJob {

    @Autowired(required = false)
    private DetailedForecastService detailedForecastService;

    @Autowired(required = false)
    private RocketMqProducer rocketMqProducer;

    @Autowired(required = false)
    private LoginUserService loginUserService;

    @Autowired(required = false)
    private RedisService redisService;


    @DynamicTaskService(cornExpression = "0 0 1 * * ?", taskDesc = "细案预测汇总增量更新定时任务")
    public void detailedForecastSummaryUpdateQuery() {
        log.info("=====>    细案预测汇总增量更新[{}] start    <=====", DateUtil.dateStrNowAll());
        loginUserService.refreshAuthentication(null);
        try {
            if (redisService.hasKey(DeatailedForecastConstants.DETAILED_FORECAST_SUMMARY)) {
                Object o = redisService.get(DeatailedForecastConstants.DETAILED_FORECAST_SUMMARY);
                String msg = "细案预测汇总增量更新进行中！开始时间：" + o.toString();
                log.error(msg);
                throw new RuntimeException(msg);
            }
            String nowDateTime = DateUtil.getDate(DateUtil.DEFAULT_DATE_ALL_PATTERN);
            //锁50分钟自然解锁
            redisService.set(DeatailedForecastConstants.DETAILED_FORECAST_SUMMARY, nowDateTime, 60 * 50);
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern(DateUtil.DEFAULT_YEAR_MONTH_DAY);

            LocalDate localDate = LocalDate.now();
            localDate = localDate.plusDays(-1);
            //跑昨天更新的数据：根据tpm_activity_detail_plan_item表的更新时间来获取哪些plan_code需要重新跑，然后再去细案预测里面查询关联的明细进行汇总处理
            DetailedForecastSummaryDto dto = new DetailedForecastSummaryDto();
            dto.setUpdateQueryBegin(localDate.format(formatter) + " " + DateUtil.DAY_EARLIEST_TIME);
            dto.setUpdateQueryEnd(localDate.format(formatter) + " " + DateUtil.DAY_LATEST_TIME);
            try {
                detailedForecastService.detailedForecastSummaryUpdateQuery(dto);
            } catch (Exception e) {
                log.error("细案预测汇总增量更新===》垂直===》异常：" + e.getMessage(), e);
            }
        } catch (RuntimeException e) {
            e.printStackTrace();
            log.error("细案预测汇总增量更新异常：" + e.getMessage(), e);
        }
        log.info("=====>    细案预测汇总增量更新[{}] end    <=====", DateUtil.dateStrNowAll());
    }
}
