package com.biz.crm.tpm.business.detailed.forecast.local.task.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mn.third.system.ecrm.sdk.service.EcrmService;
import com.biz.crm.mn.third.system.ecrm.sdk.vo.DetailedForecastRequestVo;
import com.biz.crm.tpm.business.detailed.forecast.sdk.service.DetailedForecastService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.SchedulingConfigurer;
import org.springframework.scheduling.config.ScheduledTaskRegistrar;
import org.springframework.scheduling.support.CronTrigger;
import org.springframework.stereotype.Component;

import java.util.ArrayList;


/**
 * @author yangshen
 * @version 1.0
 * @date 2023/1/16 21:25
 * @ClassName DeatailedForecastSchedulingImp
 * @Description TODO
 */
@EnableScheduling
@Component
@Slf4j
public class DeatailedForecastSchedulingImp implements SchedulingConfigurer {

    private static final String DEFAULT_CRON = "0 0 1,12,17,23 * * ?";

    private String cron = DEFAULT_CRON;

    @Autowired
    private DetailedForecastService detailedForecastService;

    @Autowired(required = false)
    private EcrmService ecrmService;

    /**
     * 是否开启定时任务
     */
    @Value("${ce1.ce1EnableSchedulingFlag}")
    private boolean ce1EnableSchedulingFlag;

    @Override
    public void configureTasks(ScheduledTaskRegistrar taskRegistrar) {

        ce1EnableSchedulingFlag = false;

        if (ce1EnableSchedulingFlag) {
            taskRegistrar.addTriggerTask(this::executePullTask, triggerContext -> {
                CronTrigger trigger = new CronTrigger(cron);
                return trigger.nextExecutionTime(triggerContext);
            });
        } else {
            log.info("未开启定时任务，请手动调用");
        }
    }

    /**
     * 执行定时任务
     */
    public void executePullTask() {
        //改为分页推送，每页200条
        int pageNum = 1;
        int pageSize = 200;
        Pageable pageable = PageRequest.of(pageNum, pageSize);
        Page<DetailedForecastRequestVo> page = detailedForecastService.selectUnSynchronizedPage(pageable);
        while (!CollectionUtils.isEmpty(page.getRecords())) {
            //进行同步
            //发请求进行同步
            boolean success = ecrmService.initiateSynchronization(page.getRecords());
            if (success) {
                detailedForecastService.updateSynchronousRegime(page.getRecords());
            }
            if (page.getRecords().size() == pageSize) {
                pageNum++;
                pageable = PageRequest.of(pageNum, pageSize);
                page = detailedForecastService.selectUnSynchronizedPage(pageable);
            } else {
                page.setRecords(new ArrayList<>());
            }
        }
    }
}
