package com.biz.crm.tpm.business.detailed.forecast.local.util;

import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgAllParentVo;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.util.MnMdgCodeCheckUtil;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanItemDto;
import com.biz.crm.tpm.business.detailed.forecast.sdk.constant.DetailedPredictionTypeEnum;
import com.biz.crm.tpm.business.detailed.forecast.sdk.dto.DetailedForecastDto;
import com.biz.crm.tpm.business.promotion.plan.sdk.vo.GeneralExpensesVo;
import com.biz.crm.tpm.business.promotion.plan.sdk.vo.PromotionPlanVo;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.vo.SubComActivityDetailPlanItemVo;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.vo.SubComActivityDetailPlanVo;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.vo.AuditExecuteIndicatorVo;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;

import java.util.Map;
import java.util.Objects;

/**
 * <p>
 * 活动细案推细案预测参数构建
 * </p>
 *
 * @author chenshuang
 * @since 2023-04-18
 */
public class ActivityDetailPlanPassDetailedForecastBuilder {

    /**
     * 主体、垂直
     *
     * @param activityDetailPlanDto
     * @param item
     * @param regionMap
     * @param customerVo
     * @param salesOrgAllParentVo
     * @param finalAuditExecuteIndicatorMap
     * @return
     */
    public static DetailedForecastDto buildUnit1Dto(ActivityDetailPlanDto activityDetailPlanDto,
                                                    ActivityDetailPlanItemDto item,
                                                    Map<String, String> regionMap,
                                                    CustomerVo customerVo,
                                                    SalesOrgAllParentVo salesOrgAllParentVo,
                                                    ProductVo productVo, Map<String, AuditExecuteIndicatorVo> finalAuditExecuteIndicatorMap) {
        DetailedForecastDto detailedForecastDto = new DetailedForecastDto();
        detailedForecastDto.setBusinessFormatCode(activityDetailPlanDto.getBusinessFormatCode());
        detailedForecastDto.setBusinessUnitCode(activityDetailPlanDto.getBusinessUnitCode());
        detailedForecastDto.setDetailedCaseCode(activityDetailPlanDto.getDetailPlanCode());
        detailedForecastDto.setDetailedCaseName(activityDetailPlanDto.getDetailPlanName());
        detailedForecastDto.setActivityTypeCode(item.getActivityTypeCode());
        detailedForecastDto.setActivityTypeName(item.getActivityTypeName());
        detailedForecastDto.setActivityFormCode(item.getActivityFormCode());
        detailedForecastDto.setActivityFormName(item.getActivityFormName());
        detailedForecastDto.setActivityStartTime(item.getActivityBeginDate());
        detailedForecastDto.setActivityEndTime(item.getActivityEndDate());
        detailedForecastDto.setPrimaryManagementChannel(item.getFirstChannelCode());
        detailedForecastDto.setCustomer(item.getCustomerName());
        detailedForecastDto.setCustomerCode(item.getCustomerCode());
        detailedForecastDto.setAuditType(item.getAuditType());
        detailedForecastDto.setSaleOrgCode(item.getActivityOrgCode());
        detailedForecastDto.setSaleOrgName(item.getActivityOrgName());
        detailedForecastDto.setSalesOrgCode(item.getActivityOrgCode());
        detailedForecastDto.setSalesOrgName(item.getActivityOrgName());
        detailedForecastDto.setIdentityCard(item.getIdentityCard());
        detailedForecastDto.setFirstChannelCode(item.getFirstChannelCode());
        detailedForecastDto.setFirstChannelName(item.getFirstChannelName());
        detailedForecastDto.setSecondChannelCode(item.getSecondChannelCode());
        detailedForecastDto.setSecondChannelName(item.getSecondChannelName());
        detailedForecastDto.setHeadBudgetItemCode(item.getHeadBudgetItemCode());
        detailedForecastDto.setMonthBudgetCode(item.getMonthBudgetCode());
        detailedForecastDto.setFormDescription(item.getFormDescription());
        detailedForecastDto.setIsTemporary(activityDetailPlanDto.getIsTemporary());
        detailedForecastDto.setApplyAmount(item.getFeeAmount());
        detailedForecastDto.setCustomerAccount(item.getIsCustomerAccount());
        detailedForecastDto.setDisplayNumber(item.getDisplayLot());
        detailedForecastDto.setDepartmentFeeAmount(item.getDepartmentFeeAmount());
        detailedForecastDto.setHeadFeeAmount(item.getHeadFeeAmount());
        detailedForecastDto.setRegion(item.getRegion());
        if (StringUtils.isNotEmpty(item.getRegion())) {
            detailedForecastDto.setRegionName(regionMap.get(item.getRegion()));
        }

        if (Objects.nonNull(salesOrgAllParentVo)) {
            detailedForecastDto.setSalesOrgErpCode(salesOrgAllParentVo.getCurrSalesOrgVo().getErpCode());
            detailedForecastDto.setSalesInstitutionErpCode(salesOrgAllParentVo.getSalesInstitutionErpCode());
            detailedForecastDto.setSalesInstitutionCode(salesOrgAllParentVo.getSalesInstitutionCode());
            detailedForecastDto.setSalesInstitutionName(salesOrgAllParentVo.getSalesInstitutionName());
            detailedForecastDto.setSalesRegionErpCode(salesOrgAllParentVo.getSalesDepartErpCode());
            detailedForecastDto.setSalesRegionCode(salesOrgAllParentVo.getSalesDepartCode());
            detailedForecastDto.setSalesRegionName(salesOrgAllParentVo.getSalesDepartName());
            detailedForecastDto.setSalesGroupErpCode(salesOrgAllParentVo.getSalesGroupErpCode());
            detailedForecastDto.setSalesGroupCode(salesOrgAllParentVo.getSalesGroupCode());
            detailedForecastDto.setSalesGroupName(salesOrgAllParentVo.getSalesGroupName());
        } else {
            //查不到就用原来表里面的数据
            detailedForecastDto.setSalesInstitutionErpCode(item.getSalesInstitutionErpCode());
            detailedForecastDto.setSalesInstitutionCode(item.getSalesInstitutionCode());
            detailedForecastDto.setSalesInstitutionName(item.getSalesInstitutionName());
            detailedForecastDto.setSalesRegionErpCode(item.getSalesRegionErpCode());
            detailedForecastDto.setSalesRegionCode(item.getSalesRegionCode());
            detailedForecastDto.setSalesRegionName(item.getSalesRegionName());
            detailedForecastDto.setSalesGroupErpCode(item.getSalesOrgErpCode());
            detailedForecastDto.setSalesGroupCode(item.getSalesOrgCode());
            detailedForecastDto.setSalesGroupName(item.getSalesOrgName());
        }
        detailedForecastDto.setSystemName(item.getSystemName());
        if (Objects.nonNull(customerVo)) {
            detailedForecastDto.setCustomerErpCode(customerVo.getErpCode());
            detailedForecastDto.setRtmMode(customerVo.getRtmModelCode());
            detailedForecastDto.setCusCreateTime(customerVo.getCreateTime());
            detailedForecastDto.setChannelCode(customerVo.getCustomerChannelCode());
            detailedForecastDto.setChannelName(customerVo.getCustomerChannelName());
        }

        detailedForecastDto.setProductCode(item.getProductCode());
        if (Objects.nonNull(productVo)) {
            detailedForecastDto.setProductName(productVo.getProductName());
            detailedForecastDto.setProductBrandCode(productVo.getProductBrandCode());
            detailedForecastDto.setProductBrandName(productVo.getProductBrandName());
            detailedForecastDto.setProductCategoryCode(productVo.getProductCategoryCode());
            detailedForecastDto.setProductCategoryName(productVo.getProductCategoryName());
            detailedForecastDto.setProductItemCode(productVo.getProductLevelCode());
            detailedForecastDto.setProductItemName(productVo.getProductLevelName());
        }
        if (StringUtils.equals(BooleanEnum.TRUE.getCapital(), item.getIsClose())) {
            detailedForecastDto.setDetailedPredictionType(DetailedPredictionTypeEnum.CLOSED.getDictCode());
        } else {
            detailedForecastDto.setDetailedPredictionType(DetailedPredictionTypeEnum.NORMAL.getDictCode());
        }
        //细案明细编码
        detailedForecastDto.setActivityDetailItemCode(item.getDetailPlanItemCode());
        detailedForecastDto.setAuditFormulaCode(item.getAuditConditionCode());

        if (Objects.nonNull(item.getFeeYearMonth())) {
            detailedForecastDto.setYearMonthStr(DateFormatUtils.format(item.getFeeYearMonth(), "yyyy-MM"));
        }
        detailedForecastDto.setTerminalCode(item.getTerminalCode());
        detailedForecastDto.setTerminalName(item.getTerminalName());
        detailedForecastDto.setSystemCode(item.getSystemCode());
        detailedForecastDto.setSystemName(item.getSystemName());
        detailedForecastDto.setBuyWay(item.getBuyWay());
        if (StringUtils.equals(BusinessUnitEnum.HEADQUARTERS.getCode(), activityDetailPlanDto.getBusinessUnitCode())) {
            detailedForecastDto.setPersonCode(item.getPersonCode());
        } else {
            detailedForecastDto.setPersonCode(item.getEmployeeCode());
        }
        detailedForecastDto.setWriteOffMethod(item.getWriteOffMethod());
        //垂直的更新核减堆头数量
        if(BusinessUnitEnum.VERTICAL.getCode().equals(activityDetailPlanDto.getBusinessUnitCode())){
            AuditExecuteIndicatorVo auditExecuteIndicatorVo = finalAuditExecuteIndicatorMap.get(item.getDetailPlanItemCode());
            if(Objects.nonNull(auditExecuteIndicatorVo)){
                detailedForecastDto.setMinusCompostQuantity(auditExecuteIndicatorVo.getIndicatorValue());
            }
        }
        return detailedForecastDto;
    }

    /**
     * 分子
     *
     * @param detailPlanVo
     * @param item
     * @param customerVo
     * @param salesOrgVoMap
     * @return
     */
    public static DetailedForecastDto buildUnit2Dto(SubComActivityDetailPlanVo detailPlanVo,
                                                    SubComActivityDetailPlanItemVo item,
                                                    CustomerVo customerVo,
                                                    Map<String, SalesOrgAllParentVo> salesOrgVoMap,
                                                    ProductVo productVo) {
        DetailedForecastDto detailedForecastDto = new DetailedForecastDto();
        detailedForecastDto.setBusinessFormatCode(detailPlanVo.getBusinessFormatCode());
        detailedForecastDto.setBusinessUnitCode(BusinessUnitEnum.SON_COMPANY.getCode());
        detailedForecastDto.setDetailedCaseCode(detailPlanVo.getConstituentDetailPlanCode());
        detailedForecastDto.setDetailedCaseName(detailPlanVo.getConstituentDetailPlanName());
        detailedForecastDto.setActivityTypeCode(item.getActivityType());
        detailedForecastDto.setActivityTypeName(item.getActivityTypeName());
        detailedForecastDto.setActivityFormCode(item.getActivityFormCode());
        detailedForecastDto.setActivityFormName(item.getActivityFormName());
        detailedForecastDto.setActivityStartTime(item.getActivityBeginTime());
        detailedForecastDto.setActivityEndTime(item.getActivityEndTime());
        detailedForecastDto.setCustomer(item.getCustomerName());
        detailedForecastDto.setCustomerCode(item.getCustomerCode());
        detailedForecastDto.setActivityDetailItemCode(item.getConstituentDetailPlanItemCode());
        detailedForecastDto.setAuditFormulaCode(item.getAuditConditionCode());
        detailedForecastDto.setSystemName(item.getResaleCommercialName());
        detailedForecastDto.setDistributionChannelCode(item.getDistributionChannelCode());
        detailedForecastDto.setDistributionChannelName(item.getDistributionChannelName());
        detailedForecastDto.setApplyAmount(item.getTotalCost());
        detailedForecastDto.setDepartmentFeeAmount(item.getSubComAutoAmount());
        detailedForecastDto.setHeadFeeAmount(item.getHeadquartersSupportedAmount());
        detailedForecastDto.setOrgCode(detailPlanVo.getOrgCode());
        detailedForecastDto.setOrgName(detailPlanVo.getOrgName());

        String saleOrgCode = null;
        String saleOrgName = null;
        if (StringUtils.isNotEmpty(item.getSalesGroupCode())) {
            saleOrgCode = item.getSalesGroupCode();
            saleOrgName = item.getSalesGroupName();
        } else if (StringUtils.isNotEmpty(item.getSalesOrgCode())) {
            saleOrgCode = item.getSalesOrgCode();
            saleOrgName = item.getSalesOrgName();
        } else if (StringUtils.isNotEmpty(item.getSalesInstitutionCode())) {
            saleOrgCode = item.getSalesInstitutionCode();
            saleOrgName = item.getSalesInstitutionName();
        }
        detailedForecastDto.setSaleOrgCode(saleOrgCode);
        detailedForecastDto.setSaleOrgName(saleOrgName);
        detailedForecastDto.setSalesOrgCode(saleOrgCode);
        detailedForecastDto.setSalesOrgName(saleOrgName);
        SalesOrgAllParentVo salesOrgAllParentVo = null;
        if (StringUtils.isNotEmpty(detailedForecastDto.getSaleOrgCode())) {
            salesOrgAllParentVo = salesOrgVoMap.get(detailedForecastDto.getSaleOrgCode());
        }
        if (Objects.nonNull(salesOrgAllParentVo)) {
            detailedForecastDto.setSalesOrgErpCode(salesOrgAllParentVo.getCurrSalesOrgVo().getErpCode());
            detailedForecastDto.setSalesInstitutionErpCode(salesOrgAllParentVo.getSalesInstitutionErpCode());
            detailedForecastDto.setSalesInstitutionCode(salesOrgAllParentVo.getSalesInstitutionCode());
            detailedForecastDto.setSalesInstitutionName(salesOrgAllParentVo.getSalesInstitutionName());
            detailedForecastDto.setSalesRegionErpCode(salesOrgAllParentVo.getSalesDepartErpCode());
            detailedForecastDto.setSalesRegionCode(salesOrgAllParentVo.getSalesDepartCode());
            detailedForecastDto.setSalesRegionName(salesOrgAllParentVo.getSalesDepartName());
            detailedForecastDto.setSalesGroupErpCode(salesOrgAllParentVo.getSalesGroupErpCode());
            detailedForecastDto.setSalesGroupCode(salesOrgAllParentVo.getSalesGroupCode());
            detailedForecastDto.setSalesGroupName(salesOrgAllParentVo.getSalesGroupName());
        } else {
            //查不到就用原来表里面的数据
            detailedForecastDto.setSalesGroupCode(item.getSalesGroupCode());
            detailedForecastDto.setSalesGroupName(item.getSalesGroupName());
            detailedForecastDto.setSalesRegionCode(item.getSalesOrgCode());
            detailedForecastDto.setSalesRegionName(item.getSalesOrgName());
            detailedForecastDto.setSalesInstitutionErpCode(item.getSalesInstitutionErpCode());
            detailedForecastDto.setSalesInstitutionCode(item.getSalesInstitutionCode());
            detailedForecastDto.setSalesInstitutionName(item.getSalesInstitutionName());
        }

        //分子的客户编码可能是短码
        if (StringUtils.isNotEmpty(detailedForecastDto.getCustomerCode()) && !MnMdgCodeCheckUtil.checkCustomer(detailedForecastDto.getCustomerCode())) {
            detailedForecastDto.setCustomerErpCode(Objects.nonNull(customerVo) ? customerVo.getErpCode() : "");
        } else if (StringUtils.isNotEmpty(detailedForecastDto.getCustomerCode())) {
            detailedForecastDto.setCustomerErpCode(detailedForecastDto.getCustomerCode());
        }

        if (Objects.nonNull(item.getFeeYearMonth())) {
            detailedForecastDto.setYearMonthStr(DateFormatUtils.format(item.getFeeYearMonth(), "yyyy-MM"));
        }

        detailedForecastDto.setProductCode(item.getProductCode());
        if (Objects.nonNull(productVo)) {
            detailedForecastDto.setProductName(productVo.getProductName());
            detailedForecastDto.setProductBrandCode(productVo.getProductBrandCode());
            detailedForecastDto.setProductBrandName(productVo.getProductBrandName());
            detailedForecastDto.setProductCategoryCode(productVo.getProductCategoryCode());
            detailedForecastDto.setProductCategoryName(productVo.getProductCategoryName());
            detailedForecastDto.setProductItemCode(productVo.getProductLevelCode());
            detailedForecastDto.setProductItemName(productVo.getProductLevelName());
        }

        detailedForecastDto.setTerminalCode(item.getTerminalCode());
        detailedForecastDto.setTerminalName(item.getTerminalName());

        detailedForecastDto.setSystemCode(item.getResaleCommercialCode());
        detailedForecastDto.setSystemName(item.getResaleCommercialName());
        detailedForecastDto.setPersonCode(item.getPersonCode());
        detailedForecastDto.setDistributionChannelCode(item.getDistributionChannelCode());
        detailedForecastDto.setDistributionChannelName(item.getDistributionChannelName());
        detailedForecastDto.setWriteOffMethod(item.getAuditType());
        return detailedForecastDto;
    }

    /**
     * 电商
     *
     * @param plan
     * @param item
     * @param customerVo
     * @param salesOrgAllParentVo
     * @return
     */
    public static DetailedForecastDto buildUnit4Dto(PromotionPlanVo plan,
                                                    GeneralExpensesVo item,
                                                    CustomerVo customerVo,
                                                    SalesOrgAllParentVo salesOrgAllParentVo,
                                                    ProductVo productVo) {
        DetailedForecastDto detailedForecastDto = new DetailedForecastDto();
        detailedForecastDto.setBusinessFormatCode(plan.getBusinessFormatCode());
        detailedForecastDto.setDetailedCaseName(plan.getPromotionPlanName());
        detailedForecastDto.setDetailedCaseCode(plan.getPromotionPlanCode());
        detailedForecastDto.setActivityTypeCode(item.getActivityTypeCode());
        detailedForecastDto.setActivityTypeName(item.getActivityTypeName());
        detailedForecastDto.setActivityFormCode(item.getActivityFormCode());
        detailedForecastDto.setActivityFormName(item.getActivityFormName());
        detailedForecastDto.setActivityStartTime(item.getStartDate());
        detailedForecastDto.setActivityEndTime(item.getEndDate());
        detailedForecastDto.setCustomer(item.getCustomerName());
        detailedForecastDto.setCustomerCode(item.getCustomerCode());
        detailedForecastDto.setActivityDetailItemCode(item.getExpensesCode());
        detailedForecastDto.setApplyAmount(item.getApplyAmount());
        detailedForecastDto.setYearMonthStr(item.getYearMonthLy());
        detailedForecastDto.setAuditType(item.getAuditConditionType());
        detailedForecastDto.setBusinessUnitCode(BusinessUnitEnum.ONLINE.getCode());
        detailedForecastDto.setSaleOrgCode(plan.getSalesOrgCode());
        detailedForecastDto.setSaleOrgName(plan.getSalesOrgName());
        detailedForecastDto.setSalesOrgCode(plan.getSalesOrgCode());
        detailedForecastDto.setSalesOrgName(plan.getSalesOrgName());

        //销售组织三个层级字段
        if (Objects.nonNull(salesOrgAllParentVo)) {
            detailedForecastDto.setSalesOrgErpCode(salesOrgAllParentVo.getCurrSalesOrgVo().getErpCode());
            detailedForecastDto.setSalesInstitutionErpCode(salesOrgAllParentVo.getSalesInstitutionErpCode());
            detailedForecastDto.setSalesInstitutionCode(salesOrgAllParentVo.getSalesInstitutionCode());
            detailedForecastDto.setSalesInstitutionName(salesOrgAllParentVo.getSalesInstitutionName());
            detailedForecastDto.setSalesRegionErpCode(salesOrgAllParentVo.getSalesDepartErpCode());
            detailedForecastDto.setSalesRegionCode(salesOrgAllParentVo.getSalesDepartCode());
            detailedForecastDto.setSalesRegionName(salesOrgAllParentVo.getSalesDepartName());
            detailedForecastDto.setSalesGroupErpCode(salesOrgAllParentVo.getSalesGroupErpCode());
            detailedForecastDto.setSalesGroupCode(salesOrgAllParentVo.getSalesGroupCode());
            detailedForecastDto.setSalesGroupName(salesOrgAllParentVo.getSalesGroupName());
        }

        detailedForecastDto.setYearMonthStr(item.getYearMonthLy());
        if (customerVo != null) {
            detailedForecastDto.setEstoreCustomerLevel(customerVo.getEstoreCustomerLevel());
            detailedForecastDto.setCustomerErpCode(customerVo.getErpCode());
            detailedForecastDto.setChannelCode(customerVo.getCustomerChannelCode());
            detailedForecastDto.setChannelName(customerVo.getCustomerChannelName());
        }

        detailedForecastDto.setProductCode(item.getProductCode());
        if (Objects.nonNull(productVo)) {
            detailedForecastDto.setProductName(productVo.getProductName());
            detailedForecastDto.setProductBrandCode(productVo.getProductBrandCode());
            detailedForecastDto.setProductBrandName(productVo.getProductBrandName());
            detailedForecastDto.setProductCategoryCode(productVo.getProductCategoryCode());
            detailedForecastDto.setProductCategoryName(productVo.getProductCategoryName());
            detailedForecastDto.setProductItemCode(productVo.getProductLevelCode());
            detailedForecastDto.setProductItemName(productVo.getProductLevelName());
        }

        return detailedForecastDto;
    }
}
