package com.biz.crm.tpm.business.detailed.forecast.local.util;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanItemDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.enums.YesOrNoEnum;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.service.ActivityDetailPlanItemSdkService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanBudgetVo;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanItemVo;
import com.biz.crm.tpm.business.audit.business.sdk.dto.AuditFormulaMainDto;
import com.biz.crm.tpm.business.audit.business.sdk.service.AuditFormulaMainService;
import com.biz.crm.tpm.business.audit.business.sdk.vo.AuditFormulaInfoVo;
import com.biz.crm.tpm.business.audit.business.sdk.vo.AuditFormulaMainVo;
import com.biz.crm.tpm.business.audit.summary.configure.sdk.service.TpmCustomerSummaryConfigureService;
import com.biz.crm.tpm.business.business.policy.sdk.service.BusinessPolicyService;
import com.biz.crm.tpm.business.business.policy.sdk.vo.BusinessPolicyBudgetVo;
import com.biz.crm.tpm.business.detailed.forecast.local.entity.DetailedForecastEntity;
import com.biz.crm.tpm.business.detailed.forecast.local.mapper.DetailedForecastMapper;
import com.biz.crm.tpm.business.detailed.forecast.local.repository.DetailedForecastRepository;
import com.biz.crm.tpm.business.detailed.forecast.sdk.constant.DetailedForecastBudgetProjectConstants;
import com.biz.crm.tpm.business.detailed.forecast.sdk.dto.CallAuditResponse;
import com.biz.crm.tpm.business.detailed.forecast.sdk.dto.DetailedForecastCallAuditEventDto;
import com.biz.crm.tpm.business.detailed.forecast.sdk.dto.DetailedForecastDto;
import com.biz.crm.tpm.business.detailed.forecast.sdk.dto.log.DetailedForecastLogEventDto;
import com.biz.crm.tpm.business.detailed.forecast.sdk.event.DetailedForecastCallAuditListener;
import com.biz.crm.tpm.business.detailed.forecast.sdk.event.DetailedForecastLogEventListener;
import com.biz.crm.tpm.business.detailed.forecast.sdk.util.MathUtil;
import com.biz.crm.tpm.business.month.budget.sdk.dto.OperateMonthBudgetDto;
import com.biz.crm.tpm.business.month.budget.sdk.eunm.BudgetOperationTypeEnum;
import com.biz.crm.tpm.business.month.budget.sdk.eunm.VerticalFeeBelongCodeEnum;
import com.biz.crm.tpm.business.month.budget.sdk.service.MonthBudgetLockService;
import com.biz.crm.tpm.business.month.budget.sdk.service.MonthBudgetService;
import com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetDetailVo;
import com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetVo;
import com.biz.crm.tpm.business.promotion.plan.sdk.service.GeneralExpensesService;
import com.biz.crm.tpm.business.promotion.plan.sdk.vo.GeneralExpensesVo;
import com.biz.crm.tpm.business.scheme.forecast.sdk.enums.TpmAuditTypeEnum;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.service.SubComActivityDetailPlanItemVoService;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.vo.SubComActivityDetailPlanItemVo;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.dto.FormulaInfoDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.service.AuditExecuteIndicatorService;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.vo.AuditExecuteIndicatorVo;
import com.biz.crm.tpm.business.variable.sdk.service.VariableService;
import com.biz.crm.tpm.business.variable.sdk.vo.CalculateVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.bizunited.nebula.security.sdk.login.UserIdentity;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.util.*;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;

/**
 * <p>
 *
 * </p>
 *
 * @author chenshuang
 * @since 2023-02-21
 */
@Slf4j
@Component
public class ActivityDetailPlanPassDetailedForecastUtil {

    @Autowired(required = false)
    private AuditFormulaMainService auditFormulaMainService;

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    @Autowired(required = false)
    private VariableService variableService;

    @Autowired(required = false)
    private ActivityDetailPlanItemSdkService activityDetailPlanItemSdkService;

    @Autowired(required = false)
    private GeneralExpensesService generalExpensesService;

    @Autowired(required = false)
    private SubComActivityDetailPlanItemVoService activityConstituentDetailPlanItemVoService;

    @Autowired(required = false)
    private DetailedForecastRepository detailedForecastRepository;

    @Autowired(required = false)
    private NebulaNetEventClient nebulaNetEventClient;

    @Autowired(required = false)
    private LoginUserService loginUserService;

    @Autowired(required = false)
    private TpmCustomerSummaryConfigureService tpmCustomerSummaryConfigureService;

    @Autowired(required = false)
    private BusinessPolicyService businessPolicyService;

    @Autowired(required = false)
    private MonthBudgetService monthBudgetService;

    @Autowired(required = false)
    private DetailedForecastMapper detailedForecastMapper;

    @Autowired(required = false)
    private MonthBudgetLockService monthBudgetLockService;

    @Autowired(required = false)
    private AuditExecuteIndicatorService auditExecuteIndicatorService;
    /**
     * onlyKey生成
     *
     * @param entity
     * @return
     */
    public String packageOnlyKey(DetailedForecastEntity entity, String timeStamp) {
        if (StringUtils.isEmpty(timeStamp)) {
            timeStamp = "";
        }
        return DigestUtils.md5Hex(entity.getDetailedCaseCode() + entity.getActivityDetailItemCode() + timeStamp);
    }

    @Transactional(rollbackFor = Exception.class)
    public void insert(DetailedForecastDto detailedForecastDto) {
        DetailedForecastEntity detailedForecastEntity = this.nebulaToolkitService.copyObjectByWhiteList(detailedForecastDto, DetailedForecastEntity.class, null, null);
        detailedForecastEntity.setTenantCode(TenantUtils.getTenantCode());
        detailedForecastEntity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        detailedForecastEntity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        detailedForecastEntity.setShowFlag(YesOrNoEnum.YES.getCode());
        if (StringUtils.isNotEmpty(detailedForecastEntity.getYearMonthStr())) {
            detailedForecastEntity.setYearMonthLy(DateUtil.parse(detailedForecastEntity.getYearMonthStr() + "-01 00:00:00", DateUtil.DEFAULT_YEAR_MONTH));
        }
        detailedForecastEntity.setOnlyKey(this.packageOnlyKey(detailedForecastEntity, null));
        // 日志新增
        DetailedForecastLogEventDto logEventDto = new DetailedForecastLogEventDto();
        logEventDto.setOriginal(null);
        logEventDto.setNewest(detailedForecastDto);
        SerializableBiConsumer<DetailedForecastLogEventListener, DetailedForecastLogEventDto> onCreate =
                DetailedForecastLogEventListener::onCreate;
        this.nebulaNetEventClient.publish(logEventDto, DetailedForecastLogEventListener.class, onCreate);
        this.detailedForecastRepository.saveOrUpdate(detailedForecastEntity);
    }

    /**
     * 主体
     *
     * @param activityDetailPlanDto
     * @param detailedForecastDto
     * @param item
     */
    @Async("asyncThread")
    public void buildUnit1Param(ActivityDetailPlanDto activityDetailPlanDto, DetailedForecastDto detailedForecastDto, ActivityDetailPlanItemDto item, UserIdentity loginUser) {
        loginUserService.refreshAuthentication(loginUser);
        log.info("细案编码[{}]明细编码[{}]细案预测主体新增计算", detailedForecastDto.getDetailedCaseCode(), detailedForecastDto.getActivityDetailItemCode());
        if (StringUtils.isNotEmpty(item.getAuditType())) {
            if (TpmAuditTypeEnum.AUDITTYPE1.getCode().equals(item.getAuditType())) {
                AuditFormulaMainDto dto = new AuditFormulaMainDto();
                dto.setBusinessFormatCode(detailedForecastDto.getBusinessFormatCode());
                dto.setBusinessUnitCode(detailedForecastDto.getBusinessUnitCode());
                dto.setAuditType(item.getAuditType());
                dto.setSalesOrgCodes(detailedForecastDto.getSaleOrgCode());
                dto.setActivityFormCode(detailedForecastDto.getActivityFormCode());
                dto.setActivityTypeCode(detailedForecastDto.getActivityTypeCode());
                dto.setCustomerTypes(detailedForecastDto.getRtmMode());
                dto.setFirstChannel(detailedForecastDto.getFirstChannelCode());
                dto.setSecondChannel(detailedForecastDto.getSecondChannelCode());
                dto.setCustomerAccount(detailedForecastDto.getCustomerAccount());
                dto.setDisplayNumber(detailedForecastDto.getDisplayNumber());
                dto.setWriteOffMethod(detailedForecastDto.getWriteOffMethod());
                List<AuditFormulaMainVo> formulaMainVoList = auditFormulaMainService.findListByDto(dto);
                formulaMainVoList = formulaMainVoList.stream().filter(e -> CollectionUtils.isNotEmpty(e.getAuditFormulaInfoVoList())).collect(Collectors.toList());
                if (CollectionUtil.isNotEmpty(formulaMainVoList)) {
                    //上面查核销公式的时候会处理，默认取第一条公式不为空的就可以了
                    CalculateDto calDto = this.buildCalParam(formulaMainVoList.get(0), detailedForecastDto, TpmAuditTypeEnum.AUDITTYPE1.getCode());
                    this.setParam(formulaMainVoList.get(0), detailedForecastDto, calDto);
                } else {
                    detailedForecastDto.setAuditFormulaCode(null);
                }
            } else if (TpmAuditTypeEnum.AUDITTYPE2.getCode().equals(item.getAuditType())) {
                AuditFormulaMainVo auditFormulaMainVo = null;
                try {
                    auditFormulaMainVo = auditFormulaMainService.findByCode(item.getAuditConditionCode());
                } catch (Exception e) {
                    log.error("细案编码[" + detailedForecastDto.getDetailedCaseCode() + "]明细编码[" + detailedForecastDto.getActivityDetailItemCode() + "]细案预测主体新增计算" + e.getMessage(), e);
                }
                CalculateDto calDto = this.buildCalParam(auditFormulaMainVo, detailedForecastDto, TpmAuditTypeEnum.AUDITTYPE2.getCode());
                this.setParam(auditFormulaMainVo, detailedForecastDto, calDto);
            } else if (TpmAuditTypeEnum.AUDITTYPE3.getCode().equals(item.getAuditType())) {
                detailedForecastDto.setWriteOffConditions(TpmAuditTypeEnum.AUDITTYPE3.getValue());
                detailedForecastDto.setEstimatedWriteOffAmount(item.getFeeAmount());
            }
        }
        this.insert(detailedForecastDto);
    }

    /**
     * 分子
     *
     * @param detailedForecastDto
     * @param item
     * @param loginUser
     */
    @Async("asyncThread")
    public void buildUnit2Param(DetailedForecastDto detailedForecastDto, SubComActivityDetailPlanItemVo item, UserIdentity loginUser) {
        loginUserService.refreshAuthentication(loginUser);
        log.info("分子细案编码[{}]明细编码[{}]细案预测分子新增计算", detailedForecastDto.getDetailedCaseCode(), detailedForecastDto.getActivityDetailItemCode());

        //分子公司活动细案无关联方案，核销条件核销公式均在行上配置，核销条件字典暂时用和活动细案的字典
        if ("zdhx".equals(item.getAuditCondition()) || TpmAuditTypeEnum.AUDITTYPE1.getCode().equals(item.getAuditCondition())) {
            detailedForecastDto.setAuditType(TpmAuditTypeEnum.AUDITTYPE1.getCode());
            AuditFormulaMainDto dto = new AuditFormulaMainDto();
            dto.setBusinessFormatCode(detailedForecastDto.getBusinessFormatCode());
            dto.setBusinessUnitCode(detailedForecastDto.getBusinessUnitCode());
            dto.setAuditType(item.getAuditCondition());
            dto.setSalesOrgCodes(detailedForecastDto.getSaleOrgCode());
            dto.setActivityFormCode(detailedForecastDto.getActivityFormCode());
            dto.setActivityTypeCode(detailedForecastDto.getActivityTypeCode());
            dto.setWriteOffMethod(detailedForecastDto.getWriteOffMethod());
            List<AuditFormulaMainVo> formulaMainVoList = auditFormulaMainService.findListByDto(dto);
            formulaMainVoList = formulaMainVoList.stream().filter(e -> CollectionUtils.isNotEmpty(e.getAuditFormulaInfoVoList())).collect(Collectors.toList());
            if (CollectionUtil.isNotEmpty(formulaMainVoList)) {
                //上面查核销公式的时候会处理，默认取第一条公式不为空的就可以了
                CalculateDto calDto = this.buildCalParam(formulaMainVoList.get(0), detailedForecastDto, TpmAuditTypeEnum.AUDITTYPE1.getCode());
                this.setParam(formulaMainVoList.get(0), detailedForecastDto, calDto);
            } else {
                detailedForecastDto.setAuditFormulaCode(null);
            }
        } else if ("zdyhx".equals(item.getAuditCondition()) || TpmAuditTypeEnum.AUDITTYPE2.getCode().equals(item.getAuditCondition())) {
            detailedForecastDto.setAuditType(TpmAuditTypeEnum.AUDITTYPE2.getCode());
            AuditFormulaMainVo auditFormulaMainVo = null;
            try {
                auditFormulaMainVo = auditFormulaMainService.findByCode(item.getAuditConditionCode());
            } catch (Exception e) {
                log.error("细案编码[" + detailedForecastDto.getDetailedCaseCode() + "]明细编码[" + detailedForecastDto.getActivityDetailItemCode() + "]细案预测分子新增计算" + e.getMessage(), e);
            }
            CalculateDto calDto = this.buildCalParam(auditFormulaMainVo, detailedForecastDto, TpmAuditTypeEnum.AUDITTYPE2.getCode());
            this.setParam(auditFormulaMainVo, detailedForecastDto, calDto);
        } else if (StringUtils.isEmpty(item.getAuditCondition()) || "null".equals(item.getAuditCondition()) || TpmAuditTypeEnum.AUDITTYPE3.getCode().equals(item.getAuditCondition())) {
            detailedForecastDto.setAuditType(TpmAuditTypeEnum.AUDITTYPE3.getCode());
            detailedForecastDto.setWriteOffConditions(TpmAuditTypeEnum.AUDITTYPE3.getValue());
            detailedForecastDto.setEstimatedWriteOffAmount(item.getTotalCost());
//            this.setCommonQueryParam(detailedForecastDto);
        }

        this.insert(detailedForecastDto);
    }

    /**
     * 垂直
     *
     * @param detailedForecastDto
     * @param item
     */
    @Async("asyncThread")
    public void buildUnit3Param(DetailedForecastDto detailedForecastDto, ActivityDetailPlanItemDto item, UserIdentity loginUser) {
        loginUserService.refreshAuthentication(loginUser);
        log.info("细案编码[{}]明细编码[{}]细案预测垂直新增计算", detailedForecastDto.getDetailedCaseCode(), detailedForecastDto.getActivityDetailItemCode());
        if (TpmAuditTypeEnum.AUDITTYPE1.getCode().equals(item.getAuditType())) {
            AuditFormulaMainDto dto = new AuditFormulaMainDto();
            dto.setBusinessFormatCode(detailedForecastDto.getBusinessFormatCode());
            dto.setBusinessUnitCode(detailedForecastDto.getBusinessUnitCode());
            dto.setAuditType(item.getAuditType());
            dto.setSalesOrgCodes(detailedForecastDto.getSaleOrgCode());
            dto.setActivityFormCode(detailedForecastDto.getActivityFormCode());
            dto.setActivityTypeCode(detailedForecastDto.getActivityTypeCode());
            dto.setWriteOffMethod(detailedForecastDto.getWriteOffMethod());
            List<AuditFormulaMainVo> formulaMainVoList = auditFormulaMainService.findListByDto(dto);
            formulaMainVoList = formulaMainVoList.stream().filter(e -> CollectionUtils.isNotEmpty(e.getAuditFormulaInfoVoList())).collect(Collectors.toList());
            if (CollectionUtil.isNotEmpty(formulaMainVoList)) {
                //上面查核销公式的时候会处理，默认取第一条公式不为空的就可以了
                CalculateDto calDto = this.buildCalParam(formulaMainVoList.get(0), detailedForecastDto, TpmAuditTypeEnum.AUDITTYPE1.getCode());
                this.setParam(formulaMainVoList.get(0), detailedForecastDto, calDto);
            } else {
                detailedForecastDto.setAuditFormulaCode(null);
            }
        } else if (TpmAuditTypeEnum.AUDITTYPE2.getCode().equals(item.getAuditType())) {
            AuditFormulaMainVo auditFormulaMainVo = null;
            try {
                auditFormulaMainVo = auditFormulaMainService.findByCode(item.getAuditConditionCode());
            } catch (Exception e) {
                log.error("细案编码[" + detailedForecastDto.getDetailedCaseCode() + "]明细编码[" + detailedForecastDto.getActivityDetailItemCode() + "]细案预测垂直新增计算" + e.getMessage(), e);
            }
            CalculateDto calDto = this.buildCalParam(auditFormulaMainVo, detailedForecastDto, TpmAuditTypeEnum.AUDITTYPE2.getCode());
            this.setParam(auditFormulaMainVo, detailedForecastDto, calDto);
        } else if (TpmAuditTypeEnum.AUDITTYPE3.getCode().equals(item.getAuditType())) {
            detailedForecastDto.setWriteOffConditions(TpmAuditTypeEnum.AUDITTYPE3.getValue());
            detailedForecastDto.setEstimatedWriteOffAmount(item.getFeeAmount());
//            this.setCommonQueryParam(detailedForecastDto);
        } else {
//            throw new RuntimeException("细案编码[" + detailedForecastDto.getDetailedCaseCode() + "]细案预测生成计算失败：未知核销类型编码[" + item.getAuditType() + "]！");
        }
        this.verticalOperateBudget(null, detailedForecastDto);
        this.insert(detailedForecastDto);
    }

    /**
     * 电商
     *
     * @param detailedForecastDto
     * @param item
     * @param loginUser
     */
    @Async("asyncThread")
    public void buildUnit4Param(DetailedForecastDto detailedForecastDto, GeneralExpensesVo item,
                                UserIdentity loginUser) {
        loginUserService.refreshAuthentication(loginUser);
        log.info("促销规划编号[{}]明细编码[{}]细案预测垂直新增计算", detailedForecastDto.getDetailedCaseCode(), detailedForecastDto.getActivityDetailItemCode());
        if (StringUtils.isNotBlank(item.getMonthBudgetCode())) {
            detailedForecastDto.setBudgetCode(item.getMonthBudgetCode());
        } else {
            List<BusinessPolicyBudgetVo> budgetList = businessPolicyService.findBusinessPolicyBudget(item.getCommercePolicyCode());
            if (CollectionUtils.isNotEmpty(budgetList)) {
                detailedForecastDto.setBudgetCode(budgetList.get(0).getBudgetCode());
            }
        }
        //核销
        if (TpmAuditTypeEnum.AUDITTYPE2.getCode().equals(detailedForecastDto.getAuditType())) {
            AuditFormulaMainVo auditFormulaMainVo = null;
            try {
                auditFormulaMainVo = auditFormulaMainService.findByCode(item.getAuditConditionCode());
            } catch (Exception e) {
                log.error("细案编码[" + detailedForecastDto.getDetailedCaseCode() + "]明细编码[" + detailedForecastDto.getActivityDetailItemCode() + "]细案预测电商新增计算" + e.getMessage(), e);
            }
            if (Objects.nonNull(auditFormulaMainVo)
                    && CollectionUtil.isNotEmpty(auditFormulaMainVo.getAuditFormulaInfoVoList())) {
                CalculateDto calDto = this.buildCalParam(auditFormulaMainVo, detailedForecastDto, item.getAuditConditionType());
                this.setParam(auditFormulaMainVo, detailedForecastDto, calDto);
            }
        } else if (TpmAuditTypeEnum.AUDITTYPE1.getCode().equals(item.getAuditConditionType())) {
            AuditFormulaMainDto dto = new AuditFormulaMainDto();
            dto.setBusinessFormatCode(detailedForecastDto.getBusinessFormatCode());
            dto.setBusinessUnitCode(detailedForecastDto.getBusinessUnitCode());
            dto.setAuditType(detailedForecastDto.getAuditType());
            dto.setSalesOrgCodes(detailedForecastDto.getSaleOrgCode());
            dto.setActivityFormCode(detailedForecastDto.getActivityFormCode());
            dto.setActivityTypeCode(detailedForecastDto.getActivityTypeCode());
            dto.setWriteOffMethod(detailedForecastDto.getWriteOffMethod());
            List<AuditFormulaMainVo> formulaMainVoList = auditFormulaMainService.findListByDto(dto);
            formulaMainVoList = formulaMainVoList.stream().filter(e -> CollectionUtils.isNotEmpty(e.getAuditFormulaInfoVoList())).collect(Collectors.toList());
            if (CollectionUtil.isNotEmpty(formulaMainVoList)) {
                //上面查核销公式的时候会处理，默认取第一条公式不为空的就可以了
                CalculateDto calDto = this.buildCalParam(formulaMainVoList.get(0), detailedForecastDto, TpmAuditTypeEnum.AUDITTYPE1.getCode());
                this.setParam(formulaMainVoList.get(0), detailedForecastDto, calDto);
            } else {
                detailedForecastDto.setAuditFormulaCode(null);
            }
        } else if (TpmAuditTypeEnum.AUDITTYPE3.getCode().equals(item.getAuditConditionType())) {
            detailedForecastDto.setWriteOffConditions(TpmAuditTypeEnum.AUDITTYPE3.getValue());
            detailedForecastDto.setEstimatedWriteOffAmount(item.getApplyAmount());
        }
        this.insert(detailedForecastDto);
    }

    @Transactional(rollbackFor = Exception.class)
    public void refreshUpdate(DetailedForecastEntity entity,
                              ActivityDetailPlanItemVo detailPlanItemVo,
                              Map<String, ProductVo> productVoMap, UserIdentity loginUser,
                              Map<String, AuditExecuteIndicatorVo> finalAuditExecuteIndicatorMap) {
        loginUserService.refreshAuthentication(loginUser);
        DetailedForecastDto dto = nebulaToolkitService.copyObjectByWhiteList(entity, DetailedForecastDto.class, HashSet.class, ArrayList.class);
        this.refreshCal(dto);
        this.verticalOperateBudget(entity, dto);
        if(BusinessUnitEnum.VERTICAL.getCode().equals(entity.getBusinessUnitCode())){
            AuditExecuteIndicatorVo auditExecuteIndicatorVo = finalAuditExecuteIndicatorMap.get(entity.getActivityDetailItemCode());
            if(auditExecuteIndicatorVo!=null){
                entity.setMinusCompostQuantity(auditExecuteIndicatorVo.getIndicatorValue());
            }
        }
        entity.setWriteOffConditions(dto.getWriteOffConditions());
        entity.setWriteOffFormula(dto.getWriteOffFormula());
        entity.setWriteOffConditionValue(dto.getWriteOffConditionValue());
        entity.setWriteOffFormulaValue(dto.getWriteOffFormulaValue());
        entity.setEstimatedWriteOffAmount(dto.getEstimatedWriteOffAmount());
        entity.setWriteOffPremise(dto.getWriteOffPremise());
        entity.setAuditFormulaCode(dto.getAuditFormulaCode());
        entity.setCalEx(dto.getCalEx());
        entity.setCalParam(dto.getCalParam());
        entity.setOverBudgetRemark(dto.getOverBudgetRemark());
        entity.setOverBudgetFailAmount(dto.getOverBudgetFailAmount());
        entity.setOverBudgetSuccess(dto.getOverBudgetSuccess());
        entity.setHeadFeeAmount(dto.getHeadFeeAmount());
        entity.setDepartmentFeeAmount(dto.getDepartmentFeeAmount());
        entity.setOverBudgetAmount(dto.getOverBudgetAmount());
        //查询是否完全结案
        if (!StringUtils.isBlank(dto.getActivityDetailItemCode())) {
            DetailedForecastCallAuditEventDto eventDto = new DetailedForecastCallAuditEventDto();
            eventDto.setActivityDetailItemCode(dto.getActivityDetailItemCode());
            SerializableBiConsumer<DetailedForecastCallAuditListener, DetailedForecastCallAuditEventDto> getWholeAudit =
                    DetailedForecastCallAuditListener::selectWholeAuditFromAuditByActivityCode;
            CallAuditResponse response = (CallAuditResponse) this.nebulaNetEventClient.directPublish(eventDto, DetailedForecastCallAuditListener.class, getWholeAudit);
            if (!Objects.isNull(response)) {
                entity.setWholeAudit(response.getWholeAudit());
            }
        }
        if (Objects.nonNull(detailPlanItemVo)) {
            entity.setProductCode(detailPlanItemVo.getProductCode());
            ProductVo productVo = productVoMap.get(entity.getProductCode());
            if (Objects.nonNull(productVo)) {
                entity.setProductName(productVo.getProductName());
                entity.setProductBrandCode(productVo.getProductBrandCode());
                entity.setProductBrandName(productVo.getProductBrandName());
                entity.setProductCategoryCode(productVo.getProductCategoryCode());
                entity.setProductCategoryName(productVo.getProductCategoryName());
                entity.setProductItemCode(productVo.getProductLevelCode());
                entity.setProductItemName(productVo.getProductLevelName());
            }
        }

        if (StringUtils.isEmpty(entity.getOnlyKey())) {
            entity.setOnlyKey(this.packageOnlyKey(entity, null));
        }
        this.detailedForecastRepository.updateById(entity);
    }

    /**
     * 垂直单元：若预核销金额超出申请金额，补占预算
     * 1、更新时：如果上次扣减预算失败，历史计算出的预估核销金额 = 预估超额扣减预算失败时，记录上一次预估核销金额；否则取上一次预估核销金额
     * 2、只有当本次计算出的预估核销金额大于申请金额 或 上一次计算出的预估核销金额大于申请金额时，才操作预算接口
     * 3、上一次超额，本次继续超额，扣，正数，操作金额 = 本次预估核销金额-上次预估核销金额；
     * 上一次没超额，本次超额，扣，正数，操作金额 = 本次预估核销金额-申请金额；
     * 上一次超额，本次没超额，退，负数，操作金额 = 上次预估核销金额-申请金额
     * 4、操作金额为0不操作预算
     * 5、操作预算，捕获异常，异常时修改 overBudgetFailAmount 和 overBudgetSuccess 两个字段的值
     * overBudgetFailAmount：如果上一次也是失败，不更新这个字段的值，否则更新为本次计算的预估核销金额
     * overBudgetSuccess：异常改为N，正常改为Y
     * <p>
     * 2023-04-02调整逻辑：申请时有自投，补占时占自投，否则占自投的产品促销。自投的产品促销预算通过 ”细案上的区域+零售商+费用所属年月+自投+产品促销“ 去匹配
     * 总部+公投+自投：补占自投
     * 总部+自投：补占自投
     * 共投+自投：补占自投
     * 总部+公投：补占自投的产品促销
     * 公投：补占自投的产品促销
     * 总部：补占自投的产品促销
     *
     * @param entity 上一次计算数据 新增为null，更新有值
     * @param dto    本次计算数据
     */
    public void verticalOperateBudget(DetailedForecastEntity entity, DetailedForecastDto dto) {
        if (!StringUtils.equals(BusinessUnitEnum.VERTICAL.getCode(), dto.getBusinessUnitCode())) {
            return;
        }
        //申请金额
        BigDecimal applyAmount = Objects.nonNull(dto.getApplyAmount()) ? dto.getApplyAmount() : BigDecimal.ZERO;
        //本次计算出的预估核销金额
        BigDecimal newOperateAmount = Objects.nonNull(dto.getEstimatedWriteOffAmount()) ? dto.getEstimatedWriteOffAmount() : BigDecimal.ZERO;
        //上一次计算出的预估核销金额
        BigDecimal oldOperateAmount = BigDecimal.ZERO;

        //1、
        if (Objects.nonNull(entity) && StringUtils.equals(YesOrNoEnum.NO.getCode(), entity.getOverBudgetSuccess())) {
            oldOperateAmount = Objects.nonNull(entity.getOverBudgetFailAmount()) ? entity.getOverBudgetFailAmount() : BigDecimal.ZERO;
        } else if (Objects.nonNull(entity)) {
            oldOperateAmount = Objects.nonNull(entity.getEstimatedWriteOffAmount()) ? entity.getEstimatedWriteOffAmount() : BigDecimal.ZERO;
        }

        //2、
        log.error("verticalOperateBudget===>applyAmount===>" + applyAmount);
        log.error("verticalOperateBudget===>newOperateAmount===>" + newOperateAmount);
        log.error("verticalOperateBudget===>oldOperateAmount===>" + oldOperateAmount);
        if (applyAmount.compareTo(oldOperateAmount) > 0 && applyAmount.compareTo(newOperateAmount) > 0) {
            return;
        }

        //3、
        BigDecimal operateAmount = BigDecimal.ZERO;
        if (applyAmount.compareTo(oldOperateAmount) < 0 && applyAmount.compareTo(newOperateAmount) < 0) {
            operateAmount = newOperateAmount.subtract(oldOperateAmount);
        } else if (applyAmount.compareTo(oldOperateAmount) >= 0 && applyAmount.compareTo(newOperateAmount) < 0) {
            operateAmount = newOperateAmount.subtract(applyAmount);
        } else if (applyAmount.compareTo(oldOperateAmount) < 0 && applyAmount.compareTo(newOperateAmount) >= 0) {
            operateAmount = applyAmount.subtract(oldOperateAmount);
        }

        //4、
        log.error("verticalOperateBudget===>operateAmount===>" + operateAmount);
        if (BigDecimal.ZERO.compareTo(operateAmount) == 0) {
            return;
        }

        //5、
        String overBudgetSuccess = YesOrNoEnum.YES.getCode();
        BigDecimal overBudgetFailAmount = dto.getEstimatedWriteOffAmount();
        List<ActivityDetailPlanBudgetVo> budgetVos = detailedForecastMapper.findActivityDetailBudgetCodes(dto.getActivityDetailItemCode(), TenantUtils.getTenantCode());
        List<String> budgetCodes = budgetVos.stream().map(ActivityDetailPlanBudgetVo::getMonthBudgetCode).distinct().collect(Collectors.toList());
        try {
            Validate.notEmpty(budgetVos, "未获取到活动细案明细关联预算");
            boolean lock = monthBudgetLockService.lock(budgetCodes, TimeUnit.SECONDS, 30, 60);
            Validate.isTrue(lock, "操作预算失败，获取操作锁失败！");
            //排序使用的预算，按照优先级补占、退，当前逻辑：使用金额最大的预算，金额相同，录入最早的预算（按预算编码）
            List<String> useBudgetCodeList = this.getBudgetSortList(budgetVos);
            List<OperateMonthBudgetDto> operateVos = this.buildOperateList(operateAmount, dto, useBudgetCodeList);
            monthBudgetService.operateBudget(operateVos);
            dto.setOverBudgetAmount(dto.getEstimatedWriteOffAmount().subtract(dto.getApplyAmount()));
            dto.setOverBudgetRemark("");
        } catch (Exception e) {
            e.printStackTrace();
            String exMsg = "垂直单元-细案预测-补占预算异常：" + e.getMessage();
            if (exMsg.length() > 300) {
                exMsg = exMsg.substring(0, 300);
            }
            dto.setOverBudgetRemark(exMsg);
            overBudgetSuccess = YesOrNoEnum.NO.getCode();
        } finally {
            monthBudgetLockService.unLock(budgetCodes);
        }
        if (StringUtils.equals(YesOrNoEnum.NO.getCode(), overBudgetSuccess)) {
            if (Objects.nonNull(entity) && StringUtils.equals(YesOrNoEnum.NO.getCode(), entity.getOverBudgetSuccess())) {
                overBudgetFailAmount = entity.getOverBudgetFailAmount();
            } else if (Objects.nonNull(entity)) {
                overBudgetFailAmount = entity.getEstimatedWriteOffAmount();
            } else {
                overBudgetFailAmount = BigDecimal.ZERO;
            }
        }
        dto.setOverBudgetFailAmount(overBudgetFailAmount);
        dto.setOverBudgetSuccess(overBudgetSuccess);
    }

    /**
     * 使用预算排序
     * 补占使用金额最高的预算；金额相同，补占预算录入最早的预算（按预算编码）
     *
     * @param budgetVos
     * @return
     */
    public List<String> getBudgetSortList(List<ActivityDetailPlanBudgetVo> budgetVos) {
        Validate.notEmpty(budgetVos, "细案预测补占预算-使用预算为空！");
        List<ActivityDetailPlanBudgetVo> sortedList = budgetVos.stream()
                .filter(e -> Objects.nonNull(e.getUseAmount()) && VerticalFeeBelongCodeEnum.REGION_AUTOMATIC.getCode().equals(e.getFeeBelongCode()))
                .sorted(Comparator.comparing(ActivityDetailPlanBudgetVo::getUseAmount).reversed()).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(sortedList)) {
            return Lists.newArrayList();
        }
        BigDecimal useAmount = sortedList.get(0).getUseAmount();
        Map<BigDecimal, List<String>> sortedMap = sortedList.stream().collect(Collectors.groupingBy(ActivityDetailPlanBudgetVo::getUseAmount, Collectors.mapping(ActivityDetailPlanBudgetVo::getMonthBudgetCode, Collectors.toList())));
        List<String> budgetCodes = sortedMap.get(useAmount);
        Collections.sort(budgetCodes);
        return Lists.newArrayList(budgetCodes.get(0));
    }

    /**
     * 补占预算参数构建
     *
     * @return
     */
    public List<OperateMonthBudgetDto> buildOperateList(BigDecimal operateAmount, DetailedForecastDto dto, List<String> budgetCodes) {
        List<MonthBudgetVo> budgetVos = monthBudgetService.findByCodes(budgetCodes, EnableStatusEnum.ENABLE.getCode());
        if (CollectionUtils.isEmpty(budgetVos)) {
            budgetVos = Lists.newArrayList();
        }
        Map<String, List<MonthBudgetVo>> budgetVosMap = budgetVos.stream()
                .filter(e -> StringUtils.isNotEmpty(e.getFeeBelongCode()))
                .collect(Collectors.groupingBy(MonthBudgetVo::getFeeBelongCode));
        List<MonthBudgetVo> automaticVos = budgetVosMap.getOrDefault(VerticalFeeBelongCodeEnum.REGION_AUTOMATIC.getCode(), Lists.newArrayList());
//        List<MonthBudgetVo> referendumVos = budgetVosMap.getOrDefault(VerticalFeeBelongCodeEnum.REGION_REFERENDUM.getCode(), Lists.newArrayList());
        List<OperateMonthBudgetDto> operateVos = new ArrayList<>();
        AtomicReference<BigDecimal> atomicOperateAmount = new AtomicReference<>(operateAmount);
        if (BigDecimal.ZERO.compareTo(atomicOperateAmount.get()) > 0) {
            //退 按实际产生明细退
            List<MonthBudgetDetailVo> detailVos = detailedForecastMapper.findBudgetDetailByBusinessCode(dto.getActivityDetailItemCode(),
                    TenantUtils.getTenantCode());
            Map<String, List<MonthBudgetDetailVo>> detailVosMap = detailVos.stream()
                    .filter(e -> BigDecimal.ZERO.compareTo(e.getCurOperationAmount()) < 0)
                    .collect(Collectors.groupingBy(MonthBudgetDetailVo::getMonthBudgetCode));
            this.release(dto, operateVos, atomicOperateAmount, detailVosMap);
            Validate.isTrue(BigDecimal.ZERO.compareTo(atomicOperateAmount.get()) == 0, "预估超额返还预算错误，剩余待返还：%s", atomicOperateAmount.get().abs());
        } else {
            //2023-04-07取消补占公投
            //占 先公投、后自投，占自投需要区分使用的费用归口，不包含费用归口为自投的，只能占用费用归口为自投，预算项目为产品促销[KAYS030004]的预算
//            this.occupy(dto, operateVos, referendumVos, atomicOperateAmount, null);//公投
            //匹配 自投的产品促销 预算
            automaticVos = this.budgetProductProList(dto, automaticVos, budgetVos);
            List<String> budgetProjectCodes = this.filterBudgetProjectCodes(budgetVos);
            automaticVos = this.filterByProjectCodes(automaticVos, budgetProjectCodes);
            this.occupy(dto, operateVos, automaticVos, atomicOperateAmount, budgetProjectCodes);//自投
//            Validate.isTrue(BigDecimal.ZERO.compareTo(atomicOperateAmount.get()) == 0, "预估超额扣减预算不足，差异：%s", atomicOperateAmount.get());
        }
        return operateVos;
    }

    /**
     * 匹配 自投的产品促销 预算
     *
     * @param dto
     * @param automaticVos
     * @return
     */
    public List<MonthBudgetVo> budgetProductProList(DetailedForecastDto dto, List<MonthBudgetVo> automaticVos, List<MonthBudgetVo> budgetVos) {
        Set<String> feeBelongCodeSet = budgetVos.stream().filter(e -> StringUtils.isNotEmpty(e.getFeeBelongCode())).map(MonthBudgetVo::getFeeBelongCode).collect(Collectors.toSet());
        if (feeBelongCodeSet.contains(VerticalFeeBelongCodeEnum.REGION_AUTOMATIC.getCode())) {
            return automaticVos;
        }
        Validate.notBlank(dto.getSystemCode(), "匹配自投产品促销预算：零售商编码为空！");
        Validate.notBlank(dto.getRegion(), "匹配自投产品促销预算：区域编码为空！");
        Validate.notBlank(dto.getYearMonthStr(), "匹配自投产品促销预算：费用所属年月为空！");
        automaticVos = detailedForecastMapper.findBudgetProductProList(dto, TenantUtils.getTenantCode(), VerticalFeeBelongCodeEnum.REGION_AUTOMATIC.getCode(), DetailedForecastBudgetProjectConstants.PRODUCT_PRO);
        return automaticVos;
    }

    /**
     * 返回需要过滤的预算项目编码，返回空表示不过滤
     * 目前只要没有自投，就返回预算项目-产品促销[KAYS030004]
     * 总部+公投+自投：补占自投
     * 总部+自投：补占自投
     * 共投+自投：补占自投
     * 总部+公投：补占自投的产品促销
     * 公投：补占自投的产品促销
     * 总部：补占自投的产品促销
     *
     * @param budgetVos
     * @return
     */
    public List<String> filterBudgetProjectCodes(List<MonthBudgetVo> budgetVos) {
        Set<String> feeBelongCodeSet = budgetVos.stream().filter(e -> StringUtils.isNotEmpty(e.getFeeBelongCode())).map(MonthBudgetVo::getFeeBelongCode).collect(Collectors.toSet());
        if (feeBelongCodeSet.size() == 0) {
            return Lists.newArrayList();
        }
        if (!feeBelongCodeSet.contains(VerticalFeeBelongCodeEnum.REGION_AUTOMATIC.getCode())) {
            //
            return Lists.newArrayList(DetailedForecastBudgetProjectConstants.PRODUCT_PRO);

        }
        return Lists.newArrayList();
    }

    public List<MonthBudgetVo> filterByProjectCodes(List<MonthBudgetVo> vos, List<String> budgetProjectCodes) {
        vos = vos.stream()
                .filter(e -> CollectionUtils.isEmpty(budgetProjectCodes) || budgetProjectCodes.contains(e.getBudgetItemCode()))
                .collect(Collectors.toList());
        Validate.notEmpty(vos, "未匹配到预算项目为[自投产品促销]的预算！");
        return vos;
    }

    @Transactional
    public void releaseVerticalBudget(List<String> businessCodeList) {
        if (CollectionUtils.isEmpty(businessCodeList)) {
            return;
        }
        List<MonthBudgetDetailVo> detailVos = monthBudgetService.findDetailByBusinessCodes(businessCodeList);
        if (CollectionUtils.isEmpty(detailVos)) {
            return;
        }
        List<String> budgetCodes = detailVos.stream().map(MonthBudgetDetailVo::getMonthBudgetCode).distinct().collect(Collectors.toList());
        boolean lock = monthBudgetLockService.lock(budgetCodes, TimeUnit.SECONDS, 10);
        Validate.isTrue(lock, "操作预算失败，获取操作锁失败！");
        try {
            List<OperateMonthBudgetDto> operateMonthBudgetDtos = new ArrayList<>();
            Map<String, List<MonthBudgetDetailVo>> map1 = detailVos.stream().collect(Collectors.groupingBy(MonthBudgetDetailVo::getBusinessCode));
            map1.forEach((businessCode, v1) -> {
                Map<String, List<MonthBudgetDetailVo>> map2 = detailVos.stream().collect(Collectors.groupingBy(MonthBudgetDetailVo::getMonthBudgetCode));
                map2.forEach((budgetCode, v2) -> {
                    BigDecimal amount = v2.stream().map(MonthBudgetDetailVo::getCurOperationAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
                    OperateMonthBudgetDto dto = new OperateMonthBudgetDto();
                    dto.setOperationType(BudgetOperationTypeEnum.FORECAST_OVER.getCode());
                    dto.setMonthBudgetCode(budgetCode);
                    dto.setBusinessCode(businessCode);
                    dto.setOperationAmount(amount.negate());
                    operateMonthBudgetDtos.add(dto);
                });
            });
            this.monthBudgetService.operateBudget(operateMonthBudgetDtos);
        } finally {
            monthBudgetLockService.unLock(budgetCodes);
        }
    }

    //释放
    public void release(DetailedForecastDto dto, List<OperateMonthBudgetDto> operateVos,
                        AtomicReference<BigDecimal> atomicOperateAmount, Map<String, List<MonthBudgetDetailVo>> detailVosMap) {
        for (Map.Entry<String, List<MonthBudgetDetailVo>> entry : detailVosMap.entrySet()) {
            if (BigDecimal.ZERO.compareTo(atomicOperateAmount.get().abs()) >= 0) {
                break;
            }
            String monthBudgetCode = entry.getKey();
            List<MonthBudgetDetailVo> list = entry.getValue();
            for (MonthBudgetDetailVo detailVo : list) {
                if (BigDecimal.ZERO.compareTo(atomicOperateAmount.get().abs()) >= 0) {
                    break;
                }
                OperateMonthBudgetDto budgetDto = new OperateMonthBudgetDto();
                budgetDto.setMonthBudgetCode(monthBudgetCode);
                budgetDto.setOperationType(BudgetOperationTypeEnum.FORECAST_OVER.getCode());
                budgetDto.setBusinessCode(dto.getActivityDetailItemCode());
                if (atomicOperateAmount.get().abs().compareTo(detailVo.getCurOperationAmount()) >= 0) {
                    budgetDto.setOperationAmount(detailVo.getCurOperationAmount().negate());
                    atomicOperateAmount.set(atomicOperateAmount.get().add(detailVo.getCurOperationAmount()));
                } else {
                    budgetDto.setOperationAmount(atomicOperateAmount.get());
                    atomicOperateAmount.set(BigDecimal.ZERO);
                }
                operateVos.add(budgetDto);
            }
        }
    }

    /**
     * 占用
     *
     * @param dto                 补占预算的细案预测对象
     * @param operateVos          预算操作对象集合
     * @param vos                 预算集合
     * @param atomicOperateAmount 剩余待补占金额
     * @param budgetProjectCodes  限制预算项目，为空不限制
     */
    public void occupy(DetailedForecastDto dto, List<OperateMonthBudgetDto> operateVos, List<MonthBudgetVo> vos,
                       AtomicReference<BigDecimal> atomicOperateAmount, List<String> budgetProjectCodes) {
        vos.sort(Comparator.comparing(MonthBudgetVo::getMonthBudgetCode));
        int index = 0;
        for (MonthBudgetVo vo : vos) {
            index++;
            if (BigDecimal.ZERO.compareTo(atomicOperateAmount.get()) >= 0) {
                break;
            }

            OperateMonthBudgetDto budgetDto = new OperateMonthBudgetDto();
            budgetDto.setMonthBudgetCode(vo.getMonthBudgetCode());
            budgetDto.setOperationType(BudgetOperationTypeEnum.FORECAST_OVER.getCode());
            budgetDto.setBusinessCode(dto.getActivityDetailItemCode());
            if (vo.getAccumulatedAvailableBalance().compareTo(BigDecimal.ZERO) >= 0
                    && atomicOperateAmount.get().compareTo(vo.getAccumulatedAvailableBalance()) >= 0
                    && index != vos.size()) {
                budgetDto.setOperationAmount(vo.getAccumulatedAvailableBalance());
                atomicOperateAmount.set(atomicOperateAmount.get().subtract(vo.getAccumulatedAvailableBalance()));
            } else {
                budgetDto.setOperationAmount(atomicOperateAmount.get());
                atomicOperateAmount.set(BigDecimal.ZERO);
            }
            operateVos.add(budgetDto);
        }
    }

    /**
     * 更新
     *
     * @param detailedForecastDto
     */
    public void refreshCal(DetailedForecastDto detailedForecastDto) {
        log.info("细案编码[{}]明细编码[{}]细案预测更新计算", detailedForecastDto.getDetailedCaseCode(), detailedForecastDto.getActivityDetailItemCode());

        detailedForecastDto.setWriteOffConditions("");
        detailedForecastDto.setWriteOffConditionValue("");
        detailedForecastDto.setWriteOffFormula("");
        detailedForecastDto.setWriteOffFormulaValue("");
        detailedForecastDto.setWriteOffPremise("");
        detailedForecastDto.setEstimatedWriteOffAmount(null);
        detailedForecastDto.setCalEx("");
        detailedForecastDto.setCalParam("");
        detailedForecastDto.setOverBudgetRemark("");

        if (TpmAuditTypeEnum.AUDITTYPE3.getCode().equals(detailedForecastDto.getAuditType())
                ||
                (StringUtils.equals(BusinessUnitEnum.SON_COMPANY.getCode(), detailedForecastDto.getBusinessUnitCode())
                        && (StringUtils.isEmpty(detailedForecastDto.getAuditType()) || "null".equals(detailedForecastDto.getAuditType()))) //分子公司特殊处理，那边核销类型是自己定义的
        ) {
            if (StringUtils.equals(BusinessUnitEnum.HEADQUARTERS.getCode(), detailedForecastDto.getBusinessUnitCode())
                    || StringUtils.equals(BusinessUnitEnum.VERTICAL.getCode(), detailedForecastDto.getBusinessUnitCode())) {
                List<ActivityDetailPlanItemVo> detailPlanItemVos = activityDetailPlanItemSdkService.listByItemCodeList(Lists.newArrayList(detailedForecastDto.getActivityDetailItemCode()));
                Validate.notEmpty(detailPlanItemVos, "细案明细编码[%s]数据不存在！", detailedForecastDto.getActivityDetailItemCode());
                detailedForecastDto.setEstimatedWriteOffAmount(detailPlanItemVos.get(0).getFeeAmount());
//                this.setCommonQueryParam(detailedForecastDto, paramMap);
            } else if (StringUtils.equals(BusinessUnitEnum.SON_COMPANY.getCode(), detailedForecastDto.getBusinessUnitCode())) {
                List<SubComActivityDetailPlanItemVo> detailPlanItemVos = activityConstituentDetailPlanItemVoService.findDetailByItemCodeList(Lists.newArrayList(detailedForecastDto.getActivityDetailItemCode()));
                Validate.notEmpty(detailPlanItemVos, "细案明细编码[%s]数据不存在！", detailedForecastDto.getActivityDetailItemCode());
                detailedForecastDto.setEstimatedWriteOffAmount(detailPlanItemVos.get(0).getTotalCost());
//                this.setCommonQueryParam(detailedForecastDto, paramMap);
            } else if (StringUtils.equals(BusinessUnitEnum.ONLINE.getCode(), detailedForecastDto.getBusinessUnitCode())) {
                List<GeneralExpensesVo> generalExpensesVos = generalExpensesService.findByExpensesCode(Lists.newArrayList(detailedForecastDto.getActivityDetailItemCode()));
                Validate.notEmpty(generalExpensesVos, "细案明细编码[%s]数据不存在！", detailedForecastDto.getActivityDetailItemCode());
                detailedForecastDto.setEstimatedWriteOffAmount(generalExpensesVos.get(0).getApplyAmount());
//                this.setCommonQueryParam(detailedForecastDto, paramMap);
            }
        } else {
            AuditFormulaMainVo auditFormulaMainVo = null;
            try {
                auditFormulaMainVo = auditFormulaMainService.findByCode(detailedForecastDto.getAuditFormulaCode());
            } catch (Exception e) {
                log.error("细案编码[" + detailedForecastDto.getDetailedCaseCode() + "]明细编码[" + detailedForecastDto.getActivityDetailItemCode() + "]细案预测更新计算！" + e.getMessage(), e);
            }
            if (TpmAuditTypeEnum.AUDITTYPE1.getCode().equals(detailedForecastDto.getAuditType())) {
                AuditFormulaMainDto dto = new AuditFormulaMainDto();
                dto.setBusinessFormatCode(detailedForecastDto.getBusinessFormatCode());
                dto.setBusinessUnitCode(detailedForecastDto.getBusinessUnitCode());
                dto.setAuditType(detailedForecastDto.getAuditType());
                dto.setSalesOrgCodes(detailedForecastDto.getSaleOrgCode());
                dto.setActivityFormCode(detailedForecastDto.getActivityFormCode());
                dto.setActivityTypeCode(detailedForecastDto.getActivityTypeCode());
                dto.setCustomerTypes(detailedForecastDto.getRtmMode());
                dto.setFirstChannel(detailedForecastDto.getFirstChannelCode());
                dto.setSecondChannel(detailedForecastDto.getSecondChannelCode());
                dto.setCustomerAccount(detailedForecastDto.getCustomerAccount());
                dto.setDisplayNumber(detailedForecastDto.getDisplayNumber());
                dto.setWriteOffMethod(detailedForecastDto.getWriteOffMethod());
                List<AuditFormulaMainVo> formulaMainVoList = auditFormulaMainService.findListByDto(dto);
                formulaMainVoList = formulaMainVoList.stream().filter(e -> CollectionUtils.isNotEmpty(e.getAuditFormulaInfoVoList())).collect(Collectors.toList());
                if (CollectionUtil.isNotEmpty(formulaMainVoList)) {
                    //上面查核销公式的时候会处理，默认取第一条公式不为空的就可以了
                    auditFormulaMainVo = formulaMainVoList.get(0);
                } else {
                    detailedForecastDto.setAuditFormulaCode(null);
                }
            }
            CalculateDto calDto = this.buildCalParam(auditFormulaMainVo, detailedForecastDto, detailedForecastDto.getAuditType());
            this.setParam(auditFormulaMainVo, detailedForecastDto, calDto);
        }
    }

    /**
     * 公式计算请求参数构建
     * paramMap 参数说明：
     * productCode：产品编码
     * productCode：产品编码
     * yearMonthStr：年月
     * terminalCode：门店编码
     * terminalName：门店名称
     * productBrandCode：品牌编码
     * productBrandName：品牌名称
     * productCategoryCode：大类编码
     * productCategoryName：大类名称
     * productItemCode：品项编码
     * productItemName：品项名称
     * activitiesDetailCode：活动明细编码
     * region：区域
     * channelCode：渠道编码
     * channelName：渠道名称
     * planItemCode：方案活动明细编码、促销规划明细编码、分子公司活动细案明细编码
     * detailPlanItemCode：活动细案明细编码
     *
     * @param auditFormulaMainVo
     * @param detailedForecastDto
     * @param auditType
     * @return
     */
    public CalculateDto buildCalParam(AuditFormulaMainVo auditFormulaMainVo, DetailedForecastDto detailedForecastDto, String auditType) {
        if (Objects.nonNull(auditFormulaMainVo) && CollectionUtil.isNotEmpty(auditFormulaMainVo.getAuditFormulaInfoVoList())) {
            CalculateDto dto = new CalculateDto();
            dto.setCode(auditFormulaMainVo.getAuditFormulaCode());
            dto.setAuditFormulaCode(auditFormulaMainVo.getAuditFormulaCode());
            dto.setCustomerCode(detailedForecastDto.getCustomerCode());
            dto.setCustomerErpCode(detailedForecastDto.getCustomerErpCode());
            dto.setCustomerName(detailedForecastDto.getCustomer());
            dto.setBusinessFormatCode(detailedForecastDto.getBusinessFormatCode());
            dto.setBusinessUnitCode(detailedForecastDto.getBusinessUnitCode());
            dto.setActivityTypeCode(detailedForecastDto.getActivityTypeCode());
            dto.setActivityTypeName(detailedForecastDto.getActivityTypeName());
            dto.setActivityFormCode(detailedForecastDto.getActivityFormCode());
            dto.setActivityFormName(detailedForecastDto.getActivityFormName());
            dto.setStartTimeOrDate(detailedForecastDto.getActivityStartTime());
            dto.setEndTimeOrDate(detailedForecastDto.getActivityEndTime());
            dto.setFormulaInfoDtoList(this.copyFormulaInfoList(auditFormulaMainVo.getAuditFormulaInfoVoList()));
            dto.setAuditType(auditType);
            dto.setSalesOrgCode(detailedForecastDto.getSaleOrgCode());
            dto.setSalesOrgErpCode(detailedForecastDto.getSalesOrgErpCode());
            dto.setSalesOrganizationCode(detailedForecastDto.getSalesInstitutionCode());
            dto.setSalesOrganizationErpCode(detailedForecastDto.getSalesInstitutionErpCode());
            dto.setSalesRegionCode(detailedForecastDto.getSalesRegionCode());
            dto.setSalesRegionErpCode(detailedForecastDto.getSalesRegionErpCode());
            dto.setSalesGroupCode(detailedForecastDto.getSalesGroupCode());
            dto.setSalesGroupErpCode(detailedForecastDto.getSalesOrgErpCode());
            dto.setProductCode(detailedForecastDto.getProductCode());
            dto.setYearMonthLy(detailedForecastDto.getYearMonthStr());
            dto.setStoresCode(detailedForecastDto.getTerminalCode());
            dto.setBrandCode(detailedForecastDto.getProductBrandCode());
            dto.setCategoryCode(detailedForecastDto.getProductCategoryCode());
            dto.setItemCode(detailedForecastDto.getProductItemCode());
            dto.setDetailPlanItemCode(detailedForecastDto.getActivityDetailItemCode());
            dto.setActivityDetailItemCode(detailedForecastDto.getActivityDetailItemCode());
            dto.setPlanItemCode(detailedForecastDto.getDetailedCaseCode());
            dto.setActivityOrgCode(detailedForecastDto.getRegion());
            dto.setActivityOrgName(detailedForecastDto.getRegionName());
            dto.setRetailBusinessmanCode(detailedForecastDto.getSystemCode());
            dto.setRetailBusinessmanName(detailedForecastDto.getSystemName());
            dto.setActivityTypeCode(detailedForecastDto.getActivityTypeCode());
            dto.setActivityFormCode(detailedForecastDto.getActivityFormCode());
            dto.setPersonCode(detailedForecastDto.getPersonCode());
            dto.setIdentityCard(detailedForecastDto.getIdentityCard());
            dto.setSecondChannelCode(detailedForecastDto.getSecondChannelCode());
            dto.setEstoreCustomerLevel(detailedForecastDto.getEstoreCustomerLevel());
            if (Objects.nonNull(detailedForecastDto.getActivityStartTime())) {
                String date = DateUtil.format(detailedForecastDto.getActivityStartTime(), DateUtil.DEFAULT_YEAR_MONTH_DAY);
                //长度为10满足yyyy-MM-dd
                if (date.length() == 10) {
                    dto.setDate(DateUtil.parse(date, DateUtil.DEFAULT_YEAR_MONTH_DAY));
                }
                //长度为19满足yyyy-MM-dd HH:mm:ss
                else if (date.length() == 19) {
                    dto.setDate(DateUtil.parse(date, DateUtil.DEFAULT_DATE_ALL_PATTERN));
                }
            }

            dto.setDealerCode(detailedForecastDto.getCustomerErpCode());
            dto.setChannel(detailedForecastDto.getChannelCode());
            dto.setStartTimeOrDate(detailedForecastDto.getActivityStartTime());
            dto.setEndTimeOrDate(detailedForecastDto.getActivityEndTime());
            dto.setPersonIdCard(detailedForecastDto.getIdentityCard());
            dto.setFirstChannelCode(detailedForecastDto.getFirstChannelCode());
            dto.setSecondChannelCode(detailedForecastDto.getSecondChannelCode());
            dto.setHeadBudgetItemCode(detailedForecastDto.getHeadBudgetItemCode());
            dto.setMonthBudgetCode(detailedForecastDto.getMonthBudgetCode());
            dto.setSpecification(detailedForecastDto.getFormDescription());
            dto.setIsTemporary(detailedForecastDto.getIsTemporary());
            dto.setCusCreateTime(detailedForecastDto.getCusCreateTime());
            dto.setDistributionChannel(detailedForecastDto.getDistributionChannelCode());
            dto.setDeliveryPartyCode(detailedForecastDto.getTerminalCode());

            //合并客户编码-主体
            if (StringUtils.isNotEmpty(dto.getCustomerCode()) && BusinessUnitEnum.isDefaultBusinessUnit(dto.getBusinessUnitCode())) {
                Map<String, Set<String>> map = tpmCustomerSummaryConfigureService.configureIncludeMap(Lists.newArrayList(dto.getCustomerCode()));
                if (map.containsKey(dto.getCustomerCode())) {
                    dto.setCustomerCodeList(map.get(dto.getCustomerCode()));
                } else {
                    dto.setCustomerCodeList(Sets.newHashSet(dto.getCustomerCode()));
                }
            }
            return dto;
        } else {
            log.info("细案预测=====》核销条件为空");
        }
        return null;
    }

    /**
     * 公式参数计算组装
     *
     * @param auditFormulaMainVo
     * @param detailedForecastDto
     * @param calDto
     */
    public void setParam(AuditFormulaMainVo auditFormulaMainVo, DetailedForecastDto detailedForecastDto, CalculateDto calDto) {
        if (Objects.isNull(calDto)) {
            return;
        }
        detailedForecastDto.setCalEx("");
        List<CalculateVo> calculateVos = Lists.newArrayList();
        try {
//            calculateVos = variableService.allCalculateConditionAndExpression(Lists.newArrayList(calDto));
            calculateVos = variableService.orCalculateConditionAndExpression(Lists.newArrayList(calDto));
        } catch (Exception ex) {
            if (StringUtils.isNotEmpty(ex.getMessage())) {
                int length = Math.min(ex.getMessage().length(), 200);
                detailedForecastDto.setCalEx(ex.getMessage().substring(0, length));
            } else {
                detailedForecastDto.setCalEx("NPE");
            }
            log.error("细案编码[{}]明细编码[{}]细案预测计算失败：{}", detailedForecastDto.getDetailedCaseCode(), detailedForecastDto.getActivityDetailItemCode(), ex.getMessage());
            log.error("", ex);
        }

        //公式条件满足的计算结果
        AtomicReference<String> filterCondition = new AtomicReference<>();
        List<CalculateVo> filterVos = calculateVos.stream().filter(CalculateVo::getFormulaConditionValue).collect(Collectors.toList());
        if (filterVos.size() > 1) {
            log.error("核销公式编码 [" + auditFormulaMainVo.getAuditFormulaCode() + "] 计算结果：多个核销公式条件同时满足！");
        } else if (CollectionUtils.isNotEmpty(filterVos)) {
            filterCondition.set(filterVos.get(0).getFormulaConditionName());
        }
        //预估核销金额
        BigDecimal estimatedWriteOffAmount = BigDecimal.ZERO;
        if (CollectionUtils.isNotEmpty(filterVos)) {
            estimatedWriteOffAmount = filterVos.get(0).getFormulaValue();
        } else {
            log.info("细案编码[{}]明细编码[{}]未满足公式任何条件，默认预核销金额为0！", detailedForecastDto.getDetailedCaseCode(), detailedForecastDto.getActivityDetailItemCode());
        }

        //变量对应的值
        Map<String, BigDecimal> variableValueMap = new HashMap<>();
        calculateVos.forEach(v -> {
            if (Objects.nonNull(v.getVariableValueMap())) {
                variableValueMap.putAll(v.getVariableValueMap());
            }
        });

        List<String> variableCodeList = new ArrayList<>();
        for (CalculateVo calculateVo : calculateVos) {
            if (Objects.nonNull(calculateVo.getVariableValueMap())) {
                variableCodeList.addAll(calculateVo.getVariableValueMap().keySet());
            }
        }

        //核销变量编码-名称映射
        Map<String, String> variableNameMap = variableService.getVariableMap(VariableFunctionEnum.AUDIT.getCode(), variableCodeList);

        //核销条件取值
        Map<String, String> conditionValueMap = new HashMap<>();
        //核销公式取值
        Map<String, String> formulaValueMap = new HashMap<>();
        //可核销前提
        List<String> canAuditPreList = new ArrayList<>();
        auditFormulaMainVo.getAuditFormulaInfoVoList()
//                .stream().filter(e -> StringUtils.equals(e.getAuditFormulaConditionName(), filterCondition.get()))
                .forEach(formula -> {
                    //核销条件
                    Set<String> formulaCondition = MathUtil.getFormulaReplace(formula.getAuditFormulaCondition());
                    formulaCondition.forEach(v -> {
                        if (conditionValueMap.containsKey(v)) {
                            return;
                        }
                        if (variableValueMap.containsKey(v)) {
                            conditionValueMap.put(v, variableNameMap.getOrDefault(v, v) + " : " + variableValueMap.get(v).toString());
                            return;
                        }
                        conditionValueMap.put(v, variableNameMap.getOrDefault(v, v) + " : ");
                    });
                    //核销公式
                    Set<String> auditFormula = MathUtil.getFormulaReplace(formula.getAuditFormula());
                    auditFormula.forEach(v -> {
                        if (formulaValueMap.containsKey(v)) {
                            return;
                        }
                        if (variableValueMap.containsKey(v)) {
                            formulaValueMap.put(v, variableNameMap.getOrDefault(v, v) + " : " + variableValueMap.get(v).toString());
                            return;
                        }
                        formulaValueMap.put(v, variableNameMap.getOrDefault(v, v) + " : ");
                        //查不到数据先默认达标
                        canAuditPreList.add(variableNameMap.getOrDefault(v, v) + "达标");
                    });
                });
        detailedForecastDto.setCalParam(JSON.toJSONString(calDto));
        detailedForecastDto.setAuditFormulaCode(auditFormulaMainVo.getAuditFormulaCode());
        detailedForecastDto.setWriteOffConditions(auditFormulaMainVo.getAuditFormulaInfoVoList().stream()
                .filter(e -> StringUtils.equals(e.getAuditFormulaConditionName(), filterCondition.get()))
                .map(AuditFormulaInfoVo::getAuditFormulaConditionName).filter(Objects::nonNull)
                .collect(Collectors.joining(" , ")));
        detailedForecastDto.setWriteOffFormula(auditFormulaMainVo.getAuditFormulaInfoVoList().stream()
                .filter(e -> StringUtils.equals(e.getAuditFormulaConditionName(), filterCondition.get()))
                .map(AuditFormulaInfoVo::getAuditFormulaName).filter(Objects::nonNull)
                .collect(Collectors.joining(" , ")));
        detailedForecastDto.setWriteOffConditionValue(String.join(" , ", conditionValueMap.values()));
        detailedForecastDto.setWriteOffFormulaValue(String.join(" , ", formulaValueMap.values()));
        detailedForecastDto.setEstimatedWriteOffAmount(estimatedWriteOffAmount);
        detailedForecastDto.setWriteOffPremise(String.join(" , ", canAuditPreList));

        //公式查询条件保存
//        this.setCommonQueryParam(detailedForecastDto, paramMap);
    }

    public List<FormulaInfoDto> copyFormulaInfoList(List<AuditFormulaInfoVo> auditFormulaInfoVoList) {
        List<FormulaInfoDto> list = new ArrayList<>();
        auditFormulaInfoVoList.forEach(info -> {
            FormulaInfoDto dto = new FormulaInfoDto();
            dto.setFormulaCode(info.getAuditFormulaCode());
            dto.setFormulaCondition(info.getAuditFormulaCondition());
            dto.setFormulaConditionName(info.getAuditFormulaConditionName());
            dto.setFormula(info.getAuditFormula());
            dto.setFormulaName(info.getAuditFormulaName());
            list.add(dto);
        });
        return list;
    }

    public List<AuditExecuteIndicatorVo> getMinusCompostQuantity(List<String> detailPlanItemCodes) {
        if(CollectionUtils.isEmpty(detailPlanItemCodes)){
            return Lists.newArrayList();
        }
        return auditExecuteIndicatorService.getMinusCompostQuantity(detailPlanItemCodes);
    }
}
