package com.biz.crm.tpm.business.detailed.forecast.local.util;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSONObject;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.enums.YesOrNoEnum;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanBudgetVo;
import com.biz.crm.tpm.business.detailed.forecast.local.entity.DetailedForecastEntity;
import com.biz.crm.tpm.business.detailed.forecast.local.mapper.DetailedForecastMapper;
import com.biz.crm.tpm.business.detailed.forecast.local.mapper.DetailedForecastWashDataMapper;
import com.biz.crm.tpm.business.detailed.forecast.local.repository.DetailedForecastRepository;
import com.biz.crm.tpm.business.detailed.forecast.sdk.constant.DetailedForecastBudgetProjectConstants;
import com.biz.crm.tpm.business.detailed.forecast.sdk.dto.DetailedForecastDto;
import com.biz.crm.tpm.business.detailed.forecast.sdk.vo.DetailedForecastVo;
import com.biz.crm.tpm.business.month.budget.sdk.dto.OperateMonthBudgetDto;
import com.biz.crm.tpm.business.month.budget.sdk.eunm.BudgetOperationTypeEnum;
import com.biz.crm.tpm.business.month.budget.sdk.eunm.VerticalFeeBelongCodeEnum;
import com.biz.crm.tpm.business.month.budget.sdk.service.MonthBudgetLockService;
import com.biz.crm.tpm.business.month.budget.sdk.service.MonthBudgetService;
import com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetDetailVo;
import com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.util.*;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;

/**
 * <p>
 * 洗月度预算数据用的
 * </p>
 *
 * @author chenshuang
 * @since 2023-06-02
 */
@Slf4j
@Component
public class DetailedForecastVerticalBudgetDataUtil {

    @Autowired(required = false)
    private DetailedForecastRepository detailedForecastRepository;

    @Autowired(required = false)
    private DetailedForecastWashDataMapper detailedForecastWashDataMapper;

    @Autowired(required = false)
    private DetailedForecastMapper detailedForecastMapper;

    @Autowired(required = false)
    private MonthBudgetService monthBudgetService;

    @Transactional
    public void initBudget(List<String> budgetCodeList) {
//        if (CollectionUtils.isEmpty(budgetCodeList)) {
//            return;
//        }
//
//        for (String budgetCode : budgetCodeList) {
//            List<MonthBudgetDetailVo> detailList = this.detailedForecastWashDataMapper.findBudgetDetailList(budgetCode);
//            if (CollectionUtils.isEmpty(detailList)) {
//                continue;
//            }
//            detailList.sort(Comparator.comparing(MonthBudgetDetailVo::getCreateTime));
//
//            List<String> delIdList = new ArrayList<>();
//            List<MonthBudgetDetailVo> updateList = new ArrayList<>();
//
//            List<MonthBudgetDetailVo> collect = detailList.stream().filter(detailVo -> StringUtils.equals(BudgetOperationTypeEnum.INIT.getCode(), detailVo.getOperationType())).collect(Collectors.toList());
//            BigDecimal beforeAmount = collect.get(0).getInitialAmount();
//
//            for (MonthBudgetDetailVo detailVo : detailList) {
//                if (StringUtils.equals(BudgetOperationTypeEnum.INIT.getCode(), detailVo.getOperationType())) {
//                    continue;
//                }
//                if (StringUtils.equals(BudgetOperationTypeEnum.FORECAST_OVER.getCode(), detailVo.getOperationType())) {
//                    delIdList.add(detailVo.getId());
//                    continue;
//                }
//
//                BigDecimal sub = beforeAmount.subtract(detailVo.getBeforeAmount());
//                detailVo.setBeforeAmount(beforeAmount);
//                detailVo.setBalanceAmount(detailVo.getBalanceAmount().add(sub));
//                beforeAmount = detailVo.getBalanceAmount();
//
//                updateList.add(detailVo);
//            }
//            if (!CollectionUtils.isEmpty(updateList)) {
//                this.detailedForecastWashDataMapper.updateMonthBudgetDetail(updateList);
//            }
//            if (!CollectionUtils.isEmpty(delIdList)) {
//                log.error("ids===>" + JSONObject.toJSONString(delIdList));
//                this.detailedForecastWashDataMapper.delDetailByIds(delIdList);
//            }
//        }
//        if (!CollectionUtils.isEmpty(budgetCodeList)) {
//            this.detailedForecastWashDataMapper.updateMonthBudget(budgetCodeList);
//        }
    }

    @Transactional
    public void washData(List<String> activityDetailItemCodeList) {
//        List<DetailedForecastDto> forecastVos = detailedForecastWashDataMapper.washDataList(BusinessUnitEnum.VERTICAL.getCode(), activityDetailItemCodeList);
//        for (DetailedForecastDto dto : forecastVos) {
//            this.verticalOperateBudget(dto);
//            this.detailedForecastRepository.lambdaUpdate()
//                    .eq(DetailedForecastEntity::getId, dto.getId())
//                    .set(DetailedForecastEntity::getOverBudgetFailAmount, dto.getOverBudgetFailAmount())
//                    .set(DetailedForecastEntity::getOverBudgetSuccess, dto.getOverBudgetSuccess())
//                    .set(DetailedForecastEntity::getOverBudgetRemark, dto.getOverBudgetRemark())
//                    .update();
//        }
    }

    @Transactional
    public void verticalOperateBudget(DetailedForecastDto dto) {
        BigDecimal operateAmount = dto.getEstimatedWriteOffAmount().subtract(dto.getApplyAmount());

        //5、
        String overBudgetSuccess = YesOrNoEnum.YES.getCode();
        BigDecimal overBudgetFailAmount = BigDecimal.ZERO;
        List<ActivityDetailPlanBudgetVo> budgetVos = detailedForecastMapper.findActivityDetailBudgetCodes(dto.getActivityDetailItemCode(), TenantUtils.getTenantCode());
        try {
            //排序使用的预算，按照优先级补占、退，当前逻辑：使用金额最大的预算，金额相同，录入最早的预算（按预算编码）
            List<String> useBudgetCodeList = this.getBudgetSortList(budgetVos);
            List<OperateMonthBudgetDto> operateVos = this.buildOperateList(operateAmount, dto, useBudgetCodeList);
            monthBudgetService.operateBudget(operateVos);
            dto.setOverBudgetRemark("");
        } catch (Exception e) {
            e.printStackTrace();
            String exMsg = "垂直单元-细案预测-补占预算异常：" + e.getMessage();
            if (exMsg.length() > 300) {
                exMsg = exMsg.substring(0, 300);
            }
            dto.setOverBudgetRemark(exMsg);
            overBudgetSuccess = YesOrNoEnum.NO.getCode();
        }
        if (StringUtils.equals(YesOrNoEnum.NO.getCode(), overBudgetSuccess)) {
            overBudgetFailAmount = dto.getEstimatedWriteOffAmount();
        }
        dto.setOverBudgetFailAmount(overBudgetFailAmount);
        dto.setOverBudgetSuccess(overBudgetSuccess);
    }


    /**
     * 使用预算排序
     * 补占使用金额最高的预算；金额相同，补占预算录入最早的预算（按预算编码）
     *
     * @param budgetVos
     * @return
     */
    public List<String> getBudgetSortList(List<ActivityDetailPlanBudgetVo> budgetVos) {
        Validate.notEmpty(budgetVos, "细案预测补占预算-使用预算为空！");
        List<ActivityDetailPlanBudgetVo> sortedList = budgetVos.stream()
                .filter(e -> Objects.nonNull(e.getUseAmount()) && VerticalFeeBelongCodeEnum.REGION_AUTOMATIC.getCode().equals(e.getFeeBelongCode()))
                .sorted(Comparator.comparing(ActivityDetailPlanBudgetVo::getUseAmount).reversed()).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(sortedList)) {
            return Lists.newArrayList();
        }
        BigDecimal useAmount = sortedList.get(0).getUseAmount();
        Map<BigDecimal, List<String>> sortedMap = sortedList.stream().collect(Collectors.groupingBy(ActivityDetailPlanBudgetVo::getUseAmount, Collectors.mapping(ActivityDetailPlanBudgetVo::getMonthBudgetCode, Collectors.toList())));
        List<String> budgetCodes = sortedMap.get(useAmount);
        Collections.sort(budgetCodes);
        return Lists.newArrayList(budgetCodes.get(0));
    }

    /**
     * 补占预算参数构建
     *
     * @return
     */
    public List<OperateMonthBudgetDto> buildOperateList(BigDecimal operateAmount, DetailedForecastDto dto, List<String> budgetCodes) {
        List<MonthBudgetVo> budgetVos = monthBudgetService.findByCodes(budgetCodes, EnableStatusEnum.ENABLE.getCode());
        if (CollectionUtils.isEmpty(budgetVos)) {
            budgetVos = Lists.newArrayList();
        }
        Map<String, List<MonthBudgetVo>> budgetVosMap = budgetVos.stream()
                .filter(e -> StringUtils.isNotEmpty(e.getFeeBelongCode()))
                .collect(Collectors.groupingBy(MonthBudgetVo::getFeeBelongCode));
        List<MonthBudgetVo> automaticVos = budgetVosMap.getOrDefault(VerticalFeeBelongCodeEnum.REGION_AUTOMATIC.getCode(), Lists.newArrayList());
//        List<MonthBudgetVo> referendumVos = budgetVosMap.getOrDefault(VerticalFeeBelongCodeEnum.REGION_REFERENDUM.getCode(), Lists.newArrayList());
        List<OperateMonthBudgetDto> operateVos = new ArrayList<>();
        AtomicReference<BigDecimal> atomicOperateAmount = new AtomicReference<>(operateAmount);

        //2023-04-07取消补占公投
        //占 先公投、后自投，占自投需要区分使用的费用归口，不包含费用归口为自投的，只能占用费用归口为自投，预算项目为产品促销[KAYS030004]的预算
//            this.occupy(dto, operateVos, referendumVos, atomicOperateAmount, null);//公投
        //匹配 自投的产品促销 预算
        automaticVos = this.budgetProductProList(dto, automaticVos, budgetVos);
        List<String> budgetProjectCodes = this.filterBudgetProjectCodes(budgetVos);
        automaticVos = this.filterByProjectCodes(automaticVos, budgetProjectCodes);
        this.occupy(dto.getActivityDetailItemCode(), operateVos, automaticVos, atomicOperateAmount, budgetProjectCodes);//自投
//        Validate.isTrue(BigDecimal.ZERO.compareTo(atomicOperateAmount.get()) == 0, "预估超额扣减预算不足，差异：%s", atomicOperateAmount.get());
        return operateVos;
    }

    /**
     * 匹配 自投的产品促销 预算
     *
     * @param dto
     * @param automaticVos
     * @return
     */
    public List<MonthBudgetVo> budgetProductProList(DetailedForecastDto dto, List<MonthBudgetVo> automaticVos, List<MonthBudgetVo> budgetVos) {
        Set<String> feeBelongCodeSet = budgetVos.stream().filter(e -> StringUtils.isNotEmpty(e.getFeeBelongCode())).map(MonthBudgetVo::getFeeBelongCode).collect(Collectors.toSet());
        if (feeBelongCodeSet.contains(VerticalFeeBelongCodeEnum.REGION_AUTOMATIC.getCode())) {
            return automaticVos;
        }
        Validate.notBlank(dto.getSystemCode(), "匹配自投产品促销预算：零售商编码为空！");
        Validate.notBlank(dto.getRegion(), "匹配自投产品促销预算：区域编码为空！");
        Validate.notBlank(dto.getYearMonthStr(), "匹配自投产品促销预算：费用所属年月为空！");
        automaticVos = detailedForecastMapper.findBudgetProductProList(dto, TenantUtils.getTenantCode(), VerticalFeeBelongCodeEnum.REGION_AUTOMATIC.getCode(), DetailedForecastBudgetProjectConstants.PRODUCT_PRO);
        return automaticVos;
    }

    /**
     * 返回需要过滤的预算项目编码，返回空表示不过滤
     * 目前只要没有自投，就返回预算项目-产品促销[KAYS030004]
     * 总部+公投+自投：补占自投
     * 总部+自投：补占自投
     * 共投+自投：补占自投
     * 总部+公投：补占自投的产品促销
     * 公投：补占自投的产品促销
     * 总部：补占自投的产品促销
     *
     * @param budgetVos
     * @return
     */
    public List<String> filterBudgetProjectCodes(List<MonthBudgetVo> budgetVos) {
        Set<String> feeBelongCodeSet = budgetVos.stream().filter(e -> StringUtils.isNotEmpty(e.getFeeBelongCode())).map(MonthBudgetVo::getFeeBelongCode).collect(Collectors.toSet());
        if (feeBelongCodeSet.size() == 0) {
            return Lists.newArrayList();
        }
        if (!feeBelongCodeSet.contains(VerticalFeeBelongCodeEnum.REGION_AUTOMATIC.getCode())) {
            //
            return Lists.newArrayList(DetailedForecastBudgetProjectConstants.PRODUCT_PRO);

        }
        return Lists.newArrayList();
    }

    public List<MonthBudgetVo> filterByProjectCodes(List<MonthBudgetVo> vos, List<String> budgetProjectCodes) {
        vos = vos.stream()
                .filter(e -> CollectionUtils.isEmpty(budgetProjectCodes) || budgetProjectCodes.contains(e.getBudgetItemCode()))
                .collect(Collectors.toList());
        Validate.notEmpty(vos, "未匹配到预算项目为[自投产品促销]的预算！");
        return vos;
    }


    /**
     * 占用
     *
     * @param dto                 补占预算的细案预测对象
     * @param operateVos          预算操作对象集合
     * @param vos                 预算集合
     * @param atomicOperateAmount 剩余待补占金额
     * @param budgetProjectCodes  限制预算项目，为空不限制
     */
    public void occupy(String activityDetailItemCode, List<OperateMonthBudgetDto> operateVos, List<MonthBudgetVo> vos,
                       AtomicReference<BigDecimal> atomicOperateAmount, List<String> budgetProjectCodes) {
        vos.sort(Comparator.comparing(MonthBudgetVo::getMonthBudgetCode));
        int index = 0;
        for (MonthBudgetVo vo : vos) {
            index++;
            if (BigDecimal.ZERO.compareTo(atomicOperateAmount.get()) >= 0) {
                break;
            }
            OperateMonthBudgetDto budgetDto = new OperateMonthBudgetDto();
            budgetDto.setMonthBudgetCode(vo.getMonthBudgetCode());
            budgetDto.setOperationType(BudgetOperationTypeEnum.FORECAST_OVER.getCode());
            budgetDto.setBusinessCode(activityDetailItemCode);

            if (vo.getAccumulatedAvailableBalance().compareTo(BigDecimal.ZERO) >= 0
                    && atomicOperateAmount.get().compareTo(vo.getAccumulatedAvailableBalance()) >= 0
                    && index != vos.size()) {
                budgetDto.setOperationAmount(vo.getAccumulatedAvailableBalance());
                atomicOperateAmount.set(atomicOperateAmount.get().subtract(vo.getAccumulatedAvailableBalance()));
            } else {
                budgetDto.setOperationAmount(atomicOperateAmount.get());
                atomicOperateAmount.set(BigDecimal.ZERO);
            }
            operateVos.add(budgetDto);
        }
    }
}
