/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.detailed.forecast.local.consumer;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictToolkitService;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgVoService;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgAllParentVo;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.rocketmq.service.AbstractRocketMqConsumer;
import com.biz.crm.mn.common.rocketmq.service.RocketMqProducer;
import com.biz.crm.mn.common.rocketmq.util.RocketMqUtil;
import com.biz.crm.mn.common.rocketmq.vo.MqMessageVo;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanItemDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.enums.ActivityDetailPlanPassMqTagEnum;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.pojo.ActivityDetailPlanItemBase;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.service.ActivityDetailPlanSdkService;
import com.biz.crm.tpm.business.detailed.forecast.local.util.ActivityDetailPlanPassDetailedForecastBuilder;
import com.biz.crm.tpm.business.detailed.forecast.local.util.ActivityDetailPlanPassDetailedForecastUtil;
import com.biz.crm.tpm.business.detailed.forecast.sdk.dto.DetailedForecastDto;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.vo.AuditExecuteIndicatorVo;
import com.bizunited.nebula.security.sdk.login.UserIdentity;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.spring.annotation.ConsumeMode;
import org.apache.rocketmq.spring.annotation.MessageModel;
import org.apache.rocketmq.spring.annotation.RocketMQMessageListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
@RocketMQMessageListener(topic="TPM_ACTIVITY_DETAIL_PLAN_PROCESS_PASS_TOPIC${rocketmq.environment}", selectorExpression="TPM_ACTIVITY_DETAIL_PLAN_PASS_DETAILED_FORECAST", consumerGroup="TPM_ACTIVITY_DETAIL_PLAN_PASS_DETAILED_FORECAST${rocketmq.environment}", consumeMode=ConsumeMode.CONCURRENTLY, messageModel=MessageModel.CLUSTERING)
public class ActivityDetailPlanPassDetailedForecastConsumer
extends AbstractRocketMqConsumer {
    private static final Logger log = LoggerFactory.getLogger(ActivityDetailPlanPassDetailedForecastConsumer.class);
    @Autowired(required=false)
    private ActivityDetailPlanSdkService activityDetailPlanSdkService;
    @Autowired(required=false)
    private ActivityDetailPlanPassDetailedForecastUtil activityDetailPlanPassDetailedForecastUtil;
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired(required=false)
    private CustomerVoService customerVoService;
    @Autowired(required=false)
    private ProductVoService productVoService;
    @Autowired(required=false)
    private SalesOrgVoService salesOrgVoService;
    @Autowired(required=false)
    private DictToolkitService dictToolkitService;
    @Autowired(required=false)
    private RocketMqProducer rocketMqProducer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object handleMessage(MqMessageVo message) {
        log.info("\u6d3b\u52a8\u7ec6\u6848\u5ba1\u6279\u901a\u8fc7\u63a8\u9001\u7ec6\u6848\u9884\u6d4b\u8868 order mq message received  : {}", (Object)message);
        if (Objects.isNull(message) || StringUtils.isEmpty((CharSequence)message.getMsgBody())) {
            return "\u6d88\u606f\u4e3a\u7a7a!";
        }
        try {
            List detailPlanCodeList = JSON.parseArray((String)message.getMsgBody(), String.class);
            List dtoList = this.activityDetailPlanSdkService.buildActivityDetailPlanParams(detailPlanCodeList);
            UserIdentity loginUser = this.loginUserService.getLoginUser();
            if (!CollectionUtils.isEmpty((Collection)dtoList)) {
                Map regionMap = this.dictToolkitService.findMapByDictTypeCode("MDM_CUSTOMIZE_ORG");
                dtoList.forEach(activityDetailPlanDto -> {
                    List customerVos;
                    if (Objects.isNull(activityDetailPlanDto) || CollectionUtil.isEmpty((Collection)activityDetailPlanDto.getItemList())) {
                        return;
                    }
                    List cusCodes = activityDetailPlanDto.getItemList().stream().filter(e -> StringUtils.isNotEmpty((CharSequence)e.getCustomerCode())).map(ActivityDetailPlanItemBase::getCustomerCode).distinct().collect(Collectors.toList());
                    HashMap<String, CustomerVo> customerVoMap = new HashMap<String, CustomerVo>();
                    if (!CollectionUtils.isEmpty(cusCodes) && CollectionUtil.isNotEmpty((Collection)(customerVos = this.customerVoService.findBaseByCustomerCodes(cusCodes)))) {
                        customerVoMap.putAll(customerVos.stream().filter(e -> StringUtils.isNotEmpty((CharSequence)e.getErpCode())).collect(Collectors.toMap(CustomerVo::getCustomerCode, v -> v)));
                    }
                    List productCodeList = activityDetailPlanDto.getItemList().stream().filter(e -> StringUtils.isNotEmpty((CharSequence)e.getProductCode())).map(ActivityDetailPlanItemBase::getProductCode).distinct().collect(Collectors.toList());
                    HashMap productVoMap = Maps.newHashMap();
                    if (CollectionUtil.isNotEmpty(productCodeList)) {
                        List list = this.productVoService.findByCodes(productCodeList);
                        productVoMap.putAll(list.stream().collect(Collectors.toMap(ProductVo::getProductCode, v -> v, (v1, v2) -> v2)));
                    }
                    List salesOrgCodes = activityDetailPlanDto.getItemList().stream().filter(e -> StringUtils.isNotEmpty((CharSequence)e.getActivityOrgCode())).map(ActivityDetailPlanItemDto::getActivityOrgCode).distinct().collect(Collectors.toList());
                    HashMap salesOrgVoMap = Maps.newHashMap();
                    if (CollectionUtil.isNotEmpty(salesOrgCodes)) {
                        List list = this.salesOrgVoService.findSalesOrgIncludeAllParentByCodes(salesOrgCodes);
                        salesOrgVoMap.putAll(list.stream().collect(Collectors.toMap(SalesOrgAllParentVo::getCurrSalesOrgCode, v -> v, (v1, v2) -> v2)));
                    }
                    Map<Object, Object> auditExecuteIndicatorMap = new HashMap();
                    if (StringUtils.equals((CharSequence)BusinessUnitEnum.VERTICAL.getCode(), (CharSequence)activityDetailPlanDto.getBusinessUnitCode())) {
                        List<String> detailPlanItemCodes = activityDetailPlanDto.getItemList().stream().map(ActivityDetailPlanItemBase::getDetailPlanItemCode).collect(Collectors.toList());
                        List<AuditExecuteIndicatorVo> auditExecuteIndicatorVoList = this.activityDetailPlanPassDetailedForecastUtil.getMinusCompostQuantity(detailPlanItemCodes);
                        auditExecuteIndicatorMap = auditExecuteIndicatorVoList.stream().collect(Collectors.toMap(AuditExecuteIndicatorVo::getActiveNumber, Function.identity(), (o, n) -> o));
                    }
                    HashMap finalAuditExecuteIndicatorMap = auditExecuteIndicatorMap;
                    activityDetailPlanDto.getItemList().forEach(item -> {
                        SalesOrgAllParentVo salesOrgAllParentVo = null;
                        if (StringUtils.isNotEmpty((CharSequence)item.getActivityOrgCode())) {
                            salesOrgAllParentVo = (SalesOrgAllParentVo)salesOrgVoMap.get(item.getActivityOrgCode());
                        }
                        CustomerVo customerVo = null;
                        if (StringUtils.isNotEmpty((CharSequence)item.getCustomerCode())) {
                            customerVo = (CustomerVo)customerVoMap.get(item.getCustomerCode());
                        }
                        ProductVo productVo = null;
                        if (StringUtils.isNotEmpty((CharSequence)item.getProductCode())) {
                            productVo = (ProductVo)productVoMap.get(item.getProductCode());
                        }
                        String businessUnitCode = activityDetailPlanDto.getBusinessUnitCode();
                        DetailedForecastDto detailedForecastDto = ActivityDetailPlanPassDetailedForecastBuilder.buildUnit1Dto(activityDetailPlanDto, item, regionMap, customerVo, salesOrgAllParentVo, productVo, finalAuditExecuteIndicatorMap);
                        if (BusinessUnitEnum.isDefaultBusinessUnit((String)businessUnitCode)) {
                            try {
                                this.activityDetailPlanPassDetailedForecastUtil.buildUnit1Param((ActivityDetailPlanDto)activityDetailPlanDto, detailedForecastDto, (ActivityDetailPlanItemDto)item, loginUser);
                            }
                            catch (Exception e) {
                                log.error("\u7ec6\u6848\u7f16\u7801[{}]\u660e\u7ec6\u7f16\u7801[{}]\u7ec6\u6848\u9884\u6d4b\u751f\u6210\u5931\u8d25\uff1a{}", new Object[]{detailedForecastDto.getDetailedCaseCode(), detailedForecastDto.getActivityDetailItemCode(), e.getMessage()});
                                log.error("", (Throwable)e);
                            }
                        } else if (StringUtils.equals((CharSequence)BusinessUnitEnum.VERTICAL.getCode(), (CharSequence)businessUnitCode)) {
                            try {
                                this.activityDetailPlanPassDetailedForecastUtil.buildUnit3Param(detailedForecastDto, (ActivityDetailPlanItemDto)item, loginUser);
                            }
                            catch (Exception e) {
                                log.error("\u7ec6\u6848\u7f16\u7801[{}]\u660e\u7ec6\u7f16\u7801[{}]\u7ec6\u6848\u9884\u6d4b\u751f\u6210\u5931\u8d25\uff1a{}", new Object[]{detailedForecastDto.getDetailedCaseCode(), detailedForecastDto.getActivityDetailItemCode(), e.getMessage()});
                                log.error("", (Throwable)e);
                            }
                        }
                    });
                });
            }
        }
        catch (Exception e) {
            log.error(ActivityDetailPlanPassMqTagEnum.PASS_DETAILED_FORECAST.getName() + "\u5904\u7406\u5931\u8d25" + e.getMessage(), (Throwable)e);
            String string = "\u6d88\u8d39\u5931\u8d25." + e.getMessage();
            return string;
        }
        finally {
            MqMessageVo mqMessageVo = new MqMessageVo();
            mqMessageVo.setMsgBody(message.getMsgBody());
            mqMessageVo.setTopic("TPM_ACTIVITY_DETAIL_PLAN_PROCESS_PASS_TOPIC" + RocketMqUtil.mqEnvironment());
            mqMessageVo.setTag(ActivityDetailPlanPassMqTagEnum.PASS_AUDIT_FEE_PREDICTION.getCode());
            log.info("\u7ec6\u6848\u9884\u6d4b\u8868\u6267\u884c\u73a9\u540e\u63a8MQ\u5230\u6d3b\u52a8\u7ec6\u6848\u5ba1\u6279\u901a\u8fc7\u63a8\u9001\u6263\u8d39\u9884\u6d4b\u7ba1\u7406:{}", (Object)JSONObject.toJSONString((Object)mqMessageVo));
            this.rocketMqProducer.sendMqMsg(mqMessageVo, 10L);
        }
        return "\u6d88\u8d39\u6210\u529f.";
    }
}

