/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.detailed.forecast.local.consumer;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.business.common.sdk.service.RedisService;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.rocketmq.service.AbstractRocketMqConsumer;
import com.biz.crm.mn.common.rocketmq.vo.MqMessageVo;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.pojo.ActivityDetailPlanItemBase;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.service.ActivityDetailPlanItemSdkService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanItemVo;
import com.biz.crm.tpm.business.detailed.forecast.local.entity.DetailedForecastEntity;
import com.biz.crm.tpm.business.detailed.forecast.local.repository.DetailedForecastRepository;
import com.biz.crm.tpm.business.detailed.forecast.local.util.ActivityDetailPlanPassDetailedForecastUtil;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.vo.AuditExecuteIndicatorVo;
import com.bizunited.nebula.security.sdk.login.UserIdentity;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import jodd.util.StringUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.spring.annotation.ConsumeMode;
import org.apache.rocketmq.spring.annotation.MessageModel;
import org.apache.rocketmq.spring.annotation.RocketMQMessageListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
@RocketMQMessageListener(topic="TPM_ACTIVITY_DETAIL_PLAN_PROCESS_PASS_TOPIC${rocketmq.environment}", selectorExpression="TPM_ACTIVITY_DETAIL_PLAN_PASS_DETAILED_FORECAST_REFRESH", consumerGroup="TPM_ACTIVITY_DETAIL_PLAN_PASS_DETAILED_FORECAST_REFRESH${rocketmq.environment}", consumeMode=ConsumeMode.CONCURRENTLY, messageModel=MessageModel.CLUSTERING)
public class ActivityDetailPlanPassDetailedForecastRefreshConsumer
extends AbstractRocketMqConsumer {
    private static final Logger log = LoggerFactory.getLogger(ActivityDetailPlanPassDetailedForecastRefreshConsumer.class);
    @Autowired(required=false)
    private ActivityDetailPlanPassDetailedForecastUtil activityDetailPlanPassDetailedForecastUtil;
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired(required=false)
    private RedisService redisService;
    @Autowired(required=false)
    private DetailedForecastRepository detailedForecastRepository;
    @Autowired(required=false)
    private ActivityDetailPlanItemSdkService activityDetailPlanItemSdkService;
    @Autowired(required=false)
    private ProductVoService productVoService;

    protected Object handleMessage(MqMessageVo message) {
        log.info("\u7ec6\u6848\u9884\u6d4b\u8868\u66f4\u65b0 order mq message received  : {}", (Object)message);
        if (Objects.isNull(message) || StringUtils.isEmpty((CharSequence)message.getMsgBody())) {
            return "\u6d88\u606f\u4e3a\u7a7a!";
        }
        try {
            List itemList;
            Object object = this.redisService.hGet("tpm:detailed_forecast_auto_refresh_ids", message.getMsgBody());
            if (Objects.isNull(object) || StringUtils.isEmpty((CharSequence)object.toString())) {
                return "\u7f13\u5b58ids\u5df2\u8fc7\u671f!";
            }
            List ids = JSON.parseArray((String)object.toString(), String.class);
            List<DetailedForecastEntity> entityList = this.detailedForecastRepository.findByIds(ids);
            if (CollectionUtils.isEmpty(entityList)) {
                return "\u6d88\u8d39\u8b66\u544a. \u6d88\u8d39\u5bf9\u8c61\u6570\u636e\u67e5\u8be2\u4e3a\u7a7a\uff01";
            }
            List activityDetailItemCodeList = entityList.stream().filter(k -> StringUtil.isNotEmpty((CharSequence)k.getActivityDetailItemCode())).map(DetailedForecastEntity::getActivityDetailItemCode).distinct().collect(Collectors.toList());
            HashMap itemVoMap = Maps.newHashMap();
            HashMap productVoMap = Maps.newHashMap();
            if (CollectionUtil.isNotEmpty(activityDetailItemCodeList) && CollectionUtil.isNotEmpty((Collection)(itemList = this.activityDetailPlanItemSdkService.listByItemCodeList(activityDetailItemCodeList)))) {
                itemVoMap.putAll(itemList.stream().collect(Collectors.toMap(ActivityDetailPlanItemBase::getDetailPlanItemCode, v -> v, (n, oldValue) -> n)));
                List productCodeList = itemList.stream().filter(e -> StringUtils.isNotEmpty((CharSequence)e.getProductCode())).map(ActivityDetailPlanItemBase::getProductCode).distinct().collect(Collectors.toList());
                if (CollectionUtil.isNotEmpty(productCodeList)) {
                    List list = this.productVoService.findByCodes(productCodeList);
                    productVoMap.putAll(list.stream().collect(Collectors.toMap(ProductVo::getProductCode, v -> v, (v1, v2) -> v2)));
                }
            }
            UserIdentity loginUser = this.loginUserService.getLoginUser();
            Map<Object, Object> auditExecuteIndicatorMap = new HashMap();
            List<String> activityDetailItemCodes = entityList.stream().filter(item -> BusinessUnitEnum.VERTICAL.getCode().equals(item.getBusinessUnitCode())).map(DetailedForecastEntity::getActivityDetailItemCode).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(activityDetailItemCodes)) {
                List<AuditExecuteIndicatorVo> auditExecuteIndicatorVoList = this.activityDetailPlanPassDetailedForecastUtil.getMinusCompostQuantity(activityDetailItemCodes);
                auditExecuteIndicatorMap = auditExecuteIndicatorVoList.stream().collect(Collectors.toMap(AuditExecuteIndicatorVo::getActiveNumber, Function.identity(), (old, ne) -> old));
            }
            HashMap finalAuditExecuteIndicatorMap = auditExecuteIndicatorMap;
            entityList.forEach(entity -> {
                try {
                    this.activityDetailPlanPassDetailedForecastUtil.refreshUpdate((DetailedForecastEntity)((Object)entity), (ActivityDetailPlanItemVo)itemVoMap.get(entity.getActivityDetailItemCode()), productVoMap, loginUser, finalAuditExecuteIndicatorMap);
                }
                catch (Exception e) {
                    log.error("\u7ec6\u6848\u7f16\u7801[{}]\u660e\u7ec6\u7f16\u7801[{}]\u7ec6\u6848\u9884\u6d4b\u5237\u65b0\u8ba1\u7b97\u5931\u8d25\uff1a{}", new Object[]{entity.getDetailedCaseCode(), entity.getActivityDetailItemCode(), e.getMessage()});
                    log.error("", (Throwable)e);
                }
            });
        }
        catch (Exception e2) {
            log.error("\u7ec6\u6848\u9884\u6d4b\u8868\u66f4\u65b0\u5904\u7406\u5931\u8d25" + e2.getMessage(), (Throwable)e2);
            return "\u6d88\u8d39\u5931\u8d25." + e2.getMessage();
        }
        return "\u6d88\u8d39\u6210\u529f.";
    }

    public void handleMessageTest(MqMessageVo vo) {
        String uuid = UUID.randomUUID().toString().replace("-", "");
        this.redisService.hSet("tpm:detailed_forecast_auto_refresh_ids", uuid, (Object)vo.getMsgBody(), 172800L);
        vo.setMsgBody(uuid);
        this.handleMessage(vo);
    }
}

