/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.detailed.forecast.local.consumer;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.service.RedisService;
import com.biz.crm.mn.common.rocketmq.service.AbstractRocketMqConsumer;
import com.biz.crm.mn.common.rocketmq.service.RocketMqProducer;
import com.biz.crm.mn.common.rocketmq.util.RocketMqUtil;
import com.biz.crm.mn.common.rocketmq.vo.MqMessageVo;
import com.biz.crm.tpm.business.detailed.forecast.sdk.dto.DetailedForecastAutoRefreshDto;
import com.biz.crm.tpm.business.detailed.forecast.sdk.service.DetailedForecastService;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.spring.annotation.ConsumeMode;
import org.apache.rocketmq.spring.annotation.MessageModel;
import org.apache.rocketmq.spring.annotation.RocketMQMessageListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

@Component
@RocketMQMessageListener(topic="TPM_ACTIVITY_DETAIL_PLAN_PROCESS_PASS_TOPIC${rocketmq.environment}", selectorExpression="TPM_JOB_DETAILED_FORECAST_REFRESH", consumerGroup="TPM_JOB_DETAILED_FORECAST_REFRESH${rocketmq.environment}", consumeMode=ConsumeMode.CONCURRENTLY, messageModel=MessageModel.CLUSTERING)
public class DetailedForecastRefreshConsumer
extends AbstractRocketMqConsumer {
    private static final Logger log = LoggerFactory.getLogger(DetailedForecastRefreshConsumer.class);
    @Autowired(required=false)
    private DetailedForecastService detailedForecastService;
    @Autowired(required=false)
    private RedisService redisService;
    @Autowired(required=false)
    private RocketMqProducer rocketMqProducer;

    protected Object handleMessage(MqMessageVo message) {
        log.info("\u7ec6\u6848\u9884\u6d4b\u8868\u66f4\u65b0 order mq message received  : {}", (Object)message);
        if (Objects.isNull(message) || StringUtils.isEmpty((CharSequence)message.getMsgBody())) {
            return "\u6d88\u606f\u4e3a\u7a7a!";
        }
        try {
            PageRequest page = PageRequest.of((int)1, (int)2000);
            int index = 1;
            DetailedForecastAutoRefreshDto dto = (DetailedForecastAutoRefreshDto)JSONObject.parseObject((String)message.getMsgBody(), DetailedForecastAutoRefreshDto.class);
            String businessUnitCode = dto.getBusinessUnitCode();
            String yearMonthLy = dto.getYearMonthLy();
            Long total = dto.getTotal();
            while (true) {
                List list = this.detailedForecastService.findAutoRefreshDataList((Pageable)page, dto);
                log.info("\u4e1a\u52a1\u5355\u5143[" + businessUnitCode + "]\u5e74\u6708[" + yearMonthLy + "]\u7ec6\u6848\u9884\u6d4b\u5b9a\u65f6\u5237\u65b0\uff1a\u603b\u6570[{}]\u7b2c[{}]\u9875\u67e5\u8be2\u5230[{}]\u6761\u6570\u636e\uff01", new Object[]{total, index, list.size()});
                if (CollectionUtils.isEmpty((Collection)list)) break;
                try {
                    String uuid = UUID.randomUUID().toString().replace("-", "");
                    this.redisService.hSet("tpm:detailed_forecast_auto_refresh_ids", uuid, (Object)JSON.toJSONString((Object)list), 172800L);
                    MqMessageVo mqMessageVo = new MqMessageVo();
                    mqMessageVo.setMsgBody(uuid);
                    mqMessageVo.setTopic("TPM_ACTIVITY_DETAIL_PLAN_PROCESS_PASS_TOPIC" + RocketMqUtil.mqEnvironment());
                    mqMessageVo.setTag("TPM_ACTIVITY_DETAIL_PLAN_PASS_DETAILED_FORECAST_REFRESH");
                    this.rocketMqProducer.sendMqMsg(mqMessageVo);
                    Page result = new Page();
                    result.setTotal((long)list.size());
                    result.setCurrent((long)page.getPageNumber());
                    result.setSize((long)page.getPageSize());
                    Thread.sleep(200L);
                }
                catch (Exception e) {
                    log.error("businessUnitCode+\u7ec6\u6848\u9884\u6d4b\u5b9a\u65f6\u5237\u65b0\u53d1\u9001MQ\u5931\u8d25\uff01\u603b\u6570[{}]\u7b2c[{}]\u9875,{}", new Object[]{total, index, e.getMessage()});
                    log.error("", (Throwable)e);
                }
                page = PageRequest.of((int)(++index), (int)2000);
            }
        }
        catch (Exception e) {
            log.error("\u7ec6\u6848\u9884\u6d4b\u8868\u66f4\u65b0\u5904\u7406\u5931\u8d25" + e.getMessage(), (Throwable)e);
            return "\u6d88\u8d39\u5931\u8d25." + e.getMessage();
        }
        return "\u6d88\u8d39\u6210\u529f.";
    }
}

