/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.detailed.forecast.local.consumer;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgVoService;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgAllParentVo;
import com.biz.crm.mn.common.rocketmq.service.AbstractRocketMqConsumer;
import com.biz.crm.mn.common.rocketmq.vo.MqMessageVo;
import com.biz.crm.tpm.business.detailed.forecast.local.util.ActivityDetailPlanPassDetailedForecastBuilder;
import com.biz.crm.tpm.business.detailed.forecast.local.util.ActivityDetailPlanPassDetailedForecastUtil;
import com.biz.crm.tpm.business.detailed.forecast.sdk.dto.DetailedForecastDto;
import com.biz.crm.tpm.business.promotion.plan.sdk.service.PromotionPlanService;
import com.biz.crm.tpm.business.promotion.plan.sdk.vo.ExpensesVo;
import com.biz.crm.tpm.business.promotion.plan.sdk.vo.GeneralExpensesVo;
import com.biz.crm.tpm.business.promotion.plan.sdk.vo.PromotionPlanVo;
import com.bizunited.nebula.security.sdk.login.UserIdentity;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.spring.annotation.ConsumeMode;
import org.apache.rocketmq.spring.annotation.MessageModel;
import org.apache.rocketmq.spring.annotation.RocketMQMessageListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@RocketMQMessageListener(topic="TPM_PROMOTION_PLAN_PASS_PUSH_DATAILED_FORECAST_TOPIC${rocketmq.environment}", selectorExpression="TPM_PROMOTION_PLAN_PASS_DETAILED_FORECAST", consumerGroup="TPM_PROMOTION_PLAN_PASS_DETAILED_FORECAST${rocketmq.environment}", consumeMode=ConsumeMode.CONCURRENTLY, messageModel=MessageModel.CLUSTERING)
public class PromotionPlanActivityDetailPlanPassDetailedForecastConsumer
extends AbstractRocketMqConsumer {
    private static final Logger log = LoggerFactory.getLogger(PromotionPlanActivityDetailPlanPassDetailedForecastConsumer.class);
    @Autowired(required=false)
    private PromotionPlanService promotionPlanService;
    @Autowired(required=false)
    private ActivityDetailPlanPassDetailedForecastUtil activityDetailPlanPassDetailedForecastUtil;
    @Autowired(required=false)
    private CustomerVoService customerVoService;
    @Autowired(required=false)
    private SalesOrgVoService salesOrgVoService;
    @Autowired(required=false)
    private ProductVoService productVoService;
    @Autowired(required=false)
    private LoginUserService loginUserService;

    protected Object handleMessage(MqMessageVo message) {
        log.info("\u7535\u5546\u4fc3\u9500\u89c4\u5212\u5ba1\u6279\u901a\u8fc7\u63a8\u9001\u7ec6\u6848\u9884\u6d4b\u8868 order mq message received  : {}", (Object)message);
        if (Objects.isNull(message) || StringUtils.isEmpty((CharSequence)message.getMsgBody())) {
            return "\u6d88\u606f\u4e3a\u7a7a!";
        }
        try {
            String businessNo = message.getMsgBody();
            List<String> businessNoList = new ArrayList<String>();
            if (businessNo.contains("[")) {
                businessNoList = JSON.parseArray((String)message.getMsgBody(), String.class);
            } else {
                businessNoList.add(businessNo);
            }
            UserIdentity loginUser = this.loginUserService.getLoginUser();
            List planVos = this.promotionPlanService.findByCodes(businessNoList);
            if (CollectionUtils.isEmpty((Collection)planVos)) {
                log.error("\u7535\u5546\u4fc3\u9500\u89c4\u5212\u5ba1\u6279\u901a\u8fc7\u63a8\u9001\u7ec6\u6848\u9884\u6d4b\u8868=====\u300b\u6570\u636e\u4e0d\u5b58\u5728");
                return "\u7535\u5546\u4fc3\u9500\u89c4\u5212\u5ba1\u6279\u901a\u8fc7\u63a8\u9001\u7ec6\u6848\u9884\u6d4b\u8868=====\u300b\u6570\u636e\u4e0d\u5b58\u5728";
            }
            List salesOrgCodes = planVos.stream().filter(e -> StringUtils.isNotEmpty((CharSequence)e.getSalesOrgCode())).map(PromotionPlanVo::getSalesOrgCode).distinct().collect(Collectors.toList());
            HashMap<String, SalesOrgAllParentVo> salesOrgVoMap = new HashMap<String, SalesOrgAllParentVo>();
            if (!CollectionUtils.isEmpty(salesOrgCodes)) {
                List salesOrgVos = this.salesOrgVoService.findSalesOrgIncludeAllParentByCodes(salesOrgCodes);
                salesOrgVoMap.putAll(salesOrgVos.stream().collect(Collectors.toMap(SalesOrgAllParentVo::getCurrSalesOrgCode, v -> v, (v1, v2) -> v2)));
            }
            for (PromotionPlanVo plan : planVos) {
                if (!Objects.nonNull(plan) || !CollectionUtils.isNotEmpty((Collection)plan.getGeneralExpensesVos())) continue;
                List customerVoList = this.customerVoService.findByCustomerCodes(plan.getGeneralExpensesVos().stream().map(ExpensesVo::getCustomerCode).collect(Collectors.toList()));
                Map customerVoMap = customerVoList.stream().collect(Collectors.toMap(CustomerVo::getCustomerCode, Function.identity()));
                List productCodeList = plan.getGeneralExpensesVos().stream().filter(e -> StringUtils.isNotEmpty((CharSequence)e.getProductCode())).map(ExpensesVo::getProductCode).distinct().collect(Collectors.toList());
                HashMap productVoMap = Maps.newHashMap();
                if (CollectionUtil.isNotEmpty(productCodeList)) {
                    List list = this.productVoService.findByCodes(productCodeList);
                    productVoMap.putAll(list.stream().collect(Collectors.toMap(ProductVo::getProductCode, v -> v, (v1, v2) -> v2)));
                }
                plan.getGeneralExpensesVos().forEach(item -> {
                    SalesOrgAllParentVo salesOrgAllParentVo = null;
                    if (StringUtils.isNotEmpty((CharSequence)plan.getSalesOrgCode())) {
                        salesOrgAllParentVo = (SalesOrgAllParentVo)salesOrgVoMap.get(plan.getSalesOrgCode());
                    }
                    CustomerVo customerVo = null;
                    if (StringUtils.isNotEmpty((CharSequence)item.getCustomerCode())) {
                        customerVo = (CustomerVo)customerVoMap.get(item.getCustomerCode());
                    }
                    ProductVo productVo = null;
                    if (StringUtils.isNotEmpty((CharSequence)item.getProductCode())) {
                        productVo = (ProductVo)productVoMap.get(item.getProductCode());
                    }
                    DetailedForecastDto detailedForecastDto = ActivityDetailPlanPassDetailedForecastBuilder.buildUnit4Dto(plan, item, customerVo, salesOrgAllParentVo, productVo);
                    try {
                        this.activityDetailPlanPassDetailedForecastUtil.buildUnit4Param(detailedForecastDto, (GeneralExpensesVo)item, loginUser);
                    }
                    catch (Exception e) {
                        log.error("\u4fc3\u9500\u89c4\u5212\u7f16\u53f7[{}]\u660e\u7ec6\u7f16\u7801[{}]\u7ec6\u6848\u9884\u6d4b\u751f\u6210\u8ba1\u7b97\u5931\u8d25\uff1a{}", new Object[]{detailedForecastDto.getDetailedCaseCode(), detailedForecastDto.getActivityDetailItemCode(), e.getMessage()});
                        e.printStackTrace();
                    }
                });
            }
        }
        catch (Exception e2) {
            log.error("\u4fc3\u9500\u89c4\u5212\u5ba1\u6279\u901a\u8fc7\u63a8\u9001\u6d3b\u52a8\u7ec6\u6848MQ\u6d88\u606f\u5904\u7406\u5931\u8d25" + e2.getMessage(), (Throwable)e2);
            return "\u6d88\u8d39\u5931\u8d25." + e2.getMessage();
        }
        return "\u6d88\u8d39\u6210\u529f.";
    }
}

