/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.detailed.forecast.local.consumer;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgVoService;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgAllParentVo;
import com.biz.crm.mn.common.rocketmq.service.AbstractRocketMqConsumer;
import com.biz.crm.mn.common.rocketmq.vo.MqMessageVo;
import com.biz.crm.tpm.business.detailed.forecast.local.util.ActivityDetailPlanPassDetailedForecastBuilder;
import com.biz.crm.tpm.business.detailed.forecast.local.util.ActivityDetailPlanPassDetailedForecastUtil;
import com.biz.crm.tpm.business.detailed.forecast.sdk.dto.DetailedForecastDto;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.service.SubComActivityDetailPlanVoService;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.vo.SubComActivityDetailPlanItemVo;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.vo.SubComActivityDetailPlanVo;
import com.bizunited.nebula.security.sdk.login.UserIdentity;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.spring.annotation.ConsumeMode;
import org.apache.rocketmq.spring.annotation.MessageModel;
import org.apache.rocketmq.spring.annotation.RocketMQMessageListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@RocketMQMessageListener(topic="TPM_ACTIVITY_DETAIL_PLAN_PROCESS_PASS_TOPIC${rocketmq.environment}", selectorExpression="TPM_ACTIVITY_DETAIL_PLAN_PASS_SUB_COM_DETAILED_FORECAST", consumerGroup="TPM_ACTIVITY_DETAIL_PLAN_PASS_SUB_COM_DETAILED_FORECAST${rocketmq.environment}", consumeMode=ConsumeMode.CONCURRENTLY, messageModel=MessageModel.CLUSTERING)
public class SubComActivityDetailPlanPassDetailedForecastConsumer
extends AbstractRocketMqConsumer {
    private static final Logger log = LoggerFactory.getLogger(SubComActivityDetailPlanPassDetailedForecastConsumer.class);
    @Autowired(required=false)
    private SubComActivityDetailPlanVoService subComActivityDetailPlanVoService;
    @Autowired(required=false)
    private ActivityDetailPlanPassDetailedForecastUtil activityDetailPlanPassDetailedForecastUtil;
    @Autowired(required=false)
    private CustomerVoService customerVoService;
    @Autowired(required=false)
    private ProductVoService productVoService;
    @Autowired(required=false)
    private SalesOrgVoService salesOrgVoService;
    @Autowired(required=false)
    private LoginUserService loginUserService;

    protected Object handleMessage(MqMessageVo message) {
        log.info("\u5206\u5b50\u6d3b\u52a8\u7ec6\u6848\u5ba1\u6279\u901a\u8fc7\u63a8\u9001\u7ec6\u6848\u9884\u6d4b\u8868 order mq message received  : {}", (Object)message);
        if (Objects.isNull(message) || StringUtils.isEmpty((CharSequence)message.getMsgBody())) {
            return "\u6d88\u606f\u4e3a\u7a7a!";
        }
        try {
            UserIdentity loginUser = this.loginUserService.getLoginUser();
            String businessNo = message.getMsgBody();
            List<String> businessNoList = new ArrayList<String>();
            if (businessNo.contains("[")) {
                businessNoList = JSON.parseArray((String)message.getMsgBody(), String.class);
            } else {
                businessNoList.add(businessNo);
            }
            List detailPlanVos = this.subComActivityDetailPlanVoService.findDetailByPlanCodes(businessNoList);
            if (CollectionUtils.isEmpty((Collection)detailPlanVos)) {
                log.error("\u5206\u5b50\u6d3b\u52a8\u7ec6\u6848\u5ba1\u6279\u901a\u8fc7\u63a8\u9001\u7ec6\u6848\u9884\u6d4b\u8868=====\u300b\u6570\u636e\u4e0d\u5b58\u5728");
                return "\u5206\u5b50\u6d3b\u52a8\u7ec6\u6848\u5ba1\u6279\u901a\u8fc7\u63a8\u9001\u7ec6\u6848\u9884\u6d4b\u8868=====\u300b\u6570\u636e\u4e0d\u5b58\u5728";
            }
            for (SubComActivityDetailPlanVo detailPlanVo : detailPlanVos) {
                List customerVos;
                if (!Objects.nonNull(detailPlanVo) || !CollectionUtils.isNotEmpty((Collection)detailPlanVo.getItemList())) continue;
                List cusCodes = detailPlanVo.getItemList().stream().filter(e -> StringUtils.isNotEmpty((CharSequence)e.getCustomerCode())).map(SubComActivityDetailPlanItemVo::getCustomerCode).distinct().collect(Collectors.toList());
                HashMap customerVoMap = Maps.newHashMap();
                if (CollectionUtil.isNotEmpty(cusCodes) && CollectionUtil.isNotEmpty((Collection)(customerVos = this.customerVoService.findBaseByCustomerCodes(cusCodes)))) {
                    customerVoMap.putAll(customerVos.stream().filter(e -> StringUtils.isNotEmpty((CharSequence)e.getErpCode())).collect(Collectors.toMap(CustomerVo::getCustomerCode, vo -> vo, (v1, v2) -> v2)));
                }
                List productCodeList = detailPlanVo.getItemList().stream().filter(e -> StringUtils.isNotEmpty((CharSequence)e.getProductCode())).map(SubComActivityDetailPlanItemVo::getProductCode).distinct().collect(Collectors.toList());
                HashMap productVoMap = Maps.newHashMap();
                if (CollectionUtil.isNotEmpty(productCodeList)) {
                    List list = this.productVoService.findByCodes(productCodeList);
                    productVoMap.putAll(list.stream().collect(Collectors.toMap(ProductVo::getProductCode, v -> v, (v1, v2) -> v2)));
                }
                List salesOrgCodes = detailPlanVo.getItemList().stream().filter(e -> StringUtils.isNotEmpty((CharSequence)e.getSalesGroupCode()) || StringUtils.isNotEmpty((CharSequence)e.getSalesOrgCode()) || StringUtils.isNotEmpty((CharSequence)e.getSalesInstitutionCode())).map(e -> {
                    if (StringUtils.isNotEmpty((CharSequence)e.getSalesGroupCode())) {
                        return e.getSalesGroupCode();
                    }
                    if (StringUtils.isNotEmpty((CharSequence)e.getSalesOrgCode())) {
                        return e.getSalesOrgCode();
                    }
                    if (StringUtils.isNotEmpty((CharSequence)e.getSalesInstitutionCode())) {
                        return e.getSalesInstitutionCode();
                    }
                    return "";
                }).distinct().collect(Collectors.toList());
                HashMap<String, SalesOrgAllParentVo> salesOrgVoMap = new HashMap<String, SalesOrgAllParentVo>();
                if (CollectionUtils.isNotEmpty(salesOrgCodes)) {
                    List list = this.salesOrgVoService.findSalesOrgIncludeAllParentByCodes(salesOrgCodes);
                    salesOrgVoMap.putAll(list.stream().collect(Collectors.toMap(SalesOrgAllParentVo::getCurrSalesOrgCode, v -> v, (v1, v2) -> v2)));
                }
                detailPlanVo.getItemList().forEach(item -> {
                    CustomerVo customerVo = null;
                    if (StringUtils.isNotEmpty((CharSequence)item.getCustomerCode())) {
                        customerVo = (CustomerVo)customerVoMap.get(item.getCustomerCode());
                    }
                    ProductVo productVo = null;
                    if (StringUtils.isNotEmpty((CharSequence)item.getProductCode())) {
                        productVo = (ProductVo)productVoMap.get(item.getProductCode());
                    }
                    DetailedForecastDto detailedForecastDto = ActivityDetailPlanPassDetailedForecastBuilder.buildUnit2Dto(detailPlanVo, item, customerVo, salesOrgVoMap, productVo);
                    try {
                        this.activityDetailPlanPassDetailedForecastUtil.buildUnit2Param(detailedForecastDto, (SubComActivityDetailPlanItemVo)item, loginUser);
                    }
                    catch (Exception e) {
                        log.error("\u5206\u5b50\u7ec6\u6848\u7f16\u7801[{}]\u660e\u7ec6\u7f16\u7801[{}]\u7ec6\u6848\u9884\u6d4b\u751f\u6210\u8ba1\u7b97\u5931\u8d25\uff1a{}", new Object[]{detailedForecastDto.getDetailedCaseCode(), detailedForecastDto.getActivityDetailItemCode(), e.getMessage()});
                        log.error("", (Throwable)e);
                    }
                });
            }
        }
        catch (Exception e2) {
            log.error("\u5206\u5b50\u6d3b\u52a8\u7ec6\u6848\u5ba1\u6279\u901a\u8fc7\u63a8\u9001\u7ec6\u6848\u9884\u6d4b\u8868\u5904\u7406\u5931\u8d25" + e2.getMessage(), (Throwable)e2);
            return "\u6d88\u8d39\u5931\u8d25." + e2.getMessage();
        }
        return "\u6d88\u8d39\u6210\u529f.";
    }

    public Object handleMessageTest(MqMessageVo message) {
        return this.handleMessage(message);
    }
}

