/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.detailed.forecast.local.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.rocketmq.service.RocketMqProducer;
import com.biz.crm.mn.common.rocketmq.util.RocketMqUtil;
import com.biz.crm.mn.common.rocketmq.vo.MqMessageVo;
import com.biz.crm.tpm.business.detailed.forecast.local.consumer.ActivityDetailPlanPassDetailedForecastRefreshConsumer;
import com.biz.crm.tpm.business.detailed.forecast.local.mapper.DetailedForecastMapper;
import com.biz.crm.tpm.business.detailed.forecast.local.service.internal.DetailedForecastAutoCreateXxlJob;
import com.biz.crm.tpm.business.detailed.forecast.local.service.internal.DetailedForecastAutoRefreshXxlJob;
import com.biz.crm.tpm.business.detailed.forecast.local.task.impl.DeatailedForecastSchedulingImp;
import com.biz.crm.tpm.business.detailed.forecast.local.util.DetailedForecastVerticalBudgetDataUtil;
import com.biz.crm.tpm.business.detailed.forecast.sdk.dto.DetailedForecastAutoRefreshDto;
import com.biz.crm.tpm.business.detailed.forecast.sdk.dto.DetailedForecastDto;
import com.biz.crm.tpm.business.detailed.forecast.sdk.dto.DetailedForecastInitDto;
import com.biz.crm.tpm.business.detailed.forecast.sdk.dto.DetailedForecastSummaryDto;
import com.biz.crm.tpm.business.detailed.forecast.sdk.dto.UpExpectAuditAmountMonitorDto;
import com.biz.crm.tpm.business.detailed.forecast.sdk.service.DetailedForecastService;
import com.biz.crm.tpm.business.detailed.forecast.sdk.vo.DetailedForecastSummaryVo;
import com.biz.crm.tpm.business.detailed.forecast.sdk.vo.DetailedForecastVo;
import com.biz.crm.tpm.business.detailed.forecast.sdk.vo.UpExpectAuditAmountMonitorVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/detailed/forecast"})
@Api(tags={"\u7ec6\u6848\u9884\u6d4b"})
public class DetailedForecastController {
    private static final Logger log = LoggerFactory.getLogger(DetailedForecastController.class);
    @Autowired
    private DetailedForecastService detailedForecastService;
    @Autowired(required=false)
    private DetailedForecastMapper detailedForecastMapper;
    @Autowired(required=false)
    private RocketMqProducer rocketMqProducer;
    @Autowired(required=false)
    private DeatailedForecastSchedulingImp deatailedForecastSchedulingImp;
    @Autowired(required=false)
    private ActivityDetailPlanPassDetailedForecastRefreshConsumer activityDetailPlanPassDetailedForecastRefreshConsumer;
    @Autowired(required=false)
    private DetailedForecastAutoRefreshXxlJob detailedForecastAutoRefreshXxlJob;
    @Autowired(required=false)
    private DetailedForecastAutoCreateXxlJob detailedForecastAutoCreateXxlJob;
    @Autowired(required=false)
    private DetailedForecastVerticalBudgetDataUtil detailedForecastVerticalBudgetDataUtil;

    @ApiOperation(value="\u540e\u7aef\u9884\u7b97\u9884\u6d4b\u7ba1\u7406\u5217\u8868")
    @GetMapping(value={"findByForecastsForWebList"})
    public Result<Page<DetailedForecastVo>> findByForecastsForWebList(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @ApiParam(name="detailedForecast", value="\u7ec6\u6848\u9884\u6d4b\u8868") DetailedForecastDto dto) {
        try {
            Page page = this.detailedForecastService.findByForecastsForWebList(pageable, dto);
            return Result.ok((Object)page);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u6240\u6709\u6570\u636e")
    @GetMapping(value={"findByForecasts"})
    public Result<Page<DetailedForecastVo>> findByForecasts(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @ApiParam(name="detailedForecast", value="\u7ec6\u6848\u9884\u6d4b\u8868") DetailedForecastDto detailedForecast) {
        try {
            Page page = this.detailedForecastService.findByForecasts(pageable, detailedForecast);
            return Result.ok((Object)page);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u65b0\u589e\u6570\u636e")
    @PostMapping(value={"create"})
    public Result<?> create(@ApiParam(name="detailedForecast", value="\u7ec6\u6848\u9884\u6d4b\u8868") @RequestBody DetailedForecastDto detailedForecast) {
        try {
            return Result.ok((Object)this.detailedForecastService.create(detailedForecast));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u4fee\u6539\u6570\u636e")
    @PatchMapping
    public Result<?> update(@ApiParam(name="detailedForecast", value="\u7ec6\u6848\u9884\u6d4b\u8868") @RequestBody DetailedForecastDto detailedForecast) {
        try {
            return Result.ok((Object)this.detailedForecastService.update(detailedForecast));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6279\u91cf\u66f4\u65b0(\u91cd\u65b0\u8ba1\u7b97\u9884\u4f30\u53ef\u6838\u9500\u91d1\u989d)")
    @PatchMapping(value={"updateAuditAmount"})
    public Result<?> updateAuditAmount(@ApiParam(name="idList", value="\u4e3b\u952e\u96c6\u5408") @RequestBody List<String> idList) {
        try {
            this.detailedForecastService.updateAuditAmount(idList);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u786e\u8ba4")
    @PatchMapping(value={"confirm"})
    public Result<?> confirm(@ApiParam(name="idList", value="\u4e3b\u952e\u96c6\u5408") @RequestBody List<String> idList) {
        try {
            this.detailedForecastService.confirm(idList);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5220\u9664\u6570\u636e", notes="")
    @DeleteMapping(value={"delete"})
    public Result<?> deleteById(@RequestParam(value="ids") List<String> ids) {
        try {
            this.detailedForecastService.delete(ids);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u901a\u8fc7\u4e3b\u952e\u67e5\u8be2\u5355\u6761\u6570\u636e")
    @GetMapping(value={"{id}"})
    public Result<DetailedForecastVo> findById(@PathVariable @ApiParam(name="id", value="\u4e3b\u952eid", required=true) String id) {
        try {
            DetailedForecastVo detailedForecastVo = this.detailedForecastService.findById(id);
            return Result.ok((Object)detailedForecastVo);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u66f4\u65b0\u4e0d\u8986\u76d6\u6570\u636e")
    @PostMapping(value={"updateDetailedForecast"})
    public Result<?> updateDetailedForecast(@ApiParam(name="detailedForecast", value="\u7ec6\u6848\u9884\u6d4b\u8868") @RequestBody DetailedForecastDto detailedForecast) {
        try {
            this.detailedForecastService.updateDetailedForecast(detailedForecast);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="callEcrm")
    @GetMapping(value={"callEcrm"})
    public Result callEcrm() {
        try {
            this.deatailedForecastSchedulingImp.executePullTask();
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u521d\u59cb\u5316-\u6d3b\u52a8\u7ec6\u6848\u5ba1\u6279\u901a\u8fc7\u63a8\u9001\u7ec6\u6848\u9884\u6d4b\u8868")
    @PostMapping(value={"mainQuarterInit"})
    public Result mainQuarterInit(@RequestBody DetailedForecastInitDto dto) {
        Validate.notBlank((CharSequence)dto.getBusinessUnitCode(), (String)"\u4e1a\u52a1\u5355\u5143\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        try {
            int pageNumber = 1;
            int pageSize = 50;
            while (true) {
                Page page = new Page((long)pageNumber, (long)pageSize);
                Page<String> pageList = null;
                if (BusinessUnitEnum.isDefaultBusinessUnit((String)dto.getBusinessUnitCode()) || BusinessUnitEnum.VERTICAL.getCode().equals(dto.getBusinessUnitCode())) {
                    pageList = this.detailedForecastMapper.findInitCodeList((Page<String>)page, dto);
                } else if (BusinessUnitEnum.SON_COMPANY.getCode().equals(dto.getBusinessUnitCode())) {
                    pageList = this.detailedForecastMapper.findSubComInitCodeList((Page<String>)page, dto);
                } else if (BusinessUnitEnum.ONLINE.getCode().equals(dto.getBusinessUnitCode())) {
                    pageList = this.detailedForecastMapper.findOnlineInitCodeList((Page<String>)page, dto);
                } else {
                    throw new RuntimeException("\u521d\u59cb\u5316-\u6d3b\u52a8\u7ec6\u6848\u5ba1\u6279\u901a\u8fc7\u63a8\u9001\u7ec6\u6848\u9884\u6d4b\u8868=====>\u672a\u5b9a\u4e49\u8be5\u4e1a\u52a1\u5355\u5143[" + dto.getBusinessUnitCode() + "]\u5904\u7406\u903b\u8f91");
                }
                if (CollectionUtils.isEmpty((Collection)pageList.getRecords())) break;
                log.info("\u521d\u59cb\u5316-\u6d3b\u52a8\u7ec6\u6848\u5ba1\u6279\u901a\u8fc7\u63a8\u9001\u7ec6\u6848\u9884\u6d4b\u8868=====>{}, {}, {}", new Object[]{pageNumber, pageList.getRecords().size(), pageList.getTotal()});
                MqMessageVo vo = new MqMessageVo();
                if (BusinessUnitEnum.isDefaultBusinessUnit((String)dto.getBusinessUnitCode()) || BusinessUnitEnum.VERTICAL.getCode().equals(dto.getBusinessUnitCode())) {
                    vo.setTopic("TPM_ACTIVITY_DETAIL_PLAN_PROCESS_PASS_TOPIC" + RocketMqUtil.mqEnvironment());
                    vo.setTag("TPM_ACTIVITY_DETAIL_PLAN_PASS_DETAILED_FORECAST");
                    log.info("\u521d\u59cb\u5316-\u6d3b\u52a8\u7ec6\u6848\u5ba1\u6279\u901a\u8fc7\u63a8\u9001\u7ec6\u6848\u9884\u6d4b\u8868=====>{}", (Object)dto.getBusinessUnitCode());
                } else if (BusinessUnitEnum.SON_COMPANY.getCode().equals(dto.getBusinessUnitCode())) {
                    vo.setTopic("TPM_ACTIVITY_DETAIL_PLAN_PROCESS_PASS_TOPIC" + RocketMqUtil.mqEnvironment());
                    vo.setTag("TPM_ACTIVITY_DETAIL_PLAN_PASS_SUB_COM_DETAILED_FORECAST");
                    log.info("\u521d\u59cb\u5316-\u6d3b\u52a8\u7ec6\u6848\u5ba1\u6279\u901a\u8fc7\u63a8\u9001\u7ec6\u6848\u9884\u6d4b\u8868=====>{}", (Object)dto.getBusinessUnitCode());
                } else if (BusinessUnitEnum.ONLINE.getCode().equals(dto.getBusinessUnitCode())) {
                    vo.setTopic("TPM_PROMOTION_PLAN_PASS_PUSH_DATAILED_FORECAST_TOPIC" + RocketMqUtil.mqEnvironment());
                    vo.setTag("TPM_PROMOTION_PLAN_PASS_DETAILED_FORECAST");
                    log.info("\u521d\u59cb\u5316-\u6d3b\u52a8\u7ec6\u6848\u5ba1\u6279\u901a\u8fc7\u63a8\u9001\u7ec6\u6848\u9884\u6d4b\u8868=====>{}", (Object)dto.getBusinessUnitCode());
                }
                vo.setMsgBody(JSONObject.toJSONString((Object)pageList.getRecords()));
                log.info("\u521d\u59cb\u5316-\u6d3b\u52a8\u7ec6\u6848\u5ba1\u6279\u901a\u8fc7\u63a8\u9001\u7ec6\u6848\u9884\u6d4b\u8868=====>{}", JSONObject.toJSON((Object)vo));
                this.rocketMqProducer.sendMqMsg(vo);
                Thread.sleep(200L);
                ++pageNumber;
            }
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6d4b\u8bd5\u7ec6\u6848\u9884\u6d4b\u8868\u66f4\u65b0")
    @PostMapping(value={"testRefresh"})
    public Result testRefresh(@RequestBody List<String> list) {
        try {
            MqMessageVo vo = new MqMessageVo();
            vo.setMsgBody(JSONObject.toJSONString(list));
            this.activityDetailPlanPassDetailedForecastRefreshConsumer.handleMessageTest(vo);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u63a8\u9001\u6570\u636e\u5230ECRM")
    @PostMapping(value={"pushEcrm"})
    public Result<?> pushEcrm(@RequestBody List<String> idList) {
        try {
            this.detailedForecastService.pushEcrm(idList);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6d4b\u8bd5\u7ec6\u6848\u9884\u6d4b\u81ea\u52a8\u5237\u65b0\u5b9a\u65f6\u4efb\u52a1")
    @PostMapping(value={"testAutoRefresh"})
    public Result<?> testAutoRefresh(@RequestBody DetailedForecastAutoRefreshDto dto) {
        try {
            this.detailedForecastAutoRefreshXxlJob.testAutoRefresh(dto);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6d4b\u8bd5\u7ec6\u6848\u9884\u6d4b\u5b9a\u65f6\u8865\u521b\u5efa\u4efb\u52a1")
    @PostMapping(value={"testAutoCreate"})
    public Result<?> testAutoCreate(@RequestBody DetailedForecastAutoRefreshDto dto) {
        try {
            this.detailedForecastAutoCreateXxlJob.autoCreate();
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6838\u9500\u7ed3\u6848\u5ba1\u6279\u901a\u8fc7\u66f4\u65b0\u6838\u9500\u91d1\u989d")
    @PostMapping(value={"updateWriteOffAmount"})
    public Result<?> updateWriteOffAmount(@RequestBody List<String> auditCodes) {
        try {
            this.detailedForecastService.updateWriteOffAmount(auditCodes);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5237\u9884\u7b97-\u521d\u59cb\u5316")
    @PostMapping(value={"initBudget"})
    public Result<?> initBudget(@RequestBody List<String> budgetCodeList) {
        try {
            this.detailedForecastVerticalBudgetDataUtil.initBudget(budgetCodeList);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5237\u9884\u7b97-\u91cd\u65b0\u5360\u7528")
    @PostMapping(value={"washData"})
    public Result<?> washData(@RequestBody List<String> activityDetailItemCodeList) {
        try {
            this.detailedForecastVerticalBudgetDataUtil.washData(activityDetailItemCodeList);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5411\u4e0a\u9884\u8ba1\u53ef\u6838\u9500\u91d1\u989d\u76d1\u63a7\u8868")
    @GetMapping(value={"/pageUpExpectAuditAmountMonitor"})
    public Result<Page<UpExpectAuditAmountMonitorVo>> pageUpExpectAuditAmountMonitor(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @ApiParam(name="detailedForecast", value="\u7ec6\u6848\u9884\u6d4b\u8868") UpExpectAuditAmountMonitorDto dto) {
        try {
            Page page = this.detailedForecastService.pageUpExpectAuditAmountMonitor(pageable, dto);
            return Result.ok((Object)page);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u7ec6\u6848\u9884\u6d4b\u6c47\u603b\u5206\u9875\u67e5\u8be2")
    @GetMapping(value={"summaryPage"})
    public Result<Page<DetailedForecastSummaryVo>> summaryPage(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @ApiParam(name="dto", value="\u7ec6\u6848\u9884\u6d4b\u6c47\u603bdto") DetailedForecastSummaryDto dto) {
        try {
            Page page = this.detailedForecastService.summaryPage(pageable, dto);
            return Result.ok((Object)page);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u7ec6\u6848\u9884\u6d4b\u6c47\u603b\u624b\u52a8\u6267\u884cJob")
    @GetMapping(value={"detailedForecastSummaryUpdateQuery"})
    public Result<?> detailedForecastSummaryUpdateQuery(@ApiParam(name="dto", value="\u7ec6\u6848\u9884\u6d4b\u6c47\u603bdto") DetailedForecastSummaryDto dto) {
        try {
            this.detailedForecastService.detailedForecastSummaryUpdateQuery(dto);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

