/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.detailed.forecast.local.exports;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.common.ie.sdk.excel.process.ExportProcess;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.mn.common.base.constant.CommonConstant;
import com.biz.crm.tpm.business.detailed.forecast.sdk.dto.DetailedForecastFeeLedgerDto;
import com.biz.crm.tpm.business.detailed.forecast.sdk.service.DetailedForecastFeeLedgerService;
import com.biz.crm.tpm.business.detailed.forecast.sdk.vo.DetailedForecastFeeLedgerExportVo;
import com.biz.crm.tpm.business.detailed.forecast.sdk.vo.DetailedForecastFeeLedgerVo;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

@Component
public class DetailedForecastFeeLedgerExportProcess
implements ExportProcess<DetailedForecastFeeLedgerExportVo> {
    private static final Logger log = LoggerFactory.getLogger(DetailedForecastFeeLedgerExportProcess.class);
    @Autowired(required=false)
    private DictDataVoService dictDataVoService;
    @Autowired(required=false)
    private DetailedForecastFeeLedgerService detailedForecastFeeLedgerService;

    public Integer getTotal(Map<String, Object> params) {
        DetailedForecastFeeLedgerDto dto;
        params = this.convertEuropaParam(params);
        PageRequest pageable = PageRequest.of((int)1, (int)1);
        Page pageResult = this.detailedForecastFeeLedgerService.findByForecasts((Pageable)pageable, dto = this.convertParams(params));
        Validate.isTrue((pageResult.getTotal() < (long)CommonConstant.IE_EXPORT_MAX_TOTAL.intValue() ? 1 : 0) != 0, (String)("\u5bfc\u51fa\u65f6\uff0c\u5355\u6b21\u6700\u5927\u5bfc\u51fa[" + CommonConstant.IE_EXPORT_MAX_TOTAL + "]\u6761,\u8bf7\u8f93\u5165\u66f4\u591a\u67e5\u8be2\u6761\u4ef6!!"), (Object[])new Object[0]);
        return Long.valueOf(pageResult.getTotal()).intValue();
    }

    public JSONArray getData(ExportTaskProcessVo vo, Map<String, Object> params) {
        params = this.convertEuropaParam(params);
        log.info("=====>      \u7ec6\u6848\u6838\u9500\u53f0\u8d26\u8868\u5bfc\u51fa[{}]    <=====", (Object)JSON.toJSONString((Object)vo));
        PageRequest pageable = PageRequest.of((int)(vo.getPageNo() + 1), (int)this.getPageSize());
        DetailedForecastFeeLedgerDto dto = this.convertParams(params);
        Page pageResult = this.detailedForecastFeeLedgerService.findByForecasts((Pageable)pageable, dto);
        if (CollectionUtils.isEmpty((Collection)pageResult.getRecords())) {
            return new JSONArray();
        }
        List records = pageResult.getRecords();
        this.adjustData(records);
        return JSON.parseArray((String)JSON.toJSONString((Object)records, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteDateUseDateFormat}));
    }

    public String getBusinessCode() {
        return "DETAILED_FORECAST_FEE_LEDGER_EXPORT";
    }

    public Integer getPageSize() {
        return CommonConstant.IE_EXPORT_PAGE_SIZE;
    }

    private DetailedForecastFeeLedgerDto convertParams(Map<String, Object> params) {
        return (DetailedForecastFeeLedgerDto)JSON.parseObject((String)JSON.toJSONString(params), DetailedForecastFeeLedgerDto.class);
    }

    private void adjustData(Collection<DetailedForecastFeeLedgerVo> data) {
        Map mapDict = this.dictDataVoService.findByDictTypeCodeList((List)Lists.newArrayList((Object[])new String[]{"mdm_business_format", "mdm_business_unit", "MDM_CUSTOMIZE_ORG", "yesOrNo"}));
        for (DetailedForecastFeeLedgerVo vo : data) {
            vo.setBusinessFormatCode(this.findDictValue(mapDict, "mdm_business_format", String.valueOf(vo.getBusinessFormatCode())));
            vo.setBusinessUnitCode(this.findDictValue(mapDict, "mdm_business_unit", String.valueOf(vo.getBusinessUnitCode())));
            vo.setRegion(this.findDictValue(mapDict, "MDM_CUSTOMIZE_ORG", String.valueOf(vo.getRegion())));
            vo.setWholeAudit(this.findDictValue(mapDict, "yesOrNo", String.valueOf(vo.getWholeAudit())));
        }
    }

    private String findDictValue(Map<String, List<DictDataVo>> mapDict, String dictTypeCode, String code) {
        if (Objects.isNull(mapDict) || StringUtils.isBlank((CharSequence)dictTypeCode) || StringUtils.isBlank((CharSequence)code)) {
            return "";
        }
        List<DictDataVo> vos = mapDict.get(dictTypeCode);
        if (CollectionUtils.isEmpty(vos)) {
            return "";
        }
        Optional<String> first = vos.stream().filter(a -> a.getDictCode().equals(code)).map(DictDataVo::getDictValue).findFirst();
        return first.orElse("");
    }

    public String getBusinessName() {
        return "\u7ec6\u6848\u6838\u9500\u53f0\u8d26\u8868";
    }
}

