/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.detailed.forecast.local.notifier.log;

import com.biz.crm.common.log.sdk.dto.CrmBusinessLogDto;
import com.biz.crm.common.log.sdk.enums.OperationTypeEunm;
import com.biz.crm.common.log.sdk.service.CrmBusinessLogVoService;
import com.biz.crm.tpm.business.detailed.forecast.sdk.dto.log.DetailedForecastLogEventDto;
import com.biz.crm.tpm.business.detailed.forecast.sdk.event.DetailedForecastLogEventListener;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DetailedForecastLogEventListenerImpl
implements DetailedForecastLogEventListener {
    @Autowired(required=false)
    private CrmBusinessLogVoService crmBusinessLogVoService;

    public void onCreate(DetailedForecastLogEventDto dto) {
        CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
        crmBusinessLogDto.setOperationType(OperationTypeEunm.CREATE.getDictCode());
        this.buildCrmBusinessLog(crmBusinessLogDto, dto);
    }

    public void onDelete(DetailedForecastLogEventDto dto) {
        CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
        crmBusinessLogDto.setOperationType(OperationTypeEunm.DELETE.getDictCode());
        this.buildCrmBusinessLog(crmBusinessLogDto, dto);
    }

    public void onUpdate(DetailedForecastLogEventDto dto) {
        CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
        crmBusinessLogDto.setOperationType(OperationTypeEunm.UPDATE.getDictCode());
        this.buildCrmBusinessLog(crmBusinessLogDto, dto);
    }

    private void buildCrmBusinessLog(CrmBusinessLogDto crmBusinessLogDto, DetailedForecastLogEventDto eventDto) {
        crmBusinessLogDto.setOnlyKey(eventDto.getNewest().getId());
        crmBusinessLogDto.setAppCode(TenantUtils.getTenantCode());
        crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
        crmBusinessLogDto.setOldObject((Object)eventDto.getOriginal());
        crmBusinessLogDto.setNewObject((Object)eventDto.getNewest());
        this.crmBusinessLogVoService.handleSave(crmBusinessLogDto);
    }
}

