/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.detailed.forecast.local.repository;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantEntity;
import com.biz.crm.tpm.business.detailed.forecast.local.entity.DetailedForecastEntity;
import com.biz.crm.tpm.business.detailed.forecast.local.entity.DetailedForecastProductEntity;
import com.biz.crm.tpm.business.detailed.forecast.local.mapper.DetailedForecastProductMapper;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.beans.FeatureDescriptor;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import liquibase.util.StringUtil;
import org.apache.commons.compress.utils.Lists;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class DetailedForecastProductRepository
extends ServiceImpl<DetailedForecastProductMapper, DetailedForecastProductEntity> {
    @Autowired(required=false)
    private DetailedForecastProductMapper detailedForecastProductMapper;
    private static final String property_detailedCaseCode = "detailedCaseCode";
    private static final String property_activityDetailItemCode = "activityDetailItemCode";
    private static final String property_yearMonthStr = "yearMonthStr";
    public static final List<String> excludeFieldList = Lists.newArrayList();

    public boolean hasNotEmptyProperty(DetailedForecastProductEntity entity) {
        PropertyDescriptor[] propertyDescriptors = BeanUtils.getPropertyDescriptors(DetailedForecastProductEntity.class);
        boolean hasNotEmptyProperty = false;
        for (PropertyDescriptor propertyDescriptor : propertyDescriptors) {
            if (excludeFieldList.contains(propertyDescriptor.getName())) continue;
            try {
                Object invoke = propertyDescriptor.getReadMethod().invoke((Object)entity, new Object[0]);
                if (null == invoke || !StringUtil.isNotEmpty((String)invoke.toString())) continue;
                hasNotEmptyProperty = true;
                break;
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        return hasNotEmptyProperty;
    }

    public List<DetailedForecastProductEntity> buildEntityList(DetailedForecastEntity entity) {
        ArrayList<DetailedForecastProductEntity> productEntityList = new ArrayList<DetailedForecastProductEntity>();
        if (!StringUtils.isEmpty((Object)entity.getProductCode())) {
            String[] productCodes = entity.getProductCode().split(",");
            List<Object> productNames = Lists.newArrayList();
            if (!StringUtils.isEmpty((Object)entity.getProductName())) {
                productNames = Arrays.asList(entity.getProductName().split(","));
            }
            for (int i = 0; i < productCodes.length; ++i) {
                DetailedForecastProductEntity productEntity = new DetailedForecastProductEntity();
                productEntity.setProductCode(productCodes[i]);
                if (i < productNames.size()) {
                    productEntity.setProductName((String)productNames.get(i));
                }
                productEntity.setTenantCode(TenantUtils.getTenantCode());
                productEntity.setDetailedCaseCode(entity.getDetailedCaseCode());
                productEntity.setActivityDetailItemCode(entity.getActivityDetailItemCode());
                productEntity.setYearMonthStr(entity.getYearMonthStr());
                productEntity.setYearMonthLy(entity.getYearMonthLy());
                productEntityList.add(productEntity);
            }
        }
        return productEntityList;
    }

    public boolean removeByForecastIds(List<String> forecastIds) {
        return ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(TenantEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).in(DetailedForecastProductEntity::getDetailedForecastId, forecastIds)).remove();
    }

    public List<DetailedForecastProductEntity> findByForecastIds(List<String> forecastIds) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).in(DetailedForecastProductEntity::getDetailedForecastId, forecastIds)).list();
    }

    static {
        PropertyDescriptor[] propertyDescriptors = BeanUtils.getPropertyDescriptors(TenantEntity.class);
        excludeFieldList.addAll(Arrays.stream(propertyDescriptors).map(FeatureDescriptor::getName).collect(Collectors.toList()));
        excludeFieldList.add(property_detailedCaseCode);
        excludeFieldList.add(property_activityDetailItemCode);
        excludeFieldList.add(property_yearMonthStr);
    }
}

