/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.detailed.forecast.local.repository;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidOpEntity;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.mn.common.base.eunm.BusinessFormatEnum;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.third.system.ecrm.sdk.enumeration.PushECRMStatusEnum;
import com.biz.crm.mn.third.system.ecrm.sdk.vo.DetailedForecastRequestVo;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanItemVo;
import com.biz.crm.tpm.business.detailed.forecast.local.entity.DetailedForecastEntity;
import com.biz.crm.tpm.business.detailed.forecast.local.entity.DetailedForecastFormulaEntity;
import com.biz.crm.tpm.business.detailed.forecast.local.entity.DetailedForecastProductEntity;
import com.biz.crm.tpm.business.detailed.forecast.local.mapper.DetailedForecastMapper;
import com.biz.crm.tpm.business.detailed.forecast.local.repository.DetailedForecastFormulaRepository;
import com.biz.crm.tpm.business.detailed.forecast.local.repository.DetailedForecastProductRepository;
import com.biz.crm.tpm.business.detailed.forecast.local.vo.TpmUpExpectAuditAmountMonitorWarningQueryDto;
import com.biz.crm.tpm.business.detailed.forecast.sdk.dto.DetailedForecastAutoCreateDto;
import com.biz.crm.tpm.business.detailed.forecast.sdk.dto.DetailedForecastAutoRefreshDto;
import com.biz.crm.tpm.business.detailed.forecast.sdk.dto.DetailedForecastDto;
import com.biz.crm.tpm.business.detailed.forecast.sdk.dto.DetailedForecastFeeLedgerDto;
import com.biz.crm.tpm.business.detailed.forecast.sdk.dto.DetailedForecastSummaryDto;
import com.biz.crm.tpm.business.detailed.forecast.sdk.dto.UpExpectAuditAmountMonitorDto;
import com.biz.crm.tpm.business.detailed.forecast.sdk.vo.AuditDetailedForecastVo;
import com.biz.crm.tpm.business.detailed.forecast.sdk.vo.DetailedForecastFeeLedgerResultVo;
import com.biz.crm.tpm.business.detailed.forecast.sdk.vo.DetailedForecastFeeLedgerVo;
import com.biz.crm.tpm.business.detailed.forecast.sdk.vo.DetailedForecastSummaryVo;
import com.biz.crm.tpm.business.detailed.forecast.sdk.vo.DetailedForecastVo;
import com.biz.crm.tpm.business.detailed.forecast.sdk.vo.UpExpectAuditAmountMonitorVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import jodd.util.StringUtil;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class DetailedForecastRepository
extends ServiceImpl<DetailedForecastMapper, DetailedForecastEntity> {
    @Autowired(required=false)
    private DetailedForecastMapper detailedForecastMapper;
    @Autowired(required=false)
    private DetailedForecastFormulaRepository detailedForecastFormulaRepository;
    @Autowired(required=false)
    private DetailedForecastProductRepository detailedForecastProductRepository;

    public Page<DetailedForecastVo> findByForecastsForWebList(Pageable pageable, DetailedForecastDto detailedForecast) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.detailedForecastMapper.findByForecastsForWebList((Page<DetailedForecastVo>)page, detailedForecast);
    }

    public Page<DetailedForecastVo> findByForecasts(Pageable pageable, DetailedForecastDto dto) {
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)1, (int)50));
        if (StringUtil.isEmpty((CharSequence)(dto = (DetailedForecastDto)ObjectUtils.defaultIfNull((Object)dto, (Object)new DetailedForecastDto())).getTenantCode())) {
            dto.setTenantCode(TenantUtils.getTenantCode());
        }
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.detailedForecastMapper.findByForecasts((Page<DetailedForecastVo>)page, dto);
    }

    public Page<DetailedForecastFeeLedgerVo> findByForecasts(Pageable pageable, DetailedForecastFeeLedgerDto dto) {
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)1, (int)50));
        if (StringUtil.isEmpty((CharSequence)(dto = (DetailedForecastFeeLedgerDto)ObjectUtils.defaultIfNull((Object)dto, (Object)new DetailedForecastFeeLedgerDto())).getTenantCode())) {
            dto.setTenantCode(TenantUtils.getTenantCode());
        }
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.detailedForecastMapper.findByForecastsFeeLedger((Page<DetailedForecastFeeLedgerVo>)page, dto);
    }

    public List<DetailedForecastFeeLedgerVo> getActivityDetailPlanItem(List<String> activityDetailItemCodeList) {
        if (CollectionUtils.isEmpty(activityDetailItemCodeList)) {
            return Collections.emptyList();
        }
        return this.detailedForecastMapper.getActivityDetailPlanItem(activityDetailItemCodeList);
    }

    public List<DetailedForecastFeeLedgerVo> getDetailedForecastFormula(List<String> activityDetailItemCodeList) {
        if (CollectionUtils.isEmpty(activityDetailItemCodeList)) {
            return Collections.emptyList();
        }
        return this.detailedForecastMapper.getDetailedForecastFormula(activityDetailItemCodeList);
    }

    public List<DetailedForecastEntity> findByIds(List<String> ids) {
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).in(UuidEntity::getId, ids)).list();
        return this.loadExtend(list);
    }

    public List<DetailedForecastEntity> findByDetailCodes(List<String> detailCodes) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).in(DetailedForecastEntity::getDetailedCaseCode, detailCodes)).list();
    }

    public Page<DetailedForecastVo> findForAudit(Pageable pageable, DetailedForecastDto detailedForecast) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        Page<DetailedForecastVo> pageList = this.detailedForecastMapper.findForAudit((Page<DetailedForecastVo>)page, detailedForecast);
        return pageList;
    }

    public List<DetailedForecastRequestVo> selectUnSynchronizedAll() {
        return this.detailedForecastMapper.selectUnSynchronizedAll();
    }

    public void updateSynchronousRegime(List<DetailedForecastRequestVo> vos) {
        this.detailedForecastMapper.updateSynchronousRegime(vos);
    }

    public List<DetailedForecastEntity> getDetailedForecastByParams(DetailedForecastDto detailedForecast) {
        List list = ((DetailedForecastMapper)this.baseMapper).selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(DetailedForecastEntity.class).eq(DetailedForecastEntity::getActivityDetailItemCode, (Object)detailedForecast.getActivityDetailItemCode())).orderByDesc(UuidOpEntity::getCreateTime)).last("limit 1"));
        if (CollectionUtils.isEmpty((Collection)list)) {
            return null;
        }
        return this.loadExtend(list);
    }

    public Page<DetailedForecastRequestVo> selectUnSynchronizedPage(Pageable pageable) {
        return this.detailedForecastMapper.selectUnSynchronizedPage(pageable);
    }

    public Long findAutoRefreshDataCount(DetailedForecastAutoRefreshDto dto) {
        if (BusinessUnitEnum.isDefaultBusinessUnit((String)dto.getBusinessUnitCode())) {
            return this.detailedForecastMapper.initAutoRefreshHead(dto);
        }
        if (BusinessUnitEnum.SON_COMPANY.getCode().equals(dto.getBusinessUnitCode())) {
            return this.detailedForecastMapper.initAutoRefreshSubCom(dto);
        }
        if (BusinessUnitEnum.ONLINE.getCode().equals(dto.getBusinessUnitCode())) {
            return this.detailedForecastMapper.initAutoRefreshOnLine(dto);
        }
        return 0L;
    }

    public List<String> findAutoRefreshDataList(Pageable pageable, DetailedForecastAutoRefreshDto dto) {
        dto.setOffset(Integer.valueOf(pageable.getPageSize() * (pageable.getPageNumber() - 1)));
        dto.setLimit(Integer.valueOf(pageable.getPageSize()));
        return this.detailedForecastMapper.findAutoRefreshDataList(dto);
    }

    public List<String> findAutoCreateDataList(DetailedForecastAutoCreateDto dto) {
        if (BusinessUnitEnum.SON_COMPANY.getCode().equals(dto.getBusinessUnitCode())) {
            return this.detailedForecastMapper.findSubComAutoCreateDataList(dto);
        }
        if (BusinessUnitEnum.ONLINE.getCode().equals(dto.getBusinessUnitCode())) {
            return this.detailedForecastMapper.findOnlineAutoCreateDataList(dto);
        }
        return this.detailedForecastMapper.findMainAutoCreateDataList(dto);
    }

    public List<String> findAutoUpdateShowFlagDataList(DetailedForecastAutoCreateDto dto) {
        if (BusinessUnitEnum.SON_COMPANY.getCode().equals(dto.getBusinessUnitCode())) {
            return this.detailedForecastMapper.findSubComAutoUpdateShowFlagDataList(dto);
        }
        if (BusinessUnitEnum.ONLINE.getCode().equals(dto.getBusinessUnitCode())) {
            return null;
        }
        return this.detailedForecastMapper.findMainAutoUpdateShowFlagDataList(dto);
    }

    public Long autoUpdateShowFLag(List<String> activityDetailItemCodes) {
        return this.detailedForecastMapper.autoUpdateShowFLag(activityDetailItemCodes);
    }

    public List<DetailedForecastEntity> loadExtend(List<DetailedForecastEntity> list) {
        if (CollectionUtils.isEmpty(list)) {
            return Lists.newArrayList();
        }
        List<String> idList = list.stream().map(UuidEntity::getId).collect(Collectors.toList());
        List formulaList = this.detailedForecastFormulaRepository.listByIds(idList);
        Map<String, DetailedForecastFormulaEntity> formulaMap = formulaList.stream().collect(Collectors.toMap(UuidEntity::getId, v -> v));
        List<DetailedForecastProductEntity> productList = this.detailedForecastProductRepository.findByForecastIds(idList);
        Map<String, List<DetailedForecastProductEntity>> productListMap = productList.stream().collect(Collectors.groupingBy(DetailedForecastProductEntity::getDetailedForecastId));
        String[] formulaIgnoreFieldArr = DetailedForecastFormulaRepository.excludeFieldList.toArray(new String[0]);
        for (DetailedForecastEntity entity : list) {
            if (formulaMap.containsKey(entity.getId())) {
                BeanUtils.copyProperties((Object)((Object)formulaMap.get(entity.getId())), (Object)((Object)entity), (String[])formulaIgnoreFieldArr);
            }
            if (!productListMap.containsKey(entity.getId())) continue;
            List<DetailedForecastProductEntity> productEntityList = productListMap.get(entity.getId());
            productEntityList.sort(Comparator.comparing(DetailedForecastProductEntity::getProductCode));
            List productCodeList = productEntityList.stream().map(DetailedForecastProductEntity::getProductCode).collect(Collectors.toList());
            List productNameList = productEntityList.stream().map(DetailedForecastProductEntity::getProductName).collect(Collectors.toList());
            entity.setProductCode(String.join((CharSequence)",", productCodeList));
            entity.setProductName(String.join((CharSequence)",", productNameList));
        }
        return list;
    }

    public List<DetailedForecastEntity> clearExtend(List<DetailedForecastEntity> list) {
        if (CollectionUtils.isEmpty(list)) {
            return Lists.newArrayList();
        }
        for (DetailedForecastEntity forecastEntity : list) {
            forecastEntity.setWriteOffConditions(null);
            forecastEntity.setWriteOffFormula(null);
            forecastEntity.setWriteOffConditionValue(null);
            forecastEntity.setWriteOffFormulaValue(null);
            forecastEntity.setWriteOffPremise(null);
            forecastEntity.setCalParam(null);
            forecastEntity.setCalEx(null);
            forecastEntity.setOverBudgetRemark(null);
            forecastEntity.setProductCode(null);
            forecastEntity.setProductName(null);
        }
        return list;
    }

    public List<DetailedForecastEntity> list(QueryWrapper<DetailedForecastEntity> queryWrapper) {
        List list = super.list(queryWrapper);
        return this.loadExtend(list);
    }

    public DetailedForecastEntity getById(Serializable id) {
        DetailedForecastEntity entity = (DetailedForecastEntity)((Object)super.getById(id));
        if (Objects.isNull((Object)entity)) {
            return null;
        }
        return this.loadExtend(Lists.newArrayList((Object[])new DetailedForecastEntity[]{entity})).get(0);
    }

    public boolean save(DetailedForecastEntity entity) {
        DetailedForecastFormulaEntity formulaEntity = (DetailedForecastFormulaEntity)((Object)BeanUtil.copyProperties((Object)((Object)entity), DetailedForecastFormulaEntity.class, (String[])new String[0]));
        List<DetailedForecastProductEntity> productEntityList = this.detailedForecastProductRepository.buildEntityList(entity);
        entity = this.clearExtend(Lists.newArrayList((Object[])new DetailedForecastEntity[]{entity})).get(0);
        boolean save = super.save((Object)entity);
        formulaEntity.setId(entity.getId());
        this.detailedForecastFormulaRepository.save((Object)formulaEntity);
        for (DetailedForecastProductEntity productEntity : productEntityList) {
            productEntity.setDetailedForecastId(entity.getId());
        }
        this.detailedForecastProductRepository.saveBatch(productEntityList);
        return save;
    }

    public boolean updateById(DetailedForecastEntity entity) {
        DetailedForecastFormulaEntity formulaEntity = (DetailedForecastFormulaEntity)((Object)BeanUtil.copyProperties((Object)((Object)entity), DetailedForecastFormulaEntity.class, (String[])new String[0]));
        List<DetailedForecastProductEntity> productEntityList = this.detailedForecastProductRepository.buildEntityList(entity);
        entity = this.clearExtend(Lists.newArrayList((Object[])new DetailedForecastEntity[]{entity})).get(0);
        boolean result = super.updateById((Object)entity);
        this.detailedForecastFormulaRepository.saveOrUpdate((Object)formulaEntity);
        for (DetailedForecastProductEntity productEntity : productEntityList) {
            productEntity.setDetailedForecastId(entity.getId());
        }
        this.detailedForecastProductRepository.removeByForecastIds(Lists.newArrayList((Object[])new String[]{entity.getId()}));
        this.detailedForecastProductRepository.saveBatch(productEntityList);
        return result;
    }

    public boolean saveOrUpdate(DetailedForecastEntity entity, Wrapper<DetailedForecastEntity> updateWrapper) {
        DetailedForecastFormulaEntity formulaEntity = (DetailedForecastFormulaEntity)((Object)BeanUtil.copyProperties((Object)((Object)entity), DetailedForecastFormulaEntity.class, (String[])new String[0]));
        List<DetailedForecastProductEntity> productEntityList = this.detailedForecastProductRepository.buildEntityList(entity);
        entity = this.clearExtend(Lists.newArrayList((Object[])new DetailedForecastEntity[]{entity})).get(0);
        boolean result = super.saveOrUpdate((Object)entity, updateWrapper);
        this.detailedForecastFormulaRepository.saveOrUpdate((Object)formulaEntity);
        for (DetailedForecastProductEntity productEntity : productEntityList) {
            productEntity.setDetailedForecastId(entity.getId());
        }
        this.detailedForecastProductRepository.removeByForecastIds(Lists.newArrayList((Object[])new String[]{entity.getId()}));
        this.detailedForecastProductRepository.saveBatch(productEntityList);
        return result;
    }

    public boolean saveBatch(Collection<DetailedForecastEntity> entityList, int batchSize) {
        ArrayList formulaEntityList = Lists.newArrayList();
        ArrayList<DetailedForecastProductEntity> productEntityList = new ArrayList<DetailedForecastProductEntity>();
        for (DetailedForecastEntity entity : entityList) {
            entity.setId(UUID.randomUUID().toString().replace("-", ""));
            DetailedForecastFormulaEntity formulaEntity = (DetailedForecastFormulaEntity)((Object)BeanUtil.copyProperties((Object)((Object)entity), DetailedForecastFormulaEntity.class, (String[])new String[0]));
            formulaEntityList.add(formulaEntity);
            List<DetailedForecastProductEntity> productList = this.detailedForecastProductRepository.buildEntityList(entity);
            for (DetailedForecastProductEntity productEntity : productList) {
                productEntity.setDetailedForecastId(entity.getId());
            }
            productEntityList.addAll(productList);
        }
        entityList = this.clearExtend(Lists.newArrayList(entityList));
        boolean result = super.saveBatch(entityList, batchSize);
        if (!CollectionUtils.isEmpty((Collection)formulaEntityList)) {
            this.detailedForecastFormulaRepository.saveBatch(formulaEntityList, batchSize);
        }
        if (!CollectionUtils.isEmpty(productEntityList)) {
            this.detailedForecastProductRepository.removeByForecastIds(entityList.stream().map(UuidEntity::getId).collect(Collectors.toList()));
            this.detailedForecastProductRepository.saveBatch(productEntityList);
        }
        return result;
    }

    public boolean saveOrUpdateBatch(Collection<DetailedForecastEntity> entityList, int batchSize) {
        ArrayList formulaEntityList = Lists.newArrayList();
        ArrayList<DetailedForecastProductEntity> productEntityList = new ArrayList<DetailedForecastProductEntity>();
        for (DetailedForecastEntity entity : entityList) {
            entity.setId(UUID.randomUUID().toString().replace("-", ""));
            DetailedForecastFormulaEntity formulaEntity = (DetailedForecastFormulaEntity)((Object)BeanUtil.copyProperties((Object)((Object)entity), DetailedForecastFormulaEntity.class, (String[])new String[0]));
            formulaEntityList.add(formulaEntity);
            List<DetailedForecastProductEntity> productList = this.detailedForecastProductRepository.buildEntityList(entity);
            for (DetailedForecastProductEntity productEntity : productList) {
                productEntity.setDetailedForecastId(entity.getId());
            }
            productEntityList.addAll(productList);
        }
        entityList = this.clearExtend(Lists.newArrayList(entityList));
        boolean result = super.saveOrUpdateBatch(entityList, batchSize);
        this.detailedForecastFormulaRepository.saveOrUpdateBatch(formulaEntityList, batchSize);
        this.detailedForecastProductRepository.removeByForecastIds(entityList.stream().map(UuidEntity::getId).collect(Collectors.toList()));
        this.detailedForecastProductRepository.saveBatch(productEntityList);
        return result;
    }

    public boolean updateBatchById(Collection<DetailedForecastEntity> entityList, int batchSize) {
        ArrayList formulaEntityList = Lists.newArrayList();
        ArrayList<DetailedForecastProductEntity> productEntityList = new ArrayList<DetailedForecastProductEntity>();
        for (DetailedForecastEntity entity : entityList) {
            DetailedForecastFormulaEntity formulaEntity = (DetailedForecastFormulaEntity)((Object)BeanUtil.copyProperties((Object)((Object)entity), DetailedForecastFormulaEntity.class, (String[])new String[0]));
            formulaEntityList.add(formulaEntity);
            List<DetailedForecastProductEntity> productList = this.detailedForecastProductRepository.buildEntityList(entity);
            for (DetailedForecastProductEntity productEntity : productList) {
                productEntity.setDetailedForecastId(entity.getId());
            }
            productEntityList.addAll(productList);
        }
        entityList = this.clearExtend(Lists.newArrayList(entityList));
        boolean result = super.updateBatchById(entityList, batchSize);
        this.detailedForecastFormulaRepository.updateBatchById(formulaEntityList, batchSize);
        this.detailedForecastProductRepository.removeByForecastIds(entityList.stream().map(UuidEntity::getId).collect(Collectors.toList()));
        this.detailedForecastProductRepository.saveBatch(productEntityList);
        return result;
    }

    public boolean removeByIds(Collection<? extends Serializable> idList) {
        if (CollectionUtils.isEmpty(idList)) {
            return true;
        }
        List<String> ids = idList.stream().map(Object::toString).collect(Collectors.toList());
        boolean result = super.removeByIds(idList);
        boolean formulaResult = this.detailedForecastFormulaRepository.removeByIds(idList);
        boolean productResult = this.detailedForecastProductRepository.removeByForecastIds(ids);
        return result && formulaResult && productResult;
    }

    public void updatePushECRMStatusByCodeSet(Set<String> activityDetailPlanItemCodeSet) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(DetailedForecastEntity::getActivityDetailItemCode, activityDetailPlanItemCodeSet)).eq(DetailedForecastEntity::getBusinessUnitCode, (Object)BusinessUnitEnum.HEADQUARTERS.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).set(DetailedForecastEntity::getPushEcrmStatus, (Object)PushECRMStatusEnum.ADD.getCode())).update();
    }

    public List<DetailedForecastEntity> findByActivityDetailItemCodes(Set<String> activityDetailItemCodes) {
        if (CollectionUtil.isEmpty(activityDetailItemCodes)) {
            return Collections.emptyList();
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).in(DetailedForecastEntity::getActivityDetailItemCode, activityDetailItemCodes)).list();
    }

    public List<DetailedForecastFeeLedgerResultVo> getPaidAmount(Set<String> codeList) {
        if (CollectionUtil.isEmpty(codeList)) {
            return Collections.emptyList();
        }
        ArrayList list = this.detailedForecastMapper.getPaidAmount(codeList);
        return !CollectionUtils.isEmpty(list) ? list : new ArrayList();
    }

    public List<DetailedForecastFeeLedgerResultVo> getReimburseTaxAmount(Set<String> codeList) {
        if (CollectionUtil.isEmpty(codeList)) {
            return Collections.emptyList();
        }
        ArrayList list = this.detailedForecastMapper.getReimburseTaxAmount(codeList);
        return !CollectionUtils.isEmpty(list) ? list : new ArrayList();
    }

    public List<DetailedForecastFeeLedgerResultVo> getFeePoolAmount(Set<String> codeList) {
        if (CollectionUtil.isEmpty(codeList)) {
            return Collections.emptyList();
        }
        ArrayList list = this.detailedForecastMapper.getFeePoolAmount(codeList);
        return !CollectionUtils.isEmpty(list) ? list : new ArrayList();
    }

    public List<DetailedForecastVo> findByPlanItemCode(Set<String> codeSet) {
        return this.detailedForecastMapper.findByPlanItemCode(codeSet, TenantUtils.getTenantCode());
    }

    public List<DetailedForecastVo> findAuditAmount(List<String> auditCodeList) {
        if (CollectionUtil.isEmpty(auditCodeList)) {
            return Collections.emptyList();
        }
        String tenantCode = TenantUtils.getTenantCode();
        ArrayList<String> businessUnitCodes = new ArrayList<String>();
        businessUnitCodes.add(BusinessUnitEnum.HEADQUARTERS.getCode());
        businessUnitCodes.add(BusinessUnitEnum.SON_COMPANY.getCode());
        List<String> activityDetailCodeList = this.detailedForecastMapper.findActivityDetailCodeByAuditList(auditCodeList, tenantCode);
        if (CollectionUtil.isEmpty(activityDetailCodeList)) {
            return Collections.emptyList();
        }
        return this.detailedForecastMapper.findAuditAmount(activityDetailCodeList, businessUnitCodes, tenantCode);
    }

    public Page<UpExpectAuditAmountMonitorVo> pageUpExpectAuditAmountMonitor(Pageable pageable, UpExpectAuditAmountMonitorDto dto) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        Page<UpExpectAuditAmountMonitorVo> pageList = this.detailedForecastMapper.pageUpExpectAuditAmountMonitor((Page<UpExpectAuditAmountMonitorVo>)page, dto);
        return pageList;
    }

    public Page<DetailedForecastSummaryVo> summaryPage(Pageable pageable, DetailedForecastSummaryDto dto) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        dto.setTenantCode(TenantUtils.getTenantCode());
        Validate.notBlank((CharSequence)dto.getTenantCode(), (String)"\u79df\u6237\u53f7\u4e3a\u7a7a", (Object[])new Object[0]);
        return this.detailedForecastMapper.summaryPage((Page<DetailedForecastSummaryVo>)page, dto);
    }

    public List<DetailedForecastSummaryVo> summarySalesPerformanceList(List<String> keyList, List<String> keyBrandList) {
        return this.detailedForecastMapper.summarySalesPerformanceList(TenantUtils.getTenantCode(), keyList, keyBrandList);
    }

    public List<Map<String, Object>> findTpmUpExpectAuditAmountMonitorWarning(TpmUpExpectAuditAmountMonitorWarningQueryDto dto) {
        dto.setBusinessFormatCode(BusinessFormatEnum.NORMAL.getCode());
        dto.setBusinessUnitCode(BusinessUnitEnum.HEADQUARTERS.getCode());
        dto.setTenantCode(TenantUtils.getTenantCode());
        dto.setShowFlag(BooleanEnum.TRUE.getCapital());
        return this.detailedForecastMapper.findTpmUpExpectAuditAmountMonitorWarning(dto);
    }

    public List<DetailedForecastEntity> findEstimatedWriteOffAmount(DetailedForecastDto detailedForecastDto) {
        if (Objects.isNull(detailedForecastDto)) {
            return Lists.newArrayList();
        }
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(DetailedForecastEntity::getSalesGroupCode, (Object)detailedForecastDto.getSalesGroupCode())).eq(DetailedForecastEntity::getBusinessUnitCode, (Object)detailedForecastDto.getBusinessUnitCode())).eq(DetailedForecastEntity::getYearMonthStr, (Object)detailedForecastDto.getYearMonthStr())).list();
        return list;
    }

    public List<DetailedForecastVo> findListForSaleAndFeeMonitoring(List<DetailedForecastDto> detailedForecastDtos) {
        if (CollectionUtils.isEmpty(detailedForecastDtos)) {
            return Lists.newArrayList();
        }
        return this.detailedForecastMapper.findListForSaleAndFeeMonitoring(detailedForecastDtos);
    }

    public List<DetailedForecastEntity> findByPlanItemCodes(Set<String> constituentDetailPlanItemCodes) {
        if (CollectionUtils.isEmpty(constituentDetailPlanItemCodes)) {
            return Lists.newArrayList();
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(DetailedForecastEntity::getActivityDetailItemCode, constituentDetailPlanItemCodes)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).list();
    }

    public List<ActivityDetailPlanItemVo> findDetailedForecastSummaryUpdate(DetailedForecastSummaryDto dto) {
        return this.detailedForecastMapper.findDetailedForecastSummaryUpdate(dto);
    }

    public List<DetailedForecastVo> findDetailedForecastSummaryUpdateList(List<String> detailPlanItemCodes) {
        return this.detailedForecastMapper.findDetailedForecastSummaryUpdateList(detailPlanItemCodes, TenantUtils.getTenantCode());
    }

    public Page<ActivityDetailPlanItemVo> findActivityDetailPlanItemList(Page<ActivityDetailPlanItemVo> page, DetailedForecastSummaryDto dto) {
        return this.detailedForecastMapper.findActivityDetailPlanItemList(page, dto);
    }

    public Page<DetailedForecastSummaryVo> summaryPageNew(Pageable pageable, DetailedForecastSummaryDto dto) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        dto.setTenantCode(TenantUtils.getTenantCode());
        Validate.notBlank((CharSequence)dto.getTenantCode(), (String)"\u79df\u6237\u53f7\u4e3a\u7a7a", (Object[])new Object[0]);
        return this.detailedForecastMapper.summaryPageNew((Page<DetailedForecastSummaryVo>)page, dto);
    }

    public List<DetailedForecastVo> findEstimatedWriteOffAmountByCodes(List<String> codes) {
        return ((DetailedForecastMapper)this.baseMapper).findEstimatedWriteOffAmountByCodes(codes, TenantUtils.getTenantCode());
    }

    public List<DetailedForecastVo> findByProfitMonitor(List<DetailedForecastDto> records) {
        return this.detailedForecastMapper.findByProfitMonitor(records);
    }

    public List<DetailedForecastVo> findByProfitMonitor1(List<DetailedForecastDto> detailedForecastDtos) {
        return this.detailedForecastMapper.findByProfitMonitor1(detailedForecastDtos);
    }

    public List<AuditDetailedForecastVo> findByActivityDetailItemCodes2(List<String> activityDetailItemCodes) {
        if (CollectionUtils.isEmpty(activityDetailItemCodes)) {
            return Lists.newArrayList();
        }
        return ((DetailedForecastMapper)this.getBaseMapper()).findByActivityDetailItemCodes2(activityDetailItemCodes);
    }
}

