/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.detailed.forecast.local.service.internal;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.business.common.sdk.service.RedisService;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.mn.common.rocketmq.service.RocketMqProducer;
import com.biz.crm.mn.common.rocketmq.util.RocketMqUtil;
import com.biz.crm.mn.common.rocketmq.vo.MqMessageVo;
import com.biz.crm.tpm.business.detailed.forecast.sdk.dto.DetailedForecastAutoCreateDto;
import com.biz.crm.tpm.business.detailed.forecast.sdk.service.DetailedForecastService;
import com.bizunited.nebula.task.annotations.DynamicTaskService;
import com.google.common.collect.Lists;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DetailedForecastAutoCreateXxlJob {
    private static final Logger log = LoggerFactory.getLogger(DetailedForecastAutoCreateXxlJob.class);
    @Autowired(required=false)
    private DetailedForecastService detailedForecastService;
    @Autowired(required=false)
    private RocketMqProducer rocketMqProducer;
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired(required=false)
    private RedisService redisService;

    @DynamicTaskService(cornExpression="0 0 7/1 * * ?", taskDesc="\u7ec6\u6848\u9884\u6d4b\u5b9a\u65f6\u8865\u521b\u5efa\u4efb\u52a1")
    public void autoCreate() {
        log.info("=====>    \u7ec6\u6848\u9884\u6d4b\u5b9a\u65f6\u8865\u521b\u5efa[{}] start    <=====", (Object)DateUtil.dateStrNowAll());
        try {
            if (this.redisService.hasKey("tpm:detailed_forecast_auto_create").booleanValue()) {
                Object o = this.redisService.get("tpm:detailed_forecast_auto_create");
                String msg = "\u7ec6\u6848\u9884\u6d4b\u5b9a\u65f6\u8865\u521b\u5efa\u8fdb\u884c\u4e2d\uff01\u5f00\u59cb\u65f6\u95f4\uff1a" + o.toString();
                log.error(msg);
                throw new RuntimeException(msg);
            }
            this.loginUserService.refreshAuthentication(null);
            String nowDateTime = DateUtil.getDate((String)"yyyy-MM-dd HH:mm:ss");
            this.redisService.set("tpm:detailed_forecast_auto_create", (Object)nowDateTime, 300L);
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
            DetailedForecastAutoCreateDto dto = new DetailedForecastAutoCreateDto();
            dto.setModifyBeginDateTime(LocalDateTime.now().plusDays(-300L).format(formatter));
            try {
                dto.setBusinessUnitCode(BusinessUnitEnum.SON_COMPANY.getCode());
                List subComList = this.detailedForecastService.findAutoCreateDataList(dto);
                log.info("\u7ec6\u6848\u9884\u6d4b\u5b9a\u65f6\u8865\u521b\u5efa===\u300b\u5206\u5b50===\u300b{}", (Object)subComList.size());
                this.sendMq(dto.getBusinessUnitCode(), subComList);
            }
            catch (Exception e) {
                log.error("\u7ec6\u6848\u9884\u6d4b\u5b9a\u65f6\u8865\u521b\u5efa===\u300b\u5206\u5b50===\u300b\u5f02\u5e38\uff1a" + e.getMessage(), (Throwable)e);
            }
            try {
                dto.setBusinessUnitCode(BusinessUnitEnum.ONLINE.getCode());
                List onlineList = this.detailedForecastService.findAutoCreateDataList(dto);
                log.info("\u7ec6\u6848\u9884\u6d4b\u5b9a\u65f6\u8865\u521b\u5efa===\u300b\u7535\u5546===\u300b{}", (Object)onlineList.size());
                this.sendMq(dto.getBusinessUnitCode(), onlineList);
            }
            catch (Exception e) {
                log.error("\u7ec6\u6848\u9884\u6d4b\u5b9a\u65f6\u8865\u521b\u5efa===\u300b\u7535\u5546===\u300b\u5f02\u5e38\uff1a" + e.getMessage(), (Throwable)e);
            }
            try {
                dto.setBusinessUnitCode(BusinessUnitEnum.HEADQUARTERS.getCode());
                List mainList = this.detailedForecastService.findAutoCreateDataList(dto);
                log.info("\u7ec6\u6848\u9884\u6d4b\u5b9a\u65f6\u8865\u521b\u5efa===\u300b\u4e3b\u4f53\u3001\u5782\u76f4===\u300b{}", (Object)mainList.size());
                this.sendMq(dto.getBusinessUnitCode(), mainList);
            }
            catch (Exception e) {
                log.error("\u7ec6\u6848\u9884\u6d4b\u5b9a\u65f6\u8865\u521b\u5efa===\u300b\u4e3b\u4f53\u3001\u5782\u76f4===\u300b\u5f02\u5e38\uff1a" + e.getMessage(), (Throwable)e);
            }
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            log.error("\u7ec6\u6848\u9884\u6d4b\u5b9a\u65f6\u8865\u521b\u5efa\u5f02\u5e38\uff1a" + e.getMessage(), (Throwable)e);
        }
        log.info("=====>    \u7ec6\u6848\u9884\u6d4b\u5b9a\u65f6\u8865\u521b\u5efa[{}] end    <=====", (Object)DateUtil.dateStrNowAll());
    }

    public void sendMq(String businessUnitCode, List<String> list) {
        Lists.partition(list, (int)50).forEach(codes -> {
            try {
                MqMessageVo mqMessageVo = new MqMessageVo();
                mqMessageVo.setMsgBody(JSONObject.toJSONString((Object)codes));
                if (BusinessUnitEnum.isDefaultBusinessUnit((String)businessUnitCode) || BusinessUnitEnum.VERTICAL.getCode().equals(businessUnitCode)) {
                    mqMessageVo.setTopic("TPM_ACTIVITY_DETAIL_PLAN_PROCESS_PASS_TOPIC" + RocketMqUtil.mqEnvironment());
                    mqMessageVo.setTag("TPM_ACTIVITY_DETAIL_PLAN_PASS_DETAILED_FORECAST");
                } else if (BusinessUnitEnum.SON_COMPANY.getCode().equals(businessUnitCode)) {
                    mqMessageVo.setTopic("TPM_ACTIVITY_DETAIL_PLAN_PROCESS_PASS_TOPIC" + RocketMqUtil.mqEnvironment());
                    mqMessageVo.setTag("TPM_ACTIVITY_DETAIL_PLAN_PASS_SUB_COM_DETAILED_FORECAST");
                } else if (BusinessUnitEnum.ONLINE.getCode().equals(businessUnitCode)) {
                    mqMessageVo.setTopic("TPM_PROMOTION_PLAN_PASS_PUSH_DATAILED_FORECAST_TOPIC" + RocketMqUtil.mqEnvironment());
                    mqMessageVo.setTag("TPM_PROMOTION_PLAN_PASS_DETAILED_FORECAST");
                }
                log.info("\u7ec6\u6848\u9884\u6d4b\u5b9a\u65f6\u8865\u521b\u5efa===>\u5355\u5143[{}]\u53d1\u9001MQ===>{}\u6761", (Object)businessUnitCode, (Object)codes.size());
                this.rocketMqProducer.sendMqMsg(mqMessageVo);
                Thread.sleep(200L);
            }
            catch (Exception e) {
                log.error("\u7ec6\u6848\u9884\u6d4b\u5b9a\u65f6\u8865\u521b\u5efa===>\u5355\u5143[" + businessUnitCode + "]\u53d1\u9001MQ\u5f02\u5e38\uff1a" + e.getMessage() + " ===> " + JSONObject.toJSONString((Object)codes), (Throwable)e);
            }
        });
    }
}

