/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.detailed.forecast.local.service.internal;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.business.common.sdk.service.RedisService;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.mn.common.rocketmq.service.RocketMqProducer;
import com.biz.crm.mn.common.rocketmq.util.RocketMqUtil;
import com.biz.crm.mn.common.rocketmq.vo.MqMessageVo;
import com.biz.crm.tpm.business.detailed.forecast.local.repository.DetailedForecastRefreshRepository;
import com.biz.crm.tpm.business.detailed.forecast.sdk.dto.DetailedForecastAutoRefreshDto;
import com.biz.crm.tpm.business.detailed.forecast.sdk.service.DetailedForecastService;
import com.bizunited.nebula.task.annotations.DynamicTaskService;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DetailedForecastAutoRefreshXxlJob {
    private static final Logger log = LoggerFactory.getLogger(DetailedForecastAutoRefreshXxlJob.class);
    @Autowired(required=false)
    private DetailedForecastService detailedForecastService;
    @Autowired(required=false)
    private RocketMqProducer rocketMqProducer;
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired(required=false)
    private RedisService redisService;
    @Autowired(required=false)
    private DetailedForecastRefreshRepository detailedForecastRefreshRepository;

    @DynamicTaskService(cornExpression="0 20 2 * * ?", taskDesc="\u7ec6\u6848\u9884\u6d4b\u5b9a\u65f6\u5237\u65b0\u4efb\u52a1-\u6d3b\u52a8\u7ec6\u6848")
    public void autoRefreshHead() {
        this.loginUserService.refreshAuthentication(null);
        this.removeExpireTimeData();
        Calendar instance = Calendar.getInstance();
        SimpleDateFormat yearMonthFormat = new SimpleDateFormat("yyyy-MM");
        this.autoRefresh(BusinessUnitEnum.HEADQUARTERS.getCode(), yearMonthFormat.format(instance.getTime()) + "-01");
        instance.add(2, -1);
        this.autoRefresh(BusinessUnitEnum.HEADQUARTERS.getCode(), yearMonthFormat.format(instance.getTime()) + "-01");
    }

    @DynamicTaskService(cornExpression="0 40 2 * * ?", taskDesc="\u7ec6\u6848\u9884\u6d4b\u5b9a\u65f6\u5237\u65b0\u4efb\u52a1-\u5206\u5b50\u7ec6\u6848")
    public void autoRefreshSubCom() {
        this.loginUserService.refreshAuthentication(null);
        this.removeExpireTimeData();
        Calendar instance = Calendar.getInstance();
        SimpleDateFormat yearMonthFormat = new SimpleDateFormat("yyyy-MM");
        this.autoRefresh(BusinessUnitEnum.SON_COMPANY.getCode(), yearMonthFormat.format(instance.getTime()) + "-01");
        instance.add(2, -1);
        this.autoRefresh(BusinessUnitEnum.SON_COMPANY.getCode(), yearMonthFormat.format(instance.getTime()) + "-01");
    }

    @DynamicTaskService(cornExpression="0 0 3 * * ?", taskDesc="\u7ec6\u6848\u9884\u6d4b\u5b9a\u65f6\u5237\u65b0\u4efb\u52a1-\u7535\u5546\u4fc3\u9500\u653f\u7b56")
    public void autoRefreshOnline() {
        this.loginUserService.refreshAuthentication(null);
        this.removeExpireTimeData();
        Calendar instance = Calendar.getInstance();
        SimpleDateFormat yearMonthFormat = new SimpleDateFormat("yyyy-MM");
        this.autoRefresh(BusinessUnitEnum.ONLINE.getCode(), yearMonthFormat.format(instance.getTime()) + "-01");
        instance.add(2, -1);
        this.autoRefresh(BusinessUnitEnum.ONLINE.getCode(), yearMonthFormat.format(instance.getTime()) + "-01");
    }

    public void autoRefresh(String businessUnitCode, String yearMonthLy) {
        log.info("=====>    \u4e1a\u52a1\u5355\u5143[" + businessUnitCode + "]\u5e74\u6708[" + yearMonthLy + "]\u7ec6\u6848\u9884\u6d4b\u5b9a\u65f6\u5237\u65b0[{}] start    <=====", (Object)DateUtil.dateStrNowAll());
        this.loginUserService.refreshAuthentication(null);
        String yearMonthDay = DateUtil.getDate((String)"yyyy-MM-dd");
        String key1 = "tpm:detailed_forecast_auto_refresh_page:" + yearMonthDay;
        String operationKey = UUID.randomUUID().toString().replace("-", "");
        try {
            DetailedForecastAutoRefreshDto dto = new DetailedForecastAutoRefreshDto();
            dto.setBusinessUnitCode(businessUnitCode);
            dto.setOperationKey(operationKey);
            dto.setYearMonthLy(yearMonthLy);
            dto.setYearMonthDay(yearMonthDay);
            Long total = this.detailedForecastService.findAutoRefreshCount(dto);
            dto.setTotal(total);
            MqMessageVo mqMessageVo = new MqMessageVo();
            mqMessageVo.setMsgBody(JSONObject.toJSONString((Object)dto));
            mqMessageVo.setTopic("TPM_ACTIVITY_DETAIL_PLAN_PROCESS_PASS_TOPIC" + RocketMqUtil.mqEnvironment());
            mqMessageVo.setTag("TPM_JOB_DETAILED_FORECAST_REFRESH");
            this.rocketMqProducer.sendMqMsg(mqMessageVo, 10L);
        }
        catch (RuntimeException e) {
            log.error("businessUnitCode+\u7ec6\u6848\u9884\u6d4b\u5b9a\u65f6\u5237\u65b0\u5f02\u5e38\uff1a" + e.getMessage(), (Throwable)e);
        }
        log.info("=====>    " + businessUnitCode + "\u7ec6\u6848\u9884\u6d4b\u5b9a\u65f6\u5237\u65b0[{}] end    <=====", (Object)DateUtil.dateStrNowAll());
    }

    public void testAutoRefresh(DetailedForecastAutoRefreshDto dto) {
        log.info("=====>    \u7ec6\u6848\u9884\u6d4b\u5b9a\u65f6\u5237\u65b0[{}] start    <=====", (Object)DateUtil.dateStrNowAll());
        String nowDateTime = DateUtil.getDate((String)"yyyy-MM-dd HH:mm:ss");
        if (StringUtils.isEmpty((CharSequence)dto.getNowDateTime()) && StringUtils.isEmpty((CharSequence)dto.getStartDateTimeStart()) && StringUtils.isEmpty((CharSequence)dto.getStartDateTimeStart()) && StringUtils.isEmpty((CharSequence)dto.getEndDateTimeStart()) && StringUtils.isEmpty((CharSequence)dto.getEndDateTimeEnd())) {
            dto.setNowDateTime(nowDateTime);
        }
        this.loginUserService.refreshAuthentication(null);
        String yearMonthDay = DateUtil.getDate((String)"yyyy-MM-dd");
        String key1 = "tpm:detailed_forecast_auto_refresh_page:" + yearMonthDay;
        try {
            PageRequest page = PageRequest.of((int)1, (int)2000);
            int index = 1;
            if (this.redisService.hasKey("tpm:detailed_forecast_auto_refresh").booleanValue()) {
                Object o = this.redisService.get("tpm:detailed_forecast_auto_refresh");
                String msg = "\u7ec6\u6848\u9884\u6d4b\u5b9a\u65f6\u5237\u65b0\u8fdb\u884c\u4e2d\uff01\u5f00\u59cb\u65f6\u95f4\uff1a" + o.toString();
                log.error(msg);
                throw new RuntimeException(msg);
            }
            this.redisService.set("tpm:detailed_forecast_auto_refresh", (Object)nowDateTime, 86400L);
            dto.setNowDateTime(nowDateTime);
            Long total = this.detailedForecastService.findAutoRefreshCount(dto);
            while (true) {
                List list = this.detailedForecastService.findAutoRefreshDataList((Pageable)page, dto);
                log.info("\u7ec6\u6848\u9884\u6d4b\u5b9a\u65f6\u5237\u65b0\uff1a\u603b\u6570[{}]\u7b2c[{}]\u9875\u67e5\u8be2\u5230[{}]\u6761\u6570\u636e\uff01", new Object[]{total, index, list.size()});
                if (CollectionUtils.isEmpty((Collection)list)) break;
                try {
                    String uuid = UUID.randomUUID().toString().replace("-", "");
                    this.redisService.hSet("tpm:detailed_forecast_auto_refresh_ids", uuid, (Object)JSON.toJSONString((Object)list), 172800L);
                    MqMessageVo mqMessageVo = new MqMessageVo();
                    mqMessageVo.setMsgBody(uuid);
                    mqMessageVo.setTopic("TPM_ACTIVITY_DETAIL_PLAN_PROCESS_PASS_TOPIC" + RocketMqUtil.mqEnvironment());
                    mqMessageVo.setTag("TPM_ACTIVITY_DETAIL_PLAN_PASS_DETAILED_FORECAST_REFRESH");
                    this.rocketMqProducer.sendMqMsg(mqMessageVo);
                    Page result = new Page();
                    result.setTotal((long)list.size());
                    result.setCurrent((long)page.getPageNumber());
                    result.setSize((long)page.getPageSize());
                    this.redisService.set(key1, (Object)JSONObject.toJSONString((Object)result), 259200L);
                    Thread.sleep(200L);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    log.error("\u7ec6\u6848\u9884\u6d4b\u5b9a\u65f6\u5237\u65b0\u53d1\u9001MQ\u5931\u8d25\uff01\u603b\u6570[{}]\u7b2c[{}]\u9875,{}", new Object[]{total, index, e.getMessage()});
                }
                page = PageRequest.of((int)(++index), (int)2000);
            }
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            log.error("\u7ec6\u6848\u9884\u6d4b\u5b9a\u65f6\u5237\u65b0\u5f02\u5e38\uff1a" + e.getMessage(), (Throwable)e);
        }
        log.info("=====>    \u7ec6\u6848\u9884\u6d4b\u5b9a\u65f6\u5237\u65b0[{}] end    <=====", (Object)DateUtil.dateStrNowAll());
    }

    @Transactional(propagation=Propagation.NOT_SUPPORTED, rollbackFor={Exception.class})
    public void removeExpireTimeData() {
        this.detailedForecastRefreshRepository.removeExpireTime();
    }
}

