/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.detailed.forecast.local.service.internal;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.local.entity.TenantEntity;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.pojo.ActivityDetailPlanItemBase;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.service.ActivityDetailPlanItemSdkService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanItemVo;
import com.biz.crm.tpm.business.detailed.forecast.local.entity.DetailedForecastFormulaEntity;
import com.biz.crm.tpm.business.detailed.forecast.local.repository.DetailedForecastFormulaRepository;
import com.biz.crm.tpm.business.detailed.forecast.local.repository.DetailedForecastRepository;
import com.biz.crm.tpm.business.detailed.forecast.sdk.dto.DetailedForecastFeeLedgerDto;
import com.biz.crm.tpm.business.detailed.forecast.sdk.service.DetailedForecastFeeLedgerService;
import com.biz.crm.tpm.business.detailed.forecast.sdk.vo.DetailedForecastFeeLedgerResultVo;
import com.biz.crm.tpm.business.detailed.forecast.sdk.vo.DetailedForecastFeeLedgerVo;
import com.biz.crm.tpm.business.detailed.forecast.sdk.vo.DetailedForecastFormulaVo;
import com.biz.crm.tpm.business.detailed.forecast.sdk.vo.DetailedForecastVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import jodd.util.StringUtil;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StopWatch;

@Service(value="detailedForecastFeeLedgerService")
public class DetailedForecastFeeLedgerServiceImpl
implements DetailedForecastFeeLedgerService {
    private static final Logger log = LoggerFactory.getLogger(DetailedForecastFeeLedgerServiceImpl.class);
    @Autowired(required=false)
    private DetailedForecastRepository detailedForecastRepository;
    @Autowired(required=false)
    private ActivityDetailPlanItemSdkService activityDetailPlanItemSdkService;
    @Autowired(required=false)
    private DetailedForecastFormulaRepository detailedForecastFormulaRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;

    public Page<DetailedForecastFeeLedgerVo> findByForecasts(Pageable pageable, DetailedForecastFeeLedgerDto dto) {
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)1, (int)50));
        if (Objects.isNull(dto)) {
            dto = new DetailedForecastFeeLedgerDto();
        }
        dto.setTenantCode(TenantUtils.getTenantCode());
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        Page<DetailedForecastFeeLedgerVo> voPage = this.detailedForecastRepository.findByForecasts(pageable, dto);
        stopWatch.stop();
        log.info("=====>    \u7ec6\u6848\u6838\u9500\u53f0\u8d26\u8868\u5217\u8868\u8017\u65f6page[{}]    <=====", (Object)DateUtil.millisecondToStr((long)stopWatch.getLastTaskTimeMillis()));
        Page page = new Page();
        page.setTotal(voPage.getTotal());
        page.setCurrent(voPage.getCurrent());
        page.setSize(voPage.getSize());
        if (CollectionUtils.isEmpty((Collection)voPage.getRecords())) {
            return page;
        }
        Map<Object, Object> paidAmountMap = new HashMap();
        Map<Object, Object> reimburseTaxAmountMap = new HashMap();
        Map<Object, Object> feePoolAmountMap = new HashMap();
        List feeLedgerVos = voPage.getRecords();
        Set itemSet = feeLedgerVos.stream().filter(k -> StringUtil.isNotEmpty((CharSequence)k.getActivityDetailItemCode())).map(DetailedForecastVo::getActivityDetailItemCode).collect(Collectors.toSet());
        List partition = Lists.partition(new ArrayList(itemSet), (int)500);
        ArrayList<DetailedForecastFeeLedgerResultVo> paidAmountList = new ArrayList<DetailedForecastFeeLedgerResultVo>();
        ArrayList<DetailedForecastFeeLedgerResultVo> reimburseTaxAmountList = new ArrayList<DetailedForecastFeeLedgerResultVo>();
        ArrayList<DetailedForecastFeeLedgerResultVo> feePoolAmountList = new ArrayList<DetailedForecastFeeLedgerResultVo>();
        ArrayList activityDetailPlanItemVoList = new ArrayList();
        ArrayList<DetailedForecastFormulaVo> detailedForecastFormulaVoList = new ArrayList<DetailedForecastFormulaVo>();
        ArrayList<DetailedForecastFeeLedgerVo> activityDetailPlanItemList = new ArrayList<DetailedForecastFeeLedgerVo>();
        ArrayList<DetailedForecastFeeLedgerVo> detailedForecastFormulaList = new ArrayList<DetailedForecastFeeLedgerVo>();
        for (List part : partition) {
            stopWatch.start();
            paidAmountList.addAll(this.detailedForecastRepository.getPaidAmount(new HashSet<String>(part)));
            stopWatch.stop();
            log.info("=====>    \u7ec6\u6848\u6838\u9500\u53f0\u8d26\u8868\u5217\u8868\u8017\u65f6PaidAmount[{}]    <=====", (Object)DateUtil.millisecondToStr((long)stopWatch.getLastTaskTimeMillis()));
            stopWatch.start();
            reimburseTaxAmountList.addAll(this.detailedForecastRepository.getReimburseTaxAmount(new HashSet<String>(part)));
            stopWatch.stop();
            log.info("=====>    \u7ec6\u6848\u6838\u9500\u53f0\u8d26\u8868\u5217\u8868\u8017\u65f6ReimburseTaxAmount[{}]    <=====", (Object)DateUtil.millisecondToStr((long)stopWatch.getLastTaskTimeMillis()));
            stopWatch.start();
            feePoolAmountList.addAll(this.detailedForecastRepository.getFeePoolAmount(new HashSet<String>(part)));
            stopWatch.stop();
            log.info("=====>    \u7ec6\u6848\u6838\u9500\u53f0\u8d26\u8868\u5217\u8868\u8017\u65f6FeePoolAmount[{}]    <=====", (Object)DateUtil.millisecondToStr((long)stopWatch.getLastTaskTimeMillis()));
            stopWatch.start();
            activityDetailPlanItemVoList.addAll(this.activityDetailPlanItemSdkService.findByItemCodes(part));
            stopWatch.stop();
            log.info("=====>    \u7ec6\u6848\u6838\u9500\u53f0\u8d26\u8868\u5217\u8868\u8017\u65f6activityDetailPlanItem[{}]    <=====", (Object)DateUtil.millisecondToStr((long)stopWatch.getLastTaskTimeMillis()));
            stopWatch.start();
            detailedForecastFormulaVoList.addAll(this.findByDetailPlanItemCodes(part));
            stopWatch.stop();
            log.info("=====>    \u7ec6\u6848\u6838\u9500\u53f0\u8d26\u8868\u5217\u8868\u8017\u65f6DetailedForecastFormula[{}]    <=====", (Object)DateUtil.millisecondToStr((long)stopWatch.getLastTaskTimeMillis()));
            stopWatch.start();
            activityDetailPlanItemList.addAll(this.detailedForecastRepository.getActivityDetailPlanItem(part));
            stopWatch.stop();
            log.info("=====>    \u7ec6\u6848\u6838\u9500\u53f0\u8d26\u8868\u5217\u8868\u8017\u65f6ActivityDetailPlanItem[{}]    <=====", (Object)DateUtil.millisecondToStr((long)stopWatch.getLastTaskTimeMillis()));
            stopWatch.start();
            detailedForecastFormulaList.addAll(this.detailedForecastRepository.getDetailedForecastFormula(part));
            stopWatch.stop();
            log.info("=====>    \u7ec6\u6848\u6838\u9500\u53f0\u8d26\u8868\u5217\u8868\u8017\u65f6DetailedForecastFormula[{}]    <=====", (Object)DateUtil.millisecondToStr((long)stopWatch.getLastTaskTimeMillis()));
        }
        if (!CollectionUtils.isEmpty(paidAmountList)) {
            paidAmountMap = paidAmountList.stream().collect(Collectors.toMap(DetailedForecastFeeLedgerResultVo::getActivityDetailCode, v -> v, (newValue, oldValue) -> newValue));
        }
        if (!CollectionUtils.isEmpty(reimburseTaxAmountList)) {
            reimburseTaxAmountMap = reimburseTaxAmountList.stream().collect(Collectors.toMap(DetailedForecastFeeLedgerResultVo::getActivityDetailCode, v -> v, (newValue, oldValue) -> newValue));
        }
        if (!CollectionUtils.isEmpty(feePoolAmountList)) {
            feePoolAmountMap = feePoolAmountList.stream().collect(Collectors.toMap(DetailedForecastFeeLedgerResultVo::getActivityDetailCode, v -> v, (newValue, oldValue) -> newValue));
        }
        Map<Object, Object> activityDetailPlanItemVoMap = new HashMap();
        if (!CollectionUtils.isEmpty(activityDetailPlanItemVoList)) {
            activityDetailPlanItemVoMap = activityDetailPlanItemVoList.stream().collect(Collectors.toMap(ActivityDetailPlanItemBase::getDetailPlanItemCode, Function.identity(), (n, o) -> n));
        }
        Map<Object, Object> detailedForecastFormulaVoMap = new HashMap();
        if (!CollectionUtils.isEmpty(detailedForecastFormulaVoList)) {
            detailedForecastFormulaVoMap = detailedForecastFormulaVoList.stream().collect(Collectors.toMap(DetailedForecastFormulaVo::getActivityDetailItemCode, Function.identity(), (n, o) -> n));
        }
        Map<Object, Object> activityDetailPlanItemMap = new HashMap();
        if (!CollectionUtils.isEmpty(activityDetailPlanItemList)) {
            activityDetailPlanItemMap = activityDetailPlanItemList.stream().collect(Collectors.toMap(DetailedForecastVo::getActivityDetailItemCode, Function.identity(), (n, o) -> n));
        }
        Map<Object, Object> detailedForecastFormulaMap = new HashMap();
        if (!CollectionUtils.isEmpty(detailedForecastFormulaList)) {
            detailedForecastFormulaMap = detailedForecastFormulaList.stream().collect(Collectors.toMap(DetailedForecastVo::getActivityDetailItemCode, Function.identity(), (n, o) -> n));
        }
        for (DetailedForecastFeeLedgerVo vo : feeLedgerVos) {
            DetailedForecastFormulaVo detailedForecastFormulaVo;
            ActivityDetailPlanItemVo activityDetailPlanItemVo;
            DetailedForecastFeeLedgerVo ledgerVo2;
            BigDecimal paidAmount = BigDecimal.ZERO;
            BigDecimal reimburseTaxAmount = BigDecimal.ZERO;
            BigDecimal feePoolAmount = BigDecimal.ZERO;
            DetailedForecastFeeLedgerVo ledgerVo1 = (DetailedForecastFeeLedgerVo)activityDetailPlanItemMap.get(vo.getActivityDetailItemCode());
            if (ledgerVo1 != null) {
                vo.setWholeAudit(ledgerVo1.getWholeAudit());
                vo.setAlreadyAuditAmountEx(ledgerVo1.getAlreadyAuditAmountEx());
            }
            if ((ledgerVo2 = (DetailedForecastFeeLedgerVo)detailedForecastFormulaMap.get(vo.getActivityDetailItemCode())) != null) {
                vo.setWriteOffConditionsEx(ledgerVo2.getWriteOffConditionsEx());
                vo.setWriteOffFormulaEx(ledgerVo2.getWriteOffFormulaEx());
                vo.setWriteOffConditionValueEx(ledgerVo2.getWriteOffConditionValueEx());
                vo.setWriteOffFormulaValueEx(ledgerVo2.getWriteOffFormulaValueEx());
                vo.setWriteOffPremiseEx(ledgerVo2.getWriteOffPremiseEx());
                vo.setCalExEx(ledgerVo2.getCalExEx());
                vo.setOverBudgetRemarkEx(ledgerVo2.getOverBudgetRemarkEx());
            }
            if ((activityDetailPlanItemVo = (ActivityDetailPlanItemVo)activityDetailPlanItemVoMap.get(vo.getActivityDetailItemCode())) != null) {
                vo.setAlreadyAuditAmountEx(activityDetailPlanItemVo.getAlreadyAuditAmount());
            }
            if ((detailedForecastFormulaVo = (DetailedForecastFormulaVo)detailedForecastFormulaVoMap.get(vo.getActivityDetailItemCode())) != null) {
                vo.setWriteOffConditionsEx(detailedForecastFormulaVo.getWriteOffConditions());
                vo.setWriteOffFormulaEx(detailedForecastFormulaVo.getWriteOffFormula());
                vo.setWriteOffConditionValueEx(detailedForecastFormulaVo.getWriteOffConditionValue());
                vo.setWriteOffFormulaValueEx(detailedForecastFormulaVo.getWriteOffFormulaValue());
                vo.setWriteOffPremiseEx(detailedForecastFormulaVo.getWriteOffPremise());
                vo.setCalExEx(detailedForecastFormulaVo.getCalEx());
                vo.setOverBudgetRemarkEx(detailedForecastFormulaVo.getOverBudgetRemark());
            }
            if (!CollectionUtils.isEmpty(paidAmountMap) && paidAmountMap.containsKey(vo.getActivityDetailItemCode())) {
                DetailedForecastFeeLedgerResultVo resVo1 = (DetailedForecastFeeLedgerResultVo)paidAmountMap.get(vo.getActivityDetailItemCode());
                paidAmount = resVo1.getAmount();
            }
            if (!CollectionUtils.isEmpty(reimburseTaxAmountMap) && reimburseTaxAmountMap.containsKey(vo.getActivityDetailItemCode())) {
                DetailedForecastFeeLedgerResultVo resVo2 = (DetailedForecastFeeLedgerResultVo)reimburseTaxAmountMap.get(vo.getActivityDetailItemCode());
                reimburseTaxAmount = resVo2.getAmount();
            }
            if (!CollectionUtils.isEmpty(feePoolAmountMap) && feePoolAmountMap.containsKey(vo.getActivityDetailItemCode())) {
                DetailedForecastFeeLedgerResultVo resVo3 = (DetailedForecastFeeLedgerResultVo)feePoolAmountMap.get(vo.getActivityDetailItemCode());
                feePoolAmount = resVo3.getAmount();
            }
            vo.setReimburseTaxAmount(reimburseTaxAmount);
            vo.setFeePoolAmount(feePoolAmount);
            vo.setPendingAmount(vo.getReimburseTaxAmount().subtract(paidAmount));
        }
        page.setRecords(feeLedgerVos);
        return page;
    }

    public List<DetailedForecastFormulaVo> findByDetailPlanItemCodes(List<String> detailPlanItemCodes) {
        if (CollectionUtils.isEmpty(detailPlanItemCodes)) {
            return Lists.newArrayList();
        }
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.detailedForecastFormulaRepository.lambdaQuery().eq(TenantEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).in(DetailedForecastFormulaEntity::getActivityDetailItemCode, detailPlanItemCodes)).list();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Lists.newArrayList();
        }
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)list, DetailedForecastFormulaEntity.class, DetailedForecastFormulaVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
    }
}

