/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.detailed.forecast.local.service.internal;

import com.biz.crm.common.ie.sdk.excel.process.ImportProcess;
import com.biz.crm.common.ie.sdk.vo.TaskGlobalParamsVo;
import com.biz.crm.tpm.business.detailed.forecast.local.model.DetailedForecastImportsVo;
import com.biz.crm.tpm.business.detailed.forecast.sdk.dto.DetailedForecastDto;
import com.biz.crm.tpm.business.detailed.forecast.sdk.service.DetailedForecastService;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DetailedForecastImportsProcess
implements ImportProcess<DetailedForecastImportsVo> {
    private static final Logger log = LoggerFactory.getLogger(DetailedForecastImportsProcess.class);
    @Resource
    private DetailedForecastService detailedForecastService;
    @Resource
    private NebulaToolkitService nebulaToolkitService;

    public Map<Integer, String> execute(LinkedHashMap<Integer, DetailedForecastImportsVo> data, TaskGlobalParamsVo paramsVo, Map<String, Object> params) {
        Validate.notEmpty(data, (String)"\u5bfc\u5165\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List<DetailedForecastDto> importList = this.validate(data);
        this.detailedForecastService.importSave(importList);
        return null;
    }

    private List<DetailedForecastDto> validate(LinkedHashMap<Integer, DetailedForecastImportsVo> data) {
        ArrayList<DetailedForecastImportsVo> detailedForecastImportsVos = new ArrayList<DetailedForecastImportsVo>(data.values());
        detailedForecastImportsVos.forEach(importsVo -> {});
        Collection detailedForecastDtoList = this.nebulaToolkitService.copyCollectionByWhiteList(detailedForecastImportsVos, DetailedForecastImportsVo.class, DetailedForecastDto.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return new ArrayList<DetailedForecastDto>(detailedForecastDtoList);
    }

    public Class<DetailedForecastImportsVo> findCrmExcelVoClass() {
        return DetailedForecastImportsVo.class;
    }

    public String getTemplateCode() {
        return "TPM_DETAILED_FORECAST";
    }

    public String getTemplateName() {
        return "TPM\u7ec6\u6848\u9884\u6d4b\u5bfc\u5165";
    }
}

